/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.spell.water;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.entity.EnumRace;
import alfheim.api.lib.LibResourceLocations;
import alfheim.api.spell.SpellBase;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.core.handler.VisualEffectHandler;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lalfheim/common/spell/water/SpellAquaBind;", "Lalfheim/api/spell/SpellBase;", "<init>", "()V", "duration", "", "getDuration", "()I", "setDuration", "(I)V", "efficiency", "", "getEfficiency", "()D", "setEfficiency", "(D)V", "radius", "getRadius", "setRadius", "usableParams", "", "", "getUsableParams", "()[Ljava/lang/Object;", "performCast", "Lalfheim/api/spell/SpellBase$SpellCastResult;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "render", "", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nSpellAquaBind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellAquaBind.kt\nalfheim/common/spell/water/SpellAquaBind\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1863#2,2:74\n*S KotlinDebug\n*F\n+ 1 SpellAquaBind.kt\nalfheim/common/spell/water/SpellAquaBind\n*L\n39#1:74,2\n*E\n"})
public final class SpellAquaBind
extends SpellBase {
    @NotNull
    public static final SpellAquaBind INSTANCE = new SpellAquaBind();
    private static int duration = 100;
    private static double efficiency = 1.0;
    private static double radius = 3.5;

    private SpellAquaBind() {
        super("aquabind", EnumRace.UNDINE, 4000, 600, 15, false, 32, null);
    }

    @Override
    public int getDuration() {
        return duration;
    }

    @Override
    public void setDuration(int n) {
        duration = n;
    }

    @Override
    public double getEfficiency() {
        return efficiency;
    }

    @Override
    public void setEfficiency(double d) {
        efficiency = d;
    }

    @Override
    public double getRadius() {
        return radius;
    }

    @Override
    public void setRadius(double d) {
        radius = d;
    }

    @Override
    @NotNull
    public Object[] getUsableParams() {
        Object[] objectArray = new Object[]{this.getDuration(), this.getEfficiency(), this.getRadius()};
        return objectArray;
    }

    @Override
    @NotNull
    public SpellBase.SpellCastResult performCast(@NotNull EntityLivingBase caster) {
        SpellBase.SpellCastResult result;
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        MovingObjectPosition mop = ASJUtilities.getSelectedBlock((EntityLivingBase)caster, (double)15.0, (boolean)false);
        if (mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return SpellBase.SpellCastResult.WRONGTGT;
        }
        Vec3 vec3 = mop.field_72307_f;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"hitVec");
        Vector3 hit = new Vector3(vec3);
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (mop.field_72310_e == 0) {
                hit.setY(hit.getY() - 0.1);
            }
            if (mop.field_72310_e == 1) {
                hit.setY(hit.getY() + 0.1);
            }
        }
        if ((result = this.checkCast(caster)) != SpellBase.SpellCastResult.OK) {
            return result;
        }
        World world = caster.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        AxisAlignedBB axisAlignedBB = ExtensionsKt.getBoundingBox((Number)hit.getX(), (Number)hit.getY(), (Number)hit.getZ()).func_72314_b(this.getRadius(), 0.5, this.getRadius());
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"expand(...)");
        ArrayList l = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityLivingBase.class, (AxisAlignedBB)axisAlignedBB);
        Iterable $this$forEach$iv = l;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityLivingBase it = (EntityLivingBase)element$iv;
            boolean bl = false;
            if (CardinalSystem.PartySystem.INSTANCE.mobsSameParty(caster, it)) continue;
            Vector3 mob = Vector3.Companion.fromEntityCenter((Entity)it);
            mob.setY(hit.getY());
            if (hit.copy().sub(mob).length() > INSTANCE.getRadius()) continue;
            it.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, INSTANCE.getDuration(), ExtensionsKt.getI((Number)INSTANCE.getEfficiency())));
        }
        double[] dArray = new double[]{hit.getX(), hit.getY(), hit.getZ()};
        VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.AQUABIND, caster.field_71093_bK, dArray);
        return result;
    }

    @Override
    public void render(@NotNull EntityLivingBase caster) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        MovingObjectPosition mop = ASJUtilities.getSelectedBlock((EntityLivingBase)caster, (double)15.0, (boolean)false);
        if (mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return;
        }
        double y = mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK ? 0.1 * (mop.field_72310_e == 0 ? -1.0 : 1.0) : 0.0;
        GL11.glDisable((int)2884);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        ExtensionsClientKt.getMc().field_71446_o.func_110577_a((ResourceLocation)LibResourceLocations.INSTANCE.getTarget());
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a(mop.field_72307_f.field_72450_a - this.getRadius(), mop.field_72307_f.field_72448_b + y, mop.field_72307_f.field_72449_c - this.getRadius(), 0.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(mop.field_72307_f.field_72450_a - this.getRadius(), mop.field_72307_f.field_72448_b + y, mop.field_72307_f.field_72449_c + this.getRadius(), 0.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(mop.field_72307_f.field_72450_a + this.getRadius(), mop.field_72307_f.field_72448_b + y, mop.field_72307_f.field_72449_c + this.getRadius(), 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(mop.field_72307_f.field_72450_a + this.getRadius(), mop.field_72307_f.field_72448_b + y, mop.field_72307_f.field_72449_c - this.getRadius(), 1.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)2884);
    }
}

