/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.spell.sound;

import alexsocol.asjlib.ASJUtilities;
import alfheim.api.entity.EnumRace;
import alfheim.api.spell.SpellBase;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.potion.PotionPriorityTarget;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lalfheim/common/spell/sound/SpellPriorityTarget;", "Lalfheim/api/spell/SpellBase;", "<init>", "()V", "duration", "", "getDuration", "()I", "setDuration", "(I)V", "efficiency", "", "getEfficiency", "()D", "setEfficiency", "(D)V", "usableParams", "", "", "getUsableParams", "()[Ljava/lang/Object;", "performCast", "Lalfheim/api/spell/SpellBase$SpellCastResult;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "Alfheim"})
public final class SpellPriorityTarget
extends SpellBase {
    @NotNull
    public static final SpellPriorityTarget INSTANCE = new SpellPriorityTarget();
    private static int duration = 200;
    private static double efficiency = 0.25;

    private SpellPriorityTarget() {
        super("priorityTarget", EnumRace.POOKA, 10000, 900, 20, false, 32, null);
    }

    @Override
    public int getDuration() {
        return duration;
    }

    @Override
    public void setDuration(int n) {
        duration = n;
    }

    @Override
    public double getEfficiency() {
        return efficiency;
    }

    @Override
    public void setEfficiency(double d) {
        efficiency = d;
    }

    @Override
    @NotNull
    public Object[] getUsableParams() {
        Object[] objectArray = new Object[]{this.getDuration(), this.getEfficiency()};
        return objectArray;
    }

    @Override
    @NotNull
    public SpellBase.SpellCastResult performCast(@NotNull EntityLivingBase caster) {
        CardinalSystem.PartySystem.Party party;
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        CardinalSystem.TargetingSystem.Target tg = CardinalSystem.TargetingSystem.INSTANCE.getTarget(caster);
        EntityLivingBase entityLivingBase = tg.getTarget();
        if (entityLivingBase == null) {
            return SpellBase.SpellCastResult.NOTARGET;
        }
        EntityLivingBase tgt = entityLivingBase;
        if (tgt == caster || tg.isParty()) {
            return SpellBase.SpellCastResult.WRONGTGT;
        }
        if (ASJUtilities.isNotInFieldOfVision((Entity)((Entity)tgt), (EntityLivingBase)caster)) {
            return SpellBase.SpellCastResult.NOTSEEING;
        }
        if (caster instanceof EntityPlayer) {
            party = CardinalSystem.PartySystem.INSTANCE.getParty((EntityPlayer)caster);
        } else {
            party = CardinalSystem.PartySystem.INSTANCE.getMobParty(caster);
            if (party == null) {
                return SpellBase.SpellCastResult.WRONGTGT;
            }
        }
        CardinalSystem.PartySystem.Party party2 = party;
        if (party2.getCount() < 2) {
            return SpellBase.SpellCastResult.WRONGTGT;
        }
        SpellBase.SpellCastResult result = this.checkCast(caster);
        if (result != SpellBase.SpellCastResult.OK) {
            return result;
        }
        int n = party2.getCount();
        for (int i = 0; i < n; ++i) {
            EntityLivingBase pm;
            int it = i;
            boolean bl = false;
            if (party2.get(it) == null || pm == caster) continue;
            PotionPriorityTarget.INSTANCE.applyTo(tgt, pm, INSTANCE.getDuration());
        }
        return result;
    }
}

