/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.spell.sound;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.entity.EnumRace;
import alfheim.api.spell.SpellBase;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.MessageVisualEffect;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lalfheim/common/spell/sound/SpellEcho;", "Lalfheim/api/spell/SpellBase;", "<init>", "()V", "usableParams", "", "", "getUsableParams", "()[Ljava/lang/Double;", "performCast", "Lalfheim/api/spell/SpellBase$SpellCastResult;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nSpellEcho.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellEcho.kt\nalfheim/common/spell/sound/SpellEcho\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1863#2,2:41\n*S KotlinDebug\n*F\n+ 1 SpellEcho.kt\nalfheim/common/spell/sound/SpellEcho\n*L\n26#1:41,2\n*E\n"})
public final class SpellEcho
extends SpellBase {
    @NotNull
    public static final SpellEcho INSTANCE = new SpellEcho();

    private SpellEcho() {
        super("echo", EnumRace.POOKA, 4000, 1500, 5, false, 32, null);
    }

    @NotNull
    public Double[] getUsableParams() {
        Double[] doubleArray = new Double[]{this.getRadius()};
        return doubleArray;
    }

    @Override
    @NotNull
    public SpellBase.SpellCastResult performCast(@NotNull EntityLivingBase caster) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        SpellBase.SpellCastResult result = this.checkCast(caster);
        if (result != SpellBase.SpellCastResult.OK) {
            return result;
        }
        World world = caster.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        AxisAlignedBB axisAlignedBB = caster.field_70121_D;
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"boundingBox");
        ArrayList list = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)ExtensionsKt.expand((AxisAlignedBB)axisAlignedBB, (Number)this.getRadius()));
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            if (Vector3.Companion.entityDistance(it, (Entity)caster) > INSTANCE.getRadius()) continue;
            Entity entity = it;
            if (entity instanceof EntityItem) {
                VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ECHO_ITEM, it);
                continue;
            }
            if (entity instanceof IMob) {
                VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ECHO_MOB, it);
                continue;
            }
            if (entity instanceof EntityPlayer) {
                VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ECHO_PLAYER, it);
                continue;
            }
            if (!(entity instanceof EntityLivingBase)) continue;
            VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ECHO_ENTITY, it);
        }
        if (caster instanceof EntityPlayerMP) {
            double[] dArray = new double[]{caster.field_70165_t, caster.field_70163_u, caster.field_70161_v};
            NetworkService.INSTANCE.sendTo(new MessageVisualEffect(VisualEffectHandlerClient.VisualEffects.ECHO.ordinal(), dArray), (EntityPlayerMP)caster);
        }
        return result;
    }
}

