/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.rod;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.item.ColorOverrideHelper;
import alfheim.api.lib.LibResourceLocations;
import alfheim.client.core.helper.InterpolatedIconHelper;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.core.handler.ragnarok.RagnarokHandler;
import alfheim.common.item.ItemMod;
import alfheim.common.item.equipment.bauble.ItemPriestEmblem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaBlock;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 92\u00020\u00012\u00020\u00022\u00020\u0003:\u00019B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JF\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%JF\u0010(\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010)\u001a\u00020 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J \u0010-\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0014H\u0016J\u0016\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016J\u0016\u00102\u001a\u00020 2\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016J\u0016\u00103\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016J\u0018\u00104\u001a\u00020\t2\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u00107\u001a\u0002082\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0012H\u0016\u00a8\u0006:"}, d2={"Lalfheim/common/item/rod/ItemRodInterdiction;", "Lalfheim/common/item/ItemMod;", "Lvazkii/botania/api/mana/IManaUsingItem;", "Lvazkii/botania/api/item/IAvatarWieldable;", "name", "", "<init>", "(Ljava/lang/String;)V", "registerIcons", "", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "loadTextures", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "par1ItemStack", "Lnet/minecraft/item/ItemStack;", "getMaxItemUseDuration", "", "isFull3D", "", "usesMana", "stack", "onItemRightClick", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "particleRing", "x", "", "y", "z", "range", "r", "", "g", "b", "pushEntities", "velocity", "entities", "", "Lnet/minecraft/entity/Entity;", "onUsingTick", "count", "getCost", "prowess", "priest", "getVelocity", "getRange", "onAvatarUpdate", "tile", "Lvazkii/botania/api/item/IAvatarTile;", "getOverlayResource", "Lalfheim/api/lib/LibResourceLocations$ResourceLocationIL;", "Companion", "Alfheim"})
public class ItemRodInterdiction
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int COST = 5;
    public static final int PROWESS_COST = -1;
    public static final int PRIEST_COST = -2;
    public static final int AVATAR_COST = 4;
    public static final double VELOCITY = 0.05;
    public static final double PROWESS_VELOCITY = 0.02;
    public static final double PRIEST_VELOCITY = 0.07;
    public static final int RANGE = 5;
    public static final int PROWESS_RANGE = 1;
    public static final int PRIEST_RANGE = 2;

    public ItemRodInterdiction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.field_77777_bU = 1;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public /* synthetic */ ItemRodInterdiction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "rodInterdiction";
        }
        this(string);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void loadTextures(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.map.func_130086_a() == 1) {
            TextureMap textureMap = event.map;
            Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
            this.field_77791_bV = InterpolatedIconHelper.INSTANCE.forItem(textureMap, this);
        }
    }

    @NotNull
    public EnumAction func_77661_b(@Nullable ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(@Nullable ItemStack par1ItemStack) {
        return 72000;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean usesMana(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    @NotNull
    public ItemStack func_77659_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public final void particleRing(@NotNull World world, double x, double y, double z, int range, float r, float g, float b) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        float m = 0.15f;
        float mv = 0.35f;
        int i = 0;
        int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)359, (int)8);
        if (i <= n) {
            while (true) {
                double rad = ExtensionsKt.getD((Number)i) * Math.PI / 180.0;
                double dispx = x + 0.5 - Math.cos(rad) * (double)ExtensionsKt.getF((Number)range);
                double dispy = y + 0.5;
                double dispz = z + 0.5 - Math.sin(rad) * (double)ExtensionsKt.getF((Number)range);
                Botania.proxy.wispFX(world, dispx, dispy, dispz, r, g, b, 0.2f, ExtensionsKt.getF((Number)(Math.random() - 0.5)) * m, ExtensionsKt.getF((Number)(Math.random() - 0.5)) * mv, ExtensionsKt.getF((Number)(Math.random() - (double)0.5f)) * m);
                if (i == n) break;
                i += 8;
            }
        }
    }

    public final boolean pushEntities(double x, double y, double z, int range, double velocity, @Nullable EntityPlayer player, @NotNull List<? extends Entity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        boolean flag = false;
        for (Entity entity : entities) {
            double xDif = entity.field_70165_t - x;
            double yDif = entity.field_70163_u - (y + 1.0);
            double zDif = entity.field_70161_v - z;
            double dist = Math.sqrt(xDif * xDif + yDif * yDif + zDif * zDif);
            if (!(dist <= (double)range)) continue;
            entity.field_70159_w = velocity * xDif;
            entity.field_70181_x = velocity * yDif;
            entity.field_70179_y = velocity * zDif;
            entity.field_70143_R = 0.0f;
            flag = true;
        }
        return flag;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityPlayer player, int count) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        World world = player.field_70170_p;
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        boolean priest = !RagnarokHandler.INSTANCE.getBlockedPowers()[2] && ItemPriestEmblem.Companion.getEmblem(2, player) != null;
        boolean prowess = IManaProficiencyArmor.Helper.hasProficiency((EntityPlayer)player);
        int cost = this.getCost(prowess, priest);
        int range = this.getRange(prowess, priest);
        double velocity = this.getVelocity(prowess, priest);
        if (ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)cost, (boolean)false)) {
            Color color = new Color(ColorOverrideHelper.INSTANCE.getColor(player, 255));
            float r = ExtensionsKt.getF((Number)color.getRed()) / 255.0f;
            float g = ExtensionsKt.getF((Number)color.getGreen()) / 255.0f;
            float b = ExtensionsKt.getF((Number)color.getBlue()) / 255.0f;
            if (count % 5 == 0) {
                double[] dArray = new double[]{x, y, z, ExtensionsKt.getD((Number)range), ExtensionsKt.getD((Number)Float.valueOf(r)), ExtensionsKt.getD((Number)Float.valueOf(g)), ExtensionsKt.getD((Number)Float.valueOf(b))};
                VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.SEAROD, world.field_73011_w.field_76574_g, dArray);
            }
            Intrinsics.checkNotNull((Object)world);
            ArrayList entities = ExtensionsKt.selectEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)ExtensionsKt.expand((AxisAlignedBB)ExtensionsKt.getBoundingBox((Number)x, (Number)y, (Number)z), (Number)range), ItemRodInterdiction::onUsingTick$lambda$0);
            entities.remove(player);
            if (this.pushEntities(x, y, z, range, velocity, player, entities)) {
                if (count % 3 == 0) {
                    ExtensionsKt.playSoundAtEntity((Entity)((Entity)player), (String)"alfheim:wind", (float)0.4f, (float)1.0f);
                }
                ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)cost, (boolean)true);
            }
        }
    }

    public final int getCost(boolean prowess, boolean priest) {
        return 5 + (prowess ? -1 : 0 + (priest ? -2 : 0));
    }

    public final double getVelocity(boolean prowess, boolean priest) {
        return 0.05 + (prowess ? 0.02 : 0.0 + (priest ? 0.07 : 0.0));
    }

    public final int getRange(boolean prowess, boolean priest) {
        return 5 + (prowess ? 1 : 0 + (priest ? 2 : 0));
    }

    public void onAvatarUpdate(@NotNull IAvatarTile tile, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        double x = ExtensionsKt.getD((Number)te.field_145851_c);
        double y = ExtensionsKt.getD((Number)te.field_145848_d);
        double z = ExtensionsKt.getD((Number)te.field_145849_e);
        if (((IManaBlock)tile).getCurrentMana() >= 4) {
            if (tile.getElapsedFunctionalTicks() % 5 == 0) {
                Intrinsics.checkNotNull((Object)world);
                this.particleRing(world, x, y, z, 5, 0.0f, 0.0f, 1.0f);
            }
            Intrinsics.checkNotNull((Object)world);
            ArrayList entities = ExtensionsKt.selectEntitiesWithinAABB((World)world, EntityLivingBase.class, (AxisAlignedBB)ExtensionsKt.expand((AxisAlignedBB)ExtensionsKt.getBoundingBox((Number)x, (Number)y, (Number)z), (Number)5), ItemRodInterdiction::onAvatarUpdate$lambda$1);
            if (this.pushEntities(x, y, z, 5, 0.05, null, entities)) {
                if (tile.getElapsedFunctionalTicks() % 3 == 0) {
                    world.func_72908_a(x, y, z, "alfheim:wind", 0.4f, 1.0f);
                }
                tile.recieveMana(-4);
            }
        }
    }

    @NotNull
    public LibResourceLocations.ResourceLocationIL getOverlayResource(@NotNull IAvatarTile tile, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return LibResourceLocations.INSTANCE.getAvatarInterdiction();
    }

    private static final boolean onUsingTick$lambda$0(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.PLAYER_SELECTOR.INSTANCE.func_82704_a(it);
    }

    private static final boolean onAvatarUpdate$lambda$1(EntityLivingBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.AVATAR_SELECTOR.INSTANCE.func_82704_a((Entity)it);
    }

    public ItemRodInterdiction() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lalfheim/common/item/rod/ItemRodInterdiction$Companion;", "", "<init>", "()V", "COST", "", "PROWESS_COST", "PRIEST_COST", "AVATAR_COST", "VELOCITY", "", "PROWESS_VELOCITY", "PRIEST_VELOCITY", "RANGE", "PROWESS_RANGE", "PRIEST_RANGE", "PLAYER_SELECTOR", "AVATAR_SELECTOR", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lalfheim/common/item/rod/ItemRodInterdiction$Companion$AVATAR_SELECTOR;", "Lnet/minecraft/command/IEntitySelector;", "<init>", "()V", "isEntityApplicable", "", "e", "Lnet/minecraft/entity/Entity;", "Alfheim"})
        public static final class AVATAR_SELECTOR
        implements IEntitySelector {
            @NotNull
            public static final AVATAR_SELECTOR INSTANCE = new AVATAR_SELECTOR();

            private AVATAR_SELECTOR() {
            }

            public boolean func_82704_a(@NotNull Entity e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return e instanceof EntityLivingBase && !(e instanceof EntityPlayer) && !(e instanceof IBossDisplayData);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lalfheim/common/item/rod/ItemRodInterdiction$Companion$PLAYER_SELECTOR;", "Lnet/minecraft/command/IEntitySelector;", "<init>", "()V", "isEntityApplicable", "", "e", "Lnet/minecraft/entity/Entity;", "Alfheim"})
        public static final class PLAYER_SELECTOR
        implements IEntitySelector {
            @NotNull
            public static final PLAYER_SELECTOR INSTANCE = new PLAYER_SELECTOR();

            private PLAYER_SELECTOR() {
            }

            public boolean func_82704_a(@NotNull Entity e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return e instanceof EntityLivingBase && !(e instanceof IBossDisplayData) || e instanceof IProjectile && !(e instanceof IManaBurst);
            }
        }
    }
}

