/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.rod;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.item.ColorOverrideHelper;
import alfheim.client.core.helper.InterpolatedIconHelper;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.core.handler.ragnarok.RagnarokHandler;
import alfheim.common.item.ItemMod;
import alfheim.common.item.equipment.bauble.ItemPriestEmblem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0016\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015J\u0016\u0010/\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015R\u0014\u0010\u001f\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0014\u0010$\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u0014\u0010&\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010!R\u0014\u0010(\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010!R\u0014\u0010*\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010!\u00a8\u00060"}, d2={"Lalfheim/common/item/rod/ItemRodFlameStar;", "Lalfheim/common/item/ItemMod;", "Lvazkii/botania/api/mana/IManaUsingItem;", "name", "", "<init>", "(Ljava/lang/String;)V", "registerIcons", "", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "loadTextures", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "par1ItemStack", "Lnet/minecraft/item/ItemStack;", "getMaxItemUseDuration", "", "isFull3D", "", "usesMana", "stack", "onItemRightClick", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onUsingTick", "count", "COST", "getCOST", "()I", "PROWESS_COST", "getPROWESS_COST", "PRIEST_COST", "getPRIEST_COST", "DAMAGE", "getDAMAGE", "PROWESS_DAMAGE", "getPROWESS_DAMAGE", "PRIEST_DAMAGE", "getPRIEST_DAMAGE", "getCost", "prowess", "priest", "getDamage", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nItemRodFlameStar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemRodFlameStar.kt\nalfheim/common/item/rod/ItemRodFlameStar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1863#2,2:134\n*S KotlinDebug\n*F\n+ 1 ItemRodFlameStar.kt\nalfheim/common/item/rod/ItemRodFlameStar\n*L\n101#1:134,2\n*E\n"})
public final class ItemRodFlameStar
extends ItemMod
implements IManaUsingItem {
    private final int COST;
    private final int PROWESS_COST;
    private final int PRIEST_COST;
    private final int DAMAGE;
    private final int PROWESS_DAMAGE;
    private final int PRIEST_DAMAGE;

    public ItemRodFlameStar(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.field_77777_bU = 1;
        if (ASJUtilities.isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.COST = 10;
        this.PROWESS_COST = -2;
        this.PRIEST_COST = 3;
        this.DAMAGE = 2;
        this.PROWESS_DAMAGE = 1;
        this.PRIEST_DAMAGE = 5;
    }

    public /* synthetic */ ItemRodFlameStar(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "rodFlameStar";
        }
        this(string);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void loadTextures(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.map.func_130086_a() == 1) {
            TextureMap textureMap = event.map;
            Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
            this.field_77791_bV = InterpolatedIconHelper.INSTANCE.forItem(textureMap, this);
        }
    }

    @NotNull
    public EnumAction func_77661_b(@Nullable ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(@Nullable ItemStack par1ItemStack) {
        return 72000;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean usesMana(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    @NotNull
    public ItemStack func_77659_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityPlayer player, int count) {
        Vector3 vector3;
        MovingObjectPosition mop;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        World world = player.field_70170_p;
        boolean priest = !RagnarokHandler.INSTANCE.getBlockedPowers()[3] && ItemPriestEmblem.Companion.getEmblem(3, player) != null;
        boolean prowess = IManaProficiencyArmor.Helper.hasProficiency((EntityPlayer)player);
        int cost = this.getCost(prowess, priest);
        if (!ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)cost, (boolean)false)) {
            return;
        }
        double maxDistance = 8.0;
        if (priest) {
            maxDistance += 6.0;
        }
        if (prowess) {
            maxDistance += 2.0;
        }
        double distance = Math.max(Math.min(maxDistance, (double)(this.func_77626_a(stack) - count) * 0.2), 0.5);
        MovingObjectPosition movingObjectPosition = mop = ASJUtilities.getMouseOver((EntityLivingBase)((EntityLivingBase)player), (double)ExtensionsKt.getD((Number)distance), (boolean)true);
        if ((movingObjectPosition != null ? movingObjectPosition.field_72307_f : null) == null) {
            Vec3 vec3 = player.func_70040_Z();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLookVec(...)");
            vector3 = Vector3.mul$default((Vector3)new Vector3(vec3).normalize(), (Number)ExtensionsKt.getD((Number)distance), null, null, (int)6, null).add((Number)player.field_70165_t, (Number)(player.field_70163_u + (double)player.eyeHeight), (Number)player.field_70161_v);
        } else {
            Vec3 vec3 = mop.field_72307_f;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"hitVec");
            Vector3 v = new Vector3(vec3);
            switch (mop.field_72310_e) {
                case 1: {
                    v.add((Number)0, (Number)0.125, (Number)0);
                    break;
                }
                case 2: {
                    v.sub((Number)0, (Number)0, (Number)0.00390625);
                    break;
                }
                case 4: {
                    v.sub((Number)0.00390625, (Number)0, (Number)0);
                }
            }
            vector3 = v;
        }
        Vector3 hit = vector3;
        double x = hit.component1();
        double y = hit.component2();
        double z = hit.component3();
        Color color = new Color(ColorOverrideHelper.INSTANCE.getColor(player, 16335879));
        float[] fArray = color.getRGBColorComponents(null);
        Intrinsics.checkNotNull((Object)fArray);
        float r = fArray[0];
        float g = fArray[1];
        float b = fArray[2];
        double[] dArray = new double[]{x, y, z, ExtensionsKt.getD((Number)Float.valueOf(r)), ExtensionsKt.getD((Number)Float.valueOf(g)), ExtensionsKt.getD((Number)Float.valueOf(b)), 1.0};
        VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.SPARKLE, world.field_73011_w.field_76574_g, dArray);
        int power = this.getDamage(prowess, priest);
        Intrinsics.checkNotNull((Object)world);
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityLivingBase.class, (AxisAlignedBB)ExtensionsKt.expand((AxisAlignedBB)ExtensionsKt.getBoundingBox((Number)x, (Number)y, (Number)z), (Number)0.5));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityLivingBase entity = (EntityLivingBase)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)entity, (Object)player)) continue;
            ExtensionsKt.knockback((Entity)((Entity)entity), (Entity)((Entity)player), (float)0.5f);
            if (entity.func_110143_aJ() <= 0.0f || !entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76361_j(), ExtensionsKt.getF((Number)power))) continue;
            ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)cost, (boolean)true);
            entity.func_70015_d(power * 20);
        }
    }

    public final int getCOST() {
        return this.COST;
    }

    public final int getPROWESS_COST() {
        return this.PROWESS_COST;
    }

    public final int getPRIEST_COST() {
        return this.PRIEST_COST;
    }

    public final int getDAMAGE() {
        return this.DAMAGE;
    }

    public final int getPROWESS_DAMAGE() {
        return this.PROWESS_DAMAGE;
    }

    public final int getPRIEST_DAMAGE() {
        return this.PRIEST_DAMAGE;
    }

    public final int getCost(boolean prowess, boolean priest) {
        int d = this.COST;
        if (prowess) {
            d += this.PROWESS_COST;
        }
        if (priest) {
            d += this.PRIEST_COST;
        }
        return d;
    }

    public final int getDamage(boolean prowess, boolean priest) {
        int d = this.DAMAGE;
        if (prowess) {
            d += this.PROWESS_DAMAGE;
        }
        if (priest) {
            d += this.PRIEST_DAMAGE;
        }
        return d;
    }

    public ItemRodFlameStar() {
        this(null, 1, null);
    }
}

