/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.relic;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.common.core.handler.ragnarok.RagnarokHandler;
import alfheim.common.item.AlfheimItems;
import baubles.api.BaubleType;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lalfheim/common/item/relic/ItemSifRing;", "Lvazkii/botania/common/item/relic/ItemRelicBauble;", "<init>", "()V", "onPlayerTick", "", "e", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "list", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lnet/minecraft/util/ChunkCoordinates;", "Lnet/minecraft/block/Block;", "getList", "()Ljava/util/ArrayList;", "reviveCacti", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "supplyVineballs", "growAnimals", "getBaubleType", "Lbaubles/api/BaubleType;", "Companion", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nItemSifRing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemSifRing.kt\nalfheim/common/item/relic/ItemSifRing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1863#2,2:99\n*S KotlinDebug\n*F\n+ 1 ItemSifRing.kt\nalfheim/common/item/relic/ItemSifRing\n*L\n76#1:99,2\n*E\n"})
public final class ItemSifRing
extends ItemRelicBauble {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<Pair<ChunkCoordinates, Block>> list;

    public ItemSifRing() {
        super("SifRing");
        ExtensionsKt.eventForge((Object)((Object)this));
        this.list = new ArrayList();
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull LivingEvent.LivingUpdateEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (RagnarokHandler.INSTANCE.getBlockedPowers()[5]) {
            return;
        }
        EntityLivingBase entityLivingBase = e.entityLiving;
        EntityPlayer entityPlayer = entityLivingBase instanceof EntityPlayer ? (EntityPlayer)entityLivingBase : null;
        if (entityPlayer == null) {
            return;
        }
        EntityPlayer player = entityPlayer;
        ItemStack itemStack = Companion.getSifRing(player);
        if (itemStack == null) {
            return;
        }
        ItemStack ring = itemStack;
        this.reviveCacti(ring, player);
        this.supplyVineballs(ring, player);
        this.growAnimals(ring, player);
    }

    @NotNull
    public final ArrayList<Pair<ChunkCoordinates, Block>> getList() {
        return this.list;
    }

    public final void reviveCacti(@NotNull ItemStack stack, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!ManaItemHandler.requestManaExact((ItemStack)stack, (EntityPlayer)player, (int)20, (boolean)true)) {
            return;
        }
        World world = player.field_70170_p;
        Integer[] integerArray = Vector3.Companion.fromEntity((Entity)player).mf();
        int x = ((Number)integerArray[0]).intValue();
        int y = ((Number)integerArray[1]).intValue();
        int z = ((Number)integerArray[2]).intValue();
        for (int i = -4; i < 5; ++i) {
            for (int j = -3; j < 4; ++j) {
                for (int k = -4; k < 5; ++k) {
                    if (world.func_147439_a(x + i, y + j, z + k) != Blocks.field_150330_I) continue;
                    boolean cactus = Blocks.field_150434_aF.func_149718_j(world, x + i, y + j, z + k);
                    boolean sapling = Blocks.field_150345_g.func_149718_j(world, x + i, y + j, z + k);
                    if (!cactus && !sapling) continue;
                    this.list.add((Pair<ChunkCoordinates, Block>)TuplesKt.to((Object)new ChunkCoordinates(x + i, y + j, z + k), (Object)(cactus ? Blocks.field_150434_aF : Blocks.field_150345_g)));
                }
            }
        }
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)this.list);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        ChunkCoordinates pos = (ChunkCoordinates)pair2.component1();
        Block block = (Block)pair2.component2();
        int i = ExtensionsKt.component1((ChunkCoordinates)pos);
        int j = ExtensionsKt.component2((ChunkCoordinates)pos);
        int k = ExtensionsKt.component3((ChunkCoordinates)pos);
        world.func_147449_b(i, j, k, block);
        this.list.clear();
    }

    public final void supplyVineballs(@NotNull ItemStack stack, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.func_70694_bm();
        if ((itemStack != null ? itemStack.func_77973_b() : null) == ModItems.slingshot && !player.field_71071_by.func_146028_b(ModItems.vineBall) && ManaItemHandler.requestManaExact((ItemStack)stack, (EntityPlayer)player, (int)50, (boolean)true)) {
            player.field_71071_by.func_70441_a(new ItemStack(ModItems.vineBall));
        }
    }

    public final void growAnimals(@NotNull ItemStack stack, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        World world = player.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        ArrayList list = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityAgeable.class, (AxisAlignedBB)ExtensionsKt.boundingBox((Entity)((Entity)player), (Number)8));
        CollectionsKt.removeAll((List)list, ItemSifRing::growAnimals$lambda$0);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityAgeable it = (EntityAgeable)element$iv;
            boolean bl = false;
            if (!ManaItemHandler.requestManaExact((ItemStack)stack, (EntityPlayer)player, (int)1, (boolean)true)) {
                return;
            }
            int n = it.func_70874_b();
            it.func_70873_a(n + 1);
        }
    }

    @NotNull
    public BaubleType getBaubleType(@Nullable ItemStack stack) {
        return BaubleType.RING;
    }

    private static final boolean growAnimals$lambda$0(EntityAgeable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.func_70631_g_();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lalfheim/common/item/relic/ItemSifRing$Companion;", "", "<init>", "()V", "getSifRing", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "isSifRing", "", "stack", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ItemStack getSifRing(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            Intrinsics.checkNotNull((Object)baubles);
            ItemStack stack1 = ExtensionsKt.get((IInventory)((IInventory)baubles), (int)1);
            ItemStack stack2 = ExtensionsKt.get((IInventory)((IInventory)baubles), (int)2);
            return this.isSifRing(stack1) ? stack1 : (this.isSifRing(stack2) ? stack2 : null);
        }

        private final boolean isSifRing(ItemStack stack) {
            return stack != null && (stack.func_77973_b() == AlfheimItems.INSTANCE.getPriestRingSif() || stack.func_77973_b() == ModItems.aesirRing);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

