/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.entity.EntityThrownPotion;
import alfheim.common.item.ItemMod;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J2\u0010#\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016J'\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\u0010\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020%H\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001dH\u0016J\u0018\u00101\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0010\u00102\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u001c\u00103\u001a\u00020\u001d2\b\u00104\u001a\u0004\u0018\u00010(2\b\u00105\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u00106\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010'\u001a\u0004\u0018\u00010(J\u0016\u00106\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010'\u001a\u00020+R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u00067"}, d2={"Lalfheim/common/item/ItemSplashPotion;", "Lalfheim/common/item/ItemMod;", "Lvazkii/botania/api/brew/IBrewItem;", "Lvazkii/botania/api/brew/IBrewContainer;", "<init>", "()V", "itemIconFluid", "Lnet/minecraft/util/IIcon;", "getItemIconFluid", "()Lnet/minecraft/util/IIcon;", "setItemIconFluid", "(Lnet/minecraft/util/IIcon;)V", "getSubItems", "", "item", "Lnet/minecraft/item/Item;", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "list", "", "", "onItemRightClick", "Lnet/minecraft/item/ItemStack;", "stack", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getColor", "", "getColorFromItemStack", "pass", "registerIcons", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "addInformation", "adv", "", "getItemForBrew", "brew", "Lvazkii/botania/api/brew/Brew;", "addStringToTooltip", "s", "", "tooltip", "addStringToTooltip$Alfheim", "requiresMultipleRenderPasses", "getRenderPasses", "metadata", "getIcon", "getBrew", "getManaCost", "p0", "p1", "setBrew", "Alfheim"})
public final class ItemSplashPotion
extends ItemMod
implements IBrewItem,
IBrewContainer {
    public IIcon itemIconFluid;

    public ItemSplashPotion() {
        super("splashPotion");
        this.field_77777_bU = 1;
    }

    @NotNull
    public final IIcon getItemIconFluid() {
        IIcon iIcon = this.itemIconFluid;
        if (iIcon != null) {
            return iIcon;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"itemIconFluid");
        return null;
    }

    public final void setItemIconFluid(@NotNull IIcon iIcon) {
        Intrinsics.checkNotNullParameter((Object)iIcon, (String)"<set-?>");
        this.itemIconFluid = iIcon;
    }

    public void func_150895_a(@NotNull Item item, @Nullable CreativeTabs tab, @NotNull List<Object> list) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        for (String brew : BotaniaAPI.brewMap.keySet()) {
            Object v = BotaniaAPI.brewMap.get(brew);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type vazkii.botania.api.brew.Brew");
            list.add(this.getItemForBrew((Brew)v, new ItemStack((Item)this)));
        }
    }

    @NotNull
    public ItemStack func_77659_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!world.field_72995_K) {
            ExtensionsKt.spawn((Entity)((Entity)new EntityThrownPotion(player, stack)), (World)world);
            int n = stack.field_77994_a;
            stack.field_77994_a = n + -1;
        }
        return stack;
    }

    public final int getColor(@Nullable ItemStack stack) {
        if (stack != null) {
            Color color = new Color(this.getBrew(stack).getColor(stack));
            int add = ExtensionsKt.getI((Number)(Math.sin(ExtensionsKt.getD((Number)Botania.proxy.getWorldElapsedTicks()) * 0.1) * 16.0));
            int r = Math.max(0, Math.min(255, color.getRed() + add));
            int g = Math.max(0, Math.min(255, color.getGreen() + add));
            int b = Math.max(0, Math.min(255, color.getBlue() + add));
            return r << 16 | g << 8 | b;
        }
        return 0xFFFFFF;
    }

    public int func_82790_a(@Nullable ItemStack stack, int pass) {
        return pass == 0 ? 0xCCCCCFF : this.getColor(stack);
    }

    @Override
    public void func_94581_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
        this.field_77791_bV = IconHelper.forName((IIconRegister)reg, (String)"vial0");
        this.setItemIconFluid(IconHelper.forName((IIconRegister)reg, (String)"vial1_0"));
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable EntityPlayer player, @NotNull List<Object> list, boolean adv) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Brew brew = this.getBrew(stack);
        Object[] objectArray = new Object[]{StatCollector.func_74838_a((String)brew.getUnlocalizedName(stack))};
        this.addStringToTooltip$Alfheim(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74837_a((String)"botaniamisc.brewOf", (Object[])objectArray), list);
        for (PotionEffect effect : brew.getPotionEffects(stack)) {
            Potion potion = Potion.field_76425_a[effect.field_76462_a];
            EnumChatFormatting format = potion.field_76418_K ? EnumChatFormatting.RED : EnumChatFormatting.GRAY;
            this.addStringToTooltip$Alfheim("" + format + StatCollector.func_74838_a((String)effect.func_76453_d()) + (effect.field_76461_c == 0 ? "" : ' ' + StatCollector.func_74838_a((String)("botania.roman" + (effect.field_76461_c + 1)))) + EnumChatFormatting.GRAY + (potion.func_76403_b() ? "" : " (" + Potion.func_76389_a((PotionEffect)effect) + ')'), list);
        }
    }

    @NotNull
    public ItemStack getItemForBrew(@NotNull Brew brew, @Nullable ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)brew, (String)"brew");
        ItemStack brewStack = new ItemStack((Item)this);
        this.setBrew(brewStack, brew);
        return brewStack;
    }

    public final void addStringToTooltip$Alfheim(@NotNull String s, @Nullable List<Object> tooltip) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            List<Object> list = tooltip;
            if (list == null) break block0;
            CharSequence charSequence = s;
            Regex regex = new Regex("&");
            String string = "\u00a7";
            list.add(regex.replace(charSequence, string));
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @NotNull
    public IIcon getIcon(@NotNull ItemStack stack, int pass) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        IIcon iIcon = pass == 0 ? this.field_77791_bV : this.getItemIconFluid();
        Intrinsics.checkNotNull((Object)iIcon);
        return iIcon;
    }

    @NotNull
    public Brew getBrew(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        String key = ItemNBTHelper.getString((ItemStack)stack, (String)"brewKey", (String)"");
        Brew brew = BotaniaAPI.getBrewFromKey((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)brew, (String)"getBrewFromKey(...)");
        return brew;
    }

    public int getManaCost(@Nullable Brew p0, @Nullable ItemStack p1) {
        Brew brew = p0;
        return brew != null ? ExtensionsKt.getI((Number)((double)brew.getManaCost() * 1.5)) : 400;
    }

    public final void setBrew(@NotNull ItemStack stack, @Nullable Brew brew) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Brew brew2 = brew;
        if (brew2 == null) {
            brew2 = BotaniaAPI.fallbackBrew;
        }
        String string = brew2.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        this.setBrew(stack, string);
    }

    public final void setBrew(@NotNull ItemStack stack, @NotNull String brew) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)brew, (String)"brew");
        ItemNBTHelper.setString((ItemStack)stack, (String)"brewKey", (String)brew);
    }
}

