/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.tinkersconstruct.modifier;

import alfheim.common.integration.tinkersconstruct.TinkersConstructAlfheimModule;
import alfheim.common.integration.tinkersconstruct.modifier.ModManaRepair;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.IAmmo;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u001a"}, d2={"Lalfheim/common/integration/tinkersconstruct/modifier/AModNatural;", "Ltconstruct/library/ActiveToolMod;", "<init>", "()V", "updateTool", "", "tool", "Ltconstruct/library/tools/ToolCore;", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "entity", "Lnet/minecraft/entity/Entity;", "repair", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "generateMana", "damageTool", "", "damage", "", "Lnet/minecraft/entity/EntityLivingBase;", "getRepairCost", "Alfheim"})
public final class AModNatural
extends ActiveToolMod {
    @NotNull
    public static final AModNatural INSTANCE = new AModNatural();

    private AModNatural() {
    }

    public void updateTool(@NotNull ToolCore tool, @NotNull ItemStack stack, @NotNull World world, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        EntityPlayer entityPlayer = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (entityPlayer == null) {
            return;
        }
        EntityPlayer player = entityPlayer;
        if (tool instanceof IAmmo) {
            return;
        }
        NBTTagCompound nBTTagCompound = ItemNBTHelper.getCompound((ItemStack)stack, (String)tool.getBaseTagName(), (boolean)true);
        if (nBTTagCompound == null) {
            return;
        }
        NBTTagCompound tag = nBTTagCompound;
        this.repair(stack, tag, player);
        this.generateMana(stack, tag, player);
    }

    public final void repair(@NotNull ItemStack stack, @NotNull NBTTagCompound tag, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int damage = tag.func_74762_e("Damage");
        if (damage <= 0) {
            return;
        }
        int cost = this.getRepairCost(tag) * 2;
        if (cost > 0 && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)cost, (boolean)true)) {
            AbilityHelper.healTool((ItemStack)stack, (int)1, (EntityLivingBase)((EntityLivingBase)player), (boolean)true);
        }
    }

    public final void generateMana(@NotNull ItemStack stack, @NotNull NBTTagCompound tag, @NotNull EntityPlayer player) {
        int addDelay;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int headMaterial = tag.func_74762_e("Head");
        int n = addDelay = stack == player.func_71045_bC() ? 1 : 10;
        if (ArraysKt.contains((int[])TinkersConstructAlfheimModule.INSTANCE.getManaGenMaterials(), (int)headMaterial)) {
            Integer n2 = TinkersConstructAlfheimModule.INSTANCE.getManaGenDelay().get(headMaterial);
            if (player.field_70173_aa % (n2 != null ? n2 : 20) * addDelay == 0) {
                ManaItemHandler.dispatchMana((ItemStack)stack, (EntityPlayer)player, (int)1, (boolean)true);
            }
        }
    }

    public boolean damageTool(@NotNull ItemStack stack, int damage, @Nullable EntityLivingBase entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (damage <= 0) {
            return false;
        }
        EntityPlayer entityPlayer = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (entityPlayer == null) {
            return false;
        }
        EntityPlayer player = entityPlayer;
        Item item = stack.func_77973_b();
        IModifyable iModifyable = item instanceof IModifyable ? (IModifyable)item : null;
        if (iModifyable == null) {
            return false;
        }
        IModifyable item2 = iModifyable;
        String[] stringArray = item2.getTraits();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getTraits(...)");
        if (ArraysKt.contains((Object[])stringArray, (Object)"ammo")) {
            return false;
        }
        NBTTagCompound nBTTagCompound = ItemNBTHelper.getCompound((ItemStack)stack, (String)item2.getBaseTagName(), (boolean)true);
        if (nBTTagCompound == null) {
            return false;
        }
        NBTTagCompound tag = nBTTagCompound;
        int mana = this.getRepairCost(tag);
        if (mana == 0) {
            return false;
        }
        return ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)mana, (boolean)true);
    }

    public final int getRepairCost(@NotNull NBTTagCompound tag) {
        int n;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int headMaterial = tag.func_74762_e("Head");
        if (ArraysKt.contains((int[])TinkersConstructAlfheimModule.INSTANCE.getManaRepairMaterials(), (int)headMaterial)) {
            Integer n2 = TinkersConstructAlfheimModule.INSTANCE.getManaRepairCost().get(headMaterial);
            n = n2 != null ? n2 : 10;
        } else {
            n = tag.func_74767_n(ModManaRepair.INSTANCE.key) ? 5 : 0;
        }
        return n;
    }
}

