/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.floatingisland;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.floatingisland.EntityFloatingIsland;
import alfheim.common.floatingisland.FloatingIslandBlockAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0004\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"J0\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010!\u001a\u00020\"J2\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020'2\u0006\u0010%\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0002J2\u0010(\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J0\u0010,\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J:\u0010/\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010+\u001a\u00020\u001a2\u0006\u00101\u001a\u00020$H\u0002J \u00102\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0002J0\u00103\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u00104\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0018\u0010#\u001a\u00020'*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0018\u0010%\u001a\u00020'*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00107R\u0018\u0010&\u001a\u00020'*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00107\u00a8\u0006:"}, d2={"Lalfheim/common/floatingisland/FloatingIslandPathfinder;", "", "island", "Lalfheim/common/floatingisland/EntityFloatingIsland;", "canPassOpenWoodenDoors", "", "canPassClosedWoodenDoors", "avoidsWater", "<init>", "(Lalfheim/common/floatingisland/EntityFloatingIsland;ZZZ)V", "getIsland", "()Lalfheim/common/floatingisland/EntityFloatingIsland;", "getCanPassOpenWoodenDoors", "()Z", "getCanPassClosedWoodenDoors", "getAvoidsWater", "worldMap", "Lalfheim/common/floatingisland/FloatingIslandBlockAccess;", "getWorldMap", "()Lalfheim/common/floatingisland/FloatingIslandBlockAccess;", "path", "Lnet/minecraft/pathfinding/Path;", "pointMap", "Lnet/minecraft/util/IntHashMap;", "pathOptions", "", "Lnet/minecraft/pathfinding/PathPoint;", "[Lnet/minecraft/pathfinding/PathPoint;", "createEntityPathTo", "Lnet/minecraft/pathfinding/PathEntity;", "host", "Lnet/minecraft/entity/Entity;", "target", "pathSearchRange", "", "x", "", "y", "z", "", "addToPath", "start", "end", "offset", "findPathOptions", "currentPoint", "targetPoint", "getSafePoint", "_y", "yOffset", "openPoint", "getEntityCollisionState", "createEntityPath", "", "getX", "(Ljava/lang/Number;)D", "getY", "getZ", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nFloatingIslandPathfinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingIslandPathfinder.kt\nalfheim/common/floatingisland/FloatingIslandPathfinder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,274:1\n11102#2:275\n11437#2,3:276\n37#3,2:279\n*S KotlinDebug\n*F\n+ 1 FloatingIslandPathfinder.kt\nalfheim/common/floatingisland/FloatingIslandPathfinder\n*L\n257#1:275\n257#1:276,3\n268#1:279,2\n*E\n"})
public final class FloatingIslandPathfinder {
    @NotNull
    private final EntityFloatingIsland island;
    private final boolean canPassOpenWoodenDoors;
    private final boolean canPassClosedWoodenDoors;
    private final boolean avoidsWater;
    @NotNull
    private final FloatingIslandBlockAccess worldMap;
    @NotNull
    private final Path path;
    @NotNull
    private final IntHashMap pointMap;
    @NotNull
    private final PathPoint[] pathOptions;

    public FloatingIslandPathfinder(@NotNull EntityFloatingIsland island, boolean canPassOpenWoodenDoors, boolean canPassClosedWoodenDoors, boolean avoidsWater) {
        Intrinsics.checkNotNullParameter((Object)island, (String)"island");
        this.island = island;
        this.canPassOpenWoodenDoors = canPassOpenWoodenDoors;
        this.canPassClosedWoodenDoors = canPassClosedWoodenDoors;
        this.avoidsWater = avoidsWater;
        this.worldMap = this.island.getBlockAccess();
        this.path = new Path();
        this.pointMap = new IntHashMap();
        this.pathOptions = new PathPoint[32];
    }

    @NotNull
    public final EntityFloatingIsland getIsland() {
        return this.island;
    }

    public final boolean getCanPassOpenWoodenDoors() {
        return this.canPassOpenWoodenDoors;
    }

    public final boolean getCanPassClosedWoodenDoors() {
        return this.canPassClosedWoodenDoors;
    }

    public final boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    @NotNull
    public final FloatingIslandBlockAccess getWorldMap() {
        return this.worldMap;
    }

    @Nullable
    public final PathEntity createEntityPathTo(@NotNull Entity host, @NotNull Entity target, float pathSearchRange) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.createEntityPathTo(host, this.getX(target.field_70165_t), this.getY(target.field_70121_D.field_72338_b), this.getZ(target.field_70161_v), pathSearchRange);
    }

    @Nullable
    public final PathEntity createEntityPathTo(@NotNull Entity host, int x, int y, int z, float pathSearchRange) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.createEntityPathTo(host, this.getX(x) + 0.5, this.getY(y) + 0.5, this.getZ(z) + 0.5, pathSearchRange);
    }

    private final PathEntity createEntityPathTo(Entity host, double x, double y, double z, float pathSearchRange) {
        this.path.func_75848_a();
        this.pointMap.func_76046_c();
        int i = ExtensionsKt.mfloor((double)(this.getY(host.field_70121_D.field_72338_b) + 0.5));
        PathPoint start = this.openPoint(ExtensionsKt.mfloor((double)this.getX(host.field_70121_D.field_72340_a)), i, ExtensionsKt.mfloor((double)this.getZ(host.field_70121_D.field_72339_c)));
        PathPoint end = this.openPoint(ExtensionsKt.mfloor((double)(x - (double)host.field_70130_N / 2.0)), ExtensionsKt.mfloor((double)y), ExtensionsKt.mfloor((double)(z - (double)host.field_70130_N / 2.0)));
        PathPoint offset = new PathPoint(ExtensionsKt.mfloor((double)((double)host.field_70130_N + 1.0)), ExtensionsKt.mfloor((double)((double)host.field_70131_O + 1.0)), ExtensionsKt.mfloor((double)((double)host.field_70130_N + 1.0)));
        return this.addToPath(host, start, end, offset, pathSearchRange);
    }

    private final PathEntity addToPath(Entity host, PathPoint start, PathPoint end, PathPoint offset, float pathSearchRange) {
        start.field_75836_e = 0.0f;
        start.field_75834_g = start.field_75833_f = start.func_75832_b(end);
        this.path.func_75848_a();
        this.path.func_75849_a(start);
        PathPoint newStart = start;
        while (!this.path.func_75845_e()) {
            PathPoint currentPoint = this.path.func_75844_c();
            if (Intrinsics.areEqual((Object)currentPoint, (Object)end)) {
                return this.createEntityPath(end);
            }
            if (currentPoint.func_75832_b(end) < newStart.func_75832_b(end)) {
                newStart = currentPoint;
            }
            currentPoint.field_75842_i = true;
            Intrinsics.checkNotNull((Object)currentPoint);
            int optionsCount = this.findPathOptions(host, currentPoint, offset, end, pathSearchRange);
            for (int j = 0; j < optionsCount; ++j) {
                PathPoint pathOption;
                if (this.pathOptions[j] == null) continue;
                float newDistance = currentPoint.field_75836_e + currentPoint.func_75832_b(pathOption);
                if (pathOption.func_75831_a() && !(newDistance < pathOption.field_75836_e)) continue;
                pathOption.field_75841_h = currentPoint;
                pathOption.field_75836_e = newDistance;
                pathOption.field_75833_f = pathOption.func_75832_b(end);
                if (pathOption.func_75831_a()) {
                    this.path.func_75850_a(pathOption, pathOption.field_75836_e + pathOption.field_75833_f);
                    continue;
                }
                pathOption.field_75834_g = pathOption.field_75836_e + pathOption.field_75833_f;
                this.path.func_75849_a(pathOption);
            }
        }
        return newStart == start ? null : this.createEntityPath(newStart);
    }

    private final int findPathOptions(Entity host, PathPoint currentPoint, PathPoint offset, PathPoint targetPoint, float pathSearchRange) {
        int optionsCount = 0;
        int collisionState = this.getEntityCollisionState(host, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, offset) == 1 ? 1 : 0;
        PathPoint pathPosZ = this.getSafePoint(host, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, offset, collisionState);
        PathPoint pathNegX = this.getSafePoint(host, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, offset, collisionState);
        PathPoint pathPosX = this.getSafePoint(host, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, offset, collisionState);
        PathPoint pathNegZ = this.getSafePoint(host, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, offset, collisionState);
        if (pathPosZ != null && !pathPosZ.field_75842_i && pathPosZ.func_75829_a(targetPoint) < pathSearchRange) {
            this.pathOptions[optionsCount++] = pathPosZ;
        }
        if (pathNegX != null && !pathNegX.field_75842_i && pathNegX.func_75829_a(targetPoint) < pathSearchRange) {
            this.pathOptions[optionsCount++] = pathNegX;
        }
        if (pathPosX != null && !pathPosX.field_75842_i && pathPosX.func_75829_a(targetPoint) < pathSearchRange) {
            this.pathOptions[optionsCount++] = pathPosX;
        }
        if (pathNegZ != null && !pathNegZ.field_75842_i && pathNegZ.func_75829_a(targetPoint) < pathSearchRange) {
            this.pathOptions[optionsCount++] = pathNegZ;
        }
        return optionsCount;
    }

    private final PathPoint getSafePoint(Entity host, int x, int _y, int z, PathPoint offset, int yOffset) {
        int y = _y;
        PathPoint nextPoint = null;
        int collisionState = this.getEntityCollisionState(host, x, y, z, offset);
        if (collisionState == 2) {
            return this.openPoint(x, y, z);
        }
        if (collisionState == 1) {
            nextPoint = this.openPoint(x, y, z);
        }
        if (nextPoint == null && yOffset > 0 && collisionState != -3 && collisionState != -4 && this.getEntityCollisionState(host, x, y + yOffset, z, offset) == 1) {
            nextPoint = this.openPoint(x, y + yOffset, z);
            y += yOffset;
        }
        if (nextPoint == null) {
            return null;
        }
        int j1 = 0;
        int newCollisionState = 0;
        while (y > 0) {
            newCollisionState = this.getEntityCollisionState(host, x, y - 1, z, offset);
            if (this.avoidsWater && newCollisionState == -1) {
                return null;
            }
            if (newCollisionState != 1) break;
            if (j1++ >= host.func_82143_as()) {
                return null;
            }
            if (--y <= 0) continue;
            nextPoint = this.openPoint(x, y, z);
        }
        if (newCollisionState == -2) {
            return null;
        }
        return nextPoint;
    }

    private final PathPoint openPoint(int x, int y, int z) {
        PathPoint pathpoint;
        int l = PathPoint.func_75830_a((int)x, (int)y, (int)z);
        Object object = this.pointMap.func_76041_a(l);
        PathPoint pathPoint = pathpoint = object instanceof PathPoint ? (PathPoint)object : null;
        if (pathpoint == null) {
            pathpoint = new PathPoint(x, y, z);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }

    private final int getEntityCollisionState(Entity host, int x, int y, int z, PathPoint offset) {
        boolean foundSomeSemiBlockingShit = false;
        int n = x + offset.field_75839_a;
        for (int i = x; i < n; ++i) {
            int n2 = y + offset.field_75837_b;
            for (int j = y; j < n2; ++j) {
                int n3 = z + offset.field_75838_c;
                for (int k = z; k < n3; ++k) {
                    Block block = this.worldMap.func_147439_a(i, j, k);
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    if (block == Blocks.field_150415_aT) {
                        foundSomeSemiBlockingShit = true;
                    } else if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                        if (!this.canPassOpenWoodenDoors && block == Blocks.field_150466_ao) {
                            return 0;
                        }
                    } else {
                        if (this.avoidsWater) {
                            return -1;
                        }
                        foundSomeSemiBlockingShit = true;
                    }
                    int blockRenderType = block.func_149645_b();
                    if (blockRenderType == 9) {
                        int startZ;
                        int startY;
                        int startX = ExtensionsKt.mfloor((double)this.getX(host.field_70165_t));
                        if (this.worldMap.func_147439_a(startX, startY = ExtensionsKt.mfloor((double)this.getY(host.field_70163_u)), startZ = ExtensionsKt.mfloor((double)this.getZ(host.field_70161_v))).func_149645_b() == 9 || this.worldMap.func_147439_a(startX, startY - 1, startZ).func_149645_b() == 9) continue;
                        return -3;
                    }
                    if (block.func_149655_b((IBlockAccess)this.worldMap, i, j, k)) continue;
                    if (this.canPassClosedWoodenDoors) {
                        if (block == Blocks.field_150466_ao) continue;
                    }
                    if (blockRenderType == 11 || block == Blocks.field_150396_be || blockRenderType == 32) {
                        return -3;
                    }
                    if (block == Blocks.field_150415_aT) {
                        return -4;
                    }
                    if (block.func_149688_o() != Material.field_151587_i) {
                        return 0;
                    }
                    if (host.func_70058_J()) continue;
                    return -2;
                }
            }
        }
        return foundSomeSemiBlockingShit ? 2 : 1;
    }

    /*
     * WARNING - void declaration
     */
    private final PathEntity createEntityPath(PathPoint end) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        int i = 1;
        PathPoint start = end;
        while (start.field_75841_h != null) {
            ++i;
            start = start.field_75841_h;
        }
        PathPoint[] path = new PathPoint[i];
        start = end;
        path[--i] = end;
        while (start.field_75841_h != null) {
            start = start.field_75841_h;
            path[--i] = start;
        }
        Object $this$map$iv = path;
        boolean $i$f$map = false;
        PathPoint[] pathPointArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PathPoint[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            PathPoint pathPoint;
            void it;
            void item$iv$iv;
            void var13_13 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it == null) {
                pathPoint = null;
            } else {
                PathPoint pathPoint2;
                PathPoint $this$createEntityPath_u24lambda_u241_u24lambda_u240 = pathPoint2 = new PathPoint(it.field_75839_a + ExtensionsKt.mfloor((double)(this.island.field_70165_t + 0.5)), it.field_75837_b + ExtensionsKt.mfloor((double)this.island.field_70163_u), it.field_75838_c + ExtensionsKt.mfloor((double)(this.island.field_70161_v + 0.5)));
                boolean bl2 = false;
                $this$createEntityPath_u24lambda_u241_u24lambda_u240.field_75835_d = it.field_75835_d;
                $this$createEntityPath_u24lambda_u241_u24lambda_u240.field_75836_e = it.field_75836_e;
                $this$createEntityPath_u24lambda_u241_u24lambda_u240.field_75833_f = it.field_75833_f;
                $this$createEntityPath_u24lambda_u241_u24lambda_u240.field_75834_g = it.field_75834_g;
                $this$createEntityPath_u24lambda_u241_u24lambda_u240.field_75841_h = it.field_75841_h;
                $this$createEntityPath_u24lambda_u241_u24lambda_u240.field_75842_i = it.field_75842_i;
                pathPoint = pathPoint2;
            }
            collection.add(pathPoint);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        PathPoint[] pathPointArray2 = thisCollection$iv.toArray(new PathPoint[0]);
        return new PathEntity(pathPointArray2);
    }

    private final double getX(Number $this$x) {
        return ExtensionsKt.getD((Number)$this$x) - (this.island.field_70165_t - 0.5);
    }

    private final double getY(Number $this$y) {
        return ExtensionsKt.getD((Number)$this$y) - this.island.field_70163_u;
    }

    private final double getZ(Number $this$z) {
        return ExtensionsKt.getD((Number)$this$z) - (this.island.field_70161_v - 0.5);
    }
}

