/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.floatingisland;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.BlockElement;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.LocationElement;
import alexsocol.asjlib.UnsafeSchemaUtils;
import alexsocol.asjlib.math.Vector3;
import alexsocol.patcher.event.ServerStoppedEvent;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.AlfheimFluffBlocks;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.floatingisland.EntityFloatingIsland;
import alfheim.common.floatingisland.FloatingIslandBlockAccess;
import alfheim.common.world.dim.alfheim.WorldProviderAlfheim;
import alfheim.common.world.dim.alfheim.customgens.WorldGenGrass;
import alfheim.common.world.dim.alfheim.customgens.YggdrasilGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import ru.vamig.worldengine.WE_Biome;
import ru.vamig.worldengine.WE_ChunkProvider;
import ru.vamig.worldengine.WE_PerlinNoise;
import vazkii.botania.common.block.ModBlocks;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J(\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J6\u0010!\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0014J.\u0010#\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010+\u001a&\u0012\u0004\u0012\u00020\u0005\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050-0'0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u00102\u001a&\u0012\"\u0012 \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050403\u0012\u0004\u0012\u0002050403X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106\u00a8\u00067"}, d2={"Lalfheim/common/floatingisland/FloatingIslandGenerator;", "", "<init>", "()V", "genTimer", "", "getGenTimer", "()I", "setGenTimer", "(I)V", "onServerStop", "", "e", "Lalexsocol/patcher/event/ServerStoppedEvent;", "worldTickEvent", "Lcpw/mods/fml/common/gameevent/TickEvent$WorldTickEvent;", "generate", "island", "Lalfheim/common/floatingisland/EntityFloatingIsland;", "hasBlock", "", "x", "y", "z", "ix", "", "iz", "generateSubstrate", "world", "Lalfheim/common/floatingisland/FloatingIslandBlockAccess;", "rand", "Lkotlin/random/Random;", "generateSurface", "genTrees", "isForest", "genGrassAndFlowers", "genStructure", "Lalexsocol/asjlib/math/Vector3;", "structure", "", "Lalexsocol/asjlib/BlockElement;", "pools", "ruins", "lootboxes", "Ljava/util/HashMap;", "Lkotlin/Triple;", "lootboxTypes", "", "dreamTreeSchema", "sadOakSchema", "dynamicLeaves", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "[Lkotlin/Pair;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nFloatingIslandGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingIslandGenerator.kt\nalfheim/common/floatingisland/FloatingIslandGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,396:1\n808#2,11:397\n1755#2,3:408\n1863#2,2:412\n1863#2:414\n1863#2,2:415\n1864#2:417\n295#2,2:422\n1863#2:424\n1863#2,2:425\n1864#2:427\n1557#2:428\n1628#2,2:429\n1557#2:431\n1628#2,3:432\n1630#2:435\n1#3:411\n13346#4:418\n13346#4,2:419\n13347#4:421\n*S KotlinDebug\n*F\n+ 1 FloatingIslandGenerator.kt\nalfheim/common/floatingisland/FloatingIslandGenerator\n*L\n43#1:397,11\n53#1:408,3\n141#1:412,2\n167#1:414\n170#1:415,2\n167#1:417\n333#1:422,2\n338#1:424\n341#1:425,2\n338#1:427\n388#1:428\n388#1:429,2\n390#1:431\n390#1:432,3\n388#1:435\n234#1:418\n235#1:419,2\n234#1:421\n*E\n"})
public final class FloatingIslandGenerator {
    @NotNull
    public static final FloatingIslandGenerator INSTANCE;
    private static int genTimer;
    @NotNull
    private static final List<List<BlockElement>> pools;
    @NotNull
    private static final List<List<BlockElement>> ruins;
    @NotNull
    private static final HashMap<Integer, List<Triple<Integer, Integer, Integer>>> lootboxes;
    @NotNull
    private static final Map<Integer, Integer> lootboxTypes;
    @NotNull
    private static final List<BlockElement> dreamTreeSchema;
    @NotNull
    private static final List<BlockElement> sadOakSchema;
    @NotNull
    private static final Pair<Pair<Integer, Integer>[], IntRange>[] dynamicLeaves;

    private FloatingIslandGenerator() {
    }

    public final int getGenTimer() {
        return genTimer;
    }

    public final void setGenTimer(int n) {
        genTimer = n;
    }

    @SubscribeEvent
    public final void onServerStop(@NotNull ServerStoppedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        genTimer = 0;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void worldTickEvent(@NotNull TickEvent.WorldTickEvent e) {
        EntityFloatingIsland entityFloatingIsland;
        boolean bl;
        int y;
        int j;
        int z;
        int x;
        EntityPlayer target;
        World world;
        block13: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!ASJUtilities.isServer()) {
                return;
            }
            world = e.world;
            if (e.phase != TickEvent.Phase.END) {
                return;
            }
            if (world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
                return;
            }
            if (world.field_73010_i.isEmpty()) {
                return;
            }
            int n = genTimer;
            genTimer = n + -1;
            if (n > 0) {
                return;
            }
            List list = world.field_72996_f;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadedEntityList");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EntityFloatingIsland)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fis = (List)destination$iv$iv;
            if (fis.size() >= AlfheimConfigHandler.INSTANCE.getFloatingIslandCountMax()) {
                return;
            }
            if (fis.size() >= AlfheimConfigHandler.INSTANCE.getFloatingIslandCountPerPlayer() * world.field_73010_i.size()) {
                return;
            }
            List list2 = world.field_73010_i;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"playerEntities");
            Collection collection = list2;
            Random random = world.field_73012_v;
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
            Object object = ExtensionsKt.random((Collection)collection, (Random)random);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            target = (EntityPlayer)object;
            Integer[] integerArray = Vector3.mul$default((Vector3)Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null).mul((Number)1, (Number)0, (Number)1).normalize(), (Number)(world.field_73012_v.nextInt(200) + 300), null, null, (int)6, null).add((Entity)target).getI();
            x = ((Number)integerArray[0]).intValue();
            z = ((Number)integerArray[2]).intValue();
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkNotNull((Object)worldProvider, (String)"null cannot be cast to non-null type alfheim.common.world.dim.alfheim.WorldProviderAlfheim");
            j = WE_Biome.getBiomeAt((WE_ChunkProvider)((WorldProviderAlfheim)worldProvider).getChunkProvider(), (int)x, (int)z).biomeSurfaceHeight;
            y = j + world.field_73012_v.nextInt(32) + 32;
            if (Vector3.Companion.pointDistancePlane((Number)x, (Number)z, (Number)0, (Number)0) < 1024.0) {
                return;
            }
            Iterable $this$any$iv = fis;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EntityFloatingIsland it = (EntityFloatingIsland)element$iv;
                    boolean bl2 = false;
                    if (!(Vector3.Companion.pointDistancePlane((Number)x, (Number)z, (Number)it.field_70165_t, (Number)it.field_70163_u) < 64.0)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        world.func_147439_a(x, y, z);
        Intrinsics.checkNotNull((Object)world);
        EntityFloatingIsland $this$worldTickEvent_u24lambda_u241 = entityFloatingIsland = new EntityFloatingIsland(world);
        boolean bl3 = false;
        $this$worldTickEvent_u24lambda_u241.func_70107_b(ExtensionsKt.getD((Number)x), ExtensionsKt.getD((Number)y), ExtensionsKt.getD((Number)z));
        Float[] floatArray = Vector3.mul$default((Vector3)Vector3.Companion.fromEntity((Entity)target).sub((Entity)$this$worldTickEvent_u24lambda_u241).mul((Number)1, (Number)0, (Number)1).normalize(), (Number)((double)j / 10000.0), null, null, (int)6, null).getF();
        float mx = ((Number)floatArray[0]).floatValue();
        float mz = ((Number)floatArray[2]).floatValue();
        $this$worldTickEvent_u24lambda_u241.setVelocity(mx, mz);
        INSTANCE.generate($this$worldTickEvent_u24lambda_u241);
        ExtensionsKt.spawn$default((Entity)$this$worldTickEvent_u24lambda_u241, null, (int)1, null);
        $this$worldTickEvent_u24lambda_u241.loadChunk();
        genTimer = 32766;
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull EntityFloatingIsland island) {
        void it;
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkNotNullParameter((Object)island, (String)"island");
        FloatingIslandBlockAccess world = island.getBlockAccess();
        world.getBlockMap().clear();
        long seed = island.field_70170_p.field_73012_v.nextLong();
        kotlin.random.Random rand = RandomKt.Random((long)seed);
        int min = -4;
        int max = 4;
        float ix = (float)min + rand.nextFloat() * (float)(max - min);
        float iz = (float)min + rand.nextFloat() * (float)(max - min);
        this.generateSubstrate(world, ix, iz, rand);
        this.generateSurface(world, ix, iz, rand);
        NBTTagCompound nBTTagCompound2 = nBTTagCompound = new NBTTagCompound();
        EntityFloatingIsland entityFloatingIsland = island;
        boolean bl = false;
        island.func_70014_b((NBTTagCompound)it);
        entityFloatingIsland.func_70037_a(nBTTagCompound);
    }

    private final boolean hasBlock(int x, int y, int z, float ix, float iz) {
        return YggdrasilGenerator.INSTANCE.yobaFunction(x * 10, y - 1, z * 10, ix, 1.0f, iz);
    }

    private final void generateSubstrate(FloatingIslandBlockAccess world, float ix, float iz, kotlin.random.Random rand) {
        for (int x = -64; x < 65; ++x) {
            for (int z = -64; z < 65; ++z) {
                for (int y = 15; -1 < y; --y) {
                    Pair pair;
                    block4: {
                        int n;
                        block3: {
                            if (!this.hasBlock(x, y, z, ix, iz)) continue;
                            n = rand.nextInt(10);
                            boolean bl = 0 <= n ? n < 3 : false;
                            if (!bl) break block3;
                            pair = TuplesKt.to((Object)AlfheimFluffBlocks.INSTANCE.getLivingMountain(), (Object)0);
                            break block4;
                        }
                        pair = (3 <= n ? n < 6 : false) ? TuplesKt.to((Object)AlfheimBlocks.INSTANCE.getLivingcobble(), (Object)0) : ((6 <= n ? n < 8 : false) ? TuplesKt.to((Object)AlfheimBlocks.INSTANCE.getLivingcobble(), (Object)3) : TuplesKt.to((Object)ModBlocks.livingrock, (Object)0));
                    }
                    Pair pair2 = pair;
                    Block block = (Block)pair2.component1();
                    int meta = ((Number)pair2.component2()).intValue();
                    FloatingIslandBlockAccess.setBlock$default(world, x, y, z, block, meta, null, false, 96, null);
                }
            }
        }
    }

    private final void generateSurface(FloatingIslandBlockAccess world, float ix, float iz, kotlin.random.Random rand) {
        int n;
        int y;
        int x;
        block14: {
            boolean hasPool;
            long seed = rand.nextLong();
            double scaleXZ = 10.0;
            int scaleY = 8;
            for (int x2 = -64; x2 < 65; ++x2) {
                block1: for (int z = -64; z < 65; ++z) {
                    int y2 = 16;
                    int maxY = Math.max(16, ExtensionsKt.getI((Number)(WE_PerlinNoise.PerlinNoise2D((long)seed, (double)((double)x2 / scaleXZ), (double)((double)z / scaleXZ), (double)1.0, (int)1) * (double)scaleY)) + 18);
                    if (y2 > maxY) continue;
                    while (true) {
                        if (this.hasBlock(x2, y2, z, ix, iz) && world.func_147437_c(x2, y2, z)) {
                            Block block = y2 == maxY ? (Block)Blocks.field_150349_c : Blocks.field_150346_d;
                            Intrinsics.checkNotNull((Object)block);
                            FloatingIslandBlockAccess.setBlock$default(world, x2, y2, z, block, 0, null, false, 112, null);
                        }
                        if (y2 == maxY) continue block1;
                        ++y2;
                    }
                }
            }
            boolean isForest = rand.nextBoolean();
            boolean hasStructure = rand.nextInt(100) < (isForest ? 50 : 90);
            boolean bl = hasPool = hasStructure && rand.nextInt(100) < 40;
            if (hasPool) {
                this.genStructure(world, rand, (List)CollectionsKt.random((Collection)pools, (kotlin.random.Random)rand));
            }
            for (x = -64; x < 65; ++x) {
                block4: for (int z = -64; z < 65; ++z) {
                    y = 16;
                    n = world.getEndY();
                    if (y > n) continue;
                    while (true) {
                        if (Intrinsics.areEqual((Object)world.func_147439_a(x, y, z), (Object)Blocks.field_150349_c)) {
                            this.genTrees(world, x, y + 1, z, rand, isForest);
                            continue block4;
                        }
                        if (y == n) continue block4;
                        ++y;
                    }
                }
            }
            if (hasPool || !hasStructure) break block14;
            int id = RangesKt.random((IntRange)CollectionsKt.getIndices((Collection)ruins), (kotlin.random.Random)rand);
            Integer[] z = this.genStructure(world, rand, ruins.get(id)).getI();
            int x3 = ((Number)z[0]).intValue();
            int y3 = ((Number)z[1]).intValue();
            int z2 = ((Number)z[2]).intValue();
            List<Triple<Integer, Integer, Integer>> list = lootboxes.get(id);
            if (list == null) break block14;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n2;
                int k;
                int j;
                int i;
                block16: {
                    int n3;
                    block15: {
                        Triple triple = (Triple)element$iv;
                        boolean bl2 = false;
                        i = ((Number)triple.component1()).intValue();
                        j = ((Number)triple.component2()).intValue();
                        k = ((Number)triple.component3()).intValue();
                        n3 = rand.nextInt(100) + 1;
                        boolean bl3 = 1 <= n3 ? n3 < 11 : false;
                        if (!bl3) break block15;
                        n2 = 0;
                        break block16;
                    }
                    n2 = (11 <= n3 ? n3 < 36 : false) ? 2 : ((36 <= n3 ? n3 < 41 : false) ? 3 : 1);
                }
                int rarity = n2 * 3;
                Integer n4 = lootboxTypes.get(id);
                FloatingIslandBlockAccess.setBlock$default(world, x3 + i, y3 + j, z2 + k, AlfheimBlocks.INSTANCE.getLootbox(), rarity + (n4 != null ? n4 : 0), null, false, 96, null);
            }
        }
        for (x = -64; x < 65; ++x) {
            block8: for (int z = -64; z < 65; ++z) {
                y = 16;
                n = world.getEndY();
                if (y > n) continue;
                while (true) {
                    if (Intrinsics.areEqual((Object)world.func_147439_a(x, y, z), (Object)Blocks.field_150349_c)) {
                        this.genGrassAndFlowers(world, x, y + 1, z, rand);
                        continue block8;
                    }
                    if (y == n) continue block8;
                    ++y;
                }
            }
        }
    }

    public final void genTrees(@NotNull FloatingIslandBlockAccess world, int x, int y, int z, @NotNull kotlin.random.Random rand, boolean isForest) {
        int n;
        int k;
        Block block;
        int logMeta;
        Block log;
        int type2;
        int height;
        block32: {
            int n22;
            block31: {
                int n3;
                block30: {
                    int e2;
                    block29: {
                        Block block2;
                        block23: {
                            int element$iv2;
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block22: {
                                                    Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                                                    Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
                                                    double d = rand.nextFloat();
                                                    double d2 = isForest ? 0.015 : 0.001;
                                                    if (d > d2) {
                                                        return;
                                                    }
                                                    if (isForest && (double)rand.nextFloat() < 0.15) {
                                                        Iterable $this$forEach$iv = (double)rand.nextFloat() < 0.33 ? dreamTreeSchema : sadOakSchema;
                                                        boolean $i$f$forEach = false;
                                                        for (Object element$iv2 : $this$forEach$iv) {
                                                            BlockElement e2 = (BlockElement)element$iv2;
                                                            boolean n22 = false;
                                                            if (e2.getBlock() == null) continue;
                                                            Iterable $this$forEach$iv2 = e2.getLocation();
                                                            boolean $i$f$forEach2 = false;
                                                            for (Object element$iv3 : $this$forEach$iv2) {
                                                                Block block3;
                                                                LocationElement l = (LocationElement)element$iv3;
                                                                boolean bl = false;
                                                                int Y = y + l.getY() - 1;
                                                                if (block3.isLeaves((IBlockAccess)world, x + l.getX(), Y, z + l.getZ())) {
                                                                    Block it = world.func_147439_a(x + l.getX(), Y, z + l.getZ());
                                                                    boolean bl2 = false;
                                                                    boolean bl3 = it.isAir((IBlockAccess)world, x + l.getX(), Y, z + l.getZ()) || it.isLeaves((IBlockAccess)world, x + l.getX(), Y, z + l.getZ());
                                                                    if (!bl3) continue;
                                                                }
                                                                FloatingIslandBlockAccess.setBlock$default(world, x + l.getX(), Y, z + l.getZ(), block3, l.getMeta(), null, false, 96, null);
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    height = rand.nextInt(5, 7);
                                                    type2 = isForest ? -1 : rand.nextInt(24);
                                                    element$iv2 = type2;
                                                    boolean bl = 0 <= element$iv2 ? element$iv2 < 4 : false;
                                                    if (!bl) break block22;
                                                    block2 = AlfheimBlocks.INSTANCE.getIrisWood0();
                                                    break block23;
                                                }
                                                boolean bl = 4 <= element$iv2 ? element$iv2 < 8 : false;
                                                if (!bl) break block24;
                                                block2 = AlfheimBlocks.INSTANCE.getIrisWood1();
                                                break block23;
                                            }
                                            boolean bl = 8 <= element$iv2 ? element$iv2 < 12 : false;
                                            if (!bl) break block25;
                                            block2 = AlfheimBlocks.INSTANCE.getIrisWood2();
                                            break block23;
                                        }
                                        boolean bl = 12 <= element$iv2 ? element$iv2 < 16 : false;
                                        if (!bl) break block26;
                                        block2 = AlfheimBlocks.INSTANCE.getIrisWood3();
                                        break block23;
                                    }
                                    if (element$iv2 != 16) break block27;
                                    block2 = AlfheimBlocks.INSTANCE.getRainbowWood();
                                    break block23;
                                }
                                if (element$iv2 != 17) break block28;
                                block2 = AlfheimBlocks.INSTANCE.getAuroraWood();
                                break block23;
                            }
                            block2 = (18 <= element$iv2 ? element$iv2 < 22 : false) ? AlfheimBlocks.INSTANCE.getAltWood0() : ((22 <= element$iv2 ? element$iv2 < 24 : false) ? AlfheimBlocks.INSTANCE.getAltWood1() : Blocks.field_150364_r);
                        }
                        log = block2;
                        e2 = type2;
                        boolean bl = 0 <= e2 ? e2 < 16 : false;
                        if (!bl) break block29;
                        n3 = type2 % 4;
                        break block30;
                    }
                    n3 = (18 <= e2 ? e2 < 22 : false) ? type2 - 18 : ((22 <= e2 ? e2 < 24 : false) ? type2 - 22 : 0);
                }
                logMeta = n3;
                n22 = type2;
                boolean bl = 0 <= n22 ? n22 < 8 : false;
                if (!bl) break block31;
                block = AlfheimBlocks.INSTANCE.getIrisLeaves0();
                break block32;
            }
            block = (8 <= n22 ? n22 < 16 : false) ? AlfheimBlocks.INSTANCE.getIrisLeaves1() : (n22 == 16 ? AlfheimBlocks.INSTANCE.getRainbowLeaves() : (n22 == 17 ? AlfheimBlocks.INSTANCE.getAuroraLeaves() : ((18 <= n22 ? n22 < 24 : false) ? AlfheimBlocks.INSTANCE.getAltLeaves() : (Block)Blocks.field_150362_t)));
        }
        Block leaves = block;
        int block3 = type2;
        int leavesMeta = (0 <= block3 ? block3 < 16 : false) ? type2 % 8 : ((18 <= block3 ? block3 < 24 : false) ? type2 - 18 : 0);
        int j = height;
        int $this$forEach$iv2 = height - 3;
        if ($this$forEach$iv2 <= j) {
            while (true) {
                int element$iv3;
                IntRange range;
                int i;
                if ((i = (range = j > height - 2 ? new IntRange(-1, 1) : new IntRange(-2, 2)).getFirst()) <= (element$iv3 = range.getLast())) {
                    while (true) {
                        if ((k = range.getFirst()) <= (n = range.getLast())) {
                            while (true) {
                                if (Math.abs(i) != range.getLast() || Math.abs(k) != range.getLast()) {
                                    Block it = world.func_147439_a(x + i, y + j, z + k);
                                    boolean bl = false;
                                    boolean bl4 = it.isAir((IBlockAccess)world, x + i, y + j, z + k) || it.isLeaves((IBlockAccess)world, x + i, y + j, z + k);
                                    if (bl4) {
                                        Intrinsics.checkNotNull((Object)leaves);
                                        FloatingIslandBlockAccess.setBlock$default(world, x + i, y + j, z + k, leaves, leavesMeta, null, false, 96, null);
                                    }
                                }
                                if (k == n) break;
                                ++k;
                            }
                        }
                        if (i == element$iv3) break;
                        ++i;
                    }
                }
                if (j == $this$forEach$iv2) break;
                --j;
            }
        }
        FloatingIslandGenerator $this$genTrees_u24lambda_u24122 = this;
        int n4 = 0;
        Pair<Pair<Integer, Integer>[], IntRange>[] $this$forEach$iv = dynamicLeaves;
        boolean $i$f$forEach = false;
        n = $this$forEach$iv.length;
        for (k = 0; k < n; ++k) {
            Pair<Pair<Integer, Integer>[], IntRange> element$iv;
            Pair<Pair<Integer, Integer>[], IntRange> pair = element$iv = $this$forEach$iv[k];
            boolean bl = false;
            Pair[] coords = (Pair[])pair.component1();
            IntRange rangeY = (IntRange)pair.component2();
            Pair[] $this$forEach$iv3 = coords;
            boolean $i$f$forEach3 = false;
            int n5 = $this$forEach$iv3.length;
            block6: for (int i = 0; i < n5; ++i) {
                int n6;
                int j2;
                Pair element$iv4;
                Pair pair2 = element$iv4 = $this$forEach$iv3[i];
                boolean bl5 = false;
                int i2 = ((Number)pair2.component1()).intValue();
                int k2 = ((Number)pair2.component2()).intValue();
                if (rand.nextBoolean() || (j2 = rangeY.getFirst()) > (n6 = rangeY.getLast())) continue;
                while (!rand.nextBoolean()) {
                    Block it = world.func_147439_a(x + i2, y + j2 + height, z + k2);
                    boolean bl6 = false;
                    boolean bl7 = it.isAir((IBlockAccess)world, x + i2, y + j2 + height, z + k2) || it.isLeaves((IBlockAccess)world, x + i2, y + j2 + height, z + k2);
                    if (!bl7) continue block6;
                    Intrinsics.checkNotNull((Object)leaves);
                    FloatingIslandBlockAccess.setBlock$default(world, x + i2, y + j2 + height, z + k2, leaves, leavesMeta, null, false, 96, null);
                    if (j2 == n6) continue block6;
                    ++j2;
                }
            }
        }
        for (j = 0; j < height; ++j) {
            Intrinsics.checkNotNull((Object)log);
            FloatingIslandBlockAccess.setBlock$default(world, x, y + j, z, log, logMeta, null, false, 96, null);
        }
        if (isForest) {
            return;
        }
        int $this$genTrees_u24lambda_u24122 = type2;
        Block grass = (0 <= $this$genTrees_u24lambda_u24122 ? $this$genTrees_u24lambda_u24122 < 16 : false) ? AlfheimBlocks.INSTANCE.getIrisDirt() : ($this$genTrees_u24lambda_u24122 == 16 ? AlfheimBlocks.INSTANCE.getRainbowDirt() : ($this$genTrees_u24lambda_u24122 == 17 ? AlfheimBlocks.INSTANCE.getAuroraDirt() : ((18 <= $this$genTrees_u24lambda_u24122 ? $this$genTrees_u24lambda_u24122 < 24 : false) ? ModBlocks.altGrass : (Block)Blocks.field_150349_c)));
        n4 = type2;
        int grassMeta = (0 <= n4 ? n4 < 16 : false) ? type2 : ((18 <= n4 ? n4 < 24 : false) ? type2 - 18 : 0);
        for (int i = -2; i < 3; ++i) {
            block10: for (int k3 = -2; k3 < 3; ++k3) {
                IntRange intRange;
                int j3;
                if (Math.abs(i) == 2 && Math.abs(k3) == 2 || (j3 = (intRange = ExtensionsKt.bidiRange((int)0, (int)height)).getFirst()) > (n = intRange.getLast())) continue;
                while (true) {
                    if (world.func_147439_a(x + i, y + j3, z + k3) == Blocks.field_150349_c) {
                        Intrinsics.checkNotNull((Object)grass);
                        FloatingIslandBlockAccess.setBlock$default(world, x + i, y + j3, z + k3, grass, grassMeta, null, false, 96, null);
                        continue block10;
                    }
                    if (j3 == n) continue block10;
                    ++j3;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void genGrassAndFlowers(@NotNull FloatingIslandBlockAccess world, int x, int y, int z, @NotNull kotlin.random.Random rand) {
        Pair pair;
        int type2;
        block13: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
            if ((double)rand.nextFloat() > 0.4) {
                return;
            }
            if (!world.func_147437_c(x, y, z)) {
                return;
            }
            if (world.func_147439_a(x, y - 1, z) != Blocks.field_150349_c) {
                return;
            }
            type2 = rand.nextInt(16);
            FloatingIslandGenerator $this$genGrassAndFlowers_u24lambda_u2414 = this;
            boolean bl = false;
            if (type2 > 12) break block13;
            byte[] byArray = new byte[]{0, 0, 0, 0, -1, 0, 2, 1, 1, 1, 1, 2, -1};
            byte[] metas = byArray;
            switch (type2) {
                case 4: {
                    metas[4] = (byte)(rand.nextInt(8) + 1);
                    break;
                }
                case 11: {
                    Block it = world.func_147439_a(x, y + 1, z);
                    boolean bl2 = false;
                    boolean bl3 = it.isAir((IBlockAccess)world, x, y + 1, z) || it.isLeaves((IBlockAccess)world, x, y + 1, z);
                    if (bl3) {
                        FloatingIslandBlockAccess.setBlock$default(world, x, y + 1, z, WorldGenGrass.Companion.getTypes()[11], metas[11] + 8, null, false, 96, null);
                        break;
                    }
                    break block13;
                }
                case 12: {
                    metas[12] = (byte)rand.nextInt(6);
                    if (ExtensionsKt.getI((Number)metas[12]) == 2) break block13;
                    Block it = world.func_147439_a(x, y + 1, z);
                    boolean bl4 = false;
                    boolean bl5 = it.isAir((IBlockAccess)world, x, y + 1, z) || it.isLeaves((IBlockAccess)world, x, y + 1, z);
                    if (!bl5) break block13;
                    FloatingIslandBlockAccess.setBlock$default(world, x, y + 1, z, WorldGenGrass.Companion.getTypes()[12], metas[12] + 8, null, false, 96, null);
                }
            }
            FloatingIslandBlockAccess.setBlock$default(world, x, y, z, WorldGenGrass.Companion.getTypes()[type2], ExtensionsKt.getI((Number)metas[type2]), null, false, 96, null);
            return;
        }
        FloatingIslandGenerator $this$genGrassAndFlowers_u24lambda_u2416 = this;
        boolean bl = false;
        int meta = rand.nextInt(17);
        if (type2 == 16) {
            Pair result = meta == 16 ? TuplesKt.to((Object)AlfheimBlocks.INSTANCE.getRainbowTallFlower(), (Object)0) : TuplesKt.to((Object)(meta > 7 ? ModBlocks.doubleFlower2 : ModBlocks.doubleFlower1), (Object)(meta % 8));
            Block it = world.func_147439_a(x, y + 1, z);
            boolean bl6 = false;
            if (!it.isAir((IBlockAccess)world, x, y + 1, z)) {
                if (!it.isLeaves((IBlockAccess)world, x, y + 1, z)) return;
            }
            boolean bl7 = true;
            if (!bl7) {
                return;
            }
            Object object = result.getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
            FloatingIslandBlockAccess.setBlock$default(world, x, y + 1, z, (Block)object, ((Number)result.getSecond()).intValue(), null, false, 96, null);
            pair = result;
        } else {
            pair = meta == 16 ? TuplesKt.to((Object)AlfheimBlocks.INSTANCE.getRainbowGrass(), (Object)2) : TuplesKt.to((Object)ModBlocks.flower, (Object)meta);
        }
        Pair pair2 = pair;
        Block block = (Block)pair2.component1();
        int meta2 = ((Number)pair2.component2()).intValue();
        Intrinsics.checkNotNull((Object)block);
        FloatingIslandBlockAccess.setBlock$default(world, x, y, z, block, meta2, null, false, 96, null);
    }

    private final Vector3 genStructure(FloatingIslandBlockAccess world, kotlin.random.Random rand, List<BlockElement> structure) {
        Object v0;
        int z;
        int x;
        block5: {
            Integer[] integerArray = Vector3.sub$default((Vector3)new Vector3((Number)rand.nextInt(16), (Number)0, (Number)rand.nextInt(16)), (Number)8, null, null, (int)6, null).getI();
            x = ((Number)integerArray[0]).intValue();
            z = ((Number)integerArray[2]).intValue();
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.downTo((int)world.getEndY(), (int)16);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                Block block = world.func_147439_a(x, it, z);
                if (!(!ASJUtilities.isBlockReplaceable((Block)block) && !block.isWood((IBlockAccess)world, x, it, z))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Integer n = v0;
        int y = (n != null ? n : 16) + 1;
        Iterable $this$forEach$iv = structure;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockElement e = (BlockElement)element$iv;
            boolean bl = false;
            if (e.getBlock() == null) continue;
            Iterable $this$forEach$iv2 = e.getLocation();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Block block;
                TileEntity tileEntity;
                LocationElement l = (LocationElement)element$iv2;
                boolean bl2 = false;
                int Y = y + l.getY();
                if (l.getNbt() != null) {
                    TileEntity tileEntity2;
                    NBTBase nBTBase = JsonToNBT.func_150315_a((String)l.getNbt());
                    Intrinsics.checkNotNull((Object)nBTBase, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
                    TileEntity $this$genStructure_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418 = tileEntity2 = TileEntity.func_145827_c((NBTTagCompound)((NBTTagCompound)nBTBase));
                    boolean bl3 = false;
                    $this$genStructure_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.field_145851_c = x + l.getX();
                    $this$genStructure_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.field_145848_d = Y;
                    $this$genStructure_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.field_145849_e = z + l.getZ();
                    tileEntity = tileEntity2;
                } else {
                    tileEntity = null;
                }
                TileEntity tile = tileEntity;
                FloatingIslandBlockAccess.setBlock$default(world, x + l.getX(), Y, z + l.getZ(), block, l.getMeta(), tile, false, 64, null);
            }
        }
        return new Vector3((Number)x, (Number)y, (Number)z);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_7;
        void $this$mapTo$iv$iv;
        int n;
        INSTANCE = new FloatingIslandGenerator();
        int n2 = 0;
        Object[] objectArray = new List[7];
        while (n2 < 7) {
            n = n2++;
            objectArray[n] = UnsafeSchemaUtils.INSTANCE.loadStructure("alfheim/schemas/fi/pool" + n);
        }
        pools = ArraysKt.toList((Object[])objectArray);
        n2 = 0;
        objectArray = new List[12];
        while (n2 < 12) {
            n = n2++;
            objectArray[n] = UnsafeSchemaUtils.INSTANCE.loadStructure("alfheim/schemas/fi/ruin" + n);
        }
        ruins = ArraysKt.toList((Object[])objectArray);
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)0, (Object)CollectionsKt.listOf((Object)ExtensionsKt.with((Pair)TuplesKt.to((Object)0, (Object)0), (Object)0)));
        pairArray[1] = TuplesKt.to((Object)2, (Object)CollectionsKt.listOf((Object)ExtensionsKt.with((Pair)TuplesKt.to((Object)0, (Object)3), (Object)0)));
        objectArray = new Triple[]{ExtensionsKt.with((Pair)TuplesKt.to((Object)0, (Object)0), (Object)0), ExtensionsKt.with((Pair)TuplesKt.to((Object)0, (Object)7), (Object)0)};
        pairArray[2] = TuplesKt.to((Object)3, (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Triple[]{ExtensionsKt.with((Pair)TuplesKt.to((Object)-2, (Object)0), (Object)1), ExtensionsKt.with((Pair)TuplesKt.to((Object)1, (Object)3), (Object)-1)};
        pairArray[3] = TuplesKt.to((Object)8, (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[4] = TuplesKt.to((Object)9, (Object)CollectionsKt.listOf((Object)ExtensionsKt.with((Pair)TuplesKt.to((Object)1, (Object)0), (Object)0)));
        objectArray = new Triple[]{ExtensionsKt.with((Pair)TuplesKt.to((Object)-5, (Object)1), (Object)2), ExtensionsKt.with((Pair)TuplesKt.to((Object)1, (Object)1), (Object)5), ExtensionsKt.with((Pair)TuplesKt.to((Object)3, (Object)1), (Object)-4)};
        pairArray[5] = TuplesKt.to((Object)10, (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Triple[]{ExtensionsKt.with((Pair)TuplesKt.to((Object)-3, (Object)3), (Object)0), ExtensionsKt.with((Pair)TuplesKt.to((Object)0, (Object)3), (Object)-3), ExtensionsKt.with((Pair)TuplesKt.to((Object)0, (Object)3), (Object)3), ExtensionsKt.with((Pair)TuplesKt.to((Object)3, (Object)3), (Object)0)};
        pairArray[6] = TuplesKt.to((Object)11, (Object)CollectionsKt.listOf((Object[])objectArray));
        lootboxes = MapsKt.hashMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)0), TuplesKt.to((Object)2, (Object)0), TuplesKt.to((Object)3, (Object)0), TuplesKt.to((Object)8, (Object)0), TuplesKt.to((Object)9, (Object)0), TuplesKt.to((Object)10, (Object)0), TuplesKt.to((Object)11, (Object)1)};
        lootboxTypes = MapsKt.mapOf((Pair[])pairArray);
        dreamTreeSchema = UnsafeSchemaUtils.INSTANCE.loadStructure("alfheim/schemas/fi/DreamTree");
        Iterable $this$map$iv = dreamTreeSchema;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void old;
            BlockElement blockElement = (BlockElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = old.getLocation();
            boolean leaves = old.getBlock() instanceof BlockLeavesBase;
            Block block = leaves ? (Block)Blocks.field_150362_t : Blocks.field_150364_r;
            boolean $i$f$map2 = false;
            void var13_17 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                LocationElement locationElement = (LocationElement)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new LocationElement(it.getX(), it.getY(), it.getZ(), leaves ? 0 : it.getMeta() - 3, null));
            }
            List list = (List)destination$iv$iv2;
            Block block2 = block;
            collection.add(new BlockElement(block2, list));
        }
        sadOakSchema = (List)var3_7;
        pairArray = new Pair[2];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)-2, (Object)-2), TuplesKt.to((Object)2, (Object)-2), TuplesKt.to((Object)-2, (Object)2), TuplesKt.to((Object)2, (Object)2)};
        pairArray[0] = TuplesKt.to((Object)pairArray2, (Object)new IntRange(-3, -2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)-1, (Object)-1), TuplesKt.to((Object)1, (Object)-1), TuplesKt.to((Object)-1, (Object)1), TuplesKt.to((Object)1, (Object)1)};
        pairArray[1] = TuplesKt.to((Object)pairArray2, (Object)new IntRange(-1, 0));
        dynamicLeaves = pairArray;
    }
}

