/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.entity.IAlfheimMob;
import alfheim.common.core.handler.AlfheimConfigHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.item.ModItems;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0014J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lalfheim/common/entity/EntityVoidCreeper;", "Lnet/minecraft/entity/monster/EntityCreeper;", "Lalfheim/api/entity/IAlfheimMob;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "lastActiveTime", "", "timeSinceIgnited", "range", "fuseTime", "writeEntityToNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "readEntityFromNBT", "getDropItem", "Lnet/minecraft/item/Item;", "dropFewItems", "par1", "", "par2", "onUpdate", "fall", "distance", "", "creeperGoBoom", "getPickedResult", "Lnet/minecraft/item/ItemStack;", "target", "Lnet/minecraft/util/MovingObjectPosition;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nEntityVoidCreeper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityVoidCreeper.kt\nalfheim/common/entity/EntityVoidCreeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1863#2,2:98\n*S KotlinDebug\n*F\n+ 1 EntityVoidCreeper.kt\nalfheim/common/entity/EntityVoidCreeper\n*L\n86#1:98,2\n*E\n"})
public final class EntityVoidCreeper
extends EntityCreeper
implements IAlfheimMob {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int range;
    private int fuseTime;

    public EntityVoidCreeper(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.range = 3;
        this.fuseTime = 30;
    }

    public void func_70014_b(@NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.func_70014_b(tag);
        tag.func_74757_a("powered", this.func_70083_f(6));
        tag.func_74768_a("Fuse", this.fuseTime);
        tag.func_74757_a("ignited", this.func_146078_ca());
    }

    public void func_70037_a(@NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.func_70037_a(tag);
        this.func_70052_a(6, tag.func_74767_n("powered"));
        if (tag.func_74764_b("Fuse")) {
            this.fuseTime = tag.func_74762_e("Fuse");
        }
        if (tag.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    @NotNull
    protected Item func_146068_u() {
        Item item = Items.field_151016_H;
        Intrinsics.checkNotNull((Object)item);
        return item;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1 && Math.random() < AlfheimConfigHandler.INSTANCE.getBlackLotusDropRate()) {
            this.func_70099_a(new ItemStack(ModItems.blackLotus), 1.0f);
        }
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.func_146078_ca()) {
            this.func_70829_a(1);
        }
        if ((i = this.func_70832_p()) > 0 && this.timeSinceIgnited == 0) {
            this.func_85030_a("creeper.primed", 1.0f, 0.5f);
        }
        this.timeSinceIgnited += i;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.creeperGoBoom();
        }
    }

    protected void func_70069_a(float distance) {
        super.func_70069_a(distance);
        this.timeSinceIgnited = ExtensionsKt.getI((Number)Float.valueOf(ExtensionsKt.getF((Number)this.timeSinceIgnited) + distance * 1.5f));
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    private final void creeperGoBoom() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int r = this.range * (this.func_70830_n() ? 2 : 1);
        World world = this.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityLivingBase.class, (AxisAlignedBB)ExtensionsKt.boundingBox((Entity)((Entity)this), (Number)r));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityLivingBase it = (EntityLivingBase)element$iv;
            boolean bl = false;
            if (!(it instanceof EntityPlayer)) continue;
            it.func_70690_d(ExtensionsKt.PotionEffectU$default((int)AlfheimConfigHandler.INSTANCE.getPotionIDManaVoid(), (int)(this.func_70830_n() ? 1200 : 120), (int)0, (boolean)false, (int)8, null));
        }
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false);
        this.func_70106_y();
    }

    @Override
    @Nullable
    public ItemStack getPickedResult(@Nullable MovingObjectPosition target) {
        return IAlfheimMob.DefaultImpls.getPickedResult(this, target);
    }
}

