/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.ItemSplashPotion;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.brew.ModPotions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lalfheim/common/entity/EntityThrownPotion;", "Lnet/minecraft/entity/projectile/EntityThrowable;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "st", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;)V", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)V", "effects", "", "Lnet/minecraft/potion/PotionEffect;", "getEffects", "()Ljava/util/List;", "stack", "getStack", "()Lnet/minecraft/item/ItemStack;", "value", "", "color", "getColor", "()I", "setColor", "(I)V", "entityInit", "", "peClear", "getPeClear", "()Lnet/minecraft/potion/PotionEffect;", "onImpact", "movingObject", "Lnet/minecraft/util/MovingObjectPosition;", "getGravityVelocity", "", "func_70183_g", "func_70182_d", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nEntityThrownPotion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityThrownPotion.kt\nalfheim/common/entity/EntityThrownPotion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1863#2,2:98\n*S KotlinDebug\n*F\n+ 1 EntityThrownPotion.kt\nalfheim/common/entity/EntityThrownPotion\n*L\n67#1:98,2\n*E\n"})
public final class EntityThrownPotion
extends EntityThrowable {
    @NotNull
    private final List<PotionEffect> effects;
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final PotionEffect peClear;

    public EntityThrownPotion(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.peClear = new PotionEffect(ModPotions.clear.field_76415_H, 0, 0);
        this.stack = new ItemStack(AlfheimItems.INSTANCE.getSplashPotion());
        this.effects = CollectionsKt.emptyList();
        this.setColor(0xFFFFFF);
    }

    public EntityThrownPotion(@NotNull World world, @NotNull ItemStack st) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        super(world);
        this.peClear = new PotionEffect(ModPotions.clear.field_76415_H, 0, 0);
        this.stack = st;
        Item item = this.stack.func_77973_b();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type alfheim.common.item.ItemSplashPotion");
        ItemSplashPotion brew = (ItemSplashPotion)item;
        this.effects = brew.getBrew(this.stack).getPotionEffects(this.stack);
        this.setColor(brew.getColor(this.stack));
    }

    public EntityThrownPotion(@NotNull EntityPlayer player, @NotNull ItemStack st) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        super(player.field_70170_p, (EntityLivingBase)player);
        this.peClear = new PotionEffect(ModPotions.clear.field_76415_H, 0, 0);
        this.stack = st;
        Item item = this.stack.func_77973_b();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type alfheim.common.item.ItemSplashPotion");
        ItemSplashPotion brew = (ItemSplashPotion)item;
        this.effects = brew.getBrew(this.stack).getPotionEffects(this.stack);
        this.setColor(brew.getColor(this.stack));
    }

    @NotNull
    public final List<PotionEffect> getEffects() {
        return this.effects;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    public final int getColor() {
        return this.field_70180_af.func_75679_c(31);
    }

    public final void setColor(int value) {
        this.field_70180_af.func_75692_b(31, (Object)value);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_82708_h(30);
        this.field_70180_af.func_75682_a(31, (Object)0);
        this.field_70180_af.func_82708_h(31);
    }

    @NotNull
    public final PotionEffect getPeClear() {
        return this.peClear;
    }

    protected void func_70184_a(@Nullable MovingObjectPosition movingObject) {
        if (this.field_70170_p.field_72995_K || movingObject == null || this.effects.isEmpty()) {
            this.func_70106_y();
            return;
        }
        double[] dArray = new double[]{this.field_70165_t, this.field_70163_u, this.field_70161_v, ExtensionsKt.getD((Number)this.getColor()), this.effects.contains(this.peClear) ? 1.0 : 0.0};
        VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.POTION, this.field_71093_bK, dArray);
        World world = this.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        AxisAlignedBB axisAlignedBB = this.field_70121_D.func_72314_b(5.0, 2.5, 5.0);
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"expand(...)");
        ArrayList list = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityLivingBase.class, (AxisAlignedBB)axisAlignedBB);
        if (list.isEmpty()) {
            this.func_70106_y();
            return;
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityLivingBase living = (EntityLivingBase)element$iv;
            boolean bl = false;
            double d0 = this.func_70068_e((Entity)living);
            if (d0 >= 16.0) continue;
            double d1 = 1.0 - Math.sqrt(d0) / 4.0;
            if (living == movingObject.field_72308_g) {
                d1 = 1.0;
            }
            for (PotionEffect e : this.effects) {
                if (!Potion.field_76425_a[e.field_76462_a].func_76403_b()) {
                    int j = ExtensionsKt.getI((Number)(d1 * ExtensionsKt.getD((Number)e.field_76460_b) + 0.5));
                    if (j <= 20) continue;
                    living.func_70690_d(new PotionEffect(e.field_76462_a, j, e.field_76461_c));
                    continue;
                }
                Potion.field_76425_a[e.field_76462_a].func_76402_a(this.field_70192_c, living, e.field_76461_c, d1);
            }
        }
        this.func_70106_y();
    }

    protected float func_70185_h() {
        return this.field_70180_af.func_111145_d(30);
    }

    public float func_70183_g() {
        return -10.0f;
    }

    public float func_70182_d() {
        return 1.0f;
    }
}

