/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.entity.EntityFracturedSpaceCollectorKt;
import alfheim.common.item.AlfheimItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileAvatar;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.core.helper.MathHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0004\u0010\fJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0016J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010'\u001a\u00020\u0007H\u0016R\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lalfheim/common/entity/EntityFracturedSpaceCollector;", "Lnet/minecraft/entity/Entity;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "toX", "", "toY", "toZ", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/player/EntityPlayer;)V", "x", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "z", "getZ", "setZ", "ownerUUID", "Ljava/util/UUID;", "getOwnerUUID", "()Ljava/util/UUID;", "setOwnerUUID", "(Ljava/util/UUID;)V", "entityInit", "", "onUpdate", "doSparkles", "age", "writeEntityToNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readEntityFromNBT", "getMaxInPortalTime", "Companion", "Alfheim"})
public final class EntityFracturedSpaceCollector
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int x;
    private int y;
    private int z;
    @Nullable
    private UUID ownerUUID;
    @NotNull
    public static final String TAG_OWNER_MOST = "ownerMost";
    @NotNull
    public static final String TAG_OWNER_LEAST = "ownerLeast";
    public static final double RADIUS = 2.0;
    public static final int MAX_AGE = 30;
    public static final float AGE_SPECIAL_START = 22.5f;
    public static final int MANA_COST_PER_ITEM = 10;
    public static final int PARTICLE_COUNT = 12;
    @NotNull
    private static final ItemStack TOOL_STACK = new ItemStack(AlfheimItems.INSTANCE.getRodBlackHole());

    public EntityFracturedSpaceCollector(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.y = -1;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setZ(int n) {
        this.z = n;
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@Nullable UUID uUID) {
        this.ownerUUID = uUID;
    }

    public EntityFracturedSpaceCollector(@NotNull World world, int toX, int toY, int toZ, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world);
        this.x = toX;
        this.y = toY;
        this.z = toZ;
        EntityPlayer entityPlayer = player;
        this.ownerUUID = entityPlayer != null ? entityPlayer.func_110124_au() : null;
    }

    protected void func_70088_a() {
        this.func_70105_a(0.0f, 0.0f);
    }

    public void func_70071_h_() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        int age = this.field_70173_aa;
        if (this.field_70170_p.field_72995_K && age <= 30) {
            this.doSparkles(age);
        } else if ((float)age > 22.5f) {
            World world = this.field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
            AxisAlignedBB axisAlignedBB = ExtensionsKt.boundingBox$default((Entity)this, null, (int)1, null).func_72314_b(2.0, 1.0, 2.0);
            Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"expand(...)");
            ArrayList nearbyItemEnts = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityItem.class, (AxisAlignedBB)axisAlignedBB);
            CollectionsKt.removeAll((List)nearbyItemEnts, arg_0 -> EntityFracturedSpaceCollector.onUpdate$lambda$0(this, arg_0));
            Iterator iterator = nearbyItemEnts.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                EntityItem ent = (EntityItem)e;
                double xDifference = this.field_70165_t - ent.field_70165_t;
                double zDifference = this.field_70161_v - ent.field_70161_v;
                ent.field_70159_w += xDifference * 0.3;
                ent.field_70179_y += zDifference * 0.3;
                ent.field_70133_I = true;
            }
            if (age >= 30) {
                TileEntity tile;
                UUID uUID = this.ownerUUID;
                if (uUID == null) {
                    uUID = EntityFracturedSpaceCollectorKt.access$getDUMMY_UUID$p();
                }
                EntityPlayer player = this.field_70170_p.func_152378_a(uUID);
                TileAvatar avatar = null;
                if (player == null) {
                    Iterator xDifference = ArrayIteratorKt.iterator((Object[])ForgeDirection.VALID_DIRECTIONS);
                    while (xDifference.hasNext()) {
                        ForgeDirection dir = (ForgeDirection)xDifference.next();
                        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) continue;
                        World world2 = this.field_70170_p;
                        Intrinsics.checkNotNullExpressionValue((Object)world2, (String)"worldObj");
                        TileEntity tileEntity = ExtensionsKt.getTileEntity$default((World)world2, (Entity)this, (int)(dir.offsetX * 2), (int)0, (int)(dir.offsetZ * 2), (int)4, null);
                        TileAvatar tileAvatar = tileEntity instanceof TileAvatar ? (TileAvatar)tileEntity : null;
                        if (tileAvatar == null) continue;
                        avatar = tileAvatar;
                        ItemStack itemStack = ExtensionsKt.get((IInventory)((IInventory)avatar), (int)0);
                        if ((itemStack != null ? itemStack.func_77973_b() : null) == AlfheimItems.INSTANCE.getRodBlackHole()) break;
                        ItemStack itemStack2 = ExtensionsKt.get((IInventory)((IInventory)avatar), (int)0);
                        if ((itemStack2 != null ? itemStack2.func_77973_b() : null) == AlfheimItems.INSTANCE.getRodClicker()) break;
                        avatar = null;
                    }
                    if (avatar == null) {
                        this.func_70106_y();
                        return;
                    }
                }
                if ((tile = this.field_70170_p.func_147438_o(this.x, this.y, this.z)) instanceof TileOpenCrate && ((TileOpenCrate)tile).canEject()) {
                    Iterator iterator3 = nearbyItemEnts.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
                    Iterator iterator4 = iterator3;
                    while (iterator4.hasNext()) {
                        boolean can;
                        boolean bl;
                        Object e = iterator4.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        EntityItem ent = (EntityItem)e;
                        ItemStack stack = ent.func_92059_d();
                        int cost = stack.field_77994_a * 10;
                        if (player != null) {
                            bl = ManaItemHandler.requestManaExact((ItemStack)TOOL_STACK, (EntityPlayer)player, (int)cost, (boolean)true);
                        } else {
                            boolean can2;
                            TileAvatar tileAvatar = avatar;
                            Intrinsics.checkNotNull((Object)tileAvatar);
                            boolean bl2 = can2 = tileAvatar.getCurrentMana() >= cost;
                            if (can2) {
                                avatar.recieveMana(-cost);
                            }
                            bl = can2;
                        }
                        if (!(can = bl)) continue;
                        TileOpenCrate tileOpenCrate = (TileOpenCrate)tile;
                        Intrinsics.checkNotNull((Object)stack);
                        Companion.fakeCrateEject(tileOpenCrate, stack);
                        ent.func_92058_a(null);
                        ent.func_70106_y();
                    }
                }
                this.func_70106_y();
            }
        }
    }

    public final void doSparkles(int age) {
        double ageFraction = (double)age / ExtensionsKt.getD((Number)30);
        double radiusMult = 1.6 * (ageFraction - Math.pow(ageFraction, 7.0));
        double particleAngle = (double)age / 25.0;
        double height = radiusMult / (double)2;
        for (int i = 0; i < 13; ++i) {
            double x = Math.cos(particleAngle) * 2.0 * radiusMult;
            double z = Math.sin(particleAngle) * 2.0 * radiusMult;
            float size = ExtensionsKt.getF((Number)(1.0 + ageFraction * (double)5 * Math.random()));
            Botania.proxy.sparkleFX(this.field_70170_p, this.field_70165_t + x, this.field_70163_u + height, this.field_70161_v + z, 0.5f, 0.15f, 0.9f, size, 5);
            particleAngle += 0.5235987755982988;
        }
        double x = Math.cos(Math.random() * Math.PI * (double)2) * 2.0 * radiusMult;
        double z = Math.cos(Math.random() * Math.PI * (double)2) * 2.0 * radiusMult;
        Botania.proxy.wispFX(this.field_70170_p, this.field_70165_t + x, this.field_70163_u - 0.5 + height, this.field_70161_v + z, 0.5f, 0.15f, 1.0f, 0.3f, -0.3f, 0.5f);
        if (age >= 28) {
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            for (int i = 0; i < 5; ++i) {
                Botania.proxy.wispFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, 0.45f, 0.9f, 2.0f, -0.1f, 0.1f);
            }
        }
    }

    protected void func_70014_b(@NotNull NBTTagCompound nbt) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a("toX", this.x);
        nbt.func_74768_a("toY", this.y);
        nbt.func_74768_a("toZ", this.z);
        UUID uUID2 = this.ownerUUID;
        if (uUID2 == null) {
            uUID2 = new UUID(0L, 0L);
        }
        UUID $this$writeEntityToNBT_u24lambda_u241 = uUID = uUID2;
        boolean bl = false;
        nbt.func_74772_a(TAG_OWNER_MOST, $this$writeEntityToNBT_u24lambda_u241.getMostSignificantBits());
        nbt.func_74772_a(TAG_OWNER_LEAST, $this$writeEntityToNBT_u24lambda_u241.getLeastSignificantBits());
    }

    protected void func_70037_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.x = nbt.func_74762_e("toX");
        this.y = nbt.func_74762_e("toY");
        this.z = nbt.func_74762_e("toZ");
        this.ownerUUID = new UUID(nbt.func_74763_f(TAG_OWNER_MOST), nbt.func_74763_f(TAG_OWNER_LEAST));
    }

    public int func_82145_z() {
        return Integer.MAX_VALUE;
    }

    private static final boolean onUpdate$lambda$0(EntityFracturedSpaceCollector this$0, EntityItem it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (double)MathHelper.pointDistancePlane((double)it.field_70165_t, (double)it.field_70161_v, (double)this$0.field_70165_t, (double)this$0.field_70161_v) > 2.0 || !it.func_70089_S() || it.func_92059_d() == null || it.func_92059_d().field_77994_a <= 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lalfheim/common/entity/EntityFracturedSpaceCollector$Companion;", "", "<init>", "()V", "TAG_OWNER_MOST", "", "TAG_OWNER_LEAST", "RADIUS", "", "MAX_AGE", "", "AGE_SPECIAL_START", "", "MANA_COST_PER_ITEM", "PARTICLE_COUNT", "TOOL_STACK", "Lnet/minecraft/item/ItemStack;", "getTOOL_STACK", "()Lnet/minecraft/item/ItemStack;", "isPowered", "", "Lvazkii/botania/common/block/tile/TileOpenCrate;", "fakeCrateEject", "", "stack", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ItemStack getTOOL_STACK() {
            return TOOL_STACK;
        }

        public final boolean isPowered(@NotNull TileOpenCrate $this$isPowered) {
            Intrinsics.checkNotNullParameter((Object)$this$isPowered, (String)"<this>");
            Iterator iterator = ArrayIteratorKt.iterator((Object[])ForgeDirection.VALID_DIRECTIONS);
            while (iterator.hasNext()) {
                ForgeDirection dir = (ForgeDirection)iterator.next();
                int redstoneSide = $this$isPowered.func_145831_w().func_72878_l($this$isPowered.field_145851_c + dir.offsetX, $this$isPowered.field_145848_d + dir.offsetY, $this$isPowered.field_145849_e + dir.offsetZ, dir.ordinal());
                if (redstoneSide <= 0) continue;
                return true;
            }
            return false;
        }

        public final void fakeCrateEject(@NotNull TileOpenCrate $this$fakeCrateEject, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)$this$fakeCrateEject, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            EntityItem newEnt = new EntityItem($this$fakeCrateEject.func_145831_w(), (double)$this$fakeCrateEject.field_145851_c + 0.5, (double)$this$fakeCrateEject.field_145848_d - 0.5, (double)$this$fakeCrateEject.field_145849_e + 0.5, stack);
            newEnt.field_70159_w = 0.0;
            newEnt.field_70181_x = 0.0;
            newEnt.field_70179_y = 0.0;
            if (this.isPowered($this$fakeCrateEject)) {
                newEnt.field_70292_b = -200;
            }
            ExtensionsKt.spawn$default((Entity)((Entity)newEnt), null, (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

