/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.core.handler.ragnarok.RagnarokHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.jetbrains.annotations.NotNull;
import ru.vamig.worldengine.WE_Biome;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u001aH\u0014R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006 "}, d2={"Lalfheim/common/entity/EntityEarthquakeFracture;", "Lnet/minecraft/entity/Entity;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "x", "", "z", "maxLife", "(Lnet/minecraft/world/World;III)V", "a", "", "getA", "()D", "setA", "(D)V", "lifetime", "getLifetime", "()I", "setLifetime", "(I)V", "maxLifetime", "getMaxLifetime", "setMaxLifetime", "onUpdate", "", "readEntityFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeEntityToNBT", "entityInit", "Alfheim"})
public final class EntityEarthquakeFracture
extends Entity {
    private double a;
    private int lifetime;
    private int maxLifetime;

    public EntityEarthquakeFracture(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.func_70105_a(0.0f, 0.0f);
    }

    public final double getA() {
        return this.a;
    }

    public final void setA(double d) {
        this.a = d;
    }

    public final int getLifetime() {
        return this.lifetime;
    }

    public final void setLifetime(int n) {
        this.lifetime = n;
    }

    public final int getMaxLifetime() {
        return this.maxLifetime;
    }

    public final void setMaxLifetime(int n) {
        this.maxLifetime = n;
    }

    public EntityEarthquakeFracture(@NotNull World world, int x, int z, int maxLife) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world);
        this.a = this.field_70146_Z.nextDouble() * Math.PI * (double)2;
        this.func_70107_b(ExtensionsKt.getD((Number)x), -3.0, ExtensionsKt.getD((Number)z));
        this.maxLifetime = maxLife;
        World world2 = this.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world2, (String)"worldObj");
        if (RagnarokHandler.isProtected$default(RagnarokHandler.INSTANCE, world2, ExtensionsKt.mfloor((double)this.field_70165_t), ExtensionsKt.mfloor((double)this.field_70163_u), ExtensionsKt.mfloor((double)this.field_70161_v), false, false, 16, null)) {
            this.func_70106_y();
        } else {
            for (int y = 256; 11 < y; --y) {
                Block block = this.field_70170_p.func_147439_a(x, y, z);
                if (block.isAir((IBlockAccess)this.field_70170_p, x, y, z) || block == Blocks.field_150358_i || block == Blocks.field_150355_j) continue;
                world.func_72876_a((Entity)this, ExtensionsKt.getD((Number)x), ExtensionsKt.getD((Number)y), ExtensionsKt.getD((Number)z), 6.0f, true);
            }
        }
    }

    public void func_70071_h_() {
        if (!RagnarokHandler.INSTANCE.getGinnungagap() || this.field_70128_L) {
            this.func_70106_y();
            return;
        }
        World world = this.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        if (RagnarokHandler.isProtected$default(RagnarokHandler.INSTANCE, world, ExtensionsKt.mfloor((double)this.field_70165_t), ExtensionsKt.mfloor((double)this.field_70163_u), ExtensionsKt.mfloor((double)this.field_70161_v), false, false, 16, null)) {
            this.func_70106_y();
            return;
        }
        this.a += (this.field_70146_Z.nextDouble() - 0.5) / 12.0;
        this.func_70107_b(this.field_70165_t + Math.cos(this.a) * 0.1, -3.0, this.field_70161_v + Math.sin(this.a) * 0.1);
        int x = ExtensionsKt.mfloor((double)this.field_70165_t);
        int z = ExtensionsKt.mfloor((double)this.field_70161_v);
        int range = (this.maxLifetime - this.lifetime) / 20 + 3;
        int i = -range;
        if (i <= range) {
            while (true) {
                int k;
                if ((k = -range) <= range) {
                    while (true) {
                        if (i * i + k * k < range) {
                            BiomeGenBase biomeGenBase = this.field_70170_p.func_72807_a(x, z);
                            WE_Biome wE_Biome = biomeGenBase instanceof WE_Biome ? (WE_Biome)biomeGenBase : null;
                            int maxY = wE_Biome != null ? wE_Biome.biomeSurfaceHeight : 64;
                            for (int j = maxY + 10; 11 < j; --j) {
                                Block block;
                                if (this.field_70170_p.func_147437_c(i + x, j, k + z)) continue;
                                if (this.field_70146_Z.nextDouble() < 0.3 && !this.field_70170_p.field_72995_K) {
                                    World world2 = this.field_70170_p;
                                    Intrinsics.checkNotNullExpressionValue((Object)world2, (String)"worldObj");
                                    if (!RagnarokHandler.isProtected$default(RagnarokHandler.INSTANCE, world2, i + x, j, k + z, false, false, 16, null)) {
                                        this.field_70170_p.func_147468_f(i + x, j, k + z);
                                    }
                                }
                                if ((block = this.field_70170_p.func_147439_a(i + x, j, k + z)) != Blocks.field_150358_i && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150353_l) break;
                            }
                        }
                        if (k == range) break;
                        ++k;
                    }
                }
                if (i == range) break;
                ++i;
            }
        }
        int n = this.lifetime;
        this.lifetime = n + 1;
        if (this.maxLifetime < n) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.a = nbt.func_74769_h("a");
        this.lifetime = nbt.func_74762_e("life");
        this.maxLifetime = nbt.func_74762_e("maxlife");
    }

    protected void func_70014_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74780_a("a", this.a);
        nbt.func_74768_a("life", this.lifetime);
        nbt.func_74768_a("maxlife", this.maxLifetime);
    }

    protected void func_70088_a() {
    }
}

