/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.crafting.recipe;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.ItemNBTHelper;
import alfheim.common.entity.item.EntityItemImmortal;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.material.ElvenResourcesMetas;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lalfheim/common/crafting/recipe/RecipeSaveIvy;", "Lnet/minecraft/item/crafting/IRecipe;", "<init>", "()V", "TAG_SAVE", "", "matches", "", "inv", "Lnet/minecraft/inventory/InventoryCrafting;", "world", "Lnet/minecraft/world/World;", "getCraftingResult", "Lnet/minecraft/item/ItemStack;", "getRecipeSize", "", "getRecipeOutput", "", "onSaveItemSpawn", "", "e", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onSaveItemToss", "Lnet/minecraftforge/event/entity/item/ItemTossEvent;", "checkEntity", "entity", "Lnet/minecraft/entity/item/EntityItem;", "checkStack", "stack", "Alfheim"})
public final class RecipeSaveIvy
implements IRecipe {
    @NotNull
    public static final RecipeSaveIvy INSTANCE = new RecipeSaveIvy();
    @NotNull
    public static final String TAG_SAVE = "alfheim_saveIvy";

    private RecipeSaveIvy() {
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @Nullable World world) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        boolean foundIvy = false;
        boolean foundItem = false;
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack stack;
            if (inv.func_70301_a(i) == null) continue;
            if (!foundIvy && stack.func_77973_b() == AlfheimItems.INSTANCE.getElvenResource() && ExtensionsKt.getMeta((ItemStack)stack) == ElvenResourcesMetas.SaveIvy.getI()) {
                foundIvy = true;
                continue;
            }
            if (!(foundItem || ItemNBTHelper.INSTANCE.getBoolean(stack, TAG_SAVE, false) || stack.func_77973_b().hasContainerItem(stack))) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundIvy && foundItem;
    }

    @Nullable
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        ItemStack item = null;
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack stack;
            if (inv.func_70301_a(i) == null || stack.func_77973_b() == AlfheimItems.INSTANCE.getElvenResource() && ExtensionsKt.getMeta((ItemStack)stack) == ElvenResourcesMetas.SaveIvy.getI()) continue;
            item = stack;
        }
        ItemStack itemStack = item;
        if (itemStack == null || (itemStack = itemStack.func_77946_l()) == null) {
            return null;
        }
        ItemStack copy = itemStack;
        ItemNBTHelper.INSTANCE.setBoolean(copy, TAG_SAVE, true);
        copy.field_77994_a = 1;
        return copy;
    }

    public int func_77570_a() {
        return 10;
    }

    @Nullable
    public Void getRecipeOutput() {
        return null;
    }

    @SubscribeEvent
    public final void onSaveItemSpawn(@NotNull EntityJoinWorldEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Entity entity = e.entity;
        EntityItem entityItem = entity instanceof EntityItem ? (EntityItem)entity : null;
        if (entityItem == null) {
            return;
        }
        EntityItem entity2 = entityItem;
        if (!this.checkEntity(entity2)) {
            return;
        }
        e.setCanceled(true);
        World world = e.world;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        ExtensionsKt.spawn$default((Entity)new EntityItemImmortal(world, (Entity)entity2, entity2.func_92059_d().func_77946_l()), null, (int)1, null);
        entity2.func_92059_d().field_77994_a = 0;
        entity2.func_92058_a(null);
        entity2.func_70106_y();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onSaveItemToss(@NotNull ItemTossEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityItem entityItem = e.entityItem;
        Intrinsics.checkNotNullExpressionValue((Object)entityItem, (String)"entityItem");
        if (!this.checkEntity(entityItem)) {
            return;
        }
        e.setCanceled(true);
        ItemStack stack = e.entityItem.func_92059_d();
        boolean added = e.player.field_71071_by.func_70441_a(stack);
        if (!added && !e.player.field_70170_p.field_72995_K) {
            e.player.func_70099_a(stack, 0.0f);
        }
    }

    public final boolean checkEntity(@NotNull EntityItem entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.field_70128_L) {
            return false;
        }
        ItemStack itemStack = entity.func_70096_w().func_82710_f(10);
        if (itemStack == null || (itemStack = itemStack.func_77946_l()) == null) {
            return false;
        }
        return this.checkStack(itemStack);
    }

    public final boolean checkStack(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.field_77994_a < 1) {
            return false;
        }
        return ItemNBTHelper.INSTANCE.getBoolean(stack, TAG_SAVE, false);
    }

    static {
        ExtensionsKt.eventForge((Object)INSTANCE);
    }
}

