/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.helper;

import alexsocol.asjlib.ASJUtilities;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lalfheim/common/core/helper/HashHelper;", "", "<init>", "()V", "hash", "", "str", "salt", "Alfheim"})
public final class HashHelper {
    @NotNull
    public static final HashHelper INSTANCE = new HashHelper();

    private HashHelper() {
    }

    @NotNull
    public final String hash(@Nullable String str, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        if (str != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();
                String string = this.salt(str, salt);
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String string2 = hexBinaryAdapter.marshal(md.digest(byArray));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"marshal(...)");
                return string2;
            }
            catch (NoSuchAlgorithmException e) {
                ASJUtilities.error((String)"Hashing error:", (Throwable)e);
            }
        }
        return "";
    }

    public static /* synthetic */ String hash$default(HashHelper hashHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "soyeahthatsjustarandomuselesssecuritysaltthingsoyeah";
        }
        return hashHelper.hash(string, string2);
    }

    @NotNull
    public final String salt(@NotNull String str, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        String salted = str + salt;
        Random rand = new Random(salted.length());
        int l = salted.length();
        int steps = rand.nextInt(l);
        char[] cArray = salted.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        for (int i = 0; i < steps; ++i) {
            char c;
            int indA = rand.nextInt(l);
            int indB = 0;
            while ((indB = rand.nextInt(l)) == indA) {
            }
            chars[indA] = c = (char)(chars[indA] ^ chars[indB]);
        }
        return new String(chars);
    }
}

