/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.helper;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.block.tile.corporea.TileCorporeaInjector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lib.LibMisc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\"\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0010J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u001b"}, d2={"Lalfheim/common/core/helper/CorporeaAdvancedHelper;", "", "<init>", "()V", "putToNetwork", "Lnet/minecraft/item/ItemStack;", "spark", "Lvazkii/botania/api/corporea/ICorporeaSpark;", "stack", "insertToHard", "inv", "Lnet/minecraft/inventory/IInventory;", "insertTo", "isValidSlot", "", "slot", "", "putOrDrop", "", "tile", "Lnet/minecraft/tileentity/TileEntity;", "yOff", "getFilters", "", "requestMatches", "request", "filter", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nCorporeaAdvancedHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorporeaAdvancedHelper.kt\nalfheim/common/core/helper/CorporeaAdvancedHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n1863#2,2:115\n1#3:114\n*S KotlinDebug\n*F\n+ 1 CorporeaAdvancedHelper.kt\nalfheim/common/core/helper/CorporeaAdvancedHelper\n*L\n22#1:111\n22#1:112,2\n94#1:115,2\n*E\n"})
public final class CorporeaAdvancedHelper {
    @NotNull
    public static final CorporeaAdvancedHelper INSTANCE = new CorporeaAdvancedHelper();

    private CorporeaAdvancedHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ItemStack putToNetwork(@NotNull ICorporeaSpark spark, @NotNull ItemStack stack) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)spark, (String)"spark");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        List list = CorporeaHelper.getInventoriesOnNetwork((ICorporeaSpark)spark);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInventoriesOnNetwork(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IInventory it = (IInventory)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof TileCorporeaInjector))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inventories = (List)destination$iv$iv;
        if (inventories.isEmpty()) {
            return stack;
        }
        for (IInventory inv : inventories) {
            if (stack.field_77994_a <= 0) {
                return null;
            }
            Intrinsics.checkNotNull((Object)inv);
            if (this.insertTo(spark, stack, inv) != null) continue;
            return null;
        }
        if (stack.field_77994_a <= 0) {
            return null;
        }
        for (IInventory inv : inventories) {
            if (stack.field_77994_a <= 0) {
                return null;
            }
            Intrinsics.checkNotNull((Object)inv);
            if (this.insertToHard(spark, stack, inv) != null) continue;
            return null;
        }
        return stack;
    }

    @Nullable
    public final ItemStack insertToHard(@Nullable ICorporeaSpark spark, @NotNull ItemStack stack, @NotNull IInventory inv) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
            int canPut = InventoryHelper.testInventoryInsertion((IInventory)inv, (ItemStack)stack, (ForgeDirection)ForgeDirection.UP);
            if (canPut <= 0) {
                return stack;
            }
            InventoryHelper.insertItemIntoInventory((IInventory)inv, (ItemStack)stack.func_77979_a(canPut), (ForgeDirection)ForgeDirection.UP, (int)-1);
            ICorporeaSpark iCorporeaSpark = spark;
            if (iCorporeaSpark == null) break block1;
            iCorporeaSpark.onItemExtracted(stack);
        }
        return stack.field_77994_a <= 0 ? null : stack;
    }

    @Nullable
    public final ItemStack insertTo(@Nullable ICorporeaSpark spark, @NotNull ItemStack stack, @NotNull IInventory inv) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        boolean did = false;
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack;
            int canPut;
            ItemStack stackAt;
            if (stack.field_77994_a <= 0) {
                return null;
            }
            if (!this.isValidSlot(inv, stack, i) || ExtensionsKt.get((IInventory)inv, (int)i) == null || !CorporeaHelper.stacksMatch((ItemStack)stack, (ItemStack)stackAt, (boolean)true) || (canPut = stackAt.func_77976_d() - stackAt.field_77994_a) <= 0) continue;
            if (stack.field_77994_a >= canPut) {
                itemStack = stack.func_77979_a(canPut);
            } else {
                ItemStack itemStack2;
                ItemStack it = itemStack2 = stack.func_77946_l();
                boolean bl = false;
                stack.field_77994_a = 0;
                itemStack = itemStack2;
            }
            ItemStack place = itemStack;
            InventoryHelper.insertItemIntoInventory((IInventory)inv, (ItemStack)place, (ForgeDirection)ForgeDirection.UP, (int)i);
            did = true;
            ICorporeaSpark iCorporeaSpark = spark;
            if (iCorporeaSpark == null) continue;
            iCorporeaSpark.onItemExtracted(stack);
        }
        if (did) {
            inv.func_70296_d();
        }
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidSlot(@NotNull IInventory inv, @NotNull ItemStack stack, int slot) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!(inv instanceof ISidedInventory)) return true;
        int[] nArray = ((ISidedInventory)inv).func_94128_d(ForgeDirection.UP.ordinal());
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getAccessibleSlotsFromSide(...)");
        if (!ArraysKt.contains((int[])nArray, (int)slot)) return false;
        if (!((ISidedInventory)inv).func_102007_a(slot, stack, ForgeDirection.UP.ordinal())) return false;
        return true;
    }

    public final void putOrDrop(@NotNull TileEntity tile, @Nullable ICorporeaSpark spark, @Nullable ItemStack stack, int yOff) {
        EntityItem entityItem;
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        World world = tile.func_145831_w();
        double d = (double)tile.field_145851_c + 0.5;
        double d2 = (double)tile.field_145848_d + 0.5 + (double)yOff;
        double d3 = (double)tile.field_145849_e + 0.5;
        ICorporeaSpark iCorporeaSpark = spark;
        if (iCorporeaSpark != null) {
            ItemStack itemStack2 = stack;
            if (itemStack2 == null) {
                return;
            }
            itemStack = this.putToNetwork(iCorporeaSpark, itemStack2);
            if (itemStack == null) {
                return;
            }
        } else {
            itemStack = stack;
            if (itemStack == null) {
                return;
            }
        }
        EntityItem item = entityItem = new EntityItem(world, d, d2, d3, itemStack);
        boolean bl = false;
        ExtensionsKt.setMotion$default((Entity)((Entity)item), (double)0.0, (double)0.0, (double)0.0, (int)6, null);
        ExtensionsKt.spawn$default((Entity)((Entity)entityItem), null, (int)1, null);
    }

    public static /* synthetic */ void putOrDrop$default(CorporeaAdvancedHelper corporeaAdvancedHelper, TileEntity tileEntity, ICorporeaSpark iCorporeaSpark, ItemStack itemStack, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 2;
        }
        corporeaAdvancedHelper.putOrDrop(tileEntity, iCorporeaSpark, itemStack, n);
    }

    @NotNull
    public final List<ItemStack> getFilters(@NotNull TileEntity tile) {
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        Object object = new int[]{3, 4, 2, 5};
        int[] orientationToDir = object;
        object = ArrayIteratorKt.iterator((Object[])LibMisc.CARDINAL_DIRECTIONS);
        while (object.hasNext()) {
            ForgeDirection dir = (ForgeDirection)object.next();
            World world = tile.func_145831_w();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
            AxisAlignedBB axisAlignedBB = ExtensionsKt.boundingBox$default((TileEntity)tile, null, (int)1, null).func_72317_d(ExtensionsKt.getD((Number)dir.offsetX), ExtensionsKt.getD((Number)dir.offsetY), ExtensionsKt.getD((Number)dir.offsetZ));
            Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"offset(...)");
            Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityItemFrame.class, (AxisAlignedBB)axisAlignedBB);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityItemFrame frame = (EntityItemFrame)element$iv;
                boolean bl = false;
                int orientation = frame.field_82332_a;
                if (orientationToDir[orientation] != dir.ordinal()) continue;
                filter.add(frame.func_82335_i());
            }
        }
        return filter;
    }

    public final boolean requestMatches(@Nullable Object request, @Nullable ItemStack filter) {
        Object object;
        boolean bl = filter == null ? false : ((object = request) instanceof ItemStack ? ((ItemStack)request).func_77969_a(filter) && ItemStack.func_77970_a((ItemStack)filter, (ItemStack)((ItemStack)request)) : (object instanceof String ? CorporeaHelper.stacksMatch((ItemStack)filter, (String)((String)request)) : false));
        return bl;
    }
}

