/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.patcher.event.ServerStoppedEvent;
import alfheim.AlfheimCore;
import alfheim.common.core.handler.AlfheimTicket;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0007J\u001e\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lalfheim/common/core/handler/ChunkLoadingHandler;", "Lnet/minecraftforge/common/ForgeChunkManager$LoadingCallback;", "<init>", "()V", "ticketsStore", "Ljava/util/HashMap;", "", "Ljava/util/LinkedHashSet;", "Lalfheim/common/core/handler/AlfheimTicket;", "getTicketsStore", "()Ljava/util/HashMap;", "requestChunkLoad", "", "world", "Lnet/minecraft/world/World;", "chunkX", "chunkZ", "onServerTick", "", "e", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "onServerStopped", "Lalexsocol/patcher/event/ServerStoppedEvent;", "ticketsLoaded", "tickets", "", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nChunkLoadingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLoadingHandler.kt\nalfheim/common/core/handler/ChunkLoadingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,103:1\n295#2,2:104\n295#2,2:106\n1863#2,2:109\n1628#2,2:112\n1293#2,4:114\n1630#2:118\n216#3:108\n217#3:111\n*S KotlinDebug\n*F\n+ 1 ChunkLoadingHandler.kt\nalfheim/common/core/handler/ChunkLoadingHandler\n*L\n31#1:104,2\n33#1:106,2\n80#1:109,2\n96#1:112,2\n97#1:114,4\n96#1:118\n64#1:108\n64#1:111\n*E\n"})
public final class ChunkLoadingHandler
implements ForgeChunkManager.LoadingCallback {
    @NotNull
    public static final ChunkLoadingHandler INSTANCE = new ChunkLoadingHandler();
    @NotNull
    private static final HashMap<Integer, LinkedHashSet<AlfheimTicket>> ticketsStore = new HashMap();

    private ChunkLoadingHandler() {
    }

    @NotNull
    public final HashMap<Integer, LinkedHashSet<AlfheimTicket>> getTicketsStore() {
        return ticketsStore;
    }

    public final boolean requestChunkLoad(@NotNull World world, int chunkX, int chunkZ) {
        AlfheimTicket alfheimTicket;
        Object v1;
        AlfheimTicket it;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        LinkedHashSet ticketsForDim;
        ChunkCoordIntPair chunk;
        block8: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            if (ASJUtilities.isClient()) {
                return false;
            }
            chunk = new ChunkCoordIntPair(chunkX, chunkZ);
            LinkedHashSet linkedHashSet = ticketsStore.computeIfAbsent(world.field_73011_w.field_76574_g, arg_0 -> ChunkLoadingHandler.requestChunkLoad$lambda$1(ChunkLoadingHandler::requestChunkLoad$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"computeIfAbsent(...)");
            ticketsForDim = linkedHashSet;
            $this$firstOrNull$iv = ticketsForDim;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (AlfheimTicket)element$iv;
                boolean bl = false;
                if (!it.getTicket().getChunkList().contains((Object)chunk)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        if ((alfheimTicket = (AlfheimTicket)v1) == null) {
            Object v3;
            block9: {
                $this$firstOrNull$iv = ticketsForDim;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (AlfheimTicket)element$iv;
                    boolean bl = false;
                    if (!(it.getTicket().getChunkListDepth() <= 0 || it.getTicket().getChunkList().size() < it.getTicket().getChunkListDepth())) continue;
                    v3 = element$iv;
                    break block9;
                }
                v3 = null;
            }
            alfheimTicket = v3;
        }
        AlfheimTicket ticket = alfheimTicket;
        boolean newTicket = false;
        if (ticket == null) {
            ForgeChunkManager.Ticket ticket2 = ForgeChunkManager.requestTicket((Object)AlfheimCore.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket2 == null) {
                ChunkLoadingHandler $this$requestChunkLoad_u24lambda_u244 = this;
                boolean bl = false;
                FMLLog.bigWarning((String)"Unable to allocate new chunkloading ticket for [alfheim]! Please, expand the limit in FML configs or remove extra", (Object[])new Object[0]);
                return false;
            }
            ForgeChunkManager.Ticket fTicket = ticket2;
            ticket = new AlfheimTicket(fTicket, new LinkedHashMap<ChunkCoordIntPair, Integer>());
            newTicket = true;
        }
        if (!ForgeChunkManager.getPersistentChunksFor((World)world).containsKey((Object)chunk)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket.getTicket(), (ChunkCoordIntPair)chunk);
        }
        ((Map)ticket.getRequestedChunkTimers()).put(chunk, 100);
        if (newTicket) {
            ((Collection)ticketsForDim).add(ticket);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onServerTick(@NotNull TickEvent.ServerTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Map $this$forEach$iv = ticketsStore;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iTicket;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            LinkedHashSet alfheimTicketsPerDim = (LinkedHashSet)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(alfheimTicketsPerDim.iterator(), (String)"iterator(...)");
            while (iTicket.hasNext()) {
                void $this$forEach$iv2;
                Object e2 = iTicket.next();
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                AlfheimTicket ticket = (AlfheimTicket)e2;
                Set toRemove = new LinkedHashSet();
                Object object = ticket.getRequestedChunkTimers().keySet().iterator();
                while (object.hasNext()) {
                    ChunkCoordIntPair key;
                    Intrinsics.checkNotNullExpressionValue((Object)object.next(), (String)"next(...)");
                    Integer n = ticket.getRequestedChunkTimers().get(key);
                    Intrinsics.checkNotNull((Object)n);
                    int timer = ((Number)n).intValue() - 1;
                    Integer n2 = timer;
                    ((Map)ticket.getRequestedChunkTimers()).put(key, n2);
                    if (timer > 0) continue;
                    ((Collection)toRemove).add(key);
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket.getTicket(), (ChunkCoordIntPair)key);
                }
                object = toRemove;
                LinkedHashMap<ChunkCoordIntPair, Integer> linkedHashMap = ticket.getRequestedChunkTimers();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ChunkCoordIntPair p0 = (ChunkCoordIntPair)element$iv2;
                    boolean bl2 = false;
                    linkedHashMap.remove(p0);
                }
                if (!ticket.getTicket().getChunkList().isEmpty()) continue;
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket.getTicket());
                iTicket.remove();
            }
        }
    }

    @SubscribeEvent
    public final void onServerStopped(@NotNull ServerStoppedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ticketsStore.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void ticketsLoaded(@NotNull List<ForgeChunkManager.Ticket> tickets, @NotNull World world) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(tickets, (String)"tickets");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Iterable iterable = tickets;
        LinkedHashSet linkedHashSet = ticketsStore.computeIfAbsent(world.field_73011_w.field_76574_g, arg_0 -> ChunkLoadingHandler.ticketsLoaded$lambda$7(ChunkLoadingHandler::ticketsLoaded$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"computeIfAbsent(...)");
        Collection destination$iv = linkedHashSet;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void destination$iv2;
            void $this$associateWithTo$iv;
            void it;
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            ImmutableSet immutableSet = it.getChunkList();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"getChunkList(...)");
            Iterable iterable2 = (Iterable)immutableSet;
            Map map = new LinkedHashMap();
            void var12_12 = it;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                ChunkCoordIntPair chunkCoordIntPair = (ChunkCoordIntPair)element$iv;
                Object t = element$iv;
                void var18_18 = destination$iv2;
                boolean bl2 = false;
                Integer n = 100;
                var18_18.put(t, n);
            }
            LinkedHashMap linkedHashMap = (LinkedHashMap)destination$iv2;
            void var23_23 = var12_12;
            collection.add(new AlfheimTicket((ForgeChunkManager.Ticket)var23_23, linkedHashMap));
        }
        ASJUtilities.log((String)("Loaded " + tickets.size() + " [alfheim] chunkloading ticket(s) for dim " + world.field_73011_w.field_76574_g));
    }

    private static final LinkedHashSet requestChunkLoad$lambda$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final LinkedHashSet requestChunkLoad$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LinkedHashSet)$tmp0.invoke(p0);
    }

    private static final LinkedHashSet ticketsLoaded$lambda$6(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final LinkedHashSet ticketsLoaded$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LinkedHashSet)$tmp0.invoke(p0);
    }

    static {
        ExtensionsKt.eventForge((Object)ExtensionsKt.eventFML((Object)INSTANCE));
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)AlfheimCore.INSTANCE, (ForgeChunkManager.LoadingCallback)INSTANCE);
    }
}

