/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alexsocol.patcher.event.EntityUpdateEvent;
import alexsocol.patcher.event.ServerStartedEvent;
import alexsocol.patcher.event.ServerStoppingEvent;
import alfheim.AlfheimCore;
import alfheim.api.AlfheimAPI;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.api.event.SpellCastEvent;
import alfheim.api.event.TimeStopCheckEvent;
import alfheim.api.spell.ITimeStopSpecific;
import alfheim.api.spell.SpellBase;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.item.relic.ItemTankMask;
import alfheim.common.network.M1d;
import alfheim.common.network.M2d;
import alfheim.common.network.M3d;
import alfheim.common.network.Mni;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.Message1d;
import alfheim.common.network.packet.Message2d;
import alfheim.common.network.packet.Message3d;
import alfheim.common.network.packet.MessageHotSpellC;
import alfheim.common.network.packet.MessageNI;
import alfheim.common.network.packet.MessageParty;
import alfheim.common.network.packet.MessageRaceInfo;
import alfheim.common.network.packet.MessageSkinInfo;
import alfheim.common.network.packet.MessageTimeStop;
import alfheim.common.spell.tech.SpellTimeStop;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000b\u001b\u001c\u001d\u001e\u001f !\"#$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0019H\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001aH\u0007R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lalfheim/common/core/handler/CardinalSystem;", "", "<init>", "()V", "playerSegments", "Ljava/util/HashMap;", "", "Lalfheim/common/core/handler/CardinalSystem$PlayerSegment;", "getPlayerSegments", "()Ljava/util/HashMap;", "setPlayerSegments", "(Ljava/util/HashMap;)V", "load", "", "save", "transfer", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "ensureExistance", "", "Lnet/minecraft/entity/player/EntityPlayer;", "forPlayer", "e", "Lalexsocol/patcher/event/ServerStartedEvent;", "tick", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "Lalexsocol/patcher/event/ServerStoppingEvent;", "CommonSystem", "KnowledgeSystem", "SpellCastingSystem", "ManaSystem", "TargetingSystem", "PartySystem", "HotSpellsSystem", "TimeStopSystem", "ElvenStoryModeSystem", "ElvenReputationSystem", "PlayerSegment", "Alfheim"})
public final class CardinalSystem {
    @NotNull
    public static final CardinalSystem INSTANCE = new CardinalSystem();
    @NotNull
    private static HashMap<String, PlayerSegment> playerSegments = new HashMap();

    private CardinalSystem() {
    }

    @NotNull
    public final HashMap<String, PlayerSegment> getPlayerSegments() {
        return playerSegments;
    }

    public final void setPlayerSegments(@NotNull HashMap<String, PlayerSegment> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        playerSegments = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull String save) {
        Intrinsics.checkNotNullParameter((Object)save, (String)"save");
        File file = new File(save + "/data/alfheim/Cardinal.sys");
        if (!file.exists()) {
            ASJUtilities.log((String)"Cardinal System data file not found. Generating default values...");
            playerSegments = new HashMap();
            TimeStopSystem.INSTANCE.setTsAreas(new HashMap<Integer, LinkedList<TimeStopSystem.TimeStopArea>>());
            return;
        }
        try {
            Closeable closeable = new ObjectInputStream(new FileInputStream(file));
            Throwable throwable = null;
            try {
                ObjectInputStream ois = (ObjectInputStream)closeable;
                boolean bl = false;
                Object object = ois.readObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.String, alfheim.common.core.handler.CardinalSystem.PlayerSegment>");
                playerSegments = (HashMap)object;
                Object object2 = ois.readObject();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.Int, java.util.LinkedList<alfheim.common.core.handler.CardinalSystem.TimeStopSystem.TimeStopArea>>");
                TimeStopSystem.INSTANCE.setTsAreas((HashMap)object2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            ASJUtilities.error((String)"Unable to read whole Cardinal System data. Generating default values.", (Throwable)e);
            playerSegments = new HashMap();
            TimeStopSystem.INSTANCE.setTsAreas(new HashMap<Integer, LinkedList<TimeStopSystem.TimeStopArea>>());
        }
    }

    public final void transfer(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NetworkService.INSTANCE.sendTo(new Message1d(M1d.LIMBO, ExtensionsKt.getD((Number)ItemTankMask.Companion.getLimboCounter((EntityPlayer)player)), 0, 4, null), player);
        KnowledgeSystem.INSTANCE.transfer(player);
        CommonSystem.loseHearts$default(CommonSystem.INSTANCE, player, 0, 2, null);
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            NetworkService.INSTANCE.sendTo(new Message1d(M1d.ESMABIL, this.forPlayer((EntityPlayer)player).getEsmAbility() ? 1.0 : 0.0, 0, 4, null), player);
            ElvenStoryModeSystem.INSTANCE.transfer(player);
            if (AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                SpellCastingSystem.INSTANCE.transfer(player);
                HotSpellsSystem.INSTANCE.transfer(player);
                PartySystem.INSTANCE.transfer(player);
                TimeStopSystem.INSTANCE.transfer(player, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        try {
            Closeable closeable = new ObjectOutputStream(new FileOutputStream(AlfheimCore.INSTANCE.getSave() + "/data/alfheim/Cardinal.sys"));
            Throwable throwable = null;
            try {
                ObjectOutputStream oos = (ObjectOutputStream)closeable;
                boolean bl = false;
                oos.writeObject(playerSegments);
                oos.writeObject(TimeStopSystem.INSTANCE.getTsAreas());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            ASJUtilities.error((String)"Unable to save whole Cardinal System data. Discarding. Sorry :(", (Throwable)e);
        }
    }

    public final boolean ensureExistance(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!playerSegments.containsKey(player.func_70005_c_())) {
            ((Map)playerSegments).put(player.func_70005_c_(), new PlayerSegment(player));
        }
        return true;
    }

    @NotNull
    public final PlayerSegment forPlayer(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.field_70170_p.field_72995_K) {
            throw new RuntimeException("You shouldn't access this from client");
        }
        this.ensureExistance(player);
        PlayerSegment playerSegment = playerSegments.get(player.func_70005_c_());
        Intrinsics.checkNotNull((Object)playerSegment);
        return playerSegment;
    }

    @SubscribeEvent
    public final void load(@NotNull ServerStartedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.load(AlfheimCore.INSTANCE.getSave());
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ServerTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.phase == TickEvent.Phase.END) {
            if (MinecraftServer.func_71276_C().func_71259_af() % 900 == 0) {
                this.save();
            }
            return;
        }
        if (!AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
            return;
        }
        SpellCastingSystem.INSTANCE.tick();
        TimeStopSystem.INSTANCE.tick();
        TargetingSystem.INSTANCE.tick();
    }

    @SubscribeEvent
    public final void save(@NotNull ServerStoppingEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.save();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u001bH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lalfheim/common/core/handler/CardinalSystem$CommonSystem;", "", "<init>", "()V", "heartLossUUID", "Ljava/util/UUID;", "getHeartLossUUID", "()Ljava/util/UUID;", "cantLostHearts", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "loseHearts", "", "additionalLoss", "", "updateLostHearts", "Lnet/minecraft/entity/player/EntityPlayer;", "lost", "onPlayerJoined", "e", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onPlayerRespawn", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPlayerDimChange", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerTick", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "Alfheim"})
    public static final class CommonSystem {
        @NotNull
        public static final CommonSystem INSTANCE = new CommonSystem();
        @NotNull
        private static final UUID heartLossUUID;

        private CommonSystem() {
        }

        @NotNull
        public final UUID getHeartLossUUID() {
            return heartLossUUID;
        }

        public final boolean cantLostHearts(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() <= (double)(INSTANCE.forPlayer((EntityPlayer)player).getHeartLoss() * 2 + 2);
        }

        public final void loseHearts(@NotNull EntityPlayerMP player, int additionalLoss) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PlayerSegment segment = INSTANCE.forPlayer((EntityPlayer)player);
            segment.setHeartLoss(Math.max(0, segment.getHeartLoss() + additionalLoss));
            this.updateLostHearts((EntityPlayer)player, segment.getHeartLoss());
            int[] nArray = new int[]{segment.getHeartLoss()};
            NetworkService.INSTANCE.sendTo(new MessageNI(Mni.HEARTLOSS, nArray, 0, 4, null), player);
        }

        public static /* synthetic */ void loseHearts$default(CommonSystem commonSystem, EntityPlayerMP entityPlayerMP, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            commonSystem.loseHearts(entityPlayerMP, n);
        }

        public final void updateLostHearts(@NotNull EntityPlayer player, int lost) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            HashMultimap mm = HashMultimap.create();
            mm.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(heartLossUUID, "Hel took your hearts", (double)lost * -2.0, 0));
            player.func_110140_aT().func_111147_b((Multimap)mm);
        }

        @SubscribeEvent
        public final void onPlayerJoined(@NotNull EntityJoinWorldEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (ASJUtilities.isServer()) {
                Entity entity = e.entity;
                EntityPlayerMP entityPlayerMP = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
                if (entityPlayerMP == null) {
                    return;
                }
                CommonSystem.loseHearts$default(this, entityPlayerMP, 0, 2, null);
            }
        }

        @SubscribeEvent
        public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (ASJUtilities.isServer()) {
                EntityPlayer entityPlayer = e.player;
                EntityPlayerMP entityPlayerMP = entityPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)entityPlayer : null;
                if (entityPlayerMP == null) {
                    return;
                }
                CommonSystem.loseHearts$default(this, entityPlayerMP, 0, 2, null);
            }
        }

        @SubscribeEvent
        public final void onPlayerDimChange(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (ASJUtilities.isServer()) {
                EntityPlayer entityPlayer = e.player;
                EntityPlayerMP entityPlayerMP = entityPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)entityPlayer : null;
                if (entityPlayerMP == null) {
                    return;
                }
                CommonSystem.loseHearts$default(this, entityPlayerMP, 0, 2, null);
            }
        }

        @SubscribeEvent
        public final void onPlayerTick(@NotNull LivingEvent.LivingUpdateEvent e) {
            block3: {
                PotionEffect potionEffect;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EntityLivingBase entityLivingBase = e.entityLiving;
                EntityPlayerMP entityPlayerMP = entityLivingBase instanceof EntityPlayerMP ? (EntityPlayerMP)entityLivingBase : null;
                if (entityPlayerMP == null) {
                    return;
                }
                EntityPlayerMP player = entityPlayerMP;
                int wisdomLevel = INSTANCE.forPlayer((EntityPlayer)player).getWisdom();
                if (wisdomLevel <= 0) {
                    player.func_82170_o(AlfheimConfigHandler.INSTANCE.getPotionIDWisdom());
                    return;
                }
                if (!player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDWisdom())) {
                    player.func_70690_d(ExtensionsKt.PotionEffectU$default((int)AlfheimConfigHandler.INSTANCE.getPotionIDWisdom(), (int)Integer.MAX_VALUE, (int)(wisdomLevel - 1), (boolean)false, (int)8, null));
                }
                PotionEffect potionEffect2 = ExtensionsKt.getActivePotionEffect((EntityLivingBase)((EntityLivingBase)player), (int)AlfheimConfigHandler.INSTANCE.getPotionIDWisdom());
                if (potionEffect2 == null) break block3;
                PotionEffect $this$onPlayerTick_u24lambda_u240 = potionEffect = potionEffect2;
                boolean bl = false;
                $this$onPlayerTick_u24lambda_u240.field_76460_b = Integer.MAX_VALUE;
                $this$onPlayerTick_u24lambda_u240.field_76461_c = wisdomLevel - 1;
            }
        }

        static {
            UUID uUID = UUID.fromString("5F618E7B-10E1-412F-A61C-A310D8C879BA");
            Intrinsics.checkNotNull((Object)uUID);
            heartLossUUID = uUID;
            ExtensionsKt.eventFML((Object)ExtensionsKt.eventForge((Object)INSTANCE));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ElvenReputationSystem;", "", "<init>", "()V", "getReputationLevel", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "race", "Lalfheim/api/entity/EnumRace;", "getReputationValue", "changeReputationValue", "", "amount", "changeReputationValueBasedOnLevel", "Alfheim"})
    public static final class ElvenReputationSystem {
        @NotNull
        public static final ElvenReputationSystem INSTANCE = new ElvenReputationSystem();

        private ElvenReputationSystem() {
        }

        public final int getReputationLevel(@NotNull EntityPlayer player, @NotNull EnumRace race) {
            int n;
            block1: {
                int n2;
                block2: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                        Intrinsics.checkNotNullParameter((Object)((Object)race), (String)"race");
                        n2 = this.getReputationValue(player, race);
                        boolean bl = 0 <= n2 ? n2 < 100 : false;
                        if (!bl) break block0;
                        n = 0;
                        break block1;
                    }
                    boolean bl = 100 <= n2 ? n2 < 250 : false;
                    if (!bl) break block2;
                    n = 1;
                    break block1;
                }
                n = (250 <= n2 ? n2 < 500 : false) ? 2 : ((500 <= n2 ? n2 <= Integer.MAX_VALUE : false) ? 3 : -1);
            }
            return n;
        }

        public final int getReputationValue(@NotNull EntityPlayer player, @NotNull EnumRace race) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)race), (String)"race");
            return INSTANCE.forPlayer(player).getReputation()[race.ordinal()] + (EnumRaceKt.getRace(player) == EnumRace.ALV ? 100 : (EnumRaceKt.getRace(player) != race && EnumRaceKt.getRace(player) != EnumRace.HUMAN ? -50 : 0));
        }

        public final void changeReputationValue(@NotNull EntityPlayer player, @NotNull EnumRace race, int amount) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)race), (String)"race");
            Integer[] integerArray = INSTANCE.forPlayer(player).getReputation();
            int n = race.ordinal();
            integerArray[n] = integerArray[n] + amount;
        }

        public final void changeReputationValueBasedOnLevel(@NotNull EntityPlayer player, @NotNull EnumRace race, int amount) {
            double d;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)race), (String)"race");
            int lvl = this.getReputationLevel(player, race);
            if (amount < 0) {
                switch (lvl) {
                    case 3: {
                        d = 3.0;
                        break;
                    }
                    case 2: {
                        d = 1.5;
                        break;
                    }
                    default: {
                        d = 1.0;
                        break;
                    }
                }
            } else {
                switch (lvl) {
                    case -1: {
                        d = 0.25;
                        break;
                    }
                    case 1: {
                        d = 1.25;
                        break;
                    }
                    case 2: {
                        d = 0.99;
                        break;
                    }
                    case 3: {
                        d = 0.75;
                        break;
                    }
                    default: {
                        d = 1.0;
                    }
                }
            }
            double multiplier = d;
            Integer[] integerArray = INSTANCE.forPlayer(player).getReputation();
            int n = race.ordinal();
            integerArray[n] = integerArray[n] + ExtensionsKt.getI((Number)((double)amount * multiplier));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ElvenStoryModeSystem;", "", "<init>", "()V", "getGender", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "setGender", "", "isFemale", "setCustomSkin", "skinOn", "transfer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Alfheim"})
    @SourceDebugExtension(value={"SMAP\nCardinalSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$ElvenStoryModeSystem\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1174:1\n216#2,2:1175\n*S KotlinDebug\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$ElvenStoryModeSystem\n*L\n1044#1:1175,2\n*E\n"})
    public static final class ElvenStoryModeSystem {
        @NotNull
        public static final ElvenStoryModeSystem INSTANCE = new ElvenStoryModeSystem();

        private ElvenStoryModeSystem() {
        }

        public final boolean getGender(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getGender();
        }

        public final void setGender(@NotNull EntityPlayer player, boolean isFemale) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            INSTANCE.forPlayer(player).setGender(isFemale);
        }

        public final void setCustomSkin(@NotNull EntityPlayer player, boolean skinOn) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            INSTANCE.forPlayer(player).setCustomSkin(skinOn);
        }

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Map $this$forEach$iv = INSTANCE.getPlayerSegments();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                PlayerSegment seg = (PlayerSegment)entry.getValue();
                NetworkService.INSTANCE.sendTo(new MessageRaceInfo(name, seg.getRaceID()), player);
                NetworkService.INSTANCE.sendTo(new MessageSkinInfo(name, seg.getGender(), seg.getCustomSkin()), player);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\tJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lalfheim/common/core/handler/CardinalSystem$HotSpellsSystem;", "", "<init>", "()V", "transfer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "getHotSpellID", "", "Lnet/minecraft/entity/player/EntityPlayer;", "slot", "setHotSpellID", "id", "Alfheim"})
    public static final class HotSpellsSystem {
        @NotNull
        public static final HotSpellsSystem INSTANCE = new HotSpellsSystem();

        private HotSpellsSystem() {
        }

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            NetworkService.INSTANCE.sendTo(new MessageHotSpellC(INSTANCE.forPlayer((EntityPlayer)player).getHotSpells()), player);
        }

        public final int getHotSpellID(@NotNull EntityPlayer player, int slot) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getHotSpells()[slot];
        }

        public final void setHotSpellID(@NotNull EntityPlayer player, int slot, int id) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player).getHotSpells()[slot] = id;
            INSTANCE.save();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lalfheim/common/core/handler/CardinalSystem$KnowledgeSystem;", "", "<init>", "()V", "learn", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "kn", "Lalfheim/common/core/handler/CardinalSystem$KnowledgeSystem$Knowledge;", "forceEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "know", "transfer", "", "Knowledge", "Alfheim"})
    public static final class KnowledgeSystem {
        @NotNull
        public static final KnowledgeSystem INSTANCE = new KnowledgeSystem();

        private KnowledgeSystem() {
        }

        public final boolean learn(@NotNull EntityPlayerMP player, @NotNull Knowledge kn, @Nullable LexiconEntry forceEntry) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)kn), (String)"kn");
            PlayerSegment seg = INSTANCE.forPlayer((EntityPlayer)player);
            if (this.know(player, kn)) {
                return false;
            }
            seg.getKnowledge().add(String.valueOf((Object)kn));
            NetworkService.INSTANCE.sendTo(new Message1d(M1d.KNOWLEDGE, ExtensionsKt.getD((Number)kn.ordinal()), 0, 4, null), player);
            INSTANCE.save();
            if (forceEntry == null) {
                return true;
            }
            ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"alfheimmisc.newentry", (Object[])new Object[0]);
            Item item = ModItems.lexicon;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"lexicon");
            InventoryPlayer inventoryPlayer = player.field_71071_by;
            Intrinsics.checkNotNullExpressionValue((Object)inventoryPlayer, (String)"inventory");
            int slot = ASJUtilities.getSlotWithItem((Item)item, (IInventory)((IInventory)inventoryPlayer));
            if (slot == -1) {
                return true;
            }
            InventoryPlayer inventoryPlayer2 = player.field_71071_by;
            Intrinsics.checkNotNullExpressionValue((Object)inventoryPlayer2, (String)"inventory");
            ItemStack itemStack = ExtensionsKt.get((IInventory)((IInventory)inventoryPlayer2), (int)slot);
            Intrinsics.checkNotNull((Object)itemStack);
            ItemStack lexicon = itemStack;
            ItemLexicon.setForcedPage((ItemStack)lexicon, (String)forceEntry.getUnlocalizedName());
            return true;
        }

        public static /* synthetic */ boolean learn$default(KnowledgeSystem knowledgeSystem, EntityPlayerMP entityPlayerMP, Knowledge knowledge, LexiconEntry lexiconEntry, int n, Object object) {
            if ((n & 4) != 0) {
                lexiconEntry = null;
            }
            return knowledgeSystem.learn(entityPlayerMP, knowledge, lexiconEntry);
        }

        public final boolean know(@NotNull EntityPlayerMP player, @NotNull Knowledge kn) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)kn), (String)"kn");
            return INSTANCE.forPlayer((EntityPlayer)player).getKnowledge().contains(String.valueOf((Object)kn));
        }

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            NetworkService.INSTANCE.sendTo(new Message1d(M1d.KNOWLEDGE, -1.0, 0, 4, null), player);
            for (Knowledge kn : Knowledge.getEntries()) {
                if (!this.know(player, kn)) continue;
                NetworkService.INSTANCE.sendTo(new Message1d(M1d.KNOWLEDGE, ExtensionsKt.getD((Number)kn.ordinal()), 0, 4, null), player);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lalfheim/common/core/handler/CardinalSystem$KnowledgeSystem$Knowledge;", "", "<init>", "(Ljava/lang/String;I)V", "ABYSS", "NIFLHEIM", "NIFLHEIM_POST", "MUSPELHEIM", "MUSPELHEIM_POST", "ABYSS_TRUTH", "PYLONS", "Alfheim"})
        public static final class Knowledge
        extends Enum<Knowledge> {
            public static final /* enum */ Knowledge ABYSS = new Knowledge();
            public static final /* enum */ Knowledge NIFLHEIM = new Knowledge();
            public static final /* enum */ Knowledge NIFLHEIM_POST = new Knowledge();
            public static final /* enum */ Knowledge MUSPELHEIM = new Knowledge();
            public static final /* enum */ Knowledge MUSPELHEIM_POST = new Knowledge();
            public static final /* enum */ Knowledge ABYSS_TRUTH = new Knowledge();
            public static final /* enum */ Knowledge PYLONS = new Knowledge();
            private static final /* synthetic */ Knowledge[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Knowledge[] values() {
                return (Knowledge[])$VALUES.clone();
            }

            public static Knowledge valueOf(String value) {
                return Enum.valueOf(Knowledge.class, value);
            }

            @NotNull
            public static EnumEntries<Knowledge> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = knowledgeArray = new Knowledge[]{Knowledge.ABYSS, Knowledge.NIFLHEIM, Knowledge.NIFLHEIM_POST, Knowledge.MUSPELHEIM, Knowledge.MUSPELHEIM_POST, Knowledge.ABYSS_TRUTH, Knowledge.PYLONS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ManaSystem;", "", "<init>", "()V", "handleManaChange", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getMana", "", "mr", "Lnet/minecraft/entity/EntityLivingBase;", "ManaSyncHandler", "Alfheim"})
    @SourceDebugExtension(value={"SMAP\nCardinalSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$ManaSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1174:1\n1#2:1175\n*E\n"})
    public static final class ManaSystem {
        @NotNull
        public static final ManaSystem INSTANCE = new ManaSystem();

        private ManaSystem() {
        }

        public final void handleManaChange(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PartySystem.INSTANCE.getParty(player).sendMana(player, this.getMana(player));
        }

        public final int getMana(@NotNull EntityPlayer player) {
            int invSize;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int totalMana = 0;
            InventoryPlayer mainInv = player.field_71071_by;
            IInventory baublesInv = BotaniaAPI.internalHandler.getBaublesInventory(player);
            int size = invSize = mainInv.func_70302_i_();
            if (baublesInv != null) {
                size += baublesInv.func_70302_i_();
            }
            int n = size;
            for (int i = 0; i < n; ++i) {
                boolean useBaubles = i >= invSize;
                IInventory inv = useBaubles ? baublesInv : (IInventory)mainInv;
                Intrinsics.checkNotNull((Object)inv);
                ItemStack stack = ExtensionsKt.get((IInventory)inv, (int)(i - (useBaubles ? invSize : 0)));
                if (stack == null) continue;
                Item item = stack.func_77973_b();
                if (item instanceof ICreativeManaProvider && ((ICreativeManaProvider)item).isCreative(stack)) {
                    return Integer.MAX_VALUE;
                }
                if (!(item instanceof IManaItem) || ((IManaItem)item).isNoExport(stack)) continue;
                if (Integer.MAX_VALUE - ((IManaItem)item).getMana(stack) <= totalMana) {
                    return Integer.MAX_VALUE;
                }
                totalMana += ((IManaItem)item).getMana(stack);
            }
            return totalMana;
        }

        public final int getMana(@NotNull EntityLivingBase mr) {
            int n;
            Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
            EntityPlayer entityPlayer = mr instanceof EntityPlayer ? (EntityPlayer)mr : null;
            if (entityPlayer != null) {
                EntityPlayer it = entityPlayer;
                boolean bl = false;
                n = INSTANCE.getMana(it);
            } else {
                n = 0;
            }
            return n;
        }

        static {
            MinecraftForge.EVENT_BUS.register((Object)new ManaSyncHandler());
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ManaSystem$ManaSyncHandler;", "", "<init>", "()V", "onLivingUpdate", "", "e", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "Alfheim"})
        public static final class ManaSyncHandler {
            @SubscribeEvent
            public final void onLivingUpdate(@NotNull LivingEvent.LivingUpdateEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && e.entityLiving instanceof EntityPlayer) {
                    EntityLivingBase entityLivingBase = e.entityLiving;
                    Intrinsics.checkNotNull((Object)entityLivingBase, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    EntityPlayer player = (EntityPlayer)entityLivingBase;
                    if (player.field_70170_p.func_82737_E() % (long)20 == 0L) {
                        INSTANCE.handleManaChange(player);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020 H\u0007\u00a8\u0006#"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem;", "", "<init>", "()V", "transfer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "setParty", "Lnet/minecraft/entity/player/EntityPlayer;", "party", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "getParty", "getMobParty", "living", "Lnet/minecraft/entity/EntityLivingBase;", "getUUIDParty", "id", "Ljava/util/UUID;", "sameParty", "", "p1", "p2", "e", "mobsSameParty", "e1", "e2", "friendlyFire", "entityLiving", "source", "Lnet/minecraft/util/DamageSource;", "notifySpawn", "Lnet/minecraft/entity/Entity;", "Party", "PartyThingsListener", "Alfheim"})
    @SourceDebugExtension(value={"SMAP\nCardinalSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$PartySystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1174:1\n295#2,2:1175\n295#2,2:1177\n1755#2,3:1179\n1755#2,3:1182\n*S KotlinDebug\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$PartySystem\n*L\n470#1:1175,2\n473#1:1177,2\n478#1:1179,3\n481#1:1182,3\n*E\n"})
    public static final class PartySystem {
        @NotNull
        public static final PartySystem INSTANCE = new PartySystem();

        private PartySystem() {
        }

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            NetworkService.INSTANCE.sendTo(new MessageParty(INSTANCE.forPlayer((EntityPlayer)player).getParty()), player);
        }

        public final void setParty(@NotNull EntityPlayer player, @NotNull Party party) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)party, (String)"party");
            INSTANCE.forPlayer(player).setParty(party);
            party.sendChanges();
            INSTANCE.save();
        }

        @NotNull
        public final Party getParty(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getParty();
        }

        @Nullable
        public final Party getMobParty(@Nullable EntityLivingBase living) {
            Object v1;
            block1: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PlayerSegment it = (PlayerSegment)element$iv;
                    boolean bl = false;
                    if (!it.getParty().isMember(living)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            PlayerSegment playerSegment = v1;
            return playerSegment != null ? playerSegment.getParty() : null;
        }

        @Nullable
        public final Party getUUIDParty(@Nullable UUID id) {
            Object v1;
            block1: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PlayerSegment it = (PlayerSegment)element$iv;
                    boolean bl = false;
                    if (!it.getParty().isMember(id)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            PlayerSegment playerSegment = v1;
            return playerSegment != null ? playerSegment.getParty() : null;
        }

        public final boolean sameParty(@NotNull EntityPlayer p1, @Nullable EntityLivingBase p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return this.getParty(p1).isMember(p2);
        }

        public final boolean sameParty(@Nullable UUID id, @Nullable EntityLivingBase e) {
            boolean bl;
            block3: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerSegment it = (PlayerSegment)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParty().isMember(id) && it.getParty().isMember(e))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean mobsSameParty(@Nullable EntityLivingBase e1, @Nullable EntityLivingBase e2) {
            boolean bl;
            block3: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerSegment it = (PlayerSegment)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParty().isMember(e1) && it.getParty().isMember(e2))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean friendlyFire(@NotNull EntityLivingBase entityLiving, @NotNull DamageSource source) {
            Intrinsics.checkNotNullParameter((Object)entityLiving, (String)"entityLiving");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!AlfheimConfigHandler.INSTANCE.getEnableMMO()) return false;
            String string = source.field_76373_n;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"damageType");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"_FF", (boolean)false, (int)2, null)) {
                return false;
            }
            if (ASJUtilities.isClient()) {
                return false;
            }
            if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
                Entity entity = source.func_76346_g();
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                if (this.getParty((EntityPlayer)entity).isMember(entityLiving)) {
                    return true;
                }
            }
            if (entityLiving instanceof EntityPlayer && source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                Party party = this.getParty((EntityPlayer)entityLiving);
                Entity entity = source.func_76346_g();
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.EntityLivingBase");
                if (party.isMember((EntityLivingBase)entity)) {
                    return true;
                }
            }
            if (source.func_76346_g() == null) return false;
            if (!(source.func_76346_g() instanceof EntityLivingBase)) return false;
            Entity entity = source.func_76346_g();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.EntityLivingBase");
            if (!this.mobsSameParty(entityLiving, (EntityLivingBase)entity)) return false;
            return true;
        }

        @JvmStatic
        public static final void notifySpawn(@NotNull Entity e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!(e instanceof EntityLivingBase)) {
                return;
            }
            Iterator<PlayerSegment> iterator = INSTANCE.getPlayerSegments().values().iterator();
            while (iterator.hasNext()) {
                PlayerSegment segment;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                if (!segment.getParty().isMember((EntityLivingBase)e)) continue;
                int n = segment.getParty().getCount();
                for (int i = 0; i < n; ++i) {
                    EntityLivingBase mr;
                    if (!segment.getParty().isPlayer(i) || !((mr = segment.getParty().get(i)) instanceof EntityPlayerMP)) continue;
                    NetworkService.INSTANCE.sendTo(new Message2d(M2d.PARTYID, ExtensionsKt.getD((Number)e.func_145782_y()), ExtensionsKt.getD((Number)segment.getParty().indexOf((EntityLivingBase)e)), 0, 8, null), (EntityPlayerMP)mr);
                }
            }
        }

        static {
            MinecraftForge.EVENT_BUS.register((Object)new PartyThingsListener());
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0003GHIB\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0003\u0010\fJ\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u001cJ\u0016\u0010&\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u001cJ\u0016\u0010(\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J\u0016\u0010*\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006J\u0010\u0010,\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0018J\u0010\u0010,\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010.\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u0018J\u0010\u0010.\u001a\u00020\u000b2\b\u0010/\u001a\u0004\u0018\u000100J\u0016\u00101\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u000bJ\u0016\u00101\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u000bJ\u0016\u00103\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006J\u0010\u00105\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u0018J\u0010\u00106\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u0018J\u0010\u00106\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\b\u00107\u001a\u00020\u000bH\u0002J\u0012\u00108\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u00108\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u00109\u001a\u00020$J\u0016\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u000bJ\u0016\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u001cJ\u0016\u0010>\u001a\u00020$2\u0006\u0010=\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u001cJ\u0016\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0006J\u0016\u0010A\u001a\u00020$2\u0006\u0010=\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006J\u000e\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020DJ\b\u0010E\u001a\u00020FH\u0016R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006J"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "Ljava/io/Serializable;", "", "<init>", "()V", "i", "", "(I)V", "pl", "Lnet/minecraft/entity/player/EntityPlayer;", "isMemberTypeKnown", "", "(Lnet/minecraft/entity/player/EntityPlayer;Z)V", "members", "", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member;", "[Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member;", "count", "getCount", "()I", "setCount", "getPl", "()Lnet/minecraft/entity/player/EntityPlayer;", "get", "Lnet/minecraft/entity/EntityLivingBase;", "name", "", "getHealth", "", "getMaxHealth", "getMana", "getName", "getType", "isPlayer", "isDead", "setHealth", "", "health", "setMaxHealth", "maxHealth", "setMana", "mana", "setType", "type", "indexOf", "mr", "isMember", "uuid", "Ljava/util/UUID;", "setDead", "d", "setUUID", "enID", "add", "remove", "removePL", "removeSafe", "sendChanges", "sendDead", "id", "sendHealth", "index", "sendMaxHealth", "sendMana", "player", "sendType", "write", "buf", "Lio/netty/buffer/ByteBuf;", "clone", "", "PartyStatus", "Member", "Companion", "Alfheim"})
        @SourceDebugExtension(value={"SMAP\nCardinalSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$PartySystem$Party\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1174:1\n295#2,2:1175\n295#2,2:1178\n295#2,2:1180\n1#3:1177\n*S KotlinDebug\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$PartySystem$Party\n*L\n557#1:1175,2\n602#1:1178,2\n612#1:1180,2\n*E\n"})
        public static final class Party
        implements Serializable,
        Cloneable {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private Member[] members;
            private int count;
            private static final long serialVersionUID = 84616843168484257L;
            private static transient boolean serverIO;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            @Nullable
            public final EntityPlayer getPl() {
                return (EntityPlayer)this.get(0);
            }

            public Party() {
                this.members = new Member[AlfheimConfigHandler.INSTANCE.getMaxPartyMembers()];
            }

            private Party(int i) {
                this.members = new Member[i];
            }

            public Party(@NotNull EntityPlayer pl, boolean isMemberTypeKnown) {
                Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
                this();
                int n = this.count;
                this.count = n + 1;
                String string = pl.func_70005_c_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandSenderName(...)");
                UUID uUID = pl.func_110124_au();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueID(...)");
                this.members[n] = new Member(string, uUID, ManaSystem.INSTANCE.getMana(pl), true, !pl.func_70089_S(), pl.func_110143_aJ(), pl.func_110138_aP(), (isMemberTypeKnown ? Member.MemberType.Companion.typeOf((EntityLivingBase)pl) : Member.MemberType.HUMAN).ordinal());
            }

            public /* synthetic */ Party(EntityPlayer entityPlayer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                this(entityPlayer, bl);
            }

            @Nullable
            public final EntityLivingBase get(int i) {
                Member member = this.members[i];
                boolean bl = member != null ? member.isPlayer() : false;
                if (bl) {
                    EntityLivingBase entityLivingBase;
                    if (ASJUtilities.isServer()) {
                        Member member2 = this.members[i];
                        entityLivingBase = (EntityLivingBase)MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(member2 != null ? member2.getName() : null);
                    } else {
                        Member member3 = this.members[i];
                        entityLivingBase = (EntityLivingBase)ExtensionsClientKt.getMc().field_71441_e.func_72924_a(member3 != null ? member3.getName() : null);
                    }
                    return entityLivingBase;
                }
                if (ASJUtilities.isServer()) {
                    Iterator iterator = ArrayIteratorKt.iterator((Object[])MinecraftServer.func_71276_C().field_71305_c);
                    while (iterator.hasNext()) {
                        WorldServer world = (WorldServer)iterator.next();
                        for (Object entity : world.field_72996_f) {
                            if (!(entity instanceof EntityLivingBase)) continue;
                            Member member4 = this.members[i];
                            if (!Intrinsics.areEqual((Object)((EntityLivingBase)entity).func_110124_au(), (Object)(member4 != null ? member4.getUuid() : null))) continue;
                            return (EntityLivingBase)entity;
                        }
                    }
                } else {
                    Serializable serializable = this.members[i];
                    Entity e = ExtensionsClientKt.getMc().field_71441_e.func_73045_a(serializable != null && (serializable = ((Member)serializable).getUuid()) != null ? ExtensionsKt.getI((Number)((UUID)serializable).getMostSignificantBits()) : 0);
                    return e instanceof EntityLivingBase ? (EntityLivingBase)e : null;
                }
                return null;
            }

            @Nullable
            public final EntityLivingBase get(@NotNull String name) {
                EntityLivingBase entityLivingBase;
                Object v1;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.count);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl = false;
                        Member member = this.members[it];
                        if (!Intrinsics.areEqual((Object)(member != null ? member.getName() : null), (Object)name)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                Integer n = v1;
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    entityLivingBase = this.get(it);
                } else {
                    entityLivingBase = null;
                }
                return entityLivingBase;
            }

            public final float getHealth(int i) {
                Member member = this.members[i];
                return member != null ? member.getHealth() : 0.0f;
            }

            public final float getMaxHealth(int i) {
                Member member = this.members[i];
                return member != null ? member.getMaxHealth() : 0.0f;
            }

            public final int getMana(int i) {
                Member member = this.members[i];
                return member != null ? member.getMana() : 0;
            }

            @NotNull
            public final String getName(int i) {
                Object object = this.members[i];
                if (object == null || (object = ((Member)object).getName()) == null) {
                    object = "";
                }
                return object;
            }

            public final int getType(int i) {
                Member member = this.members[i];
                return member != null ? member.getType() : 0;
            }

            public final boolean isPlayer(int i) {
                Member member = this.members[i];
                return member != null ? member.isPlayer() : false;
            }

            public final boolean isDead(int i) {
                Member member = this.members[i];
                return member != null ? member.isDead() : false;
            }

            public final void setHealth(int i, float health) {
                Member member = this.members[i];
                if (member == null) {
                    return;
                }
                Member mr = member;
                float was = mr.getHealth();
                if (!(was == health)) {
                    mr.setHealth(health);
                    if (ASJUtilities.isServer()) {
                        this.sendHealth(i, health);
                    }
                }
            }

            public final void setMaxHealth(int i, float maxHealth) {
                Member member = this.members[i];
                if (member == null) {
                    return;
                }
                Member mr = member;
                float was = mr.getMaxHealth();
                if (!(was == maxHealth)) {
                    mr.setMaxHealth(maxHealth);
                    if (ASJUtilities.isServer()) {
                        this.sendMaxHealth(i, maxHealth);
                    }
                }
            }

            public final void setMana(int i, int mana) {
                block0: {
                    Member member = this.members[i];
                    if (member == null) break block0;
                    member.setMana(mana);
                }
            }

            public final void setType(int i, int type2) {
                Member member = this.members[i];
                if (member != null) {
                    member.setType(type2);
                }
                if (ASJUtilities.isServer()) {
                    this.sendType(i, type2);
                }
            }

            public final int indexOf(@Nullable EntityLivingBase mr) {
                Object v2;
                block4: {
                    if (mr == null) {
                        return -1;
                    }
                    Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.count);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (ASJUtilities.isServer()) {
                            Member member = this.members[it];
                            bl = Intrinsics.areEqual((Object)mr.func_110124_au(), (Object)(member != null ? member.getUuid() : null));
                        } else {
                            UUID uUID;
                            Member member = this.members[it];
                            bl = member != null && (uUID = member.getUuid()) != null ? (long)mr.func_145782_y() == uUID.getMostSignificantBits() : false;
                        }
                        if (!bl) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                Integer n = v2;
                return n != null ? n : -1;
            }

            public final int indexOf(@Nullable String name) {
                Object v1;
                block2: {
                    CharSequence charSequence = name;
                    if (charSequence == null || charSequence.length() == 0) {
                        return -1;
                    }
                    Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.count);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl = false;
                        Member member = this.members[it];
                        if (!Intrinsics.areEqual((Object)name, (Object)(member != null ? member.getName() : null))) continue;
                        v1 = element$iv;
                        break block2;
                    }
                    v1 = null;
                }
                Integer n = v1;
                return n != null ? n : -1;
            }

            public final boolean isMember(@Nullable EntityLivingBase mr) {
                if (mr != null) {
                    int n = this.count;
                    for (int i = 0; i < n; ++i) {
                        UUID uUID;
                        if (ASJUtilities.isServer()) {
                            Member member = this.members[i];
                            if (!Intrinsics.areEqual((Object)mr.func_110124_au(), (Object)(member != null ? member.getUuid() : null))) continue;
                            return true;
                        }
                        Member member = this.members[i];
                        boolean bl = member != null && (uUID = member.getUuid()) != null ? (long)mr.func_145782_y() == uUID.getMostSignificantBits() : false;
                        if (!bl) continue;
                        return true;
                    }
                }
                return false;
            }

            public final boolean isMember(@Nullable UUID uuid) {
                if (uuid != null) {
                    int n = this.count;
                    for (int i = 0; i < n; ++i) {
                        UUID uUID;
                        if (ASJUtilities.isServer()) {
                            Member member = this.members[i];
                            if (!Intrinsics.areEqual((Object)uuid, (Object)(member != null ? member.getUuid() : null))) continue;
                            return true;
                        }
                        Member member = this.members[i];
                        boolean bl = member != null && (uUID = member.getUuid()) != null ? uuid.getMostSignificantBits() == uUID.getMostSignificantBits() : false;
                        if (!bl) continue;
                        return true;
                    }
                }
                return false;
            }

            public final void setDead(int i, boolean d) {
                block1: {
                    if (!ASJUtilities.isClient()) break block1;
                    Member member = this.members[i];
                    if (member != null) {
                        member.setDead(d);
                    }
                }
            }

            public final void setDead(@NotNull EntityLivingBase mr, boolean d) {
                Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
                int i = this.indexOf(mr);
                if (i == -1) {
                    return;
                }
                if (mr instanceof EntityPlayer) {
                    Member member = this.members[i];
                    if (member != null) {
                        member.setDead(d);
                    }
                    this.sendDead(i, d);
                } else if (d) {
                    this.remove(mr);
                    int n = this.count;
                    for (int j = 0; j < n; ++j) {
                        EntityLivingBase e;
                        Member member = this.members[j];
                        boolean bl = member != null ? member.isPlayer() : false;
                        if (!bl || !((e = this.get(j)) instanceof EntityPlayer)) continue;
                        Object[] objectArray = new Object[]{mr.func_70005_c_()};
                        ASJUtilities.say((ICommandSender)((ICommandSender)e), (String)"alfheimmisc.party.memberdied", (Object[])objectArray);
                    }
                }
            }

            public final void setUUID(int i, int enID) {
                block1: {
                    if (this.members[i] == null) break block1;
                    Member member = this.members[i];
                    if (member != null) {
                        member.setUuid(new UUID(enID, enID));
                    }
                }
            }

            public final boolean add(@Nullable EntityLivingBase mr) {
                if (mr == null) {
                    return false;
                }
                if (this.indexOf(mr) != -1) {
                    return false;
                }
                if (this.count >= this.members.length) {
                    return false;
                }
                int n = this.count;
                this.count = n + 1;
                String string = mr.func_70005_c_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandSenderName(...)");
                UUID uUID = mr.func_110124_au();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueID(...)");
                this.members[n] = new Member(string, uUID, ManaSystem.INSTANCE.getMana(mr), mr instanceof EntityPlayer, !mr.func_70089_S(), mr.func_110143_aJ(), mr.func_110138_aP(), Member.MemberType.Companion.typeOf(mr).ordinal());
                this.sendChanges();
                CardinalSystem.INSTANCE.save();
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final boolean remove(@Nullable EntityLivingBase mr) {
                boolean bl;
                if (mr == null) {
                    return false;
                }
                if (mr instanceof EntityPlayer) {
                    Member member = this.members[0];
                    if (Intrinsics.areEqual((Object)(member != null ? member.getName() : null), (Object)((EntityPlayer)mr).func_70005_c_())) {
                        bl = this.removePL();
                        return bl;
                    }
                }
                bl = this.removeSafe(mr);
                return bl;
            }

            public final boolean remove(@Nullable String name) {
                CharSequence charSequence = name;
                if (charSequence == null || charSequence.length() == 0) {
                    return false;
                }
                Member member = this.members[0];
                return Intrinsics.areEqual((Object)(member != null ? member.getName() : null), (Object)name) ? this.removePL() : this.removeSafe(name);
            }

            private final boolean removePL() {
                if (this.getPl() == null) {
                    return false;
                }
                EntityPlayer entityPlayer = this.getPl();
                Intrinsics.checkNotNull((Object)entityPlayer);
                EntityPlayer entityPlayer2 = this.getPl();
                Intrinsics.checkNotNull((Object)entityPlayer2);
                INSTANCE.setParty(entityPlayer, new Party(entityPlayer2, false, 2, null));
                for (int i = 1; i < this.count; ++i) {
                    Member member = this.members[i];
                    boolean bl = member != null ? member.isPlayer() : false;
                    if (!bl) continue;
                    this.members[0] = this.members[i];
                    this.count += -1;
                    while (i < this.count) {
                        this.members[i] = this.members[i + 1];
                        ++i;
                    }
                    this.sendChanges();
                }
                CardinalSystem.INSTANCE.save();
                return true;
            }

            private final boolean removeSafe(String name) {
                int id;
                CharSequence charSequence = name;
                if (charSequence == null || charSequence.length() == 0) {
                    return false;
                }
                EntityLivingBase mr = this.get(name);
                if (mr == null && id != -1 && !this.isPlayer(id)) {
                    this.count += -1;
                    for (id = this.indexOf(name); id < this.count; ++id) {
                        this.members[id] = this.members[id + 1];
                    }
                    this.members[this.count] = null;
                    this.sendChanges();
                    CardinalSystem.INSTANCE.save();
                    return true;
                }
                return this.removeSafe(mr);
            }

            private final boolean removeSafe(EntityLivingBase mr) {
                if (mr == null) {
                    return false;
                }
                int id = this.indexOf(mr);
                if (id == -1) {
                    return false;
                }
                this.count += -1;
                if (mr instanceof EntityPlayer) {
                    INSTANCE.setParty((EntityPlayer)mr, new Party((EntityPlayer)mr, false, 2, null));
                }
                while (id < this.count) {
                    this.members[id] = this.members[id + 1];
                    ++id;
                }
                this.members[this.count] = null;
                this.sendChanges();
                CardinalSystem.INSTANCE.save();
                return true;
            }

            public final void sendChanges() {
                if (ASJUtilities.isServer()) {
                    int n = this.count;
                    for (int i = 0; i < n; ++i) {
                        EntityLivingBase e = this.get(i);
                        if (e == null) continue;
                        Member member = this.members[i];
                        boolean bl = member != null ? member.isPlayer() : false;
                        if (!bl || !(e instanceof EntityPlayerMP)) continue;
                        INSTANCE.transfer((EntityPlayerMP)e);
                    }
                }
            }

            public final void sendDead(int id, boolean d) {
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    EntityLivingBase e = this.get(i);
                    if (e == null) continue;
                    Member member = this.members[i];
                    boolean bl = member != null ? member.isPlayer() : false;
                    if (!bl || !(e instanceof EntityPlayerMP)) continue;
                    NetworkService.INSTANCE.sendTo(new Message3d(M3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.DEAD.ordinal()), ExtensionsKt.getD((Number)id), ExtensionsKt.getD((Number)(d ? -10 : -100)), 0, 16, null), (EntityPlayerMP)e);
                }
            }

            public final void sendHealth(int index, float health) {
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    EntityLivingBase e = this.get(i);
                    if (e == null) continue;
                    Member member = this.members[i];
                    boolean bl = member != null ? member.isPlayer() : false;
                    if (!bl || !(e instanceof EntityPlayerMP)) continue;
                    NetworkService.INSTANCE.sendTo(new Message3d(M3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.HEALTH.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)Float.valueOf(health)), 0, 16, null), (EntityPlayerMP)e);
                }
            }

            public final void sendMaxHealth(int index, float maxHealth) {
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    EntityLivingBase e = this.get(i);
                    if (e == null) continue;
                    Member member = this.members[i];
                    boolean bl = member != null ? member.isPlayer() : false;
                    if (!bl || !(e instanceof EntityPlayerMP)) continue;
                    NetworkService.INSTANCE.sendTo(new Message3d(M3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.MAXHEALTH.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)Float.valueOf(maxHealth)), 0, 16, null), (EntityPlayerMP)e);
                }
            }

            public final void sendMana(@NotNull EntityPlayer player, int mana) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                int index = this.indexOf((EntityLivingBase)player);
                if (index == -1) {
                    return;
                }
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    EntityLivingBase e = this.get(i);
                    if (e == null) continue;
                    Member member = this.members[i];
                    boolean bl = member != null ? member.isPlayer() : false;
                    if (!bl || !(e instanceof EntityPlayerMP)) continue;
                    NetworkService.INSTANCE.sendTo(new Message3d(M3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.MANA.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)mana), 0, 16, null), (EntityPlayerMP)e);
                }
            }

            public final void sendType(int index, int type2) {
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    EntityLivingBase e = this.get(i);
                    if (e == null) continue;
                    Member member = this.members[i];
                    boolean bl = member != null ? member.isPlayer() : false;
                    if (!bl || !(e instanceof EntityPlayerMP)) continue;
                    NetworkService.INSTANCE.sendTo(new Message3d(M3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.TYPE.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)type2), 0, 16, null), (EntityPlayerMP)e);
                }
            }

            public final void write(@NotNull ByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                buf.writeInt(this.members.length);
                buf.writeInt(this.count);
                EntityLivingBase mr = null;
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    ByteBuf byteBuf;
                    mr = this.get(i);
                    if (serverIO) {
                        Object object2 = mr;
                        buf.writeLong(object2 != null && (object2 = object2.func_110124_au()) != null ? ((UUID)object2).getMostSignificantBits() : 0L);
                        Object object3 = mr;
                        byteBuf = buf.writeLong(object3 != null && (object3 = object3.func_110124_au()) != null ? ((UUID)object3).getLeastSignificantBits() : 0L);
                    } else {
                        EntityLivingBase entityLivingBase = mr;
                        byteBuf = buf.writeInt(entityLivingBase != null ? entityLivingBase.func_145782_y() : 0);
                    }
                    if ((object = this.members[i]) == null || (object = ((Member)object).getName()) == null) {
                        object = "";
                    }
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)object);
                    Member member = this.members[i];
                    buf.writeInt(member != null ? member.getMana() : 0);
                    Member member2 = this.members[i];
                    buf.writeBoolean(member2 != null ? member2.isPlayer() : false);
                    Member member3 = this.members[i];
                    buf.writeBoolean(member3 != null ? member3.isDead() : false);
                    Member member4 = this.members[i];
                    buf.writeFloat(member4 != null ? member4.getHealth() : 0.0f);
                    Member member5 = this.members[i];
                    buf.writeFloat(member5 != null ? member5.getMaxHealth() : 0.0f);
                    Member member6 = this.members[i];
                    buf.writeInt(member6 != null ? member6.getType() : Member.MemberType.MOB.ordinal());
                }
            }

            @NotNull
            public Object clone() {
                Party result = new Party();
                result.members = (Member[])this.members.clone();
                result.count = this.count;
                return result;
            }

            public /* synthetic */ Party(int i, DefaultConstructorMarker $constructor_marker) {
                this(i);
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Companion;", "", "<init>", "()V", "serialVersionUID", "", "serverIO", "", "getServerIO", "()Z", "setServerIO", "(Z)V", "read", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "buf", "Lio/netty/buffer/ByteBuf;", "Alfheim"})
            public static final class Companion {
                private Companion() {
                }

                public final boolean getServerIO() {
                    return serverIO;
                }

                public final void setServerIO(boolean bl) {
                    serverIO = bl;
                }

                @NotNull
                public final Party read(@NotNull ByteBuf buf) {
                    Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                    int size = buf.readInt();
                    int count = buf.readInt();
                    Party pt = new Party(size, null);
                    pt.setCount(count);
                    long most = 0L;
                    long least = 0L;
                    for (int i = 0; i < count; ++i) {
                        if (this.getServerIO()) {
                            most = buf.readLong();
                            least = buf.readLong();
                        } else {
                            most = least = (long)buf.readInt();
                        }
                        Member[] memberArray = pt.members;
                        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF8String(...)");
                        memberArray[i] = new Member(string, new UUID(most, least), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readFloat(), buf.readFloat(), buf.readInt());
                    }
                    return pt;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u001d\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002()BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010'\u001a\u00020\u0000H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u001cR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\"R\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0019\"\u0004\b&\u0010\u001b\u00a8\u0006*"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member;", "Ljava/io/Serializable;", "", "name", "", "uuid", "Ljava/util/UUID;", "mana", "", "isPlayer", "", "isDead", "health", "", "maxHealth", "type", "<init>", "(Ljava/lang/String;Ljava/util/UUID;IZZFFI)V", "getName", "()Ljava/lang/String;", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "getMana", "()I", "setMana", "(I)V", "()Z", "setDead", "(Z)V", "getHealth", "()F", "setHealth", "(F)V", "getMaxHealth", "setMaxHealth", "getType", "setType", "clone", "MemberType", "Companion", "Alfheim"})
            private static final class Member
            implements Serializable,
            Cloneable {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String name;
                @NotNull
                private UUID uuid;
                private int mana;
                private final boolean isPlayer;
                private boolean isDead;
                private float health;
                private float maxHealth;
                private int type;
                private static final long serialVersionUID = 8416468367146381L;

                public Member(@NotNull String name, @NotNull UUID uuid, int mana, boolean isPlayer, boolean isDead, float health, float maxHealth, int type2) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                    this.name = name;
                    this.uuid = uuid;
                    this.mana = mana;
                    this.isPlayer = isPlayer;
                    this.isDead = isDead;
                    this.health = health;
                    this.maxHealth = maxHealth;
                    this.type = type2;
                }

                @NotNull
                public final String getName() {
                    return this.name;
                }

                @NotNull
                public final UUID getUuid() {
                    return this.uuid;
                }

                public final void setUuid(@NotNull UUID uUID) {
                    Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
                    this.uuid = uUID;
                }

                public final int getMana() {
                    return this.mana;
                }

                public final void setMana(int n) {
                    this.mana = n;
                }

                public final boolean isPlayer() {
                    return this.isPlayer;
                }

                public final boolean isDead() {
                    return this.isDead;
                }

                public final void setDead(boolean bl) {
                    this.isDead = bl;
                }

                public final float getHealth() {
                    return this.health;
                }

                public final void setHealth(float f) {
                    this.health = f;
                }

                public final float getMaxHealth() {
                    return this.maxHealth;
                }

                public final void setMaxHealth(float f) {
                    this.maxHealth = f;
                }

                public final int getType() {
                    return this.type;
                }

                public final void setType(int n) {
                    this.type = n;
                }

                @NotNull
                public Member clone() {
                    return new Member(this.name, this.uuid, this.mana, this.isPlayer, this.isDead, this.health, this.maxHealth, this.type);
                }

                @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$Companion;", "", "<init>", "()V", "serialVersionUID", "", "Alfheim"})
                public static final class Companion {
                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }

                @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$MemberType;", "", "<init>", "(Ljava/lang/String;I)V", "HUMAN", "SALAMANDER", "SYLPH", "CAITSITH", "POOKA", "GNOME", "LEPRECHAUN", "SPRIGGAN", "UNDINE", "IMP", "ALV", "MOB", "NPC", "BOSS", "Companion", "Alfheim"})
                public static final class MemberType
                extends Enum<MemberType> {
                    @NotNull
                    public static final Companion Companion;
                    public static final /* enum */ MemberType HUMAN;
                    public static final /* enum */ MemberType SALAMANDER;
                    public static final /* enum */ MemberType SYLPH;
                    public static final /* enum */ MemberType CAITSITH;
                    public static final /* enum */ MemberType POOKA;
                    public static final /* enum */ MemberType GNOME;
                    public static final /* enum */ MemberType LEPRECHAUN;
                    public static final /* enum */ MemberType SPRIGGAN;
                    public static final /* enum */ MemberType UNDINE;
                    public static final /* enum */ MemberType IMP;
                    public static final /* enum */ MemberType ALV;
                    public static final /* enum */ MemberType MOB;
                    public static final /* enum */ MemberType NPC;
                    public static final /* enum */ MemberType BOSS;
                    private static final /* synthetic */ MemberType[] $VALUES;
                    private static final /* synthetic */ EnumEntries $ENTRIES;

                    public static MemberType[] values() {
                        return (MemberType[])$VALUES.clone();
                    }

                    public static MemberType valueOf(String value) {
                        return Enum.valueOf(MemberType.class, value);
                    }

                    @NotNull
                    public static EnumEntries<MemberType> getEntries() {
                        return $ENTRIES;
                    }

                    static {
                        HUMAN = new MemberType();
                        SALAMANDER = new MemberType();
                        SYLPH = new MemberType();
                        CAITSITH = new MemberType();
                        POOKA = new MemberType();
                        GNOME = new MemberType();
                        LEPRECHAUN = new MemberType();
                        SPRIGGAN = new MemberType();
                        UNDINE = new MemberType();
                        IMP = new MemberType();
                        ALV = new MemberType();
                        MOB = new MemberType();
                        NPC = new MemberType();
                        BOSS = new MemberType();
                        $VALUES = memberTypeArray = new MemberType[]{MemberType.HUMAN, MemberType.SALAMANDER, MemberType.SYLPH, MemberType.CAITSITH, MemberType.POOKA, MemberType.GNOME, MemberType.LEPRECHAUN, MemberType.SPRIGGAN, MemberType.UNDINE, MemberType.IMP, MemberType.ALV, MemberType.MOB, MemberType.NPC, MemberType.BOSS};
                        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                        Companion = new Companion(null);
                    }

                    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$MemberType$Companion;", "", "<init>", "()V", "typeOf", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$MemberType;", "e", "Lnet/minecraft/entity/EntityLivingBase;", "Alfheim"})
                    public static final class Companion {
                        private Companion() {
                        }

                        @NotNull
                        public final MemberType typeOf(@NotNull EntityLivingBase e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            EntityLivingBase entityLivingBase = e;
                            return entityLivingBase instanceof EntityPlayer ? (MemberType)((Object)MemberType.getEntries().get(EnumRaceKt.getRaceID((EntityPlayer)e))) : (entityLivingBase instanceof IBossDisplayData ? BOSS : (entityLivingBase instanceof INpc ? NPC : MOB));
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$PartyStatus;", "", "<init>", "(Ljava/lang/String;I)V", "DEAD", "HEALTH", "MAXHEALTH", "MANA", "TYPE", "Alfheim"})
            public static final class PartyStatus
            extends Enum<PartyStatus> {
                public static final /* enum */ PartyStatus DEAD = new PartyStatus();
                public static final /* enum */ PartyStatus HEALTH = new PartyStatus();
                public static final /* enum */ PartyStatus MAXHEALTH = new PartyStatus();
                public static final /* enum */ PartyStatus MANA = new PartyStatus();
                public static final /* enum */ PartyStatus TYPE = new PartyStatus();
                private static final /* synthetic */ PartyStatus[] $VALUES;
                private static final /* synthetic */ EnumEntries $ENTRIES;

                public static PartyStatus[] values() {
                    return (PartyStatus[])$VALUES.clone();
                }

                public static PartyStatus valueOf(String value) {
                    return Enum.valueOf(PartyStatus.class, value);
                }

                @NotNull
                public static EnumEntries<PartyStatus> getEntries() {
                    return $ENTRIES;
                }

                static {
                    $VALUES = partyStatusArray = new PartyStatus[]{PartyStatus.DEAD, PartyStatus.HEALTH, PartyStatus.MAXHEALTH, PartyStatus.MANA, PartyStatus.TYPE};
                    $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$PartyThingsListener;", "", "<init>", "()V", "onClonePlayer", "", "e", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onPlayerRespawn", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "Alfheim"})
        public static final class PartyThingsListener {
            @SubscribeEvent
            public final void onClonePlayer(@NotNull PlayerEvent.Clone e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && e.wasDeath) {
                    EntityPlayer entityPlayer = e.entityPlayer;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"entityPlayer");
                    Party party = INSTANCE.getParty(entityPlayer);
                    EntityPlayer entityPlayer2 = e.entityPlayer;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"entityPlayer");
                    party.setDead((EntityLivingBase)entityPlayer2, false);
                }
            }

            @SubscribeEvent
            public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                    EntityPlayer entityPlayer = e.player;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"player");
                    Party party = INSTANCE.getParty(entityPlayer);
                    EntityPlayer entityPlayer2 = e.player;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"player");
                    party.setDead((EntityLivingBase)entityPlayer2, false);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 s2\u00020\u0001:\u0001sB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010F\u001a\u00020GR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\n\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0019\"\u0004\b1\u0010\u001bR\u001a\u00102\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0019\"\u0004\b4\u0010\u001bR \u00105\u001a\b\u0012\u0004\u0012\u00020\u001e06X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0019\"\u0004\bB\u0010\u001bR\u001a\u0010C\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0014\"\u0004\bE\u0010\u0015R\u001a\u0010H\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0019\"\u0004\bJ\u0010\u001bR\u001a\u0010K\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u0014\"\u0004\bM\u0010\u0015R\u001a\u0010N\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\u0014\"\u0004\bP\u0010\u0015R\"\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00170RX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010W\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u001a\u0010X\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0019\"\u0004\bZ\u0010\u001bR\u001a\u0010[\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0019\"\u0004\b]\u0010\u001bR\u001a\u0010^\u001a\u00020_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001a\u0010d\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\u0019\"\u0004\bf\u0010\u001bR\u001a\u0010g\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010\u0019\"\u0004\bi\u0010\u001bR\u001a\u0010j\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010\u0019\"\u0004\bl\u0010\u001bR\u001a\u0010m\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010\u0019\"\u0004\bo\u0010\u001bR\u001a\u0010p\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010\u0019\"\u0004\br\u0010\u001b\u00a8\u0006t"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PlayerSegment;", "Ljava/io/Serializable;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "<init>", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "party", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "getParty", "()Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "setParty", "(Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;)V", "target", "Lnet/minecraft/entity/EntityLivingBase;", "getTarget", "()Lnet/minecraft/entity/EntityLivingBase;", "setTarget", "(Lnet/minecraft/entity/EntityLivingBase;)V", "isParty", "", "()Z", "(Z)V", "partyIndex", "", "getPartyIndex", "()I", "setPartyIndex", "(I)V", "coolDown", "Ljava/util/HashMap;", "", "getCoolDown", "()Ljava/util/HashMap;", "setCoolDown", "(Ljava/util/HashMap;)V", "hotSpells", "", "getHotSpells", "()[I", "setHotSpells", "([I)V", "castableSpell", "Lalfheim/api/spell/SpellBase;", "getCastableSpell", "()Lalfheim/api/spell/SpellBase;", "setCastableSpell", "(Lalfheim/api/spell/SpellBase;)V", "ids", "getIds", "setIds", "init", "getInit", "setInit", "knowledge", "", "getKnowledge", "()Ljava/util/Set;", "setKnowledge", "(Ljava/util/Set;)V", "userName", "getUserName", "()Ljava/lang/String;", "setUserName", "(Ljava/lang/String;)V", "raceID", "getRaceID", "setRaceID", "esmAbility", "getEsmAbility", "setEsmAbility", "toggleESMAbility", "", "flightEnableCooldown", "getFlightEnableCooldown", "setFlightEnableCooldown", "gender", "getGender", "setGender", "customSkin", "getCustomSkin", "setCustomSkin", "reputation", "", "getReputation", "()[Ljava/lang/Integer;", "setReputation", "([Ljava/lang/Integer;)V", "[Ljava/lang/Integer;", "quadStage", "getQuadStage", "setQuadStage", "standingStill", "getStandingStill", "setStandingStill", "lastPos", "Lalexsocol/asjlib/math/Vector3;", "getLastPos", "()Lalexsocol/asjlib/math/Vector3;", "setLastPos", "(Lalexsocol/asjlib/math/Vector3;)V", "abyss", "getAbyss", "setAbyss", "limbo", "getLimbo", "setLimbo", "heartLoss", "getHeartLoss", "setHeartLoss", "cold", "getCold", "setCold", "wisdom", "getWisdom", "setWisdom", "Companion", "Alfheim"})
    public static final class PlayerSegment
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private PartySystem.Party party;
        @Nullable
        private transient EntityLivingBase target;
        private transient boolean isParty;
        private transient int partyIndex;
        @NotNull
        private HashMap<String, Integer> coolDown;
        @NotNull
        private int[] hotSpells;
        @Nullable
        private transient SpellBase castableSpell;
        private transient int ids;
        private transient int init;
        @NotNull
        private Set<String> knowledge;
        @NotNull
        private String userName;
        private int raceID;
        private boolean esmAbility;
        private int flightEnableCooldown;
        private boolean gender;
        private boolean customSkin;
        @NotNull
        private Integer[] reputation;
        private transient int quadStage;
        private transient int standingStill;
        @NotNull
        private transient Vector3 lastPos;
        private int abyss;
        private int limbo;
        private int heartLoss;
        private int cold;
        private int wisdom;
        private static final long serialVersionUID = 4267437884578826733L;

        public PlayerSegment(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.party = new PartySystem.Party(player, false);
            this.partyIndex = -1;
            this.coolDown = new HashMap();
            this.hotSpells = new int[12];
            this.knowledge = new HashSet();
            String string = player.func_70005_c_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandSenderName(...)");
            this.userName = string;
            this.esmAbility = true;
            int n = 0;
            int n2 = EnumRace.getEntries().size();
            Integer[] integerArray = new Integer[n2];
            PlayerSegment playerSegment = this;
            while (n < n2) {
                int n3 = n++;
                integerArray[n3] = 150;
            }
            playerSegment.reputation = integerArray;
            this.lastPos = Vector3.Companion.fromEntity((Entity)player);
        }

        @NotNull
        public final PartySystem.Party getParty() {
            return this.party;
        }

        public final void setParty(@NotNull PartySystem.Party party) {
            Intrinsics.checkNotNullParameter((Object)party, (String)"<set-?>");
            this.party = party;
        }

        @Nullable
        public final EntityLivingBase getTarget() {
            return this.target;
        }

        public final void setTarget(@Nullable EntityLivingBase entityLivingBase) {
            this.target = entityLivingBase;
        }

        public final boolean isParty() {
            return this.isParty;
        }

        public final void setParty(boolean bl) {
            this.isParty = bl;
        }

        public final int getPartyIndex() {
            return this.partyIndex;
        }

        public final void setPartyIndex(int n) {
            this.partyIndex = n;
        }

        @NotNull
        public final HashMap<String, Integer> getCoolDown() {
            return this.coolDown;
        }

        public final void setCoolDown(@NotNull HashMap<String, Integer> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            this.coolDown = hashMap;
        }

        @NotNull
        public final int[] getHotSpells() {
            return this.hotSpells;
        }

        public final void setHotSpells(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.hotSpells = nArray;
        }

        @Nullable
        public final SpellBase getCastableSpell() {
            return this.castableSpell;
        }

        public final void setCastableSpell(@Nullable SpellBase spellBase) {
            this.castableSpell = spellBase;
        }

        public final int getIds() {
            return this.ids;
        }

        public final void setIds(int n) {
            this.ids = n;
        }

        public final int getInit() {
            return this.init;
        }

        public final void setInit(int n) {
            this.init = n;
        }

        @NotNull
        public final Set<String> getKnowledge() {
            return this.knowledge;
        }

        public final void setKnowledge(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.knowledge = set;
        }

        @NotNull
        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.userName = string;
        }

        public final int getRaceID() {
            return this.raceID;
        }

        public final void setRaceID(int n) {
            this.raceID = n;
        }

        public final boolean getEsmAbility() {
            return this.esmAbility;
        }

        public final void setEsmAbility(boolean bl) {
            this.esmAbility = bl;
        }

        public final void toggleESMAbility() {
            this.esmAbility = !this.esmAbility;
        }

        public final int getFlightEnableCooldown() {
            return this.flightEnableCooldown;
        }

        public final void setFlightEnableCooldown(int n) {
            this.flightEnableCooldown = n;
        }

        public final boolean getGender() {
            return this.gender;
        }

        public final void setGender(boolean bl) {
            this.gender = bl;
        }

        public final boolean getCustomSkin() {
            return this.customSkin;
        }

        public final void setCustomSkin(boolean bl) {
            this.customSkin = bl;
        }

        @NotNull
        public final Integer[] getReputation() {
            return this.reputation;
        }

        public final void setReputation(@NotNull Integer[] integerArray) {
            Intrinsics.checkNotNullParameter((Object)integerArray, (String)"<set-?>");
            this.reputation = integerArray;
        }

        public final int getQuadStage() {
            return this.quadStage;
        }

        public final void setQuadStage(int n) {
            this.quadStage = n;
        }

        public final int getStandingStill() {
            return this.standingStill;
        }

        public final void setStandingStill(int n) {
            this.standingStill = n;
        }

        @NotNull
        public final Vector3 getLastPos() {
            return this.lastPos;
        }

        public final void setLastPos(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
            this.lastPos = vector3;
        }

        public final int getAbyss() {
            return this.abyss;
        }

        public final void setAbyss(int n) {
            this.abyss = n;
        }

        public final int getLimbo() {
            return this.limbo;
        }

        public final void setLimbo(int n) {
            this.limbo = n;
        }

        public final int getHeartLoss() {
            return this.heartLoss;
        }

        public final void setHeartLoss(int n) {
            this.heartLoss = n;
        }

        public final int getCold() {
            return this.cold;
        }

        public final void setCold(int n) {
            this.cold = n;
        }

        public final int getWisdom() {
            return this.wisdom;
        }

        public final void setWisdom(int n) {
            this.wisdom = n;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PlayerSegment$Companion;", "", "<init>", "()V", "serialVersionUID", "", "Alfheim"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\u0005J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lalfheim/common/core/handler/CardinalSystem$SpellCastingSystem;", "", "<init>", "()V", "transfer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "setCoolDown", "", "caster", "Lnet/minecraft/entity/player/EntityPlayer;", "spell", "Lalfheim/api/spell/SpellBase;", "cd", "getCoolDown", "tick", "performCast", "raceID", "spellID", "SpellCastingHandler", "Alfheim"})
    @SourceDebugExtension(value={"SMAP\nCardinalSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$SpellCastingSystem\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1174:1\n216#2,2:1175\n*S KotlinDebug\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$SpellCastingSystem\n*L\n273#1:1175,2\n*E\n"})
    public static final class SpellCastingSystem {
        @NotNull
        public static final SpellCastingSystem INSTANCE = new SpellCastingSystem();

        private SpellCastingSystem() {
        }

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            for (EnumRace affinity : EnumRace.getEntries()) {
                for (SpellBase spell : AlfheimAPI.INSTANCE.getSpellsFor(affinity)) {
                    NetworkService.INSTANCE.sendTo(new Message2d(M2d.COOLDOWN, ExtensionsKt.getD((Number)((affinity.ordinal() & 0xF) << 28 | AlfheimAPI.INSTANCE.getSpellID(spell) & 0xFFFFFFF)), ExtensionsKt.getD((Number)this.getCoolDown((EntityPlayer)player, spell)), 0, 8, null), player);
                }
            }
        }

        public final int setCoolDown(@NotNull EntityPlayer caster, @NotNull SpellBase spell, int cd) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            Integer n = cd;
            ((Map)INSTANCE.forPlayer(caster).getCoolDown()).put(spell.getName(), n);
            if (cd > 6000) {
                INSTANCE.save();
            }
            return cd;
        }

        public final int getCoolDown(@NotNull EntityPlayer caster, @NotNull SpellBase spell) {
            int n;
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            try {
                Integer n2 = INSTANCE.forPlayer(caster).getCoolDown().get(spell.getName());
                n = n2 != null ? n2 : 0;
            }
            catch (Throwable e) {
                ASJUtilities.error((String)("Something went wrong getting cooldown for " + spell + ". Returning 0."), (Throwable)e);
                n = 0;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void tick() {
            try {
                Map $this$forEach$iv = INSTANCE.getPlayerSegments();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    String name = (String)entry.getKey();
                    PlayerSegment segment = (PlayerSegment)entry.getValue();
                    Iterator<String> iterator2 = segment.getCoolDown().keySet().iterator();
                    while (iterator2.hasNext()) {
                        int time;
                        String spell;
                        Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                        Integer n = segment.getCoolDown().get(spell);
                        int n2 = time = n != null ? n : 0;
                        if (time > 5) {
                            EntityPlayerMP entityPlayerMP = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(name);
                            boolean bl2 = entityPlayerMP != null && (entityPlayerMP = entityPlayerMP.field_71075_bZ) != null ? entityPlayerMP.field_75098_d : false;
                            if (bl2) {
                                time = 5;
                            }
                        }
                        if (time <= 0) continue;
                        ((Map)segment.getCoolDown()).put(spell, time - 1);
                    }
                    EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(segment.getUserName());
                    if (player != null) {
                        if (segment.getInit() > 0) {
                            segment.setInit(segment.getInit() + -1);
                            segment.getInit();
                            continue;
                        }
                        if (segment.getIds() == 0 || segment.getCastableSpell() == null) continue;
                        try {
                            NetworkService.INSTANCE.sendTo(new Message2d(M2d.COOLDOWN, ExtensionsKt.getD((Number)segment.getIds()), ExtensionsKt.getD((Number)INSTANCE.performCast(player, segment.getIds() >> 28 & 0xF, segment.getIds() & 0xFFFFFFF)), 0, 8, null), player);
                            continue;
                        }
                        finally {
                            segment.setIds(0);
                            segment.setInit(0);
                            segment.setCastableSpell(null);
                            continue;
                        }
                    }
                    segment.setIds(0);
                    segment.setInit(0);
                    segment.setCastableSpell(null);
                }
            }
            catch (Throwable e) {
                ASJUtilities.error((String)"Something went wrong ticking spells. Skipping this tick.", (Throwable)e);
            }
        }

        public final int performCast(@NotNull EntityPlayerMP caster, int raceID, int spellID) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            if (!AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                return -SpellBase.SpellCastResult.NOTALLOW.ordinal();
            }
            if (caster.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDLeftFlame())) {
                return -SpellBase.SpellCastResult.NOTALLOW.ordinal();
            }
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellByIDs(raceID, spellID);
            if (spellBase == null) {
                return -SpellBase.SpellCastResult.DESYNC.ordinal();
            }
            SpellBase spell = spellBase;
            if (this.getCoolDown((EntityPlayer)caster, spell) > 0) {
                return -SpellBase.SpellCastResult.NOTREADY.ordinal();
            }
            SpellBase.SpellCastResult result = spell.performCast((EntityLivingBase)caster);
            if (result == SpellBase.SpellCastResult.OK) {
                SpellCastEvent.Post e = new SpellCastEvent.Post(spell, (EntityLivingBase)caster, spell.getCooldown());
                MinecraftForge.EVENT_BUS.post((Event)e);
                return this.setCoolDown((EntityPlayer)caster, spell, e.getCd());
            }
            return -result.ordinal();
        }

        static {
            ExtensionsKt.eventForge((Object)SpellCastingHandler.INSTANCE);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lalfheim/common/core/handler/CardinalSystem$SpellCastingSystem$SpellCastingHandler;", "", "<init>", "()V", "onSpellCasting", "", "e", "Lalfheim/api/event/SpellCastEvent$Pre;", "onSpellCasted", "Lalfheim/api/event/SpellCastEvent$Post;", "Alfheim"})
        public static final class SpellCastingHandler {
            @NotNull
            public static final SpellCastingHandler INSTANCE = new SpellCastingHandler();

            private SpellCastingHandler() {
            }

            @SubscribeEvent
            public final void onSpellCasting(@NotNull SpellCastEvent.Pre e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                if (!e.getCaster().func_70089_S() || e.getCaster().field_70128_L) {
                    e.setCanceled(true);
                    return;
                }
                if (e.getCaster().func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDLeftFlame())) {
                    e.setCanceled(true);
                    return;
                }
                if (TimeStopSystem.INSTANCE.affected((Entity)e.getCaster())) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onSpellCasted(@NotNull SpellCastEvent.Post e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                if (e.getCaster() instanceof EntityPlayer && ((EntityPlayer)e.getCaster()).field_71075_bZ.field_75098_d) {
                    e.setCd(5);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J*\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TargetingSystem;", "", "<init>", "()V", "tick", "", "setTarget", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "target", "Lnet/minecraft/entity/EntityLivingBase;", "isParty", "", "partyIndex", "", "getTarget", "Lalfheim/common/core/handler/CardinalSystem$TargetingSystem$Target;", "Target", "Alfheim"})
    public static final class TargetingSystem {
        @NotNull
        public static final TargetingSystem INSTANCE = new TargetingSystem();

        private TargetingSystem() {
        }

        public final void tick() {
            Iterator<String> iterator = INSTANCE.getPlayerSegments().keySet().iterator();
            while (iterator.hasNext()) {
                EntityLivingBase tg;
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(name);
                if (player == null) {
                    PlayerSegment s;
                    PlayerSegment playerSegment = s = INSTANCE.getPlayerSegments().get(name);
                    if (playerSegment != null) {
                        playerSegment.setTarget(null);
                    }
                    PlayerSegment playerSegment2 = s;
                    if (playerSegment2 != null) {
                        playerSegment2.setParty(false);
                    }
                    continue;
                }
                if (this.getTarget((EntityLivingBase)player).getTarget() == null) continue;
                if (!tg.field_70128_L) {
                    double d = Vector3.Companion.entityDistance((Entity)player, (Entity)tg);
                    double d2 = tg instanceof IBossDisplayData ? 128.0 : 32.0;
                    if (!(d > d2)) continue;
                }
                this.setTarget((EntityPlayer)player, null, false, -2);
            }
        }

        public final void setTarget(@NotNull EntityPlayer player, @Nullable EntityLivingBase target, boolean isParty, int partyIndex) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PlayerSegment c = INSTANCE.forPlayer(player);
            c.setTarget(target);
            if (partyIndex != -2) {
                c.setParty(isParty);
                c.setPartyIndex(partyIndex);
            }
        }

        public static /* synthetic */ void setTarget$default(TargetingSystem targetingSystem, EntityPlayer entityPlayer, EntityLivingBase entityLivingBase, boolean bl, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = -1;
            }
            targetingSystem.setTarget(entityPlayer, entityLivingBase, bl, n);
        }

        @NotNull
        public final Target getTarget(@NotNull EntityLivingBase player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof EntityPlayer)) {
                return new Target(null, false, -1);
            }
            PlayerSegment c = INSTANCE.forPlayer((EntityPlayer)player);
            return new Target(c.getTarget(), c.isParty(), c.getPartyIndex());
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TargetingSystem$Target;", "", "target", "Lnet/minecraft/entity/EntityLivingBase;", "isParty", "", "partyIndex", "", "<init>", "(Lnet/minecraft/entity/EntityLivingBase;ZI)V", "getTarget", "()Lnet/minecraft/entity/EntityLivingBase;", "()Z", "getPartyIndex", "()I", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Alfheim"})
        public static final class Target {
            @Nullable
            private final EntityLivingBase target;
            private final boolean isParty;
            private final int partyIndex;

            public Target(@Nullable EntityLivingBase target, boolean isParty, int partyIndex) {
                this.target = target;
                this.isParty = isParty;
                this.partyIndex = partyIndex;
            }

            @Nullable
            public final EntityLivingBase getTarget() {
                return this.target;
            }

            public final boolean isParty() {
                return this.isParty;
            }

            public final int getPartyIndex() {
                return this.partyIndex;
            }

            @Nullable
            public final EntityLivingBase component1() {
                return this.target;
            }

            public final boolean component2() {
                return this.isParty;
            }

            public final int component3() {
                return this.partyIndex;
            }

            @NotNull
            public final Target copy(@Nullable EntityLivingBase target, boolean isParty, int partyIndex) {
                return new Target(target, isParty, partyIndex);
            }

            public static /* synthetic */ Target copy$default(Target target, EntityLivingBase entityLivingBase, boolean bl, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    entityLivingBase = target.target;
                }
                if ((n2 & 2) != 0) {
                    bl = target.isParty;
                }
                if ((n2 & 4) != 0) {
                    n = target.partyIndex;
                }
                return target.copy(entityLivingBase, bl, n);
            }

            @NotNull
            public String toString() {
                return "Target(target=" + this.target + ", isParty=" + this.isParty + ", partyIndex=" + this.partyIndex + ')';
            }

            public int hashCode() {
                int result = this.target == null ? 0 : this.target.hashCode();
                result = result * 31 + Boolean.hashCode(this.isParty);
                result = result * 31 + Integer.hashCode(this.partyIndex);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Target)) {
                    return false;
                }
                Target target = (Target)other;
                if (!Intrinsics.areEqual((Object)this.target, (Object)target.target)) {
                    return false;
                }
                if (this.isParty != target.isParty) {
                    return false;
                }
                return this.partyIndex == target.partyIndex;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R,\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem;", "", "<init>", "()V", "tsAreas", "Ljava/util/HashMap;", "", "Ljava/util/LinkedList;", "Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopArea;", "getTsAreas", "()Ljava/util/HashMap;", "setTsAreas", "(Ljava/util/HashMap;)V", "transfer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "fromDim", "stop", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "tick", "affected", "", "e", "Lnet/minecraft/entity/Entity;", "TimeStopArea", "TimeStopThingsListener", "Alfheim"})
    @SourceDebugExtension(value={"SMAP\nCardinalSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardinalSystem.kt\nalfheim/common/core/handler/CardinalSystem$TimeStopSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1174:1\n1#2:1175\n*E\n"})
    public static final class TimeStopSystem {
        @NotNull
        public static final TimeStopSystem INSTANCE = new TimeStopSystem();
        @NotNull
        private static HashMap<Integer, LinkedList<TimeStopArea>> tsAreas = new HashMap();

        private TimeStopSystem() {
        }

        @NotNull
        public final HashMap<Integer, LinkedList<TimeStopArea>> getTsAreas() {
            return tsAreas;
        }

        public final void setTsAreas(@NotNull HashMap<Integer, LinkedList<TimeStopArea>> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            tsAreas = hashMap;
        }

        public final void transfer(@NotNull EntityPlayerMP player, int fromDim) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            LinkedList<TimeStopArea> linkedList = tsAreas.get(fromDim);
            for (TimeStopArea tsa : linkedList != null ? (List)linkedList : CollectionsKt.emptyList()) {
                NetworkService.INSTANCE.sendTo(new Message1d(M1d.TIME_STOP_REMOVE, ExtensionsKt.getD((Number)tsa.getId()), 0, 4, null), player);
            }
            LinkedList<TimeStopArea> linkedList2 = tsAreas.get(player.field_71093_bK);
            for (TimeStopArea tsa : linkedList2 != null ? (List)linkedList2 : CollectionsKt.emptyList()) {
                NetworkService.INSTANCE.sendTo(new MessageTimeStop(PartySystem.INSTANCE.getUUIDParty(tsa.getUuid()), tsa.getPos().getX(), tsa.getPos().getY(), tsa.getPos().getZ(), tsa.getId()), player);
            }
        }

        public final void stop(@NotNull EntityLivingBase caster) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            caster.field_70170_p.func_82739_e(1013, ExtensionsKt.getI((Number)caster.field_70165_t), ExtensionsKt.getI((Number)caster.field_70163_u), ExtensionsKt.getI((Number)caster.field_70161_v), 0);
            LinkedList<TimeStopArea> linkedList = tsAreas.get(caster.field_71093_bK);
            if (linkedList == null) {
                LinkedList linkedList2;
                LinkedList it = linkedList2 = new LinkedList();
                boolean bl = false;
                ((Map)tsAreas).put(caster.field_71093_bK, it);
                linkedList = linkedList2;
            }
            linkedList.addLast(new TimeStopArea(caster));
            NetworkService.INSTANCE.sendToDim(new MessageTimeStop(PartySystem.INSTANCE.getMobParty(caster), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, TimeStopArea.Companion.getNextID()), caster.field_71093_bK);
        }

        public final void tick() {
            TimeStopArea tsa = null;
            for (Map.Entry entry : ((Map)tsAreas).entrySet()) {
                Iterator i;
                int dim = ((Number)entry.getKey()).intValue();
                LinkedList tsas = (LinkedList)entry.getValue();
                Intrinsics.checkNotNullExpressionValue(tsas.iterator(), (String)"iterator(...)");
                while (i.hasNext()) {
                    TimeStopArea timeStopArea = tsa = (TimeStopArea)i.next();
                    timeStopArea.setLife(timeStopArea.getLife() + -1);
                    if (timeStopArea.getLife() > 0) continue;
                    i.remove();
                    NetworkService.INSTANCE.sendToDim(new Message1d(M1d.TIME_STOP_REMOVE, ExtensionsKt.getD((Number)tsa.getId()), 0, 4, null), dim);
                }
            }
        }

        public final boolean affected(@Nullable Entity e) {
            if (e == null) {
                return false;
            }
            TimeStopCheckEvent.TimeStopEntityCheckEvent ev = new TimeStopCheckEvent.TimeStopEntityCheckEvent(e);
            if (MinecraftForge.EVENT_BUS.post((Event)ev)) {
                return ev.getResult();
            }
            if (e instanceof IBossDisplayData && !AlfheimConfigHandler.INSTANCE.getSuperSpellBosses()) {
                return false;
            }
            if (e instanceof ITimeStopSpecific && ((ITimeStopSpecific)e).isImmune()) {
                return false;
            }
            LinkedList<TimeStopArea> linkedList = tsAreas.get(e.field_71093_bK);
            if (linkedList == null) {
                return false;
            }
            Iterator iterator = linkedList.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                TimeStopArea tsa = (TimeStopArea)e2;
                if (!(Vector3.Companion.vecEntityDistance(tsa.getPos(), e) < SpellTimeStop.INSTANCE.getRadius())) continue;
                if (e instanceof ITimeStopSpecific && ((ITimeStopSpecific)e).affectedBy(tsa.getUuid())) {
                    return true;
                }
                if (e instanceof EntityLivingBase) {
                    if (PartySystem.INSTANCE.sameParty(tsa.getUuid(), (EntityLivingBase)e)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        static {
            MinecraftForge.EVENT_BUS.register((Object)TimeStopThingsListener.INSTANCE);
            FMLCommonHandler.instance().bus().register((Object)TimeStopThingsListener.INSTANCE);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopArea;", "Ljava/io/Serializable;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "<init>", "(Lnet/minecraft/entity/EntityLivingBase;)V", "pos", "Lalexsocol/asjlib/math/Vector3;", "getPos", "()Lalexsocol/asjlib/math/Vector3;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "id", "", "getId", "()I", "life", "getLife", "setLife", "(I)V", "Companion", "Alfheim"})
        public static final class TimeStopArea
        implements Serializable {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Vector3 pos;
            @NotNull
            private final UUID uuid;
            private final transient int id;
            private int life;
            private static final long serialVersionUID = 4146871637815241L;
            private static transient int nextID = -1;

            public TimeStopArea(@NotNull EntityLivingBase caster) {
                Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
                this.pos = Vector3.Companion.fromEntity((Entity)caster);
                UUID uUID = caster.func_110124_au();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueID(...)");
                this.uuid = uUID;
                this.id = ++nextID;
                this.life = SpellTimeStop.INSTANCE.getDuration();
            }

            @NotNull
            public final Vector3 getPos() {
                return this.pos;
            }

            @NotNull
            public final UUID getUuid() {
                return this.uuid;
            }

            public final int getId() {
                return this.id;
            }

            public final int getLife() {
                return this.life;
            }

            public final void setLife(int n) {
                this.life = n;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopArea$Companion;", "", "<init>", "()V", "serialVersionUID", "", "nextID", "", "getNextID", "()I", "setNextID", "(I)V", "Alfheim"})
            public static final class Companion {
                private Companion() {
                }

                public final int getNextID() {
                    return nextID;
                }

                public final void setNextID(int n) {
                    nextID = n;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopThingsListener;", "", "<init>", "()V", "onPlayerChangedDimension", "", "e", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onEntityUpdate", "Lalexsocol/patcher/event/EntityUpdateEvent;", "onLivingUpdate", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "onChatEvent", "Lnet/minecraftforge/event/ServerChatEvent;", "onCommandEvent", "Lnet/minecraftforge/event/CommandEvent;", "Alfheim"})
        public static final class TimeStopThingsListener {
            @NotNull
            public static final TimeStopThingsListener INSTANCE = new TimeStopThingsListener();

            private TimeStopThingsListener() {
            }

            @SubscribeEvent
            public final void onPlayerChangedDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && e.player instanceof EntityPlayerMP) {
                    EntityPlayer entityPlayer = e.player;
                    Intrinsics.checkNotNull((Object)entityPlayer, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                    INSTANCE.transfer((EntityPlayerMP)entityPlayer, e.fromDim);
                }
            }

            @SubscribeEvent
            public final void onEntityUpdate(@NotNull EntityUpdateEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.getEntity().func_70089_S()) {
                    return;
                }
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && INSTANCE.affected(e.getEntity())) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onLivingUpdate(@NotNull LivingEvent.LivingUpdateEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && INSTANCE.affected(e.entity)) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onChatEvent(@NotNull ServerChatEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && INSTANCE.affected((Entity)e.player)) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onCommandEvent(@NotNull CommandEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && e.sender instanceof EntityPlayer) {
                    ICommandSender iCommandSender = e.sender;
                    Intrinsics.checkNotNull((Object)iCommandSender, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    if (INSTANCE.affected((Entity)((EntityPlayer)iCommandSender))) {
                        e.setCanceled(true);
                    }
                }
            }
        }
    }
}

