/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.command;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alfheim.AlfheimCore;
import alfheim.api.event.AlfheimModeChangedEvent;
import alfheim.common.block.BlockNiflheimPortal;
import alfheim.common.block.tile.TileDomainLobby;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.core.handler.ESMHandler;
import alfheim.common.crafting.recipe.AlfheimRecipes;
import alfheim.common.network.M3d;
import alfheim.common.network.NetworkService;
import alfheim.common.network.packet.Message3d;
import alfheim.common.world.data.CustomWorldData;
import alfheim.common.world.dim.niflheim.ChunkProviderNiflheim;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ!\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ!\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\u0010\u0011J!\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lalfheim/common/core/command/CommandAlfheim;", "Lnet/minecraft/command/CommandBase;", "<init>", "()V", "getCommandName", "", "getCommandAliases", "", "getCommandUsage", "sender", "Lnet/minecraft/command/ICommandSender;", "getRequiredPermissionLevel", "", "processCommand", "", "args", "", "(Lnet/minecraft/command/ICommandSender;[Ljava/lang/String;)V", "addTabCompletionOptions", "", "", "(Lnet/minecraft/command/ICommandSender;[Ljava/lang/String;)Ljava/util/List;", "help", "changeModes", "toggleESM", "on", "", "toggleMMO", "printRandGen", "gainKnowledge", "regenerateSurtrDomain", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nCommandAlfheim.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAlfheim.kt\nalfheim/common/core/command/CommandAlfheim\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1557#2:190\n1628#2,3:191\n1863#2:196\n1864#2:198\n1863#2,2:199\n1863#2,2:201\n37#3,2:194\n1#4:197\n*S KotlinDebug\n*F\n+ 1 CommandAlfheim.kt\nalfheim/common/core/command/CommandAlfheim\n*L\n50#1:190\n50#1:191,3\n110#1:196\n110#1:198\n161#1:199,2\n177#1:201,2\n50#1:194,2\n*E\n"})
public final class CommandAlfheim
extends CommandBase {
    @NotNull
    public static final CommandAlfheim INSTANCE = new CommandAlfheim();

    private CommandAlfheim() {
    }

    @NotNull
    public String func_71517_b() {
        return "alfheim";
    }

    @NotNull
    public List<String> func_71514_a() {
        return CollectionsKt.listOf((Object)"alf");
    }

    @NotNull
    public String func_71518_a(@NotNull ICommandSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        return '/' + this.func_71517_b() + " help";
    }

    public int func_82362_a() {
        return MinecraftServer.func_71276_C().func_110455_j();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(@NotNull ICommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)ArraysKt.getOrNull((Object[])args, (int)0);
        if (string == null) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        int n = -1;
        switch (string.hashCode()) {
            case 0x3339A3: {
                if (string.equals("mode")) {
                    n = 1;
                }
                break;
            }
            case 3198785: {
                if (string.equals("help")) {
                    n = 2;
                }
                break;
            }
            case 977900811: {
                if (string.equals("randgen")) {
                    n = 3;
                }
                break;
            }
            case -2082748369: {
                if (string.equals("surtrregen")) {
                    n = 4;
                }
                break;
            }
            case 1549887614: {
                if (string.equals("knowledge")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                this.help(sender);
                return;
            }
            case 1: {
                this.changeModes(sender, args);
                return;
            }
            case 3: {
                this.printRandGen(sender);
                return;
            }
            case 5: {
                this.gainKnowledge(sender, args);
                return;
            }
            case 4: {
                this.regenerateSurtrDomain(sender, args);
                return;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Object> func_71516_a(@Nullable ICommandSender sender, @NotNull String[] args) {
        block21: {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length == 1) {
                String[] stringArray = new String[]{"help", "mode", "randgen", "knowledge", "surtrregen"};
                List list = CommandBase.func_71530_a((String[])args, (String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getListOfStringsMatchingLastWord(...)");
                return list;
            }
            if (args.length != 2 && args.length != 3) break block21;
            switch (args[0]) {
                case "mode": {
                    List list;
                    if (args.length == 2) {
                        String[] stringArray = new String[]{"ESM", "MMO"};
                        List list2 = CommandBase.func_71530_a((String[])args, (String[])stringArray);
                        list = list2;
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getListOfStringsMatchingLastWord(...)");
                    } else {
                        list = new ArrayList();
                    }
                    return list;
                }
                case "help": 
                case "randgen": {
                    return new ArrayList();
                }
                case "knowledge": {
                    List list;
                    if (args.length == 2) {
                        void $this$toTypedArray$iv;
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        Collection $this$map$iv;
                        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                        spreadBuilder.add((Object)"ALL");
                        Iterable iterable = (Iterable)CardinalSystem.KnowledgeSystem.Knowledge.getEntries();
                        SpreadBuilder spreadBuilder2 = spreadBuilder;
                        String[] stringArray = args;
                        boolean $i$f$map = false;
                        void var8_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CardinalSystem.KnowledgeSystem.Knowledge knowledge = (CardinalSystem.KnowledgeSystem.Knowledge)((Object)item$iv$iv);
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.toString());
                        }
                        collection = (List)destination$iv$iv;
                        $this$map$iv = collection;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                        List list3 = CommandBase.func_71530_a((String[])stringArray, (String[])((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
                        list = list3;
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getListOfStringsMatchingLastWord(...)");
                    } else {
                        String[] stringArray = MinecraftServer.func_71276_C().func_71203_ab().func_72369_d();
                        List list4 = CommandBase.func_71530_a((String[])args, (String[])Arrays.copyOf(stringArray, stringArray.length));
                        list = list4;
                        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getListOfStringsMatchingLastWord(...)");
                    }
                    return list;
                }
            }
        }
        return new ArrayList();
    }

    public final void help(@NotNull ICommandSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        ASJUtilities.say((ICommandSender)sender, (String)('/' + this.func_71517_b() + " mode <ESM|MMO> - change current game mode"), (Object[])new Object[0]);
        ASJUtilities.say((ICommandSender)sender, (String)('/' + this.func_71517_b() + " randgen - print coordinates of random gen"), (Object[])new Object[0]);
        ASJUtilities.say((ICommandSender)sender, (String)('/' + this.func_71517_b() + " knowledge <knowledge> [player] - add knowledge to player"), (Object[])new Object[0]);
        ASJUtilities.say((ICommandSender)sender, (String)('/' + this.func_71517_b() + " surtrregen true - Reset Surtr domain data"), (Object[])new Object[0]);
    }

    public final void changeModes(@NotNull ICommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        boolean esmOld = AlfheimConfigHandler.INSTANCE.getEnableElvenStory();
        boolean mmoOld = AlfheimConfigHandler.INSTANCE.getEnableMMO();
        if (StringsKt.equals((String)args[1], (String)"ESM", (boolean)true)) {
            AlfheimConfigHandler.INSTANCE.setEnableElvenStory(!AlfheimConfigHandler.INSTANCE.getEnableElvenStory());
            this.toggleESM(AlfheimConfigHandler.INSTANCE.getEnableElvenStory());
        } else if (StringsKt.equals((String)args[1], (String)"MMO", (boolean)true)) {
            AlfheimConfigHandler.INSTANCE.setEnableMMO(!AlfheimConfigHandler.INSTANCE.getEnableMMO());
            this.toggleMMO(AlfheimConfigHandler.INSTANCE.getEnableMMO());
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String string = StatCollector.func_74838_a((String)"alfheim.commands.setmode.done");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translateToLocal(...)");
        String string2 = string;
        Object[] objectArray = new Object[]{sender.func_70005_c_(), AlfheimConfigHandler.INSTANCE.getEnableElvenStory() ? EnumChatFormatting.GREEN : EnumChatFormatting.DARK_RED, EnumChatFormatting.RESET, AlfheimConfigHandler.INSTANCE.getEnableMMO() ? EnumChatFormatting.GREEN : EnumChatFormatting.DARK_RED, EnumChatFormatting.RESET};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        ASJUtilities.sayToAllOnline((String)string3, (Object[])new Object[0]);
        NetworkService.INSTANCE.sendToAll(new Message3d(M3d.TOGGLER, ExtensionsKt.getD((Number)(StringsKt.equals((String)args[1], (String)"ESM", (boolean)true) ? 1 : 0)), ExtensionsKt.getD((Number)((esmOld ? 1 : 0) << 1 | (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() ? 1 : 0))), ExtensionsKt.getD((Number)((mmoOld ? 1 : 0) << 1 | (AlfheimConfigHandler.INSTANCE.getEnableMMO() ? 1 : 0))), 0, 16, null));
        MinecraftForge.EVENT_BUS.post((Event)new AlfheimModeChangedEvent(AlfheimConfigHandler.INSTANCE.getEnableElvenStory(), AlfheimConfigHandler.INSTANCE.getEnableMMO(), esmOld, mmoOld));
        ESMHandler.INSTANCE.writeModes(AlfheimCore.INSTANCE.getSave());
    }

    public final void toggleESM(boolean on) {
        if (on) {
            AlfheimConfigHandler.INSTANCE.initWorldCoordsForElvenStory(AlfheimCore.INSTANCE.getSave());
            ESMHandler.INSTANCE.checkAddAttrs();
        } else {
            AlfheimConfigHandler.INSTANCE.setEnableMMO(false);
            this.toggleMMO(AlfheimConfigHandler.INSTANCE.getEnableMMO());
            List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"playerEntityList");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                PlayerCapabilities playerCapabilities;
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                PlayerCapabilities $this$toggleESM_u24lambda_u242_u24lambda_u241 = playerCapabilities = ((EntityPlayerMP)it).field_71075_bZ;
                boolean bl2 = false;
                $this$toggleESM_u24lambda_u242_u24lambda_u241.field_75100_b = false;
                $this$toggleESM_u24lambda_u242_u24lambda_u241.field_75101_c = false;
            }
        }
    }

    public final void toggleMMO(boolean on) {
        if (on) {
            CardinalSystem.INSTANCE.load(AlfheimCore.INSTANCE.getSave());
            AlfheimRecipes.INSTANCE.addMMORecipes();
            AlfheimConfigHandler.INSTANCE.setEnableElvenStory(true);
            this.toggleESM(AlfheimConfigHandler.INSTANCE.getEnableElvenStory());
            for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                Intrinsics.checkNotNull(o, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                CardinalSystem.INSTANCE.transfer((EntityPlayerMP)o);
            }
        } else {
            CardinalSystem.INSTANCE.save();
            AlfheimRecipes.INSTANCE.removeMMORecipes();
        }
    }

    public final void printRandGen(@NotNull ICommandSender sender) {
        int sy;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim());
        Intrinsics.checkNotNullExpressionValue((Object)worldServer, (String)"worldServerForDimension(...)");
        ChunkCoordinates chunkCoordinates = BlockNiflheimPortal.Companion.onlyPortalPosition((World)worldServer);
        int nx = ExtensionsKt.component1((ChunkCoordinates)chunkCoordinates);
        int ny = ExtensionsKt.component2((ChunkCoordinates)chunkCoordinates);
        int nz = ExtensionsKt.component3((ChunkCoordinates)chunkCoordinates);
        ASJUtilities.say((ICommandSender)sender, (String)("Portal to Niflheim at " + nx + ' ' + ny + ' ' + nz), (Object[])new Object[0]);
        int tx = ASJUtilities.randInBounds((int)-1000, (int)1000, (Random)new Random(MinecraftServer.func_71276_C().func_71218_a(AlfheimConfigHandler.INSTANCE.getDimensionIDNiflheim()).func_72905_C()));
        int ty = 128;
        int tz = ChunkProviderNiflheim.Companion.f(tx) + 16;
        ASJUtilities.say((ICommandSender)sender, (String)("Thrym domain at " + tx + ' ' + ty + ' ' + tz), (Object[])new Object[0]);
        WorldServer worldServer2 = MinecraftServer.func_71276_C().func_71218_a(-1);
        Intrinsics.checkNotNullExpressionValue((Object)worldServer2, (String)"worldServerForDimension(...)");
        CustomWorldData data = CustomWorldData.Companion.getCustomData((World)worldServer2);
        Collection collection = data.getStructures().get((Object)"Surtr");
        if (collection == null || (collection = (Pair)CollectionsKt.firstOrNull((Iterable)collection)) == null) {
            collection = TuplesKt.to((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
        }
        Collection collection2 = collection;
        int sx = ((Number)collection2.component1()).intValue();
        int sz = ((Number)collection2.component2()).intValue();
        String string = data.getData().get("SurtrY");
        int n = sy = string != null ? Integer.parseInt(string) : -1;
        if (sx == Integer.MIN_VALUE || sy == -1) {
            ASJUtilities.say((ICommandSender)sender, (String)"Surtr domain not generated", (Object[])new Object[0]);
        } else {
            ASJUtilities.say((ICommandSender)sender, (String)("Surtr domain at " + sx + ' ' + sy + ' ' + sz), (Object[])new Object[0]);
        }
        Random rand = new Random(sender.func_130014_f_().func_72905_C());
        int vx = ASJUtilities.randInBounds((int)-256, (int)256, (Random)rand);
        int vz = ASJUtilities.randInBounds((int)-768, (int)-256, (Random)rand);
        ASJUtilities.say((ICommandSender)sender, (String)("Vafthrudnir soul at " + vx + ' ' + vz), (Object[])new Object[0]);
    }

    public final void gainKnowledge(@NotNull ICommandSender sender, @NotNull String[] args) {
        EntityPlayerMP target;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int n = args.length;
        if (!(2 <= n ? n < 4 : false)) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length != 3 && !(sender instanceof EntityPlayerMP)) {
            ASJUtilities.say((ICommandSender)sender, (String)"not player", (Object[])new Object[0]);
            return;
        }
        EntityPlayerMP entityPlayerMP = args.length == 3 ? MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(args[2]) : (target = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null);
        if (target == null) {
            ASJUtilities.say((ICommandSender)sender, (String)"not player", (Object[])new Object[0]);
            return;
        }
        if (!Intrinsics.areEqual((Object)args[1], (Object)"ALL")) {
            CardinalSystem.KnowledgeSystem.Knowledge knowledge = CardinalSystem.KnowledgeSystem.Knowledge.valueOf(args[1]);
            CardinalSystem.KnowledgeSystem.learn$default(CardinalSystem.KnowledgeSystem.INSTANCE, target, knowledge, null, 4, null);
        } else {
            Iterable $this$forEach$iv = (Iterable)CardinalSystem.KnowledgeSystem.Knowledge.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CardinalSystem.KnowledgeSystem.Knowledge it = (CardinalSystem.KnowledgeSystem.Knowledge)((Object)element$iv);
                boolean bl = false;
                CardinalSystem.KnowledgeSystem.learn$default(CardinalSystem.KnowledgeSystem.INSTANCE, target, it, null, 4, null);
            }
        }
    }

    public final void regenerateSurtrDomain(@NotNull ICommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 1) {
            ASJUtilities.say((ICommandSender)sender, (String)"Reset Surtr domain data. Pass 'true' as next parameter to approve it.", (Object[])new Object[0]);
        }
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(-1);
        Intrinsics.checkNotNull((Object)world);
        CustomWorldData data = CustomWorldData.Companion.getCustomData((World)world);
        Multimap<String, Pair<Integer, Integer>> structs = data.getStructures();
        if (!structs.containsKey((Object)"Surtr")) {
            return;
        }
        String string = data.getData().get("SurtrY");
        if (string == null) {
            return;
        }
        int y = Integer.parseInt(string);
        Collection collection = structs.get((Object)"Surtr");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int z;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int x = ((Number)pair.component1()).intValue();
            if (!(world.func_147438_o(x, y - 5, (z = ((Number)pair.component2()).intValue()) + 30) instanceof TileDomainLobby)) continue;
            world.func_147468_f(x, y - 5, z + 30);
        }
        data.getStructures().removeAll((Object)"Surtr");
        data.getData().remove("SurtrY");
        data.func_76185_a();
        ASJUtilities.say((ICommandSender)sender, (String)"Surtr domain data reset.", (Object[])new Object[0]);
    }
}

