/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.asm.hook.fixes;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lalfheim/common/core/asm/hook/fixes/FlightTiaraFix;", "", "<init>", "()V", "WING_TYPES", "", "onEquipped", "", "item", "Lvazkii/botania/common/item/equipment/bauble/ItemFlightTiara;", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/EntityLivingBase;", "HEX_CHARS", "", "getHash", "", "str", "dontRainbowTableMeOrMySonEverAgain", "reverseString", "onPlayerBaubleRender", "", "event", "Lnet/minecraftforge/client/event/RenderPlayerEvent;", "type", "Lvazkii/botania/api/item/IBaubleRender$RenderType;", "Alfheim"})
public final class FlightTiaraFix {
    @NotNull
    public static final FlightTiaraFix INSTANCE = new FlightTiaraFix();
    public static final int WING_TYPES = 9;
    @NotNull
    private static final char[] HEX_CHARS;

    private FlightTiaraFix() {
    }

    @JvmStatic
    @Hook(injectOnExit=true)
    public static final void onEquipped(@NotNull ItemFlightTiara item, @NotNull ItemStack stack, @Nullable EntityLivingBase player) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.func_77960_j() != 9 && Intrinsics.areEqual((Object)INSTANCE.getHash(stack.func_82833_r()), (Object)"0DAB89CC38A6546EDBC2127844CD92F7C4774E22446F0D0CCE3523E475CE3910")) {
            stack.func_77964_b(9);
            stack.func_77978_p().func_82580_o("display");
        }
    }

    private final String getHash(String str) {
        if (str != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                StringBuilder ret = new StringBuilder();
                String string = this.dontRainbowTableMeOrMySonEverAgain(str);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                for (byte b : md.digest(byArray)) {
                    ret.append(HEX_CHARS[b >> 4 & 0xF]);
                    ret.append(HEX_CHARS[b & 0xF]);
                }
                String string2 = ret.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }
            catch (NoSuchAlgorithmException e) {
                ASJUtilities.error((String)"Hashing error:", (Throwable)e);
            }
        }
        return "";
    }

    private final String dontRainbowTableMeOrMySonEverAgain(String str) {
        String input = str;
        input = input + this.reverseString(input);
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        String string = input;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        rand.setSeed(byArray);
        int l = input.length();
        int steps = rand.nextInt(l);
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chrs = cArray;
        for (int i = 0; i < steps; ++i) {
            char c;
            int indA = rand.nextInt(l);
            int indB = 0;
            while ((indB = rand.nextInt(l)) == indA) {
            }
            chrs[indA] = c = (char)(chrs[indA] ^ chrs[indB]);
        }
        return new String(chrs);
    }

    private final String reverseString(String str) {
        String string = new StringBuilder(str).reverse().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @SideOnly(value=Side.CLIENT)
    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ON_TRUE)
    public static final boolean onPlayerBaubleRender(@NotNull ItemFlightTiara item, @NotNull ItemStack stack, @NotNull RenderPlayerEvent event, @NotNull IBaubleRender.RenderType type2) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        int meta = stack.func_77960_j();
        if (meta != 3 && meta != 9) {
            return false;
        }
        if (type2 != IBaubleRender.RenderType.BODY) {
            return false;
        }
        IIcon icon = ItemFlightTiara.wingIcons[meta - 1];
        ExtensionsClientKt.getMc().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        EntityPlayer player = event.entityPlayer;
        boolean flying = player.field_71075_bZ.field_75100_b;
        Ref.FloatRef rz = new Ref.FloatRef();
        rz.element = 120.0f;
        Ref.FloatRef rx = new Ref.FloatRef();
        rx.element = 20.0f + ExtensionsKt.getF((Number)((Math.sin(ExtensionsKt.getD((Number)Float.valueOf((float)player.field_70173_aa + event.partialRenderTick)) * (double)(flying ? 0.4f : 0.2f)) + (double)0.5f) * (double)(flying ? 30.0f : 5.0f)));
        Ref.FloatRef ry = new Ref.FloatRef();
        Ref.FloatRef h = new Ref.FloatRef();
        h.element = 0.2f;
        Ref.FloatRef x = new Ref.FloatRef();
        Ref.FloatRef z = new Ref.FloatRef();
        z.element = 0.15f;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int light = 0xF000F0;
        int lightmapX = light % 65536;
        int lightmapY = light / 65536;
        switch (meta) {
            case 3: {
                h.element = -0.1f;
                rz.element = 0.0f;
                ry.element = -rx.element;
                rx.element = 0.0f;
                z.element = 0.1f;
                break;
            }
            case 9: {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)ExtensionsKt.getF((Number)lightmapX), (float)ExtensionsKt.getF((Number)lightmapY));
                rz.element = 180.0f;
                rx.element = 0.0f;
                ry.element = -ExtensionsKt.getF((Number)((Math.sin((double)((float)player.field_70173_aa + event.partialRenderTick) * 0.2) + 0.6) * (double)(flying ? 12 : 5))) - (float)5;
                h.element = 0.85f;
                x.element = -0.125f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + (flying ? ExtensionsKt.getF((Number)Math.cos((double)((float)player.field_70173_aa + event.partialRenderTick) * 0.3)) * 0.25f + 0.25f : 0.0f)));
            }
        }
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        IBaubleRender.Helper.rotateIfSneaking((EntityPlayer)player);
        FlightTiaraFix.onPlayerBaubleRender$render(x, h, z, rz, rx, ry, f1, f2, f, f3, icon);
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        FlightTiaraFix.onPlayerBaubleRender$render(x, h, z, rz, rx, ry, f1, f2, f, f3, icon);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        return true;
    }

    private static final void onPlayerBaubleRender$render(Ref.FloatRef x, Ref.FloatRef h, Ref.FloatRef z, Ref.FloatRef rz, Ref.FloatRef rx, Ref.FloatRef ry, float f1, float f2, float f, float f3, IIcon icon) {
        GL11.glTranslatef((float)x.element, (float)h.element, (float)z.element);
        GL11.glRotatef((float)rz.element, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)rx.element, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)ry.element, (float)0.0f, (float)1.0f, (float)0.0f);
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.03125f);
        GL11.glRotatef((float)(-ry.element), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-rx.element), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-rz.element), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-x.element), (float)(-h.element), (float)(-z.element));
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_CHARS = cArray;
    }
}

