/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile.sub.flower;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.VisualEffectHandler;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.lexicon.LexiconData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lalfheim/common/block/tile/sub/flower/SubTileGourmaryllisHard;", "Lvazkii/botania/api/subtile/SubTileGenerating;", "<init>", "()V", "cooldown", "", "storedMana", "lastFood", "Lnet/minecraft/item/ItemStack;", "lastFoodCount", "worldObj", "Lnet/minecraft/world/World;", "getWorldObj", "()Lnet/minecraft/world/World;", "onUpdate", "", "writeToPacketNBT", "cmp", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromPacketNBT", "getRadius", "Lvazkii/botania/api/subtile/RadiusDescriptor$Square;", "getMaxMana", "getColor", "getEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "Companion", "Alfheim"})
public final class SubTileGourmaryllisHard
extends SubTileGenerating {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int cooldown;
    private int storedMana;
    @Nullable
    private ItemStack lastFood;
    private int lastFoodCount;
    @NotNull
    private static final String TAG_COOLDOWN = "cooldown";
    @NotNull
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    @NotNull
    private static final String TAG_LAST_FOOD = "lastFood";
    @NotNull
    private static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    private static final int RANGE = 1;

    @NotNull
    public final World getWorldObj() {
        World world = this.supertile.func_145831_w();
        Intrinsics.checkNotNull((Object)world);
        return world;
    }

    public void onUpdate() {
        int id;
        super.onUpdate();
        if (this.getWorldObj().field_72995_K) {
            return;
        }
        if (this.cooldown > -1) {
            int n = this.cooldown;
            this.cooldown = n + -1;
        }
        TileEntity tileEntity = this.supertile;
        Intrinsics.checkNotNullExpressionValue((Object)tileEntity, (String)"supertile");
        Vector3 vector3 = Vector3.Companion.fromTileEntityCenter(tileEntity);
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        if (this.storedMana != 0) {
            int munchInterval = Math.max(2 + 2 * this.lastFoodCount, 4);
            if (this.cooldown == 0) {
                this.mana = Math.min(this.getMaxMana(), this.mana + this.storedMana);
                this.storedMana = 0;
                float burpPitch = 1.0f - (float)(this.lastFoodCount - 1) * 0.05f;
                this.getWorldObj().func_72908_a(x, y, z, "random.burp", 1.0f, burpPitch);
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.getWorldObj().func_72908_a(x, y, z, "random.eat", 0.5f, 1.0f);
                ItemStack itemStack = this.lastFood;
                if (itemStack != null) {
                    ItemStack it = itemStack;
                    boolean bl = false;
                    id = Item.func_150891_b((Item)it.func_77973_b());
                    int meta = it.func_77981_g() ? it.func_77960_j() : -1;
                    double[] dArray = new double[]{x, y, z, ExtensionsKt.getD((Number)id), ExtensionsKt.getD((Number)meta)};
                    VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ICONCRACK, this.getWorldObj().field_73011_w.field_76574_g, dArray);
                }
            }
        }
        if (this.cooldown > 0) {
            return;
        }
        int slowdown = this.getSlowdownFactor();
        World world = this.getWorldObj();
        TileEntity tileEntity2 = this.supertile;
        Intrinsics.checkNotNullExpressionValue((Object)tileEntity2, (String)"supertile");
        ArrayList items = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityItem.class, (AxisAlignedBB)ExtensionsKt.boundingBox((TileEntity)tileEntity2, (Number)1));
        Iterator iterator = items.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack stack;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            EntityItem item = (EntityItem)e;
            if (item.func_92059_d() == null || !(stack.func_77973_b() instanceof ItemFood) || stack.field_77994_a <= 0 || item.field_70128_L || item.field_70292_b < slowdown) continue;
            if (stack.func_77969_a(this.lastFood) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.lastFood)) {
                id = this.lastFoodCount;
                this.lastFoodCount = id + 1;
            } else {
                this.lastFood = stack.func_77946_l();
                Intrinsics.checkNotNull((Object)this.lastFood);
                this.lastFood.field_77994_a = 1;
                this.lastFoodCount = 1;
            }
            Item item2 = stack.func_77973_b();
            Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type net.minecraft.item.ItemFood");
            int heal = ((ItemFood)item2).func_150905_g(stack);
            this.storedMana = heal * heal * 64;
            this.storedMana *= ExtensionsKt.getI((Number)Float.valueOf(1.0f / (float)this.lastFoodCount));
            this.cooldown = heal * 10;
            item.func_85030_a("random.eat", 0.2f, 0.6f);
            this.sync();
            int id2 = Item.func_150891_b((Item)stack.func_77973_b());
            int meta = stack.func_77981_g() ? stack.func_77960_j() : -1;
            double[] dArray = new double[]{x, y, z, ExtensionsKt.getD((Number)id2), ExtensionsKt.getD((Number)meta)};
            VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.ICONCRACK, this.getWorldObj().field_73011_w.field_76574_g, dArray);
            stack.field_77994_a += -1;
            int cfr_ignored_0 = stack.field_77994_a;
            stack.field_77994_a += -1;
            if (stack.field_77994_a > 0) break;
            item.func_70106_y();
            break;
        }
    }

    public void writeToPacketNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74768_a(TAG_DIGESTING_MANA, this.storedMana);
        cmp.func_74768_a(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
        if (this.lastFood != null) {
            ItemStack itemStack = this.lastFood;
            Intrinsics.checkNotNull((Object)itemStack);
            cmp.func_74782_a(TAG_LAST_FOOD, (NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void readFromPacketNBT(@NotNull NBTTagCompound cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
        this.storedMana = cmp.func_74762_e(TAG_DIGESTING_MANA);
        this.lastFoodCount = cmp.func_74762_e(TAG_LAST_FOOD_COUNT);
        if (cmp.func_74764_b(TAG_LAST_FOOD)) {
            this.lastFood = ItemStack.func_77949_a((NBTTagCompound)cmp.func_74775_l(TAG_LAST_FOOD));
        }
    }

    @NotNull
    public RadiusDescriptor.Square getRadius() {
        return new RadiusDescriptor.Square(this.toChunkCoordinates(), 1);
    }

    public int getMaxMana() {
        return 9000;
    }

    public int getColor() {
        return 13882884;
    }

    @NotNull
    public LexiconEntry getEntry() {
        LexiconEntry lexiconEntry = LexiconData.gourmaryllis;
        Intrinsics.checkNotNull((Object)lexiconEntry);
        return lexiconEntry;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lalfheim/common/block/tile/sub/flower/SubTileGourmaryllisHard$Companion;", "", "<init>", "()V", "TAG_COOLDOWN", "", "TAG_DIGESTING_MANA", "TAG_LAST_FOOD", "TAG_LAST_FOOD_COUNT", "RANGE", "", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

