/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile.sub.flower;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.lexicon.AlfheimLexiconData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModFluffBlocks;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR(\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u00050\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u00061"}, d2={"Lalfheim/common/block/tile/sub/flower/SubTileCrysanthermum;", "Lvazkii/botania/api/subtile/SubTileGenerating;", "<init>", "()V", "temp", "", "getTemp", "()I", "setTemp", "(I)V", "diminishing", "getDiminishing", "setDiminishing", "lastBlocks", "Ljava/util/LinkedList;", "kotlin.jvm.PlatformType", "getLastBlocks", "()Ljava/util/LinkedList;", "setLastBlocks", "(Ljava/util/LinkedList;)V", "meta", "biomeTemp", "getBiomeTemp", "onUpdate", "", "getComparatorInputOverride", "side", "getRadius", "Lvazkii/botania/api/subtile/RadiusDescriptor;", "getMaxMana", "getValueForPassiveGeneration", "canGeneratePassively", "", "getDelayBetweenPassiveGeneration", "getColor", "getEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "renderHUD", "mc", "Lnet/minecraft/client/Minecraft;", "res", "Lnet/minecraft/client/gui/ScaledResolution;", "writeToPacketNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromPacketNBT", "getIcon", "Lnet/minecraft/util/IIcon;", "Companion", "Alfheim"})
public final class SubTileCrysanthermum
extends SubTileGenerating {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int temp;
    private int diminishing;
    @NotNull
    private LinkedList<Integer> lastBlocks;
    @NotNull
    public static final String TAG_TEMPERATURE = "flowerHeat";
    @NotNull
    public static final String TAG_DIMINISHING = "diminishing";
    public static final int DIFFERENTIATION = 4;
    public static final int RANGE = 1;
    @NotNull
    private static final Integer[] TYPES;

    public SubTileCrysanthermum() {
        int n = 0;
        int[] nArray = new int[4];
        SubTileCrysanthermum subTileCrysanthermum = this;
        while (n < 4) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        Collection collection = ArraysKt.toList((int[])nArray);
        subTileCrysanthermum.lastBlocks = new LinkedList(collection);
    }

    public final int getTemp() {
        return this.temp;
    }

    public final void setTemp(int temp) {
        this.temp = Math.max(Math.min(temp, 8), -8);
        this.supertile.func_70296_d();
    }

    public final int getDiminishing() {
        return this.diminishing;
    }

    public final void setDiminishing(int n) {
        this.diminishing = n;
    }

    @NotNull
    public final LinkedList<Integer> getLastBlocks() {
        return this.lastBlocks;
    }

    public final void setLastBlocks(@NotNull LinkedList<Integer> linkedList) {
        Intrinsics.checkNotNullParameter(linkedList, (String)"<set-?>");
        this.lastBlocks = linkedList;
    }

    public final int getTemp(int meta) {
        int n;
        Integer n2 = TYPES[meta];
        if (n2 != null) {
            n = n2;
        } else {
            Random random = this.supertile.func_145831_w().field_73012_v;
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
            n = ASJUtilities.randInBounds((int)-4, (int)4, (Random)random);
        }
        return n;
    }

    public final int getBiomeTemp() {
        float t = this.supertile.func_145831_w().getBiomeGenForCoordsBody(this.supertile.field_145851_c, this.supertile.field_145849_e).func_150564_a(this.supertile.field_145851_c, this.supertile.field_145848_d, this.supertile.field_145849_e);
        return MathKt.roundToInt((float)SubTileCrysanthermum.Companion.map(t, -2.0f, 2.0f, -6.0f, 6.0f));
    }

    public void onUpdate() {
        if (this.ticksExisted == 0) {
            this.setTemp(this.getBiomeTemp());
        }
        super.onUpdate();
        if (this.linkedCollector == null) {
            return;
        }
        boolean remote = this.supertile.func_145831_w().field_72995_K;
        Block block = ModFluffBlocks.biomeStoneA;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"biomeStoneA");
        Item biomeStone = ExtensionsKt.toItem((Block)block);
        World world = this.supertile.func_145831_w();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
        TileEntity tileEntity = this.supertile;
        Intrinsics.checkNotNullExpressionValue((Object)tileEntity, (String)"supertile");
        ArrayList items = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityItem.class, (AxisAlignedBB)ExtensionsKt.boundingBox((TileEntity)tileEntity, (Number)1));
        int slowdown = this.getSlowdownFactor();
        if (this.ticksExisted % 600 == 0) {
            int n;
            int bt = this.getBiomeTemp();
            if (this.temp > bt) {
                n = this.temp;
                this.setTemp(n + -1);
            } else if (this.temp < bt) {
                n = this.temp;
                this.setTemp(n + 1);
            }
        }
        Iterator iterator = items.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator bt = iterator;
        while (bt.hasNext()) {
            Object e = bt.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            EntityItem item = (EntityItem)e;
            ItemStack stack = item.func_92059_d();
            if (stack == null || stack.func_77973_b() != biomeStone || item.field_70128_L || item.field_70292_b < slowdown) continue;
            int meta = ExtensionsKt.getMeta((ItemStack)stack) % 8;
            if (!remote && this.canGeneratePassively()) {
                int n = this.diminishing = this.lastBlocks.contains(meta) ? 4 : Math.max(0, this.diminishing - 1);
                if (this.lastBlocks.size() >= 4) {
                    this.lastBlocks.removeFirst();
                }
                this.lastBlocks.addLast(meta);
                this.setTemp(this.temp + this.getTemp(meta));
                this.sync();
            }
            for (int i = 0; i < 10; ++i) {
                double m = 0.2;
                double mx = (Math.random() - 0.5) * m;
                double my = (Math.random() - 0.5) * m;
                double mz = (Math.random() - 0.5) * m;
                World world2 = this.supertile.func_145831_w();
                StringBuilder stringBuilder = new StringBuilder().append("blockcrack_");
                Item item2 = stack.func_77973_b();
                Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"getItem(...)");
                world2.func_72869_a(stringBuilder.append(ExtensionsKt.getId((Item)item2)).append('_').append(meta).toString(), item.field_70165_t, item.field_70163_u, item.field_70161_v, mx, my, mz);
            }
            if (remote) continue;
            ItemStack itemStack = item.func_92059_d();
            itemStack.field_77994_a += -1;
            int cfr_ignored_0 = itemStack.field_77994_a;
            if (item.func_92059_d().field_77994_a > 0) continue;
            item.func_70106_y();
        }
        Color c = new Color(this.getColor());
        if (this.ticksExisted % 20 == 0) {
            Botania.proxy.wispFX(this.supertile.func_145831_w(), (double)this.supertile.field_145851_c + 0.5, (double)this.supertile.field_145848_d + 0.75, (double)this.supertile.field_145849_e + 0.5, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 0.25f, -0.025f);
        }
    }

    public int getComparatorInputOverride(int side) {
        return this.temp == -8 || this.temp == 8 ? 0 : this.temp + 8;
    }

    @NotNull
    public RadiusDescriptor getRadius() {
        return (RadiusDescriptor)new RadiusDescriptor.Square(this.toChunkCoordinates(), 1);
    }

    public int getMaxMana() {
        return 800;
    }

    public int getValueForPassiveGeneration() {
        return Math.max(0, MathKt.roundToInt((double)(Math.pow(ExtensionsKt.getD((Number)(Math.abs(this.getBiomeTemp() - this.temp) * (this.diminishing > 0 ? 3 : 6))), 2) / (double)20)));
    }

    public boolean canGeneratePassively() {
        int n = this.temp;
        return -7 <= n ? n < 8 : false;
    }

    public int getDelayBetweenPassiveGeneration() {
        return 5;
    }

    public int getColor() {
        return Color.HSBtoRGB(SubTileCrysanthermum.Companion.map(ExtensionsKt.getF((Number)this.temp), -8.0f, 8.0f, 235.0f, 360.0f) / 360.0f, 1.0f, 1.0f);
    }

    @NotNull
    public LexiconEntry getEntry() {
        return AlfheimLexiconData.INSTANCE.getFlowerCrysanthermum();
    }

    public void renderHUD(@NotNull Minecraft mc, @NotNull ScaledResolution res) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        super.renderHUD(mc, res);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        String name = StatCollector.func_74838_a((String)("misc.alfheim:temperature." + (this.temp + 8)));
        int width = 16 + mc.field_71466_p.func_78256_a(name) / 2;
        int x = res.func_78326_a() / 2 - width;
        int y = res.func_78328_b() / 2 + 30;
        mc.field_71466_p.func_78261_a(name, x + 20, y, this.getColor());
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }

    public void writeToPacketNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.writeToPacketNBT(nbt);
        nbt.func_74768_a(TAG_TEMPERATURE, this.temp);
        nbt.func_74768_a(TAG_DIMINISHING, this.diminishing);
        for (int i = 0; i < 4; ++i) {
            String string = "last_" + i;
            Integer n = this.lastBlocks.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            nbt.func_74768_a(string, ((Number)n).intValue());
        }
    }

    public void readFromPacketNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readFromPacketNBT(nbt);
        this.setTemp(nbt.func_74762_e(TAG_TEMPERATURE));
        this.diminishing = nbt.func_74762_e(TAG_DIMINISHING);
        for (int i = 0; i < 4; ++i) {
            this.lastBlocks.set(i, nbt.func_74762_e("last_" + i));
        }
    }

    @Nullable
    public IIcon getIcon() {
        return BotaniaAPI.getSignatureForName((String)"crysanthermum").getIconForStack(null);
    }

    static {
        Integer[] integerArray = new Integer[]{1, 2, -4, null, -2, 4, -3, 3};
        TYPES = integerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lalfheim/common/block/tile/sub/flower/SubTileCrysanthermum$Companion;", "", "<init>", "()V", "TAG_TEMPERATURE", "", "TAG_DIMINISHING", "DIFFERENTIATION", "", "RANGE", "TYPES", "", "getTYPES", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "map", "", "inp", "x1", "x2", "y1", "y2", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Integer[] getTYPES() {
            return TYPES;
        }

        private final float map(float inp, float x1, float x2, float y1, float y2) {
            float distance = (inp - x1) / (x2 - x1);
            return distance * (y2 - y1) + y1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

