/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.BlockElement;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.LocationElement;
import alexsocol.asjlib.UnsafeSchemaUtils;
import alexsocol.asjlib.extendables.block.ASJTile;
import alexsocol.asjlib.math.Vector3;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.core.asm.hook.extender.SparkExtender;
import alfheim.common.core.handler.ChunkLoadingHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lalfheim/common/block/tile/TileRealityAnchor;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "Lvazkii/botania/api/mana/spark/ISparkAttachable;", "<init>", "()V", "mana", "", "getMana", "()I", "setMana", "(I)V", "updateEntity", "", "checkStructure", "", "getCurrentMana", "isFull", "recieveMana", "canRecieveManaFromBursts", "canAttachSpark", "stack", "Lnet/minecraft/item/ItemStack;", "attachSpark", "entity", "Lvazkii/botania/api/mana/spark/ISparkEntity;", "getAvailableSpaceForMana", "getAttachedSpark", "areIncomingTranfersDone", "Companion", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nTileRealityAnchor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileRealityAnchor.kt\nalfheim/common/block/tile/TileRealityAnchor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1863#2,2:105\n774#2:107\n865#2,2:108\n*S KotlinDebug\n*F\n+ 1 TileRealityAnchor.kt\nalfheim/common/block/tile/TileRealityAnchor\n*L\n29#1:105,2\n68#1:107\n68#1:108,2\n*E\n"})
public final class TileRealityAnchor
extends ASJTile
implements ISparkAttachable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mana;
    public static final int MAX_MANA = 10000000;
    @NotNull
    private static final List<BlockElement> schema = UnsafeSchemaUtils.INSTANCE.loadStructure("alfheim/schemas/RealityAnchor");

    public final int getMana() {
        return this.mana;
    }

    public final void setMana(int n) {
        this.mana = n;
    }

    public void func_145845_h() {
        this.recieveMana(-50);
        World world = ((TileEntity)this).field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        ChunkLoadingHandler.INSTANCE.requestChunkLoad(world, ((TileEntity)this).field_145851_c >> 4, ((TileEntity)this).field_145849_e >> 4);
        ISparkEntity iSparkEntity = this.getAttachedSpark();
        if (iSparkEntity == null) {
            return;
        }
        ISparkEntity spark = iSparkEntity;
        Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)this);
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        List list = SparkHelper.getSparksAround((World)((TileEntity)this).field_145850_b, (double)x, (double)y, (double)z);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSparksAround(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ISparkEntity it = (ISparkEntity)element$iv;
            boolean bl = false;
            if (!(it.getAttachedTile() instanceof IManaPool)) continue;
            it.registerTransfer(spark);
        }
    }

    public final boolean checkStructure() {
        int n;
        IntRange intRange = ExtensionsKt.bidiRange((int)0, (int)2);
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                int n2;
                IntRange intRange2;
                int j;
                if ((j = (intRange2 = ExtensionsKt.bidiRange((int)0, (int)2)).getFirst()) <= (n2 = intRange2.getLast())) {
                    while (true) {
                        int n3;
                        IntRange intRange3;
                        int k;
                        if ((k = (intRange3 = ExtensionsKt.bidiRange((int)0, (int)2)).getFirst()) <= (n3 = intRange3.getLast())) {
                            while (true) {
                                if (Math.abs(i) == 2 || Math.abs(j) == 2 || Math.abs(k) == 2) {
                                    if (((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c + i, ((TileEntity)this).field_145848_d + j, ((TileEntity)this).field_145849_e + k) != 0) {
                                        return false;
                                    }
                                    Block block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c + i, ((TileEntity)this).field_145848_d + j, ((TileEntity)this).field_145849_e + k);
                                    BlockFluidBase blockFluidBase = block instanceof BlockFluidBase ? (BlockFluidBase)block : null;
                                    if (!Intrinsics.areEqual((Object)(blockFluidBase != null && (blockFluidBase = blockFluidBase.getFluid()) != null ? blockFluidBase.getName() : null), (Object)"mana")) {
                                        return false;
                                    }
                                }
                                if (k == n3) break;
                                ++k;
                            }
                        }
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        World world = ((TileEntity)this).field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        return UnsafeSchemaUtils.checkStructure$default((UnsafeSchemaUtils)UnsafeSchemaUtils.INSTANCE, (World)world, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, schema, null, (int)32, null);
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= 10000000;
    }

    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(10000000, this.mana + mana));
        ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public boolean canAttachSpark(@Nullable ItemStack stack) {
        return true;
    }

    public void attachSpark(@Nullable ISparkEntity entity) {
        SparkExtender.INSTANCE.attachTile(entity, this);
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, 10000000 - this.mana);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ISparkEntity getAttachedSpark() {
        void $this$filterTo$iv$iv;
        World world = ((TileEntity)this).field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        Iterable $this$filter$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, ISparkEntity.class, (AxisAlignedBB)ExtensionsKt.offset((AxisAlignedBB)ExtensionsKt.boundingBox((TileEntity)((TileEntity)this), (Number)1), (Number)0, (Number)1, (Number)0));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ISparkEntity it = (ISparkEntity)element$iv$iv;
            boolean bl = false;
            if (!(it.getAttachedTile() == this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sparks = (List)destination$iv$iv;
        return sparks.size() == 1 ? (ISparkEntity)sparks.get(0) : null;
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lalfheim/common/block/tile/TileRealityAnchor$Companion;", "", "<init>", "()V", "MAX_MANA", "", "schema", "", "Lalexsocol/asjlib/BlockElement;", "getSchema", "()Ljava/util/List;", "makeMultiblockSet", "Lvazkii/botania/api/lexicon/multiblock/MultiblockSet;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BlockElement> getSchema() {
            return schema;
        }

        @NotNull
        public final MultiblockSet makeMultiblockSet() {
            int n;
            IntRange intRange;
            Multiblock mb = new Multiblock();
            for (BlockElement ele : this.getSchema()) {
                if (ele.getBlock() == null) continue;
                intRange = ele.getLocation().iterator();
                while (intRange.hasNext()) {
                    Block block;
                    LocationElement loc = (LocationElement)intRange.next();
                    mb.addComponent(loc.getX(), loc.getY() + 4, loc.getZ(), block, loc.getMeta());
                }
            }
            IntRange intRange2 = ExtensionsKt.bidiRange((int)0, (int)2);
            int i = intRange2.getFirst();
            if (i <= (n = intRange2.getLast())) {
                while (true) {
                    int n2;
                    int j;
                    if ((j = (intRange = ExtensionsKt.bidiRange((int)0, (int)2)).getFirst()) <= (n2 = intRange.getLast())) {
                        while (true) {
                            int n3;
                            IntRange intRange3;
                            int k;
                            if ((k = (intRange3 = ExtensionsKt.bidiRange((int)0, (int)2)).getFirst()) <= (n3 = intRange3.getLast())) {
                                while (true) {
                                    if (Math.abs(i) == 2 || Math.abs(j) == 2 || Math.abs(k) == 2) {
                                        mb.addComponent(i, j + 4, k, AlfheimBlocks.INSTANCE.getManaFluidBlock(), 0);
                                    }
                                    if (k == n3) break;
                                    ++k;
                                }
                            }
                            if (j == n2) break;
                            ++j;
                        }
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            mb.setRenderOffset(0, -2, 0);
            MultiblockSet multiblockSet = mb.makeSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiblockSet, (String)"makeSet(...)");
            return multiblockSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

