/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.block.tile.TileAnomalyHarvester;
import alfheim.common.core.asm.hook.AlfheimHookHandler;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.core.util.DamageSourceSpell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.Botania;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lalfheim/common/block/tile/AnomalyHarvesterBehaviors;", "", "<init>", "()V", "doAntigrav", "", "tile", "Lalfheim/common/block/tile/TileAnomalyHarvester;", "doGravity", "doTunnel", "doLightning", "doKiller", "doSpeedUp", "doWarp", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nTileAnomalyHarvester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileAnomalyHarvester.kt\nalfheim/common/block/tile/AnomalyHarvesterBehaviors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,492:1\n1863#2,2:493\n1863#2,2:495\n1863#2,2:497\n1863#2,2:500\n1863#2,2:502\n865#2,2:504\n1#3:499\n*S KotlinDebug\n*F\n+ 1 TileAnomalyHarvester.kt\nalfheim/common/block/tile/AnomalyHarvesterBehaviors\n*L\n301#1:493,2\n320#1:495,2\n362#1:497,2\n437#1:500,2\n444#1:502,2\n473#1:504,2\n*E\n"})
public final class AnomalyHarvesterBehaviors {
    @NotNull
    public static final AnomalyHarvesterBehaviors INSTANCE = new AnomalyHarvesterBehaviors();

    private AnomalyHarvesterBehaviors() {
    }

    private final int doAntigrav(TileAnomalyHarvester tile) {
        if (tile.func_145831_w().field_72995_K) {
            AlfheimHookHandler.INSTANCE.setWispNoclip(false);
            for (int c = 0; c < 4; ++c) {
                Vector3 vector3 = tile.getRadius().copy().mul(Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null)).add(tile.getOffset());
                double x = vector3.component1();
                double y = vector3.component2();
                double z = vector3.component3();
                Botania.proxy.wispFX(tile.func_145831_w(), (double)((TileEntity)tile).field_145851_c + x + 0.5, (double)((TileEntity)tile).field_145848_d + y - 0.5, (double)((TileEntity)tile).field_145849_e + z + 0.5, 0.5f, 0.9f, 1.0f, 0.1f, -0.1f, 1.0f);
            }
            AlfheimHookHandler.INSTANCE.setWispNoclip(true);
            return 0;
        }
        int applications = 0;
        AxisAlignedBB aabb = tile.getAoE();
        World world = tile.func_145831_w();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)aabb);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            it.field_70181_x = it.field_70181_x + (it.func_70093_af() ? 0.05 : 0.085 + (double)tile.getPower() * 0.005);
            it.field_70143_R = 0.0f;
            ++applications;
        }
        return applications * tile.getPower();
    }

    public final int doGravity(@NotNull TileAnomalyHarvester tile) {
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)tile).add(tile.getOffset());
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        if (tile.func_145831_w().field_72995_K) {
            Botania.proxy.wispFX(tile.func_145831_w(), x, y, z, 1.0f, 1.0f, 1.0f, 0.5f, 0.0f, 0.5f);
            return 0;
        }
        int applications = 0;
        World world = tile.func_145831_w();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)tile.getAoE());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            if (it instanceof EntityPlayer && ((EntityPlayer)it).field_71075_bZ.field_75102_a || it.func_70093_af()) continue;
            Vector3 vector32 = Vector3.mul$default((Vector3)new Vector3((Number)x, (Number)y, (Number)z).sub(Vector3.Companion.fromEntity(it)).normalize(), (Number)(0.1 * (double)tile.getPower()), null, null, (int)6, null);
            double mx = vector32.component1();
            double my = vector32.component2();
            double mz = vector32.component3();
            it.field_70159_w += mx;
            it.field_70181_x += my;
            it.field_70179_y += mz;
            it.field_70143_R = 0.0f;
            if (it instanceof EntityPlayerMP) {
                ((EntityPlayerMP)it).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(it));
            }
            ++applications;
        }
        return applications * tile.getPower();
    }

    public final int doTunnel(@NotNull TileAnomalyHarvester tile) {
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        Intrinsics.checkNotNullExpressionValue((Object)ForgeDirection.VALID_DIRECTIONS, (String)"VALID_DIRECTIONS");
        ForgeDirection dir = (ForgeDirection)ExtensionsKt.safeGet((Object[])ForgeDirection.VALID_DIRECTIONS, (int)tile.func_145831_w().func_72805_g(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e));
        float mX = (float)dir.offsetX / 10.0f;
        float mY = (float)dir.offsetY / 10.0f;
        float mZ = (float)dir.offsetZ / 10.0f;
        if (tile.func_145831_w().field_72995_K) {
            AlfheimHookHandler.INSTANCE.setWispNoclip(false);
            for (int c = 0; c < 4; ++c) {
                Vector3 vector3 = tile.getRadius().copy().mul(Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null)).add(tile.getOffset());
                double x = vector3.component1();
                double y = vector3.component2();
                double z = vector3.component3();
                Botania.proxy.wispFX(tile.func_145831_w(), (double)((TileEntity)tile).field_145851_c + x + 0.5 - (double)(mX * (float)10), (double)((TileEntity)tile).field_145848_d + y + 0.5 - (double)(mY * (float)10), (double)((TileEntity)tile).field_145849_e + z + 0.5 - (double)(mZ * (float)10), 0.3f, 0.9f, 0.8f, 0.1f, mX, mY, mZ, 1.0f);
            }
            AlfheimHookHandler.INSTANCE.setWispNoclip(true);
            return 0;
        }
        int applications = 0;
        AxisAlignedBB aabb = tile.getAoE();
        World world = tile.func_145831_w();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
        Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)aabb);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            it.field_70159_w = (double)(mX * (float)tile.getPower()) / 2.0;
            it.field_70181_x = (double)(mY * (float)tile.getPower()) / 2.0;
            it.field_70179_y = (double)(mZ * (float)tile.getPower()) / 2.0;
            it.field_70143_R = 0.0f;
            ++applications;
            if (!(it instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)it).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(it));
        }
        return applications * tile.getPower();
    }

    public final int doLightning(@NotNull TileAnomalyHarvester tile) {
        block4: {
            IMob it;
            double z;
            double y;
            double x;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
                    Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)tile).add(tile.getOffset());
                    x = vector3.component1();
                    y = vector3.component2();
                    z = vector3.component3();
                    if (tile.func_145831_w().field_72995_K) {
                        Vector3 vector32 = Vector3.sub$default((Vector3)new Vector3((Number)x, (Number)y, (Number)z).rand(), (Number)0.5, null, null, (int)6, null);
                        double i = vector32.component1();
                        double j = vector32.component2();
                        double k = vector32.component3();
                        Botania.proxy.lightningFX(tile.func_145831_w(), new vazkii.botania.common.core.helper.Vector3(x, y, z), new vazkii.botania.common.core.helper.Vector3(i, j, k), 1.0f, 0, 0xFF0000);
                        return 0;
                    }
                    World world = tile.func_145831_w();
                    Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
                    Collection collection = ExtensionsKt.getEntitiesWithinAABB((World)world, IMob.class, (AxisAlignedBB)tile.getAoE());
                    Random random = tile.func_145831_w().field_73012_v;
                    Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
                    IMob iMob = (IMob)ExtensionsKt.random((Collection)collection, (Random)random);
                    if (iMob == null) break block4;
                    it = iMob;
                    boolean bl = false;
                    Entity cfr_ignored_0 = (Entity)it;
                    if (!(it instanceof EntityCreeper) || ((EntityCreeper)it).func_70830_n()) break block5;
                    ((EntityCreeper)it).func_70096_w().func_75692_b(17, (Object)1);
                    break block6;
                }
                if (!((Entity)it).func_70097_a(DamageSourceSpell.Companion.getAnomaly(), ExtensionsKt.getF((Number)Math.random()) * (float)tile.getPower() / 2.0f + (float)tile.getPower() / 2.0f)) break block4;
            }
            Vector3 vector3 = Vector3.Companion.fromEntityCenter((Entity)it);
            double i = vector3.component1();
            double j = vector3.component2();
            double k = vector3.component3();
            double[] dArray = new double[]{x, y, z, i, j, k, 1.0, 0.0, ExtensionsKt.getD((Number)0xFF0000)};
            VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.LIGHTNING, tile.func_145831_w().field_73011_w.field_76574_g, dArray);
            return tile.getPower();
        }
        return 0;
    }

    public final int doKiller(@NotNull TileAnomalyHarvester tile) {
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)tile).add(tile.getOffset());
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        if (tile.func_145831_w().field_72995_K) {
            Botania.proxy.sparkleFX(tile.func_145831_w(), x, y, z, 1.0f, 0.0f, 0.0f, 2.0f, 1, true);
            Botania.proxy.sparkleFX(tile.func_145831_w(), x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, 1, true);
            return 0;
        }
        World world = tile.func_145831_w();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
        Collection collection = ExtensionsKt.getEntitiesWithinAABB((World)world, EntityLivingBase.class, (AxisAlignedBB)tile.getAoE());
        Random random = tile.func_145831_w().field_73012_v;
        Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
        EntityLivingBase entityLivingBase = (EntityLivingBase)ExtensionsKt.random((Collection)collection, (Random)random);
        if (entityLivingBase != null) {
            EntityLivingBase it = entityLivingBase;
            boolean bl = false;
            if (it.func_70097_a(DamageSourceSpell.Companion.getAnomaly(), ExtensionsKt.getF((Number)(Math.random() * (double)tile.getPower() / (double)2 + (double)(tile.getPower() / 2))))) {
                return tile.getPower();
            }
        }
        return 0;
    }

    public final int doSpeedUp(@NotNull TileAnomalyHarvester tile) {
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        if (tile.func_145831_w().field_72995_K) {
            Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)tile).add(tile.getRadius().copy().mul(Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null))).add(tile.getOffset());
            double x = vector3.component1();
            double y = vector3.component2();
            double z = vector3.component3();
            Botania.proxy.sparkleFX(tile.func_145831_w(), x, y, z, 0.5f, 1.0f, 0.5f, 1.0f, 1, true);
        }
        int applications = 0;
        AxisAlignedBB aabb = tile.getAoE();
        int n = ExtensionsKt.getI((Number)tile.getPower());
        for (int i = 0; i < n; ++i) {
            Object it;
            World world = tile.func_145831_w();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
            Iterable $this$forEach$iv = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)aabb);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Entity)element$iv;
                boolean bl = false;
                if (!it.func_70089_S()) continue;
                ++applications;
                it.func_70071_h_();
            }
            List list = tile.func_145831_w().field_147482_g;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadedTileEntityList");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.tileentity.TileEntity");
                TileEntity cfr_ignored_0 = (TileEntity)it;
                if (!aabb.func_72318_a(Vector3.add$default((Vector3)Vector3.Companion.fromTileEntity((TileEntity)it), (Number)0.5, null, null, (int)6, null).toVec3()) || !((TileEntity)it).canUpdate()) continue;
                ((TileEntity)it).func_145845_h();
                ++applications;
            }
        }
        int x = ExtensionsKt.getI((Number)aabb.field_72340_a);
        if (x <= (n = ExtensionsKt.getI((Number)aabb.field_72336_d) - 1)) {
            while (true) {
                int n2;
                int y;
                if ((y = ExtensionsKt.getI((Number)aabb.field_72338_b)) <= (n2 = ExtensionsKt.getI((Number)aabb.field_72337_e) - 1)) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = ExtensionsKt.getI((Number)aabb.field_72339_c)) <= (n3 = ExtensionsKt.getI((Number)aabb.field_72334_f) - 1)) {
                            while (true) {
                                Block block;
                                if ((block = tile.func_145831_w().func_147439_a(x, y, z)) != Blocks.field_150350_a && (!(block instanceof BlockFire) || tile.func_145831_w().func_82736_K().func_82766_b("doFireTick"))) {
                                    block.func_149674_a(tile.func_145831_w(), x, y, z, tile.func_145831_w().field_73012_v);
                                }
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return applications * tile.getPower();
    }

    /*
     * WARNING - void declaration
     */
    public final int doWarp(@NotNull TileAnomalyHarvester tile) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        if (tile.func_145831_w().field_72995_K) {
            Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)tile).add(tile.getRadius().copy().mul(Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null))).add(tile.getOffset());
            double x = vector3.component1();
            double y = vector3.component2();
            double z = vector3.component3();
            tile.func_145831_w().func_72869_a("portal", x, y, z, 0.0, 0.0, 0.0);
            return 0;
        }
        World world = tile.func_145831_w();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorldObj(...)");
        Iterable x = ExtensionsKt.getEntitiesWithinAABB((World)world, Entity.class, (AxisAlignedBB)tile.getAoE());
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            if (!(!it.func_70093_af())) continue;
            destination$iv.add(element$iv);
        }
        ArrayList applicable = (ArrayList)destination$iv;
        if (applicable.isEmpty()) {
            return 0;
        }
        Entity entity = (Entity)ExtensionsKt.removeRandom((Collection)applicable);
        if (entity == null) {
            return 0;
        }
        Entity target = entity;
        ForgeDirection d = (ForgeDirection)EntriesMappings.entries$0.get(tile.func_145832_p());
        Vector3 vector3 = Vector3.Companion.fromTileEntityCenter((TileEntity)tile).add((Number)d.offsetX, (Number)d.offsetY, (Number)d.offsetZ);
        double x2 = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        int cost = ExtensionsKt.mfloor((double)Vector3.Companion.vecEntityDistance(new Vector3((Number)x2, (Number)y, (Number)z), target)) * 10;
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70634_a(x2, y, z);
        } else {
            target.func_70107_b(x2, y, z);
        }
        ExtensionsKt.setMotion$default((Entity)target, (double)0.0, (double)0.0, (double)0.0, (int)6, null);
        return cost;
    }

    private static final int _init_$lambda$0(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doAntigrav((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$1(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doGravity((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$2(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doTunnel((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$3(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doLightning((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$4(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doKiller((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$5(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doSpeedUp((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$6(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.doWarp((TileAnomalyHarvester)it);
    }

    private static final int _init_$lambda$7(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    private static final int _init_$lambda$8(TileEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    static {
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("Antigrav", new AlfheimAPI.AnomalyBehavior(1, 10, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$0)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("Gravity", new AlfheimAPI.AnomalyBehavior(1, 10, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$1)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("Tunnel", new AlfheimAPI.AnomalyBehavior(2, 20, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$2)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("Lightning", new AlfheimAPI.AnomalyBehavior(1, 12, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$3)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("Killer", new AlfheimAPI.AnomalyBehavior(1, 15, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$4)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("SpeedUp", new AlfheimAPI.AnomalyBehavior(10, 100, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$5)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("Warp", new AlfheimAPI.AnomalyBehavior(1, 1, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$6)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("ManaTornado", new AlfheimAPI.AnomalyBehavior(0, 0, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$7)));
        ((Map)AlfheimAPI.INSTANCE.getAnomalyBehaviors()).put("ManaVoid", new AlfheimAPI.AnomalyBehavior(0, 0, (Function1<? super TileEntity, Integer>)((Function1)AnomalyHarvesterBehaviors::_init_$lambda$8)));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ForgeDirection> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ForgeDirection.values()));
        }
    }
}

