/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.magtrees.sealing;

import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.common.block.magtrees.sealing.ISoundSilencer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lalfheim/common/block/magtrees/sealing/EventHandlerSealingOak;", "", "<init>", "()V", "MAXRANGE", "", "onSound", "", "event", "Lnet/minecraftforge/client/event/sound/PlaySoundEvent17;", "calculateMultiplier", "", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "VolumeModSound", "Alfheim"})
public final class EventHandlerSealingOak {
    @NotNull
    public static final EventHandlerSealingOak INSTANCE = new EventHandlerSealingOak();
    public static final int MAXRANGE = 16;

    private EventHandlerSealingOak() {
    }

    @SubscribeEvent
    public final void onSound(@NotNull PlaySoundEvent17 event) {
        int z;
        int y;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.result == null || event.result instanceof ITickableSound) {
            return;
        }
        WorldClient worldClient = ExtensionsClientKt.getMc().field_71441_e;
        if (worldClient == null) {
            return;
        }
        WorldClient world = worldClient;
        int x = ExtensionsKt.getI((Number)Float.valueOf(event.result.func_147649_g()));
        float volumeMultiplier = this.calculateMultiplier((World)world, x, y = ExtensionsKt.getI((Number)Float.valueOf(event.result.func_147654_h())), z = ExtensionsKt.getI((Number)Float.valueOf(event.result.func_147651_i())));
        if (volumeMultiplier == 1.0f) {
            return;
        }
        ISound iSound = event.result;
        Intrinsics.checkNotNullExpressionValue((Object)iSound, (String)"result");
        event.result = new VolumeModSound(iSound, volumeMultiplier);
    }

    public final float calculateMultiplier(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        float volumeMultiplier = 1.0f;
        IntRange intRange = ExtensionsKt.bidiRange((int)x, (int)16);
        int dx = intRange.getFirst();
        int n = intRange.getLast();
        if (dx <= n) {
            while (true) {
                int n2;
                IntRange intRange2;
                int dy;
                if ((dy = (intRange2 = ExtensionsKt.bidiRange((int)y, (int)16)).getFirst()) <= (n2 = intRange2.getLast())) {
                    while (true) {
                        int n3;
                        IntRange intRange3;
                        int dz;
                        if ((dz = (intRange3 = ExtensionsKt.bidiRange((int)z, (int)16)).getFirst()) <= (n3 = intRange3.getLast())) {
                            while (true) {
                                double distance;
                                Block block;
                                if ((block = world.func_147439_a(dx, dy, dz)) instanceof ISoundSilencer && !((distance = Vector3.Companion.pointDistanceSpace((Number)((double)dx + 0.5), (Number)((double)dy + 0.5), (Number)((double)dz + 0.5), (Number)x, (Number)y, (Number)z)) > 16.0) && ((ISoundSilencer)block).canSilence(world, dx, dy, dz, distance)) {
                                    volumeMultiplier *= ((ISoundSilencer)block).getVolumeMultiplier(world, dx, dy, dz, distance);
                                }
                                if (dz == n3) break;
                                ++dz;
                            }
                        }
                        if (dy == n2) break;
                        ++dy;
                    }
                }
                if (dx == n) break;
                ++dx;
            }
        }
        return volumeMultiplier;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lalfheim/common/block/magtrees/sealing/EventHandlerSealingOak$VolumeModSound;", "Lnet/minecraft/client/audio/ISound;", "sound", "volumeMult", "", "<init>", "(Lnet/minecraft/client/audio/ISound;F)V", "getSound", "()Lnet/minecraft/client/audio/ISound;", "getVolumeMult", "()F", "getPositionedSoundLocation", "Lnet/minecraft/util/ResourceLocation;", "canRepeat", "", "getRepeatDelay", "", "getVolume", "getPitch", "getXPosF", "getYPosF", "getZPosF", "getAttenuationType", "Lnet/minecraft/client/audio/ISound$AttenuationType;", "Alfheim"})
    public static final class VolumeModSound
    implements ISound {
        @NotNull
        private final ISound sound;
        private final float volumeMult;

        public VolumeModSound(@NotNull ISound sound, float volumeMult) {
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            this.sound = sound;
            this.volumeMult = volumeMult;
        }

        @NotNull
        public final ISound getSound() {
            return this.sound;
        }

        public final float getVolumeMult() {
            return this.volumeMult;
        }

        @NotNull
        public ResourceLocation func_147650_b() {
            ResourceLocation resourceLocation = this.sound.func_147650_b();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getPositionedSoundLocation(...)");
            return resourceLocation;
        }

        public boolean func_147657_c() {
            return this.sound.func_147657_c();
        }

        public int func_147652_d() {
            return this.sound.func_147652_d();
        }

        public float func_147653_e() {
            return this.sound.func_147653_e() * this.volumeMult;
        }

        public float func_147655_f() {
            return this.sound.func_147655_f();
        }

        public float func_147649_g() {
            return this.sound.func_147649_g();
        }

        public float func_147654_h() {
            return this.sound.func_147654_h();
        }

        public float func_147651_i() {
            return this.sound.func_147651_i();
        }

        @NotNull
        public ISound.AttenuationType func_147656_j() {
            ISound.AttenuationType attenuationType = this.sound.func_147656_j();
            Intrinsics.checkNotNullExpressionValue((Object)attenuationType, (String)"getAttenuationType(...)");
            return attenuationType;
        }
    }
}

