/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.client.core.helper.IconHelper;
import alfheim.common.block.base.BlockContainerMod;
import alfheim.common.block.tile.TileTreeBerry;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.material.ElvenFoodMetas;
import alfheim.common.lexicon.AlfheimLexiconData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001JB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J0\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0016J&\u0010%\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J(\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J(\u0010(\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J(\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J(\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J0\u0010+\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0005H\u0016J,\u0010-\u001a\u0004\u0018\u00010.2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020\u0017H\u0016J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u00020\u0007H\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0016J$\u00107\u001a\u0004\u0018\u0001082\u0006\u0010 \u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u00109\u001a\u00020\u0007H\u0016J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010;\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\"\u0010;\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u001a\u0010<\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J8\u0010=\u001a\u00020>2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J*\u0010C\u001a\u00020D2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J(\u0010E\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J(\u0010F\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J>\u0010G\u001a\b\u0012\u0004\u0012\u00020B0H2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006K"}, d2={"Lalfheim/common/block/BlockTreeBerry;", "Lalfheim/common/block/base/BlockContainerMod;", "Lvazkii/botania/api/lexicon/ILexiconable;", "Lnet/minecraftforge/common/IPlantable;", "leaves", "Lnet/minecraft/block/Block;", "type", "", "<init>", "(Lnet/minecraft/block/Block;I)V", "getLeaves", "()Lnet/minecraft/block/Block;", "getType", "()I", "icons", "", "Lnet/minecraft/util/IIcon;", "getIcons", "()[Lnet/minecraft/util/IIcon;", "setIcons", "([Lnet/minecraft/util/IIcon;)V", "[Lnet/minecraft/util/IIcon;", "isReplaceable", "", "world", "Lnet/minecraft/world/IBlockAccess;", "x", "y", "z", "createNewTileEntity", "Lalfheim/common/block/tile/TileTreeBerry;", "Lnet/minecraft/world/World;", "meta", "updateTick", "", "random", "Ljava/util/Random;", "checkChange", "getSelectedBoundingBoxFromPool", "Lnet/minecraft/util/AxisAlignedBB;", "setBlockBoundsBasedOnState", "canBlockStay", "canPlaceBlockAt", "onNeighborBlockChange", "block", "getCollisionBoundingBoxFromPool", "", "isOpaqueCube", "renderAsNormalBlock", "getRenderType", "registerBlockIcons", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "getIcon", "side", "getItemDropped", "Lnet/minecraft/item/Item;", "fortune", "damageDropped", "quantityDropped", "quantityDroppedWithBonus", "getEntry", "Lvazkii/botania/api/lexicon/LexiconEntry;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "lexicon", "Lnet/minecraft/item/ItemStack;", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "getPlant", "getPlantMetadata", "getDrops", "Ljava/util/ArrayList;", "metadata", "Companion", "Alfheim"})
public final class BlockTreeBerry
extends BlockContainerMod
implements ILexiconable,
IPlantable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Block leaves;
    private final int type;
    public IIcon[] icons;
    @NotNull
    private static final HashMap<Integer, Boolean> hasModelErrors;

    public BlockTreeBerry(@NotNull Block leaves, int type2) {
        Intrinsics.checkNotNullParameter((Object)leaves, (String)"leaves");
        Material material = Material.field_151582_l;
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"vine");
        super(material);
        this.leaves = leaves;
        this.type = type2;
        this.func_149663_c("TreeBerry" + this.type);
        this.func_149711_c(0.0f);
        this.func_149672_a(BlockContainer.field_149779_h);
    }

    @NotNull
    public final Block getLeaves() {
        return this.leaves;
    }

    public final int getType() {
        return this.type;
    }

    @NotNull
    public final IIcon[] getIcons() {
        if (this.icons != null) {
            return this.icons;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"icons");
        return null;
    }

    public final void setIcons(@NotNull IIcon[] iIconArray) {
        Intrinsics.checkNotNullParameter((Object)iIconArray, (String)"<set-?>");
        this.icons = iIconArray;
    }

    public boolean isReplaceable(@Nullable IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @NotNull
    public TileTreeBerry createNewTileEntity(@Nullable World world, int meta) {
        return new TileTreeBerry();
    }

    public void func_149674_a(@NotNull World world, int x, int y, int z, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.checkChange(world, x, y, z);
        if (random.nextInt(10) != 0) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 2) {
            return;
        }
        world.func_72921_c(x, y, z, meta + 1, 3);
    }

    public final void checkChange(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.func_149718_j(world, x, y, z)) {
            return;
        }
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    @NotNull
    public AxisAlignedBB func_149633_g(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.func_149719_a((IBlockAccess)world, x, y, z);
        AxisAlignedBB axisAlignedBB = super.func_149633_g(world, x, y, z);
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"getSelectedBoundingBoxFromPool(...)");
        return axisAlignedBB;
    }

    public void func_149719_a(@NotNull IBlockAccess world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Block block = world.func_147439_a(x, y, z);
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                block.func_149676_a(0.28125f, 0.5625f, 0.28125f, 0.71875f, 1.0f, 0.71875f);
                break;
            }
            case 1: {
                block.func_149676_a(0.21875f, 0.375f, 0.21875f, 0.78125f, 1.0f, 0.78125f);
                break;
            }
            default: {
                block.func_149676_a(0.15625f, 0.125f, 0.15625f, 0.84375f, 1.0f, 0.84375f);
            }
        }
    }

    public boolean func_149718_j(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return world.func_147439_a(x, y + 1, z) == this.leaves;
    }

    public boolean func_149742_c(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.func_149718_j(world, x, y, z);
    }

    public void func_149695_a(@NotNull World world, int x, int y, int z, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.checkChange(world, x, y, z);
    }

    @Nullable
    public Void getCollisionBoundingBoxFromPool(@Nullable World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return AlfheimConfigHandler.INSTANCE.getMinimalGraphics() || Intrinsics.areEqual((Object)hasModelErrors.get(this.type), (Object)true) ? 1 : -1;
    }

    @Override
    public void func_149651_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
        int n = 0;
        IIcon[] iIconArray = new IIcon[3];
        BlockTreeBerry blockTreeBerry = this;
        while (n < 3) {
            int n2 = n++;
            iIconArray[n2] = IconHelper.INSTANCE.forBlock(reg, (Block)this, n2);
        }
        blockTreeBerry.setIcons(iIconArray);
    }

    @NotNull
    public IIcon func_149691_a(int side, int meta) {
        return (IIcon)ExtensionsKt.safeGet((Object[])this.getIcons(), (int)meta);
    }

    @Nullable
    public Item func_149650_a(int meta, @Nullable Random random, int fortune) {
        return meta >= 2 ? AlfheimItems.INSTANCE.getElvenFood() : null;
    }

    public int func_149692_a(int meta) {
        return meta >= 2 ? ElvenFoodMetas.TreeBerryBarrier.ordinal() + this.type : 0;
    }

    public int func_149745_a(@Nullable Random random) {
        return 1;
    }

    public int quantityDropped(int meta, int fortune, @Nullable Random random) {
        return meta >= 2 ? 1 : 0;
    }

    public int func_149679_a(int meta, @Nullable Random random) {
        return meta >= 2 ? 1 : 0;
    }

    @NotNull
    public LexiconEntry getEntry(@NotNull World world, int x, int y, int z, @NotNull EntityPlayer player, @NotNull ItemStack lexicon) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)lexicon, (String)"lexicon");
        return AlfheimLexiconData.INSTANCE.getTreeBerry();
    }

    @NotNull
    public EnumPlantType getPlantType(@Nullable IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    @NotNull
    public Block getPlant(@NotNull IBlockAccess world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Block block = world.func_147439_a(x, y, z);
        Intrinsics.checkNotNull((Object)block);
        return block;
    }

    public int getPlantMetadata(@NotNull IBlockAccess world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return world.func_72805_g(x, y, z);
    }

    @NotNull
    public ArrayList<ItemStack> getDrops(@NotNull World world, int x, int y, int z, int metadata, int fortune) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new ItemStack[1];
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        if (item == null) {
            return new ArrayList<ItemStack>();
        }
        objectArray[0] = new ItemStack(item, this.quantityDropped(metadata, fortune, world.field_73012_v), this.func_149692_a(metadata));
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)true), TuplesKt.to((Object)1, (Object)true), TuplesKt.to((Object)5, (Object)true)};
        hasModelErrors = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lalfheim/common/block/BlockTreeBerry$Companion;", "", "<init>", "()V", "hasModelErrors", "Ljava/util/HashMap;", "", "", "getHasModelErrors", "()Ljava/util/HashMap;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<Integer, Boolean> getHasModelErrors() {
            return hasModelErrors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

