/*
 * Decompiled with CFR 0.152.
 */
package alfheim.api.item;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.api.item.IPriestColorOverride;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.ICosmeticAttachable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lalfheim/api/item/ColorOverrideHelper;", "", "<init>", "()V", "getColor", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "fallback", "Alfheim"})
public final class ColorOverrideHelper {
    @NotNull
    public static final ColorOverrideHelper INSTANCE = new ColorOverrideHelper();

    private ColorOverrideHelper() {
    }

    public final int getColor(@Nullable EntityPlayer player) {
        int r = 0;
        int b = 0;
        int g = 0;
        int colors = 0;
        if (player != null) {
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < 4; ++i) {
                Intrinsics.checkNotNull((Object)baubles);
                ItemStack stack = ExtensionsKt.get((IInventory)((IInventory)baubles), (int)i);
                if (stack != null && stack.func_77973_b() instanceof IPriestColorOverride) {
                    Item item = stack.func_77973_b();
                    Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type alfheim.api.item.IPriestColorOverride");
                    int stackColor = ((IPriestColorOverride)item).colorOverride(stack);
                    if (stackColor == -1) continue;
                    Color color = new Color(stackColor);
                    r += color.getRed();
                    g += color.getGreen();
                    b += color.getBlue();
                    ++colors;
                    continue;
                }
                if (stack == null || !(stack.func_77973_b() instanceof ICosmeticAttachable)) continue;
                Item item = stack.func_77973_b();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type vazkii.botania.api.item.ICosmeticAttachable");
                if (((ICosmeticAttachable)item).getCosmeticItem(stack) == null) continue;
                Item item2 = stack.func_77973_b();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type vazkii.botania.api.item.ICosmeticAttachable");
                ItemStack cosmeticStack = ((ICosmeticAttachable)item2).getCosmeticItem(stack);
                if (cosmeticStack == null || !(cosmeticStack.func_77973_b() instanceof IPriestColorOverride)) continue;
                Item item3 = cosmeticStack.func_77973_b();
                Intrinsics.checkNotNull((Object)item3, (String)"null cannot be cast to non-null type alfheim.api.item.IPriestColorOverride");
                int stackColor = ((IPriestColorOverride)item3).colorOverride(cosmeticStack);
                if (stackColor == -1) continue;
                Color color = new Color(stackColor);
                r += color.getRed();
                g += color.getGreen();
                b += color.getBlue();
                ++colors;
            }
        }
        return colors == 0 ? -1 : new Color(r / colors, g / colors, b / colors).getRGB();
    }

    public final int getColor(@NotNull EntityPlayer player, int fallback) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int color = this.getColor(player);
        return color != -1 ? color : fallback;
    }
}

