/*
 * Decompiled with CFR 0.152.
 */
package alfheim.api;

import alexsocol.asjlib.ASJUtilities;
import alfheim.api.block.tile.SubTileAnomalyBase;
import alfheim.api.crafting.recipe.RecipeManaInfuser;
import alfheim.api.crafting.recipe.RecipeTreeCrafting;
import alfheim.api.crafting.recipe.TunerIncantation;
import alfheim.api.entity.EnumRace;
import alfheim.api.item.ThrowableCollidingItem;
import alfheim.api.lib.LibResourceLocations;
import alfheim.api.spell.SpellBase;
import alfheim.api.trees.IIridescentSaplingVariant;
import alfheim.api.trees.IridescentSaplingBaseVariant;
import alfheim.api.world.domain.Domain;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.EnumHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u00c0\u0001\u00c1\u0001\u00c2\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010n\u001a\u0004\u0018\u00010/2\b\u0010o\u001a\u0004\u0018\u00010/J/\u0010n\u001a\u00020/2\u0006\u0010p\u001a\u00020+2\u0006\u0010q\u001a\u0002032\u0012\u0010r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010s\"\u00020\u0001\u00a2\u0006\u0002\u0010tJ\u0012\u0010u\u001a\u0004\u0018\u00010/2\b\u0010o\u001a\u0004\u0018\u00010/J\u0010\u0010u\u001a\u0004\u0018\u00010/2\u0006\u0010p\u001a\u00020+J\u000e\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020+J\u000e\u0010y\u001a\u00020w2\u0006\u0010x\u001a\u00020+J\u001d\u0010z\u001a\u0004\u0018\u0001032\u0006\u0010{\u001a\u00020+2\u0006\u0010|\u001a\u000203\u00a2\u0006\u0002\u0010}J\u000e\u00104\u001a\u0002032\u0006\u0010~\u001a\u00020+J\u0010\u0010\u007f\u001a\u00030\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u000208J\u0017\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u0002080\u0083\u00012\u0007\u0010\u0084\u0001\u001a\u00020<J\u0012\u0010\u0085\u0001\u001a\u0004\u0018\u0001082\u0007\u0010\u0086\u0001\u001a\u00020@J\u001b\u0010\u0087\u0001\u001a\u0004\u0018\u0001082\u0007\u0010\u0088\u0001\u001a\u0002032\u0007\u0010\u0089\u0001\u001a\u000203J\u0010\u0010\u008a\u0001\u001a\u0002032\u0007\u0010\u0081\u0001\u001a\u000208J^\u0010\u008b\u0001\u001a\t\u0012\u0005\u0012\u0003H\u008c\u00010B\"\u000b\b\u0000\u0010\u008c\u0001\u0018\u0001*\u00020\u00012\u0007\u0010\u008d\u0001\u001a\u00020@2\u0013\u0010\u008e\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010s\"\u00020\u00012\u0017\b\b\u0010\u008f\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u008c\u0001\u0012\u0004\u0012\u00020w0\u0090\u0001H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0091\u0001JE\u0010\u0092\u0001\u001a\u00020w\"\u0005\b\u0000\u0010\u0093\u0001\"\u0005\b\u0001\u0010\u0094\u0001*\u0011\u0012\u0005\u0012\u0003H\u0093\u0001\u0012\u0005\u0012\u0003H\u0094\u00010\u0095\u00012\b\u0010\u0096\u0001\u001a\u0003H\u0093\u00012\b\u0010\u0097\u0001\u001a\u0003H\u0094\u0001H\u0086\u0002\u00a2\u0006\u0003\u0010\u0098\u0001J>\u0010\u0099\u0001\u001a\u00030\u0080\u0001\"\f\b\u0000\u0010\u008c\u0001\u0018\u0001*\u00030\u009a\u00012\u0007\u0010\u0086\u0001\u001a\u00020@2\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\u0007\u0010\u009d\u0001\u001a\u0002032\u0007\u0010\u009e\u0001\u001a\u000203H\u0086\bJ\u0010\u0010\u009f\u0001\u001a\u00020F2\u0007\u0010\u0086\u0001\u001a\u00020@J#\u0010\u00a0\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0086\u0001\u001a\u00020@2\u0007\u0010\u00a1\u0001\u001a\u0002032\u0007\u0010\u00a2\u0001\u001a\u000203J\u0019\u0010\u00a3\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00a4\u0001\u001a\u00020@2\u0006\u0010|\u001a\u000203J\u0019\u0010\u00a5\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00a4\u0001\u001a\u00020@2\u0006\u0010|\u001a\u000203J\u0010\u0010\u00a6\u0001\u001a\u00020`2\u0007\u0010\u00a7\u0001\u001a\u00020`JG\u0010\u00a6\u0001\u001a\u00020`2\u0006\u0010q\u001a\u0002032\u0007\u0010\u00a8\u0001\u001a\u00020+2\t\u0010\u00a9\u0001\u001a\u0004\u0018\u00010@2\u0007\u0010\u00aa\u0001\u001a\u00020+2\u0013\u0010\u008e\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010s\"\u00020\u0001\u00a2\u0006\u0003\u0010\u00ab\u0001JP\u0010\u00a6\u0001\u001a\u00020`2\u0006\u0010q\u001a\u0002032\u0007\u0010\u00a8\u0001\u001a\u00020+2\t\u0010\u00a9\u0001\u001a\u0004\u0018\u00010@2\u0007\u0010\u00aa\u0001\u001a\u00020+2\u0007\u0010\u00ac\u0001\u001a\u0002032\u0013\u0010\u008e\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010s\"\u00020\u0001\u00a2\u0006\u0003\u0010\u00ad\u0001J\u0013\u0010\u00ae\u0001\u001a\u0004\u0018\u00010`2\b\u0010o\u001a\u0004\u0018\u00010`J\u0011\u0010\u00ae\u0001\u001a\u0004\u0018\u00010`2\u0006\u0010p\u001a\u00020+J\u0010\u0010\u00af\u0001\u001a\u00020d2\u0007\u0010\u00b0\u0001\u001a\u00020dJ\"\u0010\u00af\u0001\u001a\u00020d2\u0007\u0010\u00b1\u0001\u001a\u00020Y2\u0007\u0010\u00b2\u0001\u001a\u00020Y2\u0007\u0010\u00b3\u0001\u001a\u00020YJ+\u0010\u00af\u0001\u001a\u00020d2\u0007\u0010\u00b1\u0001\u001a\u00020Y2\u0007\u0010\u00b2\u0001\u001a\u00020Y2\u0007\u0010\u00b3\u0001\u001a\u00020Y2\u0007\u0010\u00b4\u0001\u001a\u000203J4\u0010\u00af\u0001\u001a\u00020d2\u0007\u0010\u00b1\u0001\u001a\u00020Y2\u0007\u0010\u00b2\u0001\u001a\u00020Y2\u0007\u0010\u00b3\u0001\u001a\u00020Y2\u0007\u0010\u00b5\u0001\u001a\u0002032\u0007\u0010\u00b6\u0001\u001a\u000203J=\u0010\u00af\u0001\u001a\u00020d2\u0007\u0010\u00b1\u0001\u001a\u00020Y2\u0007\u0010\u00b2\u0001\u001a\u00020Y2\u0007\u0010\u00b3\u0001\u001a\u00020Y2\u0007\u0010\u00b5\u0001\u001a\u0002032\u0007\u0010\u00b6\u0001\u001a\u0002032\u0007\u0010\u00b7\u0001\u001a\u000203J\u0010\u0010\u00b8\u0001\u001a\u00020h2\u0007\u0010\u00b9\u0001\u001a\u00020hJ\u0010\u0010\u00ba\u0001\u001a\u00020h2\u0007\u0010\u0096\u0001\u001a\u00020@J\u000e\u0010\u00bb\u0001\u001a\t\u0012\u0004\u0012\u00020Y0\u0083\u0001J\u001b\u0010\u00bc\u0001\u001a\u0004\u0018\u00010d2\u0007\u0010\u00b1\u0001\u001a\u00020Y2\u0007\u0010\u00b4\u0001\u001a\u000203R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u001a\u0010\u001a\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0015R\u0011\u0010\u001d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u0011\u0010\u001f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u0011\u0010!\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000fR\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020/0*\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010-R\u001d\u00101\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020302\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020807\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R#\u0010;\u001a\u0014\u0012\u0004\u0012\u00020<\u0012\n\u0012\b\u0012\u0004\u0012\u0002080702\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00105R9\u0010>\u001a*\u0012\f\u0012\n A*\u0004\u0018\u00010@0@\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0001 A*\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010B0B0?\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u001d\u0010E\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020F02\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00105R\u001d\u0010H\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020I02\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00105R)\u0010K\u001a\u001a\u0012\u0004\u0012\u00020@\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002030L02\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u00105R\u001d\u0010N\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020302\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u00105R\u001d\u0010P\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020302\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u00105R\u001d\u0010R\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020T0S\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u001f\u0010W\u001a\u0010\u0012\f\u0012\n A*\u0004\u0018\u00010Y0Y0X\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u001f\u0010\\\u001a\u0010\u0012\f\u0012\n A*\u0004\u0018\u00010Y0Y0X\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010[R\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010bR\u0017\u0010c\u001a\b\u0012\u0004\u0012\u00020d0_\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010bR\u001d\u0010f\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020h0g\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010jR\u0011\u0010k\u001a\u00020h\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010mR\u0014\u0010\u00bd\u0001\u001a\u00020F\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00be\u0001\u0010\u00bf\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00c3\u0001"}, d2={"Lalfheim/api/AlfheimAPI;", "", "<init>", "()V", "elvoriumArmor", "Lnet/minecraft/item/ItemArmor$ArmorMaterial;", "getElvoriumArmor", "()Lnet/minecraft/item/ItemArmor$ArmorMaterial;", "elementalArmor", "getElementalArmor", "fenrirArmor", "getFenrirArmor", "elvoriumToolMaterial", "Lnet/minecraft/item/Item$ToolMaterial;", "getElvoriumToolMaterial", "()Lnet/minecraft/item/Item$ToolMaterial;", "mauftriumToolMaterial", "getMauftriumToolMaterial", "DAOLOS", "getDAOLOS", "setDAOLOS", "(Lnet/minecraft/item/Item$ToolMaterial;)V", "EXCALIBER", "getEXCALIBER", "FENRIR", "getFENRIR", "RUNEAXE", "getRUNEAXE", "setRUNEAXE", "SOUL", "getSOUL", "SURTR", "getSURTR", "THRYM", "getTHRYM", "mauftriumRarity", "Lnet/minecraft/item/EnumRarity;", "getMauftriumRarity", "()Lnet/minecraft/item/EnumRarity;", "ragnarokRarity", "getRagnarokRarity", "bannedRetrades", "Ljava/util/ArrayList;", "Lnet/minecraft/item/ItemStack;", "getBannedRetrades", "()Ljava/util/ArrayList;", "manaInfuserRecipes", "Lalfheim/api/crafting/recipe/RecipeManaInfuser;", "getManaInfuserRecipes", "pinkness", "Ljava/util/HashMap;", "", "getPinkness", "()Ljava/util/HashMap;", "spells", "Ljava/util/HashSet;", "Lalfheim/api/spell/SpellBase;", "getSpells", "()Ljava/util/HashSet;", "spellMapping", "Lalfheim/api/entity/EnumRace;", "getSpellMapping", "tunerIncantations", "Lcom/google/common/collect/LinkedHashMultimap;", "", "kotlin.jvm.PlatformType", "Lalfheim/api/crafting/recipe/TunerIncantation;", "getTunerIncantations", "()Lcom/google/common/collect/LinkedHashMultimap;", "anomalies", "Lalfheim/api/AlfheimAPI$AnomalyData;", "getAnomalies", "anomalyBehaviors", "Lalfheim/api/AlfheimAPI$AnomalyBehavior;", "getAnomalyBehaviors", "fuelMap", "Lkotlin/Pair;", "getFuelMap", "oreWeightsEnd", "getOreWeightsEnd", "oreWeightsAlfheim", "getOreWeightsAlfheim", "domains", "Ljava/util/LinkedHashMap;", "Lalfheim/api/world/domain/Domain;", "getDomains", "()Ljava/util/LinkedHashMap;", "coldBlocks", "", "Lnet/minecraft/block/Block;", "getColdBlocks", "()Ljava/util/Set;", "warmBlocks", "getWarmBlocks", "treeRecipes", "", "Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "getTreeRecipes", "()Ljava/util/List;", "treeVariants", "Lalfheim/api/trees/IIridescentSaplingVariant;", "getTreeVariants", "collidingItemHashMap", "", "Lalfheim/api/item/ThrowableCollidingItem;", "getCollidingItemHashMap", "()Ljava/util/Map;", "fallbackTcl", "getFallbackTcl", "()Lalfheim/api/item/ThrowableCollidingItem;", "addInfuserRecipe", "rec", "result", "mana", "ingredients", "", "(Lnet/minecraft/item/ItemStack;I[Ljava/lang/Object;)Lalfheim/api/crafting/recipe/RecipeManaInfuser;", "removeInfusionRecipe", "banRetrade", "", "output", "isRetradeable", "addPink", "pink", "weight", "(Lnet/minecraft/item/ItemStack;I)Ljava/lang/Integer;", "item", "registerSpell", "", "spell", "getSpellsFor", "", "affinity", "getSpellInstance", "name", "getSpellByIDs", "raceID", "spellID", "getSpellID", "registerIncantation", "T", "incantation", "inputs", "application", "Lkotlin/Function1;", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lalfheim/api/crafting/recipe/TunerIncantation;", "set", "K", "V", "Lcom/google/common/collect/Multimap;", "key", "value", "(Lcom/google/common/collect/Multimap;Ljava/lang/Object;Ljava/lang/Object;)Z", "registerAnomaly", "Lalfheim/api/block/tile/SubTileAnomalyBase;", "rarity", "Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalyRarity;", "strip", "color", "getAnomaly", "registerFuel", "burnTime", "manaPerTick", "addOreWeightEnd", "ore", "addOreWeightAlfheim", "addTreeRecipe", "recipe", "out", "outTileId", "core", "(ILnet/minecraft/item/ItemStack;Ljava/lang/String;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "throttle", "(ILnet/minecraft/item/ItemStack;Ljava/lang/String;Lnet/minecraft/item/ItemStack;I[Ljava/lang/Object;)Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "removeTreeRecipe", "addTreeVariant", "variant", "soil", "wood", "leaves", "meta", "metaMin", "metaMax", "metaShift", "registerThrowable", "tcl", "getThrowableFromKey", "getIridescentSoils", "getTreeVariant", "fallbackAnomalyData", "getFallbackAnomalyData", "()Lalfheim/api/AlfheimAPI$AnomalyData;", "FallbackAnomaly", "AnomalyBehavior", "AnomalyData", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nAlfheimAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlfheimAPI.kt\nalfheim/api/AlfheimAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n295#2,2:367\n2632#2,3:370\n295#2,2:373\n1053#2:375\n295#2,2:376\n295#2,2:378\n295#2,2:380\n1#3:369\n*S KotlinDebug\n*F\n+ 1 AlfheimAPI.kt\nalfheim/api/AlfheimAPI\n*L\n105#1:367,2\n114#1:370,3\n122#1:373,2\n156#1:375\n159#1:376,2\n265#1:378,2\n354#1:380,2\n*E\n"})
public final class AlfheimAPI {
    @NotNull
    public static final AlfheimAPI INSTANCE = new AlfheimAPI();
    @NotNull
    private static final ItemArmor.ArmorMaterial elvoriumArmor;
    @NotNull
    private static final ItemArmor.ArmorMaterial elementalArmor;
    @NotNull
    private static final ItemArmor.ArmorMaterial fenrirArmor;
    @NotNull
    private static final Item.ToolMaterial elvoriumToolMaterial;
    @NotNull
    private static final Item.ToolMaterial mauftriumToolMaterial;
    @NotNull
    private static Item.ToolMaterial DAOLOS;
    @NotNull
    private static final Item.ToolMaterial EXCALIBER;
    @NotNull
    private static final Item.ToolMaterial FENRIR;
    @NotNull
    private static Item.ToolMaterial RUNEAXE;
    @NotNull
    private static final Item.ToolMaterial SOUL;
    @NotNull
    private static final Item.ToolMaterial SURTR;
    @NotNull
    private static final Item.ToolMaterial THRYM;
    @NotNull
    private static final EnumRarity mauftriumRarity;
    @NotNull
    private static final EnumRarity ragnarokRarity;
    @NotNull
    private static final ArrayList<ItemStack> bannedRetrades;
    @NotNull
    private static final ArrayList<RecipeManaInfuser> manaInfuserRecipes;
    @NotNull
    private static final HashMap<ItemStack, Integer> pinkness;
    @NotNull
    private static final HashSet<SpellBase> spells;
    @NotNull
    private static final HashMap<EnumRace, HashSet<SpellBase>> spellMapping;
    @NotNull
    private static final LinkedHashMultimap<String, TunerIncantation<Object>> tunerIncantations;
    @NotNull
    private static final HashMap<String, AnomalyData> anomalies;
    @NotNull
    private static final HashMap<String, AnomalyBehavior> anomalyBehaviors;
    @NotNull
    private static final HashMap<String, Pair<Integer, Integer>> fuelMap;
    @NotNull
    private static final HashMap<String, Integer> oreWeightsEnd;
    @NotNull
    private static final HashMap<String, Integer> oreWeightsAlfheim;
    @NotNull
    private static final LinkedHashMap<String, Domain> domains;
    @NotNull
    private static final Set<Block> coldBlocks;
    @NotNull
    private static final Set<Block> warmBlocks;
    @NotNull
    private static final List<RecipeTreeCrafting> treeRecipes;
    @NotNull
    private static final List<IIridescentSaplingVariant> treeVariants;
    @NotNull
    private static final Map<String, ThrowableCollidingItem> collidingItemHashMap;
    @NotNull
    private static final ThrowableCollidingItem fallbackTcl;
    @NotNull
    private static final AnomalyData fallbackAnomalyData;

    private AlfheimAPI() {
    }

    @NotNull
    public final ItemArmor.ArmorMaterial getElvoriumArmor() {
        return elvoriumArmor;
    }

    @NotNull
    public final ItemArmor.ArmorMaterial getElementalArmor() {
        return elementalArmor;
    }

    @NotNull
    public final ItemArmor.ArmorMaterial getFenrirArmor() {
        return fenrirArmor;
    }

    @NotNull
    public final Item.ToolMaterial getElvoriumToolMaterial() {
        return elvoriumToolMaterial;
    }

    @NotNull
    public final Item.ToolMaterial getMauftriumToolMaterial() {
        return mauftriumToolMaterial;
    }

    @NotNull
    public final Item.ToolMaterial getDAOLOS() {
        return DAOLOS;
    }

    public final void setDAOLOS(@NotNull Item.ToolMaterial toolMaterial) {
        Intrinsics.checkNotNullParameter((Object)toolMaterial, (String)"<set-?>");
        DAOLOS = toolMaterial;
    }

    @NotNull
    public final Item.ToolMaterial getEXCALIBER() {
        return EXCALIBER;
    }

    @NotNull
    public final Item.ToolMaterial getFENRIR() {
        return FENRIR;
    }

    @NotNull
    public final Item.ToolMaterial getRUNEAXE() {
        return RUNEAXE;
    }

    public final void setRUNEAXE(@NotNull Item.ToolMaterial toolMaterial) {
        Intrinsics.checkNotNullParameter((Object)toolMaterial, (String)"<set-?>");
        RUNEAXE = toolMaterial;
    }

    @NotNull
    public final Item.ToolMaterial getSOUL() {
        return SOUL;
    }

    @NotNull
    public final Item.ToolMaterial getSURTR() {
        return SURTR;
    }

    @NotNull
    public final Item.ToolMaterial getTHRYM() {
        return THRYM;
    }

    @NotNull
    public final EnumRarity getMauftriumRarity() {
        return mauftriumRarity;
    }

    @NotNull
    public final EnumRarity getRagnarokRarity() {
        return ragnarokRarity;
    }

    @NotNull
    public final ArrayList<ItemStack> getBannedRetrades() {
        return bannedRetrades;
    }

    @NotNull
    public final ArrayList<RecipeManaInfuser> getManaInfuserRecipes() {
        return manaInfuserRecipes;
    }

    @NotNull
    public final HashMap<ItemStack, Integer> getPinkness() {
        return pinkness;
    }

    @NotNull
    public final HashSet<SpellBase> getSpells() {
        return spells;
    }

    @NotNull
    public final HashMap<EnumRace, HashSet<SpellBase>> getSpellMapping() {
        return spellMapping;
    }

    @NotNull
    public final LinkedHashMultimap<String, TunerIncantation<Object>> getTunerIncantations() {
        return tunerIncantations;
    }

    @NotNull
    public final HashMap<String, AnomalyData> getAnomalies() {
        return anomalies;
    }

    @NotNull
    public final HashMap<String, AnomalyBehavior> getAnomalyBehaviors() {
        return anomalyBehaviors;
    }

    @NotNull
    public final HashMap<String, Pair<Integer, Integer>> getFuelMap() {
        return fuelMap;
    }

    @NotNull
    public final HashMap<String, Integer> getOreWeightsEnd() {
        return oreWeightsEnd;
    }

    @NotNull
    public final HashMap<String, Integer> getOreWeightsAlfheim() {
        return oreWeightsAlfheim;
    }

    @NotNull
    public final LinkedHashMap<String, Domain> getDomains() {
        return domains;
    }

    @NotNull
    public final Set<Block> getColdBlocks() {
        return coldBlocks;
    }

    @NotNull
    public final Set<Block> getWarmBlocks() {
        return warmBlocks;
    }

    @NotNull
    public final List<RecipeTreeCrafting> getTreeRecipes() {
        return treeRecipes;
    }

    @NotNull
    public final List<IIridescentSaplingVariant> getTreeVariants() {
        return treeVariants;
    }

    @NotNull
    public final Map<String, ThrowableCollidingItem> getCollidingItemHashMap() {
        return collidingItemHashMap;
    }

    @NotNull
    public final ThrowableCollidingItem getFallbackTcl() {
        return fallbackTcl;
    }

    @Nullable
    public final RecipeManaInfuser addInfuserRecipe(@Nullable RecipeManaInfuser rec) {
        if (rec != null) {
            manaInfuserRecipes.add(rec);
        }
        return rec;
    }

    @NotNull
    public final RecipeManaInfuser addInfuserRecipe(@NotNull ItemStack result, int mana, Object ... ingredients) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)ingredients, (String)"ingredients");
        RecipeManaInfuser rec = new RecipeManaInfuser(mana, result, Arrays.copyOf(ingredients, ingredients.length));
        manaInfuserRecipes.add(rec);
        return rec;
    }

    @Nullable
    public final RecipeManaInfuser removeInfusionRecipe(@Nullable RecipeManaInfuser rec) {
        return rec != null && manaInfuserRecipes.remove((Object)rec) ? rec : null;
    }

    @Nullable
    public final RecipeManaInfuser removeInfusionRecipe(@NotNull ItemStack result) {
        RecipeManaInfuser recipeManaInfuser;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Iterable $this$firstOrNull$iv = (Iterable)CollectionsKt.getIndices((Collection)manaInfuserRecipes);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                ItemStack itemStack = manaInfuserRecipes.get(it).getOutput();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOutput(...)");
                if (!ASJUtilities.isItemStackEqualCrafting((ItemStack)itemStack, (ItemStack)result)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Integer n = v1;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            recipeManaInfuser = manaInfuserRecipes.remove(it);
        } else {
            recipeManaInfuser = null;
        }
        return recipeManaInfuser;
    }

    public final boolean banRetrade(@NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return bannedRetrades.add(output);
    }

    public final boolean isRetradeable(@NotNull ItemStack output) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Iterable $this$none$iv = bannedRetrades;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (!ASJUtilities.isItemStackEqualCrafting((ItemStack)output, (ItemStack)it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public final Integer addPink(@NotNull ItemStack pink, int weight) {
        Intrinsics.checkNotNullParameter((Object)pink, (String)"pink");
        return pinkness.put(pink, weight);
    }

    public final int getPinkness(@NotNull ItemStack item) {
        int n;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Set<ItemStack> set = pinkness.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!ASJUtilities.isItemStackEqualCrafting((ItemStack)it, (ItemStack)item)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        ItemStack itemStack = v1;
        if (itemStack != null) {
            ItemStack it = itemStack;
            boolean bl = false;
            Integer n2 = pinkness.get(it);
            Intrinsics.checkNotNull((Object)n2);
            n = ((Number)n2).intValue();
        } else {
            n = 0;
        }
        return n;
    }

    public final void registerSpell(@NotNull SpellBase spell) {
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        if (!(spell.getRace() != EnumRace.HUMAN)) {
            boolean $i$a$-require-AlfheimAPI$registerSpell$32 = false;
            String $i$a$-require-AlfheimAPI$registerSpell$32 = "Spell race must not be human (spell " + spell.getName() + ')';
            throw new IllegalArgumentException($i$a$-require-AlfheimAPI$registerSpell$32.toString());
        }
        if (!(spell.getRace() != EnumRace.ALV)) {
            boolean bl = false;
            String string = "Alv race is currently not supported (spell " + spell.getName() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (!spells.contains(spell)) {
            spells.add(spell);
            spellMapping.computeIfAbsent(spell.getRace(), arg_0 -> AlfheimAPI.registerSpell$lambda$9(AlfheimAPI::registerSpell$lambda$8, arg_0)).add(spell);
            if (ASJUtilities.isClient()) {
                LibResourceLocations.INSTANCE.add(spell.getName());
            }
        } else {
            ASJUtilities.warn((String)("Trying to register spell " + spell.getName() + " twice. Skipping."));
        }
    }

    @NotNull
    public final List<SpellBase> getSpellsFor(@NotNull EnumRace affinity) {
        Intrinsics.checkNotNullParameter((Object)((Object)affinity), (String)"affinity");
        HashSet hashSet = spellMapping.computeIfAbsent(affinity, arg_0 -> AlfheimAPI.getSpellsFor$lambda$11(AlfheimAPI::getSpellsFor$lambda$10, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"computeIfAbsent(...)");
        Iterable $this$sortedBy$iv = hashSet;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SpellBase it = (SpellBase)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (SpellBase)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @Nullable
    public final SpellBase getSpellInstance(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = spells;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpellBase it = (SpellBase)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final SpellBase getSpellByIDs(int raceID, int spellID) {
        int i = 0;
        for (SpellBase sb : this.getSpellsFor(EnumRace.Companion.get(raceID))) {
            if (i++ != spellID) continue;
            return sb;
        }
        return null;
    }

    public final int getSpellID(@NotNull SpellBase spell) {
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        for (EnumRace race : EnumRace.getEntries()) {
            int i = -1;
            for (SpellBase sb : this.getSpellsFor(race)) {
                ++i;
                if (sb != spell) continue;
                return i;
            }
        }
        throw new IllegalArgumentException("Client-server spells desynchronization. Not found ID for " + spell.getName());
    }

    public final /* synthetic */ <T> TunerIncantation<T> registerIncantation(String incantation, Object[] inputs, Function1<? super T, Boolean> application) {
        Intrinsics.checkNotNullParameter((Object)incantation, (String)"incantation");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(application, (String)"application");
        boolean $i$f$registerIncantation = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        TunerIncantation<? super T> ti = new TunerIncantation<T>(Object.class, incantation, inputs, application);
        Multimap multimap = (Multimap)this.getTunerIncantations();
        String string = incantation.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.set(multimap, string, ti);
        return ti;
    }

    public final <K, V> boolean set(@NotNull Multimap<K, V> $this$set, K key, V value) {
        Intrinsics.checkNotNullParameter($this$set, (String)"<this>");
        return $this$set.put(key, value);
    }

    public final /* synthetic */ <T extends SubTileAnomalyBase> void registerAnomaly(String name, SubTileAnomalyBase.EnumAnomalyRarity rarity, int strip, int color) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
        boolean $i$f$registerAnomaly = false;
        if (!(!this.getAnomalies().containsKey(name))) {
            boolean bl = false;
            String string = "Anomaly \"" + name + "\" is already registered";
            throw new IllegalArgumentException(string.toString());
        }
        Map map = this.getAnomalies();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        map.put(name, new AnomalyData(SubTileAnomalyBase.class, rarity, strip, color));
    }

    @NotNull
    public final AnomalyData getAnomaly(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AnomalyData anomalyData = anomalies.get(name);
        if (anomalyData == null) {
            anomalyData = fallbackAnomalyData;
        }
        return anomalyData;
    }

    public final void registerFuel(@NotNull String name, int burnTime, int manaPerTick) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Map)fuelMap).put(name, TuplesKt.to((Object)burnTime, (Object)manaPerTick));
    }

    public final void addOreWeightEnd(@NotNull String ore, int weight) {
        Intrinsics.checkNotNullParameter((Object)ore, (String)"ore");
        Integer n = weight;
        ((Map)oreWeightsEnd).put(ore, n);
    }

    public final void addOreWeightAlfheim(@NotNull String ore, int weight) {
        Intrinsics.checkNotNullParameter((Object)ore, (String)"ore");
        Integer n = weight;
        ((Map)oreWeightsAlfheim).put(ore, n);
    }

    @NotNull
    public final RecipeTreeCrafting addTreeRecipe(@NotNull RecipeTreeCrafting recipe) {
        RecipeTreeCrafting recipeTreeCrafting;
        Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
        RecipeTreeCrafting it = recipeTreeCrafting = recipe;
        boolean bl = false;
        treeRecipes.add(it);
        return recipeTreeCrafting;
    }

    @NotNull
    public final RecipeTreeCrafting addTreeRecipe(int mana, @NotNull ItemStack out, @Nullable String outTileId, @NotNull ItemStack core, Object ... inputs) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        return this.addTreeRecipe(new RecipeTreeCrafting(mana, out, outTileId, core, Arrays.copyOf(inputs, inputs.length)));
    }

    @NotNull
    public final RecipeTreeCrafting addTreeRecipe(int mana, @NotNull ItemStack out, @Nullable String outTileId, @NotNull ItemStack core, int throttle, Object ... inputs) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        return this.addTreeRecipe(new RecipeTreeCrafting(mana, out, outTileId, core, throttle, Arrays.copyOf(inputs, inputs.length)));
    }

    @Nullable
    public final RecipeTreeCrafting removeTreeRecipe(@Nullable RecipeTreeCrafting rec) {
        return rec != null && treeRecipes.remove((Object)rec) ? rec : null;
    }

    @Nullable
    public final RecipeTreeCrafting removeTreeRecipe(@NotNull ItemStack result) {
        RecipeTreeCrafting recipeTreeCrafting;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Iterable $this$firstOrNull$iv = (Iterable)CollectionsKt.getIndices((Collection)treeRecipes);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                ItemStack itemStack = treeRecipes.get(it).getOutput();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOutput(...)");
                if (!ASJUtilities.isItemStackEqualCrafting((ItemStack)itemStack, (ItemStack)result)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Integer n = v1;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            recipeTreeCrafting = treeRecipes.remove(it);
        } else {
            recipeTreeCrafting = null;
        }
        return recipeTreeCrafting;
    }

    @NotNull
    public final IIridescentSaplingVariant addTreeVariant(@NotNull IIridescentSaplingVariant variant) {
        IIridescentSaplingVariant iIridescentSaplingVariant;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        IIridescentSaplingVariant it = iIridescentSaplingVariant = variant;
        boolean bl = false;
        treeVariants.add(it);
        return iIridescentSaplingVariant;
    }

    @NotNull
    public final IIridescentSaplingVariant addTreeVariant(@NotNull Block soil, @NotNull Block wood, @NotNull Block leaves) {
        Intrinsics.checkNotNullParameter((Object)soil, (String)"soil");
        Intrinsics.checkNotNullParameter((Object)wood, (String)"wood");
        Intrinsics.checkNotNullParameter((Object)leaves, (String)"leaves");
        return this.addTreeVariant(new IridescentSaplingBaseVariant(soil, wood, leaves));
    }

    @NotNull
    public final IIridescentSaplingVariant addTreeVariant(@NotNull Block soil, @NotNull Block wood, @NotNull Block leaves, int meta) {
        Intrinsics.checkNotNullParameter((Object)soil, (String)"soil");
        Intrinsics.checkNotNullParameter((Object)wood, (String)"wood");
        Intrinsics.checkNotNullParameter((Object)leaves, (String)"leaves");
        return this.addTreeVariant(new IridescentSaplingBaseVariant(soil, wood, leaves, meta));
    }

    @NotNull
    public final IIridescentSaplingVariant addTreeVariant(@NotNull Block soil, @NotNull Block wood, @NotNull Block leaves, int metaMin, int metaMax) {
        Intrinsics.checkNotNullParameter((Object)soil, (String)"soil");
        Intrinsics.checkNotNullParameter((Object)wood, (String)"wood");
        Intrinsics.checkNotNullParameter((Object)leaves, (String)"leaves");
        return this.addTreeVariant(new IridescentSaplingBaseVariant(soil, wood, leaves, metaMin, metaMax));
    }

    @NotNull
    public final IIridescentSaplingVariant addTreeVariant(@NotNull Block soil, @NotNull Block wood, @NotNull Block leaves, int metaMin, int metaMax, int metaShift) {
        Intrinsics.checkNotNullParameter((Object)soil, (String)"soil");
        Intrinsics.checkNotNullParameter((Object)wood, (String)"wood");
        Intrinsics.checkNotNullParameter((Object)leaves, (String)"leaves");
        return this.addTreeVariant(new IridescentSaplingBaseVariant(soil, wood, leaves, metaMin, metaMax, metaShift));
    }

    @NotNull
    public final ThrowableCollidingItem registerThrowable(@NotNull ThrowableCollidingItem tcl) {
        ThrowableCollidingItem throwableCollidingItem;
        Intrinsics.checkNotNullParameter((Object)tcl, (String)"tcl");
        ThrowableCollidingItem it = throwableCollidingItem = tcl;
        boolean bl = false;
        collidingItemHashMap.put(it.getKey$Alfheim(), it);
        return throwableCollidingItem;
    }

    @NotNull
    public final ThrowableCollidingItem getThrowableFromKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ThrowableCollidingItem throwableCollidingItem = collidingItemHashMap.get(key);
        if (throwableCollidingItem == null) {
            throwableCollidingItem = fallbackTcl;
        }
        return throwableCollidingItem;
    }

    @NotNull
    public final List<Block> getIridescentSoils() {
        ArrayList soils = new ArrayList();
        for (IIridescentSaplingVariant variant : treeVariants) {
            soils.addAll(variant.getAcceptableSoils());
        }
        return soils;
    }

    @Nullable
    public final IIridescentSaplingVariant getTreeVariant(@NotNull Block soil, int meta) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)soil, (String)"soil");
            Iterable $this$firstOrNull$iv = treeVariants;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IIridescentSaplingVariant it = (IIridescentSaplingVariant)element$iv;
                boolean bl = false;
                if (!it.matchesSoil(soil, meta)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final AnomalyData getFallbackAnomalyData() {
        return fallbackAnomalyData;
    }

    private static final Unit fallbackTcl$lambda$0(EntityThrowable entityThrowable, MovingObjectPosition movingObjectPosition) {
        Intrinsics.checkNotNullParameter((Object)entityThrowable, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)movingObjectPosition, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final HashSet registerSpell$lambda$8(EnumRace it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new HashSet(8);
    }

    private static final HashSet registerSpell$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final HashSet getSpellsFor$lambda$10(EnumRace it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new HashSet(8);
    }

    private static final HashSet getSpellsFor$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new int[]{5, 8, 7, 4};
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)"ALFHEIM_ELVORIUM", (int)50, (int[])objectArray, (int)30);
        Intrinsics.checkNotNull((Object)armorMaterial);
        elvoriumArmor = armorMaterial;
        objectArray = new int[]{2, 9, 5, 2};
        ItemArmor.ArmorMaterial armorMaterial2 = EnumHelper.addArmorMaterial((String)"ALFHEIM_ELEMENTAL", (int)20, (int[])objectArray, (int)20);
        Intrinsics.checkNotNull((Object)armorMaterial2);
        elementalArmor = armorMaterial2;
        objectArray = new int[]{3, 7, 6, 2};
        ItemArmor.ArmorMaterial armorMaterial3 = EnumHelper.addArmorMaterial((String)"ALFHEIM_FENRIR", (int)32, (int[])objectArray, (int)15);
        Intrinsics.checkNotNull((Object)armorMaterial3);
        fenrirArmor = armorMaterial3;
        Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)"ALFHEIM_ELVORIUM", (int)4, (int)2400, (float)9.5f, (float)3.0f, (int)30);
        Intrinsics.checkNotNull((Object)toolMaterial);
        elvoriumToolMaterial = toolMaterial;
        Item.ToolMaterial toolMaterial2 = EnumHelper.addToolMaterial((String)"ALFHEIM_MAUFTRIUM", (int)10, (int)3000, (float)3.0f, (float)8.0f, (int)40);
        Intrinsics.checkNotNull((Object)toolMaterial2);
        mauftriumToolMaterial = toolMaterial2;
        Item.ToolMaterial toolMaterial3 = EnumHelper.addToolMaterial((String)"ALFHEIM_DAOLOS", (int)7, (int)1561, (float)16.0f, (float)7.0f, (int)50);
        Intrinsics.checkNotNull((Object)toolMaterial3);
        DAOLOS = toolMaterial3;
        Item.ToolMaterial toolMaterial4 = EnumHelper.addToolMaterial((String)"ALFHEIM_EXCALIBER", (int)3, (int)-1, (float)6.2f, (float)6.0f, (int)40);
        Intrinsics.checkNotNull((Object)toolMaterial4);
        EXCALIBER = toolMaterial4;
        Item.ToolMaterial toolMaterial5 = EnumHelper.addToolMaterial((String)"ALFHEIM_FENRIR", (int)0, (int)2000, (float)0.0f, (float)3.0f, (int)14);
        Intrinsics.checkNotNull((Object)toolMaterial5);
        FENRIR = toolMaterial5;
        Item.ToolMaterial toolMaterial6 = EnumHelper.addToolMaterial((String)"ALFHEIM_RUNEAXE", (int)7, (int)1561, (float)16.0f, (float)2.0f, (int)50);
        Intrinsics.checkNotNull((Object)toolMaterial6);
        RUNEAXE = toolMaterial6;
        Item.ToolMaterial toolMaterial7 = EnumHelper.addToolMaterial((String)"ALFHEIM_SOUL", (int)-1, (int)-1, (float)-1.0f, (float)-1.0f, (int)-1);
        Intrinsics.checkNotNull((Object)toolMaterial7);
        SOUL = toolMaterial7;
        Item.ToolMaterial toolMaterial8 = EnumHelper.addToolMaterial((String)"ALFHEIM_SURTR", (int)0, (int)1, (float)0.0f, (float)4.0f, (int)0);
        Intrinsics.checkNotNull((Object)toolMaterial8);
        SURTR = toolMaterial8;
        Item.ToolMaterial toolMaterial9 = EnumHelper.addToolMaterial((String)"ALFHEIM_THRYM", (int)0, (int)1, (float)0.0f, (float)4.0f, (int)0);
        Intrinsics.checkNotNull((Object)toolMaterial9);
        THRYM = toolMaterial9;
        EnumRarity enumRarity = EnumHelper.addRarity((String)"ALFHEIM_MAUFTRIUM", (EnumChatFormatting)EnumChatFormatting.GOLD, (String)"Mauftrium");
        Intrinsics.checkNotNull((Object)enumRarity);
        mauftriumRarity = enumRarity;
        EnumRarity enumRarity2 = EnumHelper.addRarity((String)"ALFHEIM_RAGNAROK", (EnumChatFormatting)EnumChatFormatting.DARK_RED, (String)"Ragnarok");
        Intrinsics.checkNotNull((Object)enumRarity2);
        ragnarokRarity = enumRarity2;
        bannedRetrades = new ArrayList();
        manaInfuserRecipes = new ArrayList();
        pinkness = new HashMap();
        spells = new HashSet();
        spellMapping = new HashMap();
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkNotNull((Object)linkedHashMultimap);
        tunerIncantations = linkedHashMultimap;
        anomalies = new HashMap();
        anomalyBehaviors = new HashMap();
        fuelMap = new HashMap();
        oreWeightsEnd = new HashMap();
        oreWeightsAlfheim = new HashMap();
        domains = new LinkedHashMap();
        objectArray = new Block[3];
        objectArray[0] = (int)Blocks.field_150432_aD;
        objectArray[1] = (int)Blocks.field_150403_cj;
        objectArray[2] = (int)Blocks.field_150433_aE;
        coldBlocks = SetsKt.mutableSetOf((Object[])objectArray);
        objectArray = new Block[7];
        objectArray[0] = (int)Blocks.field_150480_ab;
        objectArray[1] = (int)Blocks.field_150353_l;
        objectArray[2] = (int)Blocks.field_150356_k;
        objectArray[3] = (int)Blocks.field_150470_am;
        objectArray[4] = (int)Blocks.field_150478_aa;
        objectArray[5] = (int)Blocks.field_150428_aP;
        objectArray[6] = (int)Blocks.field_150382_bo;
        warmBlocks = SetsKt.mutableSetOf((Object[])objectArray);
        treeRecipes = new ArrayList();
        treeVariants = new ArrayList();
        collidingItemHashMap = new LinkedHashMap();
        fallbackTcl = new ThrowableCollidingItem("alfheim_fallback", new ItemStack(Items.field_151072_bj), (Function2<? super EntityThrowable, ? super MovingObjectPosition, Unit>)((Function2)AlfheimAPI::fallbackTcl$lambda$0));
        fallbackAnomalyData = new AnomalyData(FallbackAnomaly.class, SubTileAnomalyBase.EnumAnomalyRarity.COMMON, 31, 0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lalfheim/api/AlfheimAPI$AnomalyBehavior;", "", "costPerBlock", "", "costPerApplication", "effect", "Lkotlin/Function1;", "Lnet/minecraft/tileentity/TileEntity;", "<init>", "(IILkotlin/jvm/functions/Function1;)V", "getCostPerBlock", "()I", "getCostPerApplication", "getEffect", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Alfheim"})
    public static final class AnomalyBehavior {
        private final int costPerBlock;
        private final int costPerApplication;
        @NotNull
        private final Function1<TileEntity, Integer> effect;

        public AnomalyBehavior(int costPerBlock, int costPerApplication, @NotNull Function1<? super TileEntity, Integer> effect) {
            Intrinsics.checkNotNullParameter(effect, (String)"effect");
            this.costPerBlock = costPerBlock;
            this.costPerApplication = costPerApplication;
            this.effect = effect;
        }

        public final int getCostPerBlock() {
            return this.costPerBlock;
        }

        public final int getCostPerApplication() {
            return this.costPerApplication;
        }

        @NotNull
        public final Function1<TileEntity, Integer> getEffect() {
            return this.effect;
        }

        public final int component1() {
            return this.costPerBlock;
        }

        public final int component2() {
            return this.costPerApplication;
        }

        @NotNull
        public final Function1<TileEntity, Integer> component3() {
            return this.effect;
        }

        @NotNull
        public final AnomalyBehavior copy(int costPerBlock, int costPerApplication, @NotNull Function1<? super TileEntity, Integer> effect) {
            Intrinsics.checkNotNullParameter(effect, (String)"effect");
            return new AnomalyBehavior(costPerBlock, costPerApplication, effect);
        }

        public static /* synthetic */ AnomalyBehavior copy$default(AnomalyBehavior anomalyBehavior, int n, int n2, Function1 function1, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = anomalyBehavior.costPerBlock;
            }
            if ((n3 & 2) != 0) {
                n2 = anomalyBehavior.costPerApplication;
            }
            if ((n3 & 4) != 0) {
                function1 = anomalyBehavior.effect;
            }
            return anomalyBehavior.copy(n, n2, function1);
        }

        @NotNull
        public String toString() {
            return "AnomalyBehavior(costPerBlock=" + this.costPerBlock + ", costPerApplication=" + this.costPerApplication + ", effect=" + this.effect + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.costPerBlock);
            result = result * 31 + Integer.hashCode(this.costPerApplication);
            result = result * 31 + this.effect.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnomalyBehavior)) {
                return false;
            }
            AnomalyBehavior anomalyBehavior = (AnomalyBehavior)other;
            if (this.costPerBlock != anomalyBehavior.costPerBlock) {
                return false;
            }
            if (this.costPerApplication != anomalyBehavior.costPerApplication) {
                return false;
            }
            return Intrinsics.areEqual(this.effect, anomalyBehavior.effect);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lalfheim/api/AlfheimAPI$AnomalyData;", "", "subtileClass", "Ljava/lang/Class;", "Lalfheim/api/block/tile/SubTileAnomalyBase;", "rarity", "Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalyRarity;", "strip", "", "color", "<init>", "(Ljava/lang/Class;Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalyRarity;II)V", "getSubtileClass", "()Ljava/lang/Class;", "getRarity", "()Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalyRarity;", "getStrip", "()I", "getColor", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Alfheim"})
    public static final class AnomalyData {
        @NotNull
        private final Class<? extends SubTileAnomalyBase> subtileClass;
        @NotNull
        private final SubTileAnomalyBase.EnumAnomalyRarity rarity;
        private final int strip;
        private final int color;

        public AnomalyData(@NotNull Class<? extends SubTileAnomalyBase> subtileClass, @NotNull SubTileAnomalyBase.EnumAnomalyRarity rarity, int strip, int color) {
            Intrinsics.checkNotNullParameter(subtileClass, (String)"subtileClass");
            Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
            this.subtileClass = subtileClass;
            this.rarity = rarity;
            this.strip = strip;
            this.color = color;
        }

        @NotNull
        public final Class<? extends SubTileAnomalyBase> getSubtileClass() {
            return this.subtileClass;
        }

        @NotNull
        public final SubTileAnomalyBase.EnumAnomalyRarity getRarity() {
            return this.rarity;
        }

        public final int getStrip() {
            return this.strip;
        }

        public final int getColor() {
            return this.color;
        }

        @NotNull
        public final Class<? extends SubTileAnomalyBase> component1() {
            return this.subtileClass;
        }

        @NotNull
        public final SubTileAnomalyBase.EnumAnomalyRarity component2() {
            return this.rarity;
        }

        public final int component3() {
            return this.strip;
        }

        public final int component4() {
            return this.color;
        }

        @NotNull
        public final AnomalyData copy(@NotNull Class<? extends SubTileAnomalyBase> subtileClass, @NotNull SubTileAnomalyBase.EnumAnomalyRarity rarity, int strip, int color) {
            Intrinsics.checkNotNullParameter(subtileClass, (String)"subtileClass");
            Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
            return new AnomalyData(subtileClass, rarity, strip, color);
        }

        public static /* synthetic */ AnomalyData copy$default(AnomalyData anomalyData, Class clazz, SubTileAnomalyBase.EnumAnomalyRarity enumAnomalyRarity, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                clazz = anomalyData.subtileClass;
            }
            if ((n3 & 2) != 0) {
                enumAnomalyRarity = anomalyData.rarity;
            }
            if ((n3 & 4) != 0) {
                n = anomalyData.strip;
            }
            if ((n3 & 8) != 0) {
                n2 = anomalyData.color;
            }
            return anomalyData.copy(clazz, enumAnomalyRarity, n, n2);
        }

        @NotNull
        public String toString() {
            return "AnomalyData(subtileClass=" + this.subtileClass + ", rarity=" + (Object)((Object)this.rarity) + ", strip=" + this.strip + ", color=" + this.color + ')';
        }

        public int hashCode() {
            int result = this.subtileClass.hashCode();
            result = result * 31 + this.rarity.hashCode();
            result = result * 31 + Integer.hashCode(this.strip);
            result = result * 31 + Integer.hashCode(this.color);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnomalyData)) {
                return false;
            }
            AnomalyData anomalyData = (AnomalyData)other;
            if (!Intrinsics.areEqual(this.subtileClass, anomalyData.subtileClass)) {
                return false;
            }
            if (this.rarity != anomalyData.rarity) {
                return false;
            }
            if (this.strip != anomalyData.strip) {
                return false;
            }
            return this.color == anomalyData.color;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lalfheim/api/AlfheimAPI$FallbackAnomaly;", "Lalfheim/api/block/tile/SubTileAnomalyBase;", "<init>", "()V", "targets", "", "", "getTargets", "()Ljava/util/List;", "performEffect", "", "target", "Alfheim"})
    private static final class FallbackAnomaly
    extends SubTileAnomalyBase {
        @NotNull
        public static final FallbackAnomaly INSTANCE = new FallbackAnomaly();
        @NotNull
        private static final List<Object> targets = CollectionsKt.emptyList();

        private FallbackAnomaly() {
        }

        @Override
        @NotNull
        public List<Object> getTargets() {
            return targets;
        }

        @Override
        public void performEffect(@NotNull Object target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        }
    }
}

