/*
 * Decompiled with CFR 0.152.
 */
package ru.vamig.worldengine.standardcustomgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import ru.vamig.worldengine.additions.WE_CreateChunkGen;
import ru.vamig.worldengine.additions.WE_GeneratorData;

public class WE_RavineGen
extends WE_CreateChunkGen {
    public final List<Block> replaceBlocksList = new ArrayList<Block>();
    public final List<Byte> replaceBlocksMetaList = new ArrayList<Byte>();
    public final Block caveBlock = null;
    public final byte caveBlockMeta = 0;
    public final Block lavaBlock = Blocks.field_150353_l;
    public final byte lavaBlockMeta = 0;
    public final int lavaMaxY = 12;
    public final int range = 8;
    public final float[] field_75046_d = new float[1024];
    final Random rand = new Random();

    public WE_RavineGen() {
        this.replaceBlocksList.add(Blocks.field_150348_b);
        this.replaceBlocksMetaList.add((byte)0);
    }

    @Override
    public void gen(WE_GeneratorData data) {
        this.rand.setSeed(data.chunkProvider.world.func_72905_C());
        long rx = this.rand.nextLong();
        long rz = this.rand.nextLong();
        for (long cx = data.chunk_X / 16L - 8L; cx <= data.chunk_X / 16L + 8L; ++cx) {
            for (long cz = data.chunk_Z / 16L - 8L; cz <= data.chunk_Z / 16L + 8L; ++cz) {
                long nv1 = cx * rx;
                long nv2 = cz * rz;
                this.rand.setSeed(nv1 ^ nv2 ^ data.chunkProvider.world.func_72905_C());
                if (this.rand.nextInt(50) != 0) continue;
                double gx = (double)cx * 16.0 + (double)this.rand.nextInt(16);
                double gy = (double)this.rand.nextInt(this.rand.nextInt(40) + 8) + 20.0;
                double gz = (double)cz * 16.0 + (double)this.rand.nextInt(16);
                int b0 = 1;
                for (int i1 = 0; i1 < b0; ++i1) {
                    float x = this.rand.nextFloat() * 2.0f * (float)Math.PI;
                    float x1 = (this.rand.nextFloat() - 0.5f) * 0.25f;
                    float x2 = (this.rand.nextFloat() * 2.0f + this.rand.nextFloat()) * 2.0f;
                    this.caveGen_func(data, this.rand.nextLong(), gx, gy, gz, x2, x, x1, 0, 0, 3.0);
                }
            }
        }
    }

    public void caveGen_func(WE_GeneratorData data, long rs, double gx, double gy, double gz, float fn1, float fn2, float fn3, int in1, int in2, double dn) {
        double d4 = (double)data.chunk_X + 8.0;
        double d5 = (double)data.chunk_Z + 8.0;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random r = new Random(rs);
        if (in2 <= 0) {
            int p = 112;
            in2 = p - r.nextInt(p / 4);
        }
        boolean flag1 = false;
        if (in1 == -1) {
            in1 = in2 / 2;
            flag1 = true;
        }
        float f5 = 1.0f;
        for (int k1 = 0; k1 < 256; ++k1) {
            if (k1 == 0 || r.nextInt(3) == 0) {
                f5 = 1.0f + r.nextFloat() * r.nextFloat() * 1.0f;
            }
            this.field_75046_d[k1] = f5 * f5;
        }
        while (in1 < in2) {
            double d12 = 1.5 + (double)MathHelper.func_76126_a((float)((float)in1 * (float)Math.PI / (float)in2)) * (double)fn1;
            double d6 = d12 * dn;
            d12 *= (double)r.nextFloat() * 0.25 + 0.75;
            d6 *= (double)r.nextFloat() * 0.25 + 0.75;
            float f6 = MathHelper.func_76134_b((float)fn3);
            float f7 = MathHelper.func_76126_a((float)fn3);
            gx += (double)MathHelper.func_76134_b((float)fn2) * (double)f6;
            gy += (double)f7;
            gz += (double)MathHelper.func_76126_a((float)fn2) * (double)f6;
            fn3 *= 0.7f;
            fn3 += f4 * 0.05f;
            fn2 += f3 * 0.05f;
            f4 *= 0.8f;
            f3 *= 0.5f;
            f4 += (r.nextFloat() - r.nextFloat()) * r.nextFloat() * 2.0f;
            f3 += (r.nextFloat() - r.nextFloat()) * r.nextFloat() * 4.0f;
            if (flag1 || r.nextInt(4) != 0) {
                double d7 = gx - d4;
                double d8 = gz - d5;
                double d9 = (double)in2 - (double)in1;
                double d10 = (double)fn1 + 18.0;
                if (d7 * d7 + d8 * d8 - d9 * d9 > d10 * d10) {
                    return;
                }
                if (gx >= d4 - 16.0 - d12 * 2.0 && gz >= d5 - 16.0 - d12 * 2.0 && gx <= d4 + 16.0 + d12 * 2.0 && gz <= d5 + 16.0 + d12 * 2.0) {
                    int j3;
                    int k2;
                    int i4 = MathHelper.func_76128_c((double)(gx - d12)) - (int)data.chunk_X - 1;
                    int l1 = MathHelper.func_76128_c((double)(gx + d12)) - (int)data.chunk_X + 1;
                    int j4 = MathHelper.func_76128_c((double)(gy - d6)) - 1;
                    int i2 = MathHelper.func_76128_c((double)(gy + d6)) + 1;
                    int k4 = MathHelper.func_76128_c((double)(gz - d12)) - (int)data.chunk_Z - 1;
                    int j2 = MathHelper.func_76128_c((double)(gz + d12)) - (int)data.chunk_Z + 1;
                    if (i4 < 0) {
                        i4 = 0;
                    }
                    if (l1 > 16) {
                        l1 = 16;
                    }
                    if (j4 < 1) {
                        j4 = 1;
                    }
                    if (i2 > 248) {
                        i2 = 248;
                    }
                    if (k4 < 0) {
                        k4 = 0;
                    }
                    if (j2 > 16) {
                        j2 = 16;
                    }
                    boolean flag2 = false;
                    for (k2 = i4; !flag2 && k2 < l1; ++k2) {
                        for (int l2 = k4; !flag2 && l2 < j2; ++l2) {
                            for (int i3 = i2 + 1; !flag2 && i3 >= j4 - 1; --i3) {
                                j3 = (k2 * 16 + l2) * 256 + i3;
                                if (i3 < 0 || i3 >= 256) continue;
                                if (this.isOceanBlock(data, j3, k2, i3, l2)) {
                                    flag2 = true;
                                }
                                if (i3 == j4 - 1 || k2 == i4 || k2 == l1 - 1 || l2 == k4 || l2 == j2 - 1) continue;
                                i3 = j4;
                            }
                        }
                    }
                    if (!flag2) {
                        for (k2 = i4; k2 < l1; ++k2) {
                            double d13 = ((double)k2 + (double)data.chunk_X + 0.5 - gx) / d12;
                            for (j3 = k4; j3 < j2; ++j3) {
                                double d14 = ((double)j3 + (double)data.chunk_Z + 0.5 - gz) / d12;
                                int k3 = (k2 * 16 + j3) * 256 + i2;
                                if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                                for (int l3 = i2 - 1; l3 >= j4; --l3) {
                                    double d11 = ((double)l3 + 0.5 - gy) / d6;
                                    if ((d13 * d13 + d14 * d14) * (double)this.field_75046_d[l3] + d11 * d11 / 6.0 < 1.0) {
                                        this.digBlock(data, k3, k2, l3, j3);
                                    }
                                    --k3;
                                }
                            }
                        }
                        if (flag1) break;
                    }
                }
            }
            ++in1;
        }
    }

    public boolean isOceanBlock(WE_GeneratorData data, int index, int x, int y, int z) {
        if (data.chunkBlocks[index] != null) {
            return data.chunkBlocks[index].func_149688_o().func_76224_d();
        }
        return false;
    }

    public void digBlock(WE_GeneratorData data, int index, int x, int y, int z) {
        if (data.chunkBlocks[index] instanceof BlockFalling || data.chunkBlocks[index + 1] instanceof BlockFalling) {
            return;
        }
        for (int i2 = 0; i2 < this.replaceBlocksList.size(); ++i2) {
            if (data.chunkBlocks[index] != this.replaceBlocksList.get(i2) || data.chunkBlocksMeta[index] != this.replaceBlocksMetaList.get(i2)) continue;
            if (y <= 12) {
                data.chunkBlocks[index] = this.lavaBlock;
                data.chunkBlocksMeta[index] = 0;
                break;
            }
            data.chunkBlocks[index] = this.caveBlock;
            data.chunkBlocksMeta[index] = 0;
            break;
        }
    }

    public void addReplacingBlock(Block block, byte meta) {
        this.replaceBlocksList.add(block);
        this.replaceBlocksMetaList.add(meta);
    }
}

