/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.minecraft;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import gloomyfolken.hooklib.asm.ClassMetadataReader;
import gloomyfolken.hooklib.asm.HookClassTransformer;
import gloomyfolken.hooklib.minecraft.HookLibPlugin;
import gloomyfolken.hooklib.minecraft.HookLoader;
import gloomyfolken.hooklib.minecraft.MinecraftClassTransformer;
import java.io.IOException;
import java.lang.reflect.Method;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassVisitor;

public class DeobfuscationMetadataReader
extends ClassMetadataReader {
    private static Method runTransformers;

    @Override
    public byte[] getClassData(String className) throws IOException {
        byte[] bytes = super.getClassData(DeobfuscationMetadataReader.unmap(className.replace('.', '/')));
        return DeobfuscationMetadataReader.deobfuscateClass(className, bytes);
    }

    @Override
    protected ClassMetadataReader.MethodReference getMethodReferenceASM(String type2, String methodName, String desc) throws IOException {
        ClassMetadataReader.FindMethodClassVisitor cv = new ClassMetadataReader.FindMethodClassVisitor(methodName, desc);
        byte[] bytes = DeobfuscationMetadataReader.getTransformedBytes(type2);
        this.acceptVisitor(bytes, (ClassVisitor)cv);
        return cv.found ? new ClassMetadataReader.MethodReference(type2, cv.targetName, cv.targetDesc) : null;
    }

    @Override
    protected boolean checkSameMethod(String sourceName, String sourceDesc, String targetName, String targetDesc) {
        return DeobfuscationMetadataReader.checkSameMethod(sourceName, targetName) && sourceDesc.equals(targetDesc);
    }

    private static boolean checkSameMethod(String srgName, String mcpName) {
        if (HookLibPlugin.getObfuscated() && MinecraftClassTransformer.instance != null) {
            int methodId = MinecraftClassTransformer.getMethodId(srgName);
            String remappedName = MinecraftClassTransformer.instance.getMethodNames().get(methodId);
            if (remappedName != null && remappedName.equals(mcpName)) {
                return true;
            }
        }
        return srgName.equals(mcpName);
    }

    private static byte[] getTransformedBytes(String type2) throws IOException {
        String obfName = DeobfuscationMetadataReader.unmap(type2);
        byte[] bytes = Launch.classLoader.getClassBytes(obfName);
        if (bytes == null) {
            throw new RuntimeException("Bytes for " + obfName + " not found");
        }
        try {
            bytes = (byte[])runTransformers.invoke((Object)Launch.classLoader, obfName, type2, bytes);
        }
        catch (Exception e) {
            HookClassTransformer.logger.error("Error:", e);
        }
        return bytes;
    }

    private static String unmap(String type2) {
        if (HookLibPlugin.getObfuscated()) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(type2);
        }
        return type2;
    }

    static byte[] deobfuscateClass(String className, byte[] bytes) {
        if (HookLoader.getDeobfuscationTransformer() != null) {
            bytes = HookLoader.getDeobfuscationTransformer().transform(className, className, bytes);
        }
        return bytes;
    }

    static {
        try {
            runTransformers = LaunchClassLoader.class.getDeclaredMethod("runTransformers", String.class, String.class, byte[].class);
            runTransformers.setAccessible(true);
        }
        catch (Exception e) {
            HookClassTransformer.logger.error("Error:", e);
        }
    }
}

