/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class TypeHelper {
    private static final Map<String, Type> primitiveTypes = new HashMap<String, Type>(9);

    public static Type getType(String className) {
        return TypeHelper.getArrayType(className, 0);
    }

    public static Type getArrayType(String className, int arrayDimensions) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < arrayDimensions; ++i2) {
            sb.append("[");
        }
        Type primitive = primitiveTypes.get(className);
        if (primitive == null) {
            sb.append("L");
            sb.append(className.replace(".", "/"));
            sb.append(";");
        } else {
            sb.append(primitive.getDescriptor());
        }
        return Type.getType((String)sb.toString());
    }

    public static Type getArrayType(String className) {
        return TypeHelper.getArrayType(className, 1);
    }

    static Object getStackMapFrameEntry(Type type2) {
        if (type2 == Type.BOOLEAN_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.CHAR_TYPE || type2 == Type.INT_TYPE) {
            return Opcodes.INTEGER;
        }
        if (type2 == Type.FLOAT_TYPE) {
            return Opcodes.FLOAT;
        }
        if (type2 == Type.DOUBLE_TYPE) {
            return Opcodes.DOUBLE;
        }
        if (type2 == Type.LONG_TYPE) {
            return Opcodes.LONG;
        }
        return type2.getInternalName();
    }

    static {
        primitiveTypes.put("void", Type.VOID_TYPE);
        primitiveTypes.put("boolean", Type.BOOLEAN_TYPE);
        primitiveTypes.put("byte", Type.BYTE_TYPE);
        primitiveTypes.put("short", Type.SHORT_TYPE);
        primitiveTypes.put("char", Type.CHAR_TYPE);
        primitiveTypes.put("int", Type.INT_TYPE);
        primitiveTypes.put("float", Type.FLOAT_TYPE);
        primitiveTypes.put("long", Type.LONG_TYPE);
        primitiveTypes.put("double", Type.DOUBLE_TYPE);
    }
}

