/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.asm.AsmHook;
import gloomyfolken.hooklib.asm.ClassMetadataReader;
import gloomyfolken.hooklib.asm.HookContainerParser;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookLogger;
import gloomyfolken.hooklib.asm.SafeClassWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class HookClassTransformer {
    public static List<AsmHook> notInjectedHooks = new ArrayList<AsmHook>();
    public static HookLogger logger = new HookLogger.Log4JLogger("Hooklib");
    protected HashMap<String, List<AsmHook>> hooksMap = new HashMap();
    protected ClassMetadataReader classMetadataReader = new ClassMetadataReader();
    private HookContainerParser containerParser = new HookContainerParser(this);

    public void registerHook(AsmHook hook) {
        if (this.hooksMap.containsKey(hook.getTargetClassName())) {
            this.hooksMap.get(hook.getTargetClassName()).add(hook);
        } else {
            ArrayList<AsmHook> list = new ArrayList<AsmHook>(2);
            list.add(hook);
            this.hooksMap.put(hook.getTargetClassName(), list);
        }
        notInjectedHooks.add(hook);
    }

    public void registerHookContainer(String className) {
        this.containerParser.parseHooks(className);
    }

    public void registerHookContainer(byte[] classData) {
        this.containerParser.parseHooks(classData);
    }

    public byte[] transform(String className, byte[] bytecode) {
        if (bytecode == null) {
            return null;
        }
        List<AsmHook> hooks = this.hooksMap.get(className);
        if (hooks != null) {
            Collections.sort(hooks);
            logger.debug("Injecting hooks into class " + className);
            try {
                int majorVersion = (bytecode[6] & 0xFF) << 8 | bytecode[7] & 0xFF;
                boolean java7 = majorVersion > 50;
                ClassReader cr = new ClassReader(bytecode);
                ClassWriter cw = this.createClassWriter(java7 ? 2 : 1);
                HookInjectorClassVisitor hooksWriter = this.createInjectorClassVisitor(cw, hooks);
                cr.accept((ClassVisitor)hooksWriter, java7 ? 4 : 8);
                bytecode = cw.toByteArray();
                hooks.removeAll(hooksWriter.injectedHooks);
                notInjectedHooks.removeAll(hooksWriter.injectedHooks);
            }
            catch (Exception e) {
                logger.error("A problem has occurred during transformation of class " + className + ".");
                logger.error("Attached hooks:");
                for (AsmHook hook : hooks) {
                    logger.error(hook.toString());
                }
                logger.error("Stack trace:", e);
            }
            for (AsmHook notInjected : hooks) {
                if (notInjected.isMandatory()) {
                    throw new RuntimeException("Can not find target method of mandatory hook " + notInjected);
                }
                logger.warning("Can not find target method of hook " + notInjected);
            }
        }
        return bytecode;
    }

    protected ClassWriter createClassWriter(int flags) {
        return new SafeClassWriter(this.classMetadataReader, flags);
    }

    protected HookInjectorClassVisitor createInjectorClassVisitor(ClassWriter cw, List<AsmHook> hooks) {
        return new HookInjectorClassVisitor(this, cw, hooks);
    }
}

