/*
 * Decompiled with CFR 0.152.
 */
package com.KAIIIAK.classManipulators;

import com.KAIIIAK.KASMLib.KASMWorker;
import com.KAIIIAK.classManipulators.ChangesHolder;
import com.KAIIIAK.classManipulators.HookReplacer;
import com.KAIIIAK.classManipulators.SomeUtil;
import com.KAIIIAK.nullsafety.Opt;
import com.KAIIIAK.superwrapper.McpToSrg;
import com.google.common.collect.ImmutableMap;
import gloomyfolken.hooklib.asm.HookLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class HookReplacerWorker
extends KASMWorker {
    public static HookLogger logger = new HookLogger.Log4JLogger("HookReplacer");
    public static HookReplacerWorker inst = new HookReplacerWorker();
    public List<ChangesHolder> methodsToChange = new ArrayList<ChangesHolder>();
    public static List<ChangesHolder> registeredMethods = new ArrayList<ChangesHolder>();
    private static ImmutableMap<String, Integer> loadStoreInsns = ImmutableMap.builder().put((Object)"ILOAD", (Object)21).put((Object)"LLOAD", (Object)22).put((Object)"FLOAD", (Object)23).put((Object)"DLOAD", (Object)24).put((Object)"ALOAD", (Object)25).put((Object)"ISTORE", (Object)54).put((Object)"LSTORE", (Object)55).put((Object)"FSTORE", (Object)56).put((Object)"DSTORE", (Object)57).put((Object)"ASTORE", (Object)58).build();

    private HookReplacerWorker() {
        this.withRecalc = true;
    }

    @Override
    public void workDataStart() {
        super.workDataStart();
        this.methodsToChange.clear();
    }

    @Override
    public boolean workClass(ClassNode classNode) {
        for (ChangesHolder changesHolder : Opt.it(registeredMethods)) {
            if (!classNode.name.equals(changesHolder.clazz.getInternalName()) && !this.className.equals(changesHolder.clazz.getInternalName()) && !this.transformedClassName.equals(changesHolder.clazz.getClassName())) continue;
            logger.debug("Found Class to hook into " + this.transformedClassName);
            this.methodsToChange.add(changesHolder);
        }
        return false;
    }

    @Override
    public boolean workMethod(ClassNode classNode, MethodNode methodNode) {
        ArrayList<ChangesHolder> found = new ArrayList<ChangesHolder>();
        for (ChangesHolder changesHolder : Opt.it(this.methodsToChange)) {
            String actualName = McpToSrg.getTargetMethodMatchingNameAndDesc(classNode.methods, changesHolder.methodName, Type.getMethodDescriptor((Type)changesHolder.methodReturn, (Type[])changesHolder.methodParams));
            logger.debug(String.format("Testing method %s to be equal to %s", methodNode.name, actualName));
            if (!methodNode.name.equals(actualName)) continue;
            logger.debug(String.format("Found method to hook into %s", methodNode.name));
            Type methodType = Type.getMethodType((String)methodNode.desc);
            if (!methodType.getReturnType().equals((Object)changesHolder.methodReturn)) continue;
            logger.debug(String.format("Found method to hook into with a correct return type %s", methodNode.name));
            Type[] argTypes = methodType.getArgumentTypes();
            if (!this.isTypesSame(argTypes, changesHolder.methodParams)) continue;
            logger.debug(String.format("Found method to hook into with a correct method params %s", methodNode.name));
            this.workMethodChanges(methodNode, changesHolder);
            found.add(changesHolder);
        }
        if (!found.isEmpty()) {
            this.methodsToChange.removeAll(found);
        }
        return false;
    }

    public boolean isTypesSame(Type[] types1, Type[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        for (int i2 = 0; i2 < types1.length; ++i2) {
            if (types1[i2].equals((Object)types2[i2])) continue;
            return false;
        }
        return true;
    }

    public static List<AbstractInsnNode> getWithStaticIndexes(List<AbstractInsnNode> list) {
        ArrayList<AbstractInsnNode> buff = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode node : Opt.it(list)) {
            if (!(node instanceof VarInsnNode) || node.getOpcode() == 169) {
                buff.add(node);
                continue;
            }
            VarInsnNode varNode = (VarInsnNode)node;
            buff.add((AbstractInsnNode)new VarInsnNode(varNode.getOpcode(), varNode.var - 1));
        }
        return buff;
    }

    public void workMethodChanges(MethodNode methodNode, ChangesHolder changes) {
        for (int i2 = 0; i2 < methodNode.instructions.size(); ++i2) {
            logger.trace(String.format("methodNode.instructions.get(%d) = %s", i2, SomeUtil.getStringRepresentation(methodNode.instructions.get(i2))));
        }
        for (Map.Entry entry : Opt.it((methodNode.access & 8) != 0 && !changes.correctStaticIndexes ? changes.instToReplaceForStaticSrc.entrySet() : changes.instToReplace.entrySet())) {
            List fromList = (List)entry.getKey();
            List toList = (List)entry.getValue();
            for (int i3 = 0; i3 < fromList.size(); ++i3) {
                logger.trace(String.format("fromList.get(%d) = %s", i3, SomeUtil.getStringRepresentation((AbstractInsnNode)fromList.get(i3))));
            }
            for (int i2 = 0; i2 < toList.size(); ++i2) {
                logger.trace(String.format("toList.get(%d) = %s", i2, SomeUtil.getStringRepresentation((AbstractInsnNode)toList.get(i2))));
            }
            AbstractInsnNode[] fromArray = fromList.toArray(new AbstractInsnNode[0]);
            InsnList instructions = methodNode.instructions;
            int index = this.findInstructions(instructions, fromArray, 0);
            while (index >= 0) {
                this.removeInstructions(instructions, index, fromArray.length);
                InsnList toList2 = new InsnList();
                for (AbstractInsnNode abstractInsnNode : Opt.it(toList)) {
                    toList2.add(SomeUtil.copyInsnNode(abstractInsnNode));
                }
                instructions.insertBefore(instructions.get(index), toList2);
                logger.debug(String.format("Replaced insns at index %s", index));
                ++this.changes;
                index = this.findInstructions(instructions, fromArray, index + 1);
            }
        }
    }

    private int findInstructions(InsnList instructions, AbstractInsnNode[] fromArray, int startFromIndex) {
        if (fromArray == null || fromArray.length == 0 || instructions == null || instructions.size() == 0) {
            return -1;
        }
        AbstractInsnNode[] mainInstructions = instructions.toArray();
        AbstractInsnNode first = fromArray[0];
        List<Integer> all = this.findAll(mainInstructions, first);
        block0: for (Integer firstIndex : Opt.it(all)) {
            if (firstIndex < startFromIndex || firstIndex + fromArray.length - 1 > mainInstructions.length - 1) continue;
            for (int i2 = 0; i2 < fromArray.length; ++i2) {
                if (!SomeUtil.myEquals(mainInstructions[i2 + firstIndex], fromArray[i2])) continue block0;
            }
            return firstIndex;
        }
        return -1;
    }

    private List<Integer> findAll(AbstractInsnNode[] instructions, AbstractInsnNode first) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 = 0; i2 < instructions.length; ++i2) {
            if (!SomeUtil.myEquals(instructions[i2], first)) continue;
            list.add(i2);
        }
        return list;
    }

    private void removeInstructions(InsnList instructions, int startIndex, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            instructions.remove(instructions.get(startIndex));
        }
    }

    public static void registerHookReplacerContainer(String clazz) {
        Opt.it(HookReplacerWorker.class.getResourceAsStream('/' + clazz.replace('.', '/') + ".class"), it -> {
            try {
                HookReplacerWorker.registerHookReplacerContainer(IOUtils.toByteArray((InputStream)it));
            }
            catch (IOException e) {
                logger.error(String.format("Can not parse hooks container %s", clazz), e);
                throw new RuntimeException(e);
            }
        });
    }

    public static void registerHookReplacerContainer(byte[] clazzBytes) {
        try {
            ClassReader classReader = new ClassReader(clazzBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : Opt.it(classNode.methods)) {
                AnnotationNode hookReplacerAnnotation = null;
                for (AnnotationNode annotationNode : Opt.it(methodNode.visibleAnnotations)) {
                    if (!annotationNode.desc.contains("HookReplacer")) continue;
                    hookReplacerAnnotation = annotationNode;
                    break;
                }
                for (AnnotationNode annotationNode : Opt.it(methodNode.invisibleAnnotations)) {
                    if (!annotationNode.desc.contains("HookReplacer")) continue;
                    hookReplacerAnnotation = annotationNode;
                    break;
                }
                if (hookReplacerAnnotation == null) continue;
                String targetMethodFromAnnotation = null;
                boolean correctStaticIndexes = false;
                if (hookReplacerAnnotation.values != null) {
                    Map<String, Object> annotationArgs = SomeUtil.convertListToMap(hookReplacerAnnotation.values);
                    if (annotationArgs.containsKey("targetMethod")) {
                        targetMethodFromAnnotation = (String)annotationArgs.get("targetMethod");
                    }
                    if (annotationArgs.containsKey("correctStaticIndexes")) {
                        correctStaticIndexes = (Boolean)annotationArgs.get("correctStaticIndexes");
                    }
                }
                logger.debug(String.format("Found HookReplacer annotation: %s.%s%s", classNode.name, methodNode.name, methodNode.desc));
                Type methodType = Type.getMethodType((String)methodNode.desc);
                Type[] argTypes = methodType.getArgumentTypes();
                if (argTypes.length == 0) continue;
                ListIterator iterator2 = methodNode.instructions.iterator();
                ArrayList<AbstractInsnNode> from = new ArrayList<AbstractInsnNode>();
                ArrayList<AbstractInsnNode> to = new ArrayList<AbstractInsnNode>();
                boolean isInsideFromBlock = false;
                boolean isInsideToBlock = false;
                block15: while (iterator2.hasNext()) {
                    AbstractInsnNode insnNode = (AbstractInsnNode)iterator2.next();
                    if (insnNode instanceof MethodInsnNode && insnNode.getOpcode() == 184 && Type.getInternalName(HookReplacer.Replacer.class).equals(((MethodInsnNode)insnNode).owner)) {
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                        switch (methodInsnNode.name) {
                            case "startFROM": {
                                isInsideFromBlock = true;
                                isInsideToBlock = false;
                                continue block15;
                            }
                            case "startTO": {
                                isInsideFromBlock = false;
                                isInsideToBlock = true;
                                continue block15;
                            }
                            case "stop": {
                                isInsideFromBlock = false;
                                isInsideToBlock = false;
                                continue block15;
                            }
                        }
                    }
                    if (isInsideFromBlock) {
                        from.add(SomeUtil.copyInsnNode(insnNode));
                    }
                    if (!isInsideToBlock) continue;
                    to.add(SomeUtil.copyInsnNode(insnNode));
                }
                HookReplacerWorker.removePOP(from);
                HookReplacerWorker.removePOP(to);
                HookReplacerWorker.removeLines(from);
                HookReplacerWorker.removeLines(to);
                HookReplacerWorker.removeStoreLoad(from);
                HookReplacerWorker.removeStoreLoad(to);
                if (from.isEmpty()) continue;
                String methodName = targetMethodFromAnnotation != null ? targetMethodFromAnnotation : methodNode.name;
                ChangesHolder changesHolder = new ChangesHolder(argTypes[0], methodName);
                changesHolder.instToReplace.put(from, to);
                if (!correctStaticIndexes) {
                    changesHolder.instToReplaceForStaticSrc.put(HookReplacerWorker.getWithStaticIndexes(from), HookReplacerWorker.getWithStaticIndexes(to));
                    changesHolder.correctStaticIndexes = false;
                }
                Type[] methodParams = new Type[argTypes.length - 1];
                System.arraycopy(argTypes, 1, methodParams, 0, methodParams.length);
                changesHolder.methodParams = methodParams;
                changesHolder.methodReturn = methodType.getReturnType();
                registeredMethods.add(changesHolder);
                logger.debug(String.format("HookReplacer at %s.%s%s registered!", classNode.name, methodNode.name, methodNode.desc));
            }
        }
        catch (Exception e) {
            logger.error("Can not parse hooks container", e);
            throw new RuntimeException(e);
        }
    }

    private static void removePOP(List<AbstractInsnNode> list) {
        AbstractInsnNode last;
        if (!list.isEmpty()) {
            list.removeIf(node -> node instanceof MethodInsnNode && node.getOpcode() == 184 && Type.getInternalName(HookReplacer.Replacer.class).equals(((MethodInsnNode)node).owner) && ((MethodInsnNode)node).name.equals("POP"));
        }
        if (!list.isEmpty() && (last = list.get(list.size() - 1)) instanceof InsnNode && last.getOpcode() == 87) {
            list.remove(last);
        }
    }

    private static void removeLines(ArrayList<AbstractInsnNode> list) {
        ArrayList<AbstractInsnNode> listToRemove = new ArrayList<AbstractInsnNode>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AbstractInsnNode nodeBefore;
            AbstractInsnNode node = list.get(i2);
            if (!(node instanceof MethodInsnNode) || node.getOpcode() != 184 || !Type.getInternalName(HookReplacer.Replacer.class).equals(((MethodInsnNode)node).owner) || !((MethodInsnNode)node).name.equals("POPLine")) continue;
            listToRemove.add(node);
            if (i2 - 1 >= 0 && ((nodeBefore = list.get(i2 - 1)) instanceof LineNumberNode || nodeBefore instanceof LabelNode)) {
                listToRemove.add(nodeBefore);
            }
            if (i2 - 2 < 0 || !((nodeBefore = list.get(i2 - 2)) instanceof LineNumberNode) && !(nodeBefore instanceof LabelNode)) continue;
            listToRemove.add(nodeBefore);
        }
        list.removeAll(listToRemove);
    }

    private static void removeStoreLoad(ArrayList<AbstractInsnNode> list) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AbstractInsnNode node = list.get(i2);
            if (!(node instanceof MethodInsnNode)) {
                newList.add(node);
                continue;
            }
            MethodInsnNode mnode = (MethodInsnNode)node;
            if (node.getOpcode() != 184 || !Type.getInternalName(HookReplacer.Replacer.class).equals(mnode.owner) || !loadStoreInsns.containsKey((Object)mnode.name)) {
                newList.add(mnode);
                continue;
            }
            LdcInsnNode varIndex = (LdcInsnNode)newList.remove(newList.size() - 1);
            int var = Integer.parseInt(varIndex.cst.toString());
            newList.add(new VarInsnNode(((Integer)loadStoreInsns.get((Object)mnode.name)).intValue(), var));
            if (!mnode.name.equals("ALOAD")) continue;
            ++i2;
        }
        list.clear();
        list.addAll(newList);
    }
}

