/*
 * Decompiled with CFR 0.152.
 */
package com.KAIIIAK.KASMLib;

import alexsocol.patcher.PatcherConfigHandler;
import com.KAIIIAK.KASMLib.KASMWorker;
import com.KAIIIAK.nullsafety.Opt;
import gloomyfolken.hooklib.asm.HookLogger;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class KASMLib
implements IClassTransformer {
    public static HookLogger logger = new HookLogger.Log4JLogger("KASMLib");
    public static boolean has2DumpChangedClasses = false;
    public static boolean has2DumpUnchangedClasses = false;
    public static Set<KASMWorker> workers = new HashSet<KASMWorker>();
    public boolean withRecalc;

    public KASMLib(boolean recalc) {
        this.withRecalc = recalc;
    }

    public static void register(KASMWorker worker) {
        workers.add(worker);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            if (basicClass == null) {
                return null;
            }
            ClassReader classReader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            ClassWriter classWriter = this.withRecalc ? new ClassWriter(classReader, 3) : new ClassWriter(classReader, 0);
            long cng = 0L;
            for (KASMWorker asmWorker : Opt.it(workers)) {
                if (asmWorker == null || asmWorker.withRecalc != this.withRecalc) continue;
                asmWorker.className = name;
                asmWorker.transformedClassName = transformedName;
                asmWorker.workDataStart();
                if (asmWorker.workClass(classNode)) {
                    return null;
                }
                if (classNode.attrs != null) {
                    classNode.attrs.removeIf(attribute -> asmWorker.workClassAttribute(classNode, (Attribute)attribute));
                }
                if (classNode.innerClasses != null) {
                    classNode.innerClasses.removeIf(innerClassNode -> asmWorker.workInnerClassNode(classNode, (InnerClassNode)innerClassNode));
                }
                if (classNode.visibleAnnotations != null) {
                    classNode.visibleAnnotations.removeIf(annotationNode -> asmWorker.workClassVisibleAnnotation(classNode, (AnnotationNode)annotationNode));
                }
                if (classNode.visibleTypeAnnotations != null) {
                    classNode.visibleTypeAnnotations.removeIf(typeAnnotationNode -> asmWorker.workClassVisibleTypeAnnotation(classNode, (TypeAnnotationNode)typeAnnotationNode));
                }
                if (classNode.invisibleAnnotations != null) {
                    classNode.invisibleAnnotations.removeIf(annotationNode -> asmWorker.workClassInvisibleAnnotation(classNode, (AnnotationNode)annotationNode));
                }
                if (classNode.invisibleTypeAnnotations != null) {
                    classNode.invisibleTypeAnnotations.removeIf(typeAnnotationNode -> asmWorker.workClassInvisibleTypeAnnotation(classNode, (TypeAnnotationNode)typeAnnotationNode));
                }
                if (classNode.fields != null) {
                    classNode.fields.removeIf(fieldNode -> asmWorker.workField(classNode, (FieldNode)fieldNode));
                    for (FieldNode fieldNode2 : classNode.fields) {
                        if (fieldNode2.attrs != null) {
                            fieldNode2.attrs.removeIf(attribute -> asmWorker.workFieldAttribute(classNode, (Attribute)attribute));
                        }
                        if (fieldNode2.invisibleAnnotations != null) {
                            fieldNode2.invisibleAnnotations.removeIf(annotation -> asmWorker.workFieldInvisibleAnnotations(classNode, fieldNode2, (AnnotationNode)annotation));
                        }
                        if (fieldNode2.invisibleTypeAnnotations != null) {
                            fieldNode2.invisibleTypeAnnotations.removeIf(annotation -> asmWorker.workFieldInvisibleTypeAnnotations(classNode, fieldNode2, (TypeAnnotationNode)annotation));
                        }
                        if (fieldNode2.visibleAnnotations != null) {
                            fieldNode2.visibleAnnotations.removeIf(annotation -> asmWorker.workFieldVisibleAnnotations(classNode, fieldNode2, (AnnotationNode)annotation));
                        }
                        if (fieldNode2.visibleTypeAnnotations == null) continue;
                        fieldNode2.visibleTypeAnnotations.removeIf(annotation -> asmWorker.workFieldVisibleTypeAnnotations(classNode, fieldNode2, (TypeAnnotationNode)annotation));
                    }
                }
                if (classNode.interfaces != null) {
                    FieldNode fieldNode2;
                    ArrayList<String> interfacesL = new ArrayList<String>();
                    fieldNode2 = classNode.interfaces.iterator();
                    while (fieldNode2.hasNext()) {
                        String interf = (String)fieldNode2.next();
                        AtomicReference<String> interfaceA = new AtomicReference<String>(interf);
                        if (asmWorker.workInterface(classNode, interfaceA)) continue;
                        interfacesL.add(interfaceA.get());
                    }
                    classNode.interfaces = interfacesL;
                }
                if (classNode.methods != null) {
                    classNode.methods.removeIf(methodNode -> asmWorker.workMethod(classNode, (MethodNode)methodNode));
                    for (MethodNode methodNode2 : classNode.methods) {
                        Type[] argumentTypes;
                        if (methodNode2.attrs != null) {
                            methodNode2.attrs.removeIf(attribute -> asmWorker.workMethodAttribute(classNode, methodNode2, (Attribute)attribute));
                        }
                        if (methodNode2.localVariables != null) {
                            methodNode2.localVariables.removeIf(localVariableNode -> asmWorker.workMethodLocalVariable(classNode, methodNode2, (LocalVariableNode)localVariableNode));
                        }
                        if (methodNode2.visibleLocalVariableAnnotations != null) {
                            methodNode2.visibleLocalVariableAnnotations.removeIf(localVariableAnnotationNode -> asmWorker.workMethodVisibleLocalVariableAnnotations(classNode, methodNode2, (LocalVariableAnnotationNode)localVariableAnnotationNode));
                        }
                        if (methodNode2.invisibleLocalVariableAnnotations != null) {
                            methodNode2.invisibleLocalVariableAnnotations.removeIf(localVariableAnnotationNode -> asmWorker.workMethodInvisibleLocalVariableAnnotations(classNode, methodNode2, (LocalVariableAnnotationNode)localVariableAnnotationNode));
                        }
                        if (methodNode2.parameters != null) {
                            methodNode2.parameters.removeIf(parameterNode -> asmWorker.workMethodParameters(classNode, methodNode2, (ParameterNode)parameterNode));
                        }
                        if (methodNode2.invisibleAnnotations != null) {
                            methodNode2.invisibleAnnotations.removeIf(annotationNode -> asmWorker.workMethodInvisibleAnnotations(classNode, methodNode2, (AnnotationNode)annotationNode));
                        }
                        if (methodNode2.visibleAnnotations != null) {
                            methodNode2.visibleAnnotations.removeIf(annotationNode -> asmWorker.workMethodVisibleAnnotations(classNode, methodNode2, (AnnotationNode)annotationNode));
                        }
                        if (methodNode2.invisibleTypeAnnotations != null) {
                            methodNode2.invisibleTypeAnnotations.removeIf(typeAnnotationNode -> asmWorker.workMethodInvisibleTypeAnnotations(classNode, methodNode2, (TypeAnnotationNode)typeAnnotationNode));
                        }
                        if (methodNode2.visibleTypeAnnotations != null) {
                            methodNode2.visibleTypeAnnotations.removeIf(typeAnnotationNode -> asmWorker.workMethodVisibleTypeAnnotations(classNode, methodNode2, (TypeAnnotationNode)typeAnnotationNode));
                        }
                        if (methodNode2.tryCatchBlocks != null) {
                            methodNode2.tryCatchBlocks.removeIf(tryCatchBlockNode -> asmWorker.workMethodTryCatchBlocks(classNode, methodNode2, (TryCatchBlockNode)tryCatchBlockNode));
                        }
                        for (List listAnnotationNode : Opt.it(methodNode2.invisibleParameterAnnotations)) {
                            if (listAnnotationNode == null) continue;
                            listAnnotationNode.removeIf(annotationNode -> asmWorker.workMethodInvisibleParameterAnnotations(classNode, methodNode2, (AnnotationNode)annotationNode));
                        }
                        for (List listAnnotationNode : Opt.it(methodNode2.visibleParameterAnnotations)) {
                            if (listAnnotationNode == null) continue;
                            listAnnotationNode.removeIf(annotationNode -> asmWorker.workMethodVisibleParameterAnnotations(classNode, methodNode2, (AnnotationNode)annotationNode));
                        }
                        Type methodType = Type.getMethodType((String)methodNode2.desc);
                        ArrayList<Type> argTypes = new ArrayList<Type>();
                        for (Type type2 : argumentTypes = methodType.getArgumentTypes()) {
                            AtomicReference<Type> typeA = new AtomicReference<Type>(type2);
                            if (asmWorker.workMethodArg(classNode, methodNode2, typeA)) continue;
                            argTypes.add(typeA.get());
                        }
                        Type returnType = asmWorker.workMethodRet(classNode, methodNode2, methodType.getReturnType());
                        methodNode2.desc = Type.getMethodDescriptor((Type)returnType, (Type[])argTypes.toArray(new Type[0]));
                        if (methodNode2.instructions == null) continue;
                        for (AbstractInsnNode abstractInsnNode : methodNode2.instructions) {
                            if (abstractInsnNode instanceof TableSwitchInsnNode && asmWorker.workInstNode(classNode, methodNode2, (TableSwitchInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof MultiANewArrayInsnNode && asmWorker.workInstNode(classNode, methodNode2, (MultiANewArrayInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof LookupSwitchInsnNode && asmWorker.workInstNode(classNode, methodNode2, (LookupSwitchInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof LdcInsnNode && asmWorker.workInstNode(classNode, methodNode2, (LdcInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof InvokeDynamicInsnNode && asmWorker.workInstNode(classNode, methodNode2, (InvokeDynamicInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof IntInsnNode && asmWorker.workInstNode(classNode, methodNode2, (IntInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof IincInsnNode && asmWorker.workInstNode(classNode, methodNode2, (IincInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof FrameNode && asmWorker.workInstNode(classNode, methodNode2, (FrameNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof TypeInsnNode && asmWorker.workInstNode(classNode, methodNode2, (TypeInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof LabelNode && asmWorker.workInstNode(classNode, methodNode2, (LabelNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof LineNumberNode && asmWorker.workInstNode(classNode, methodNode2, (LineNumberNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof FieldInsnNode && asmWorker.workInstNode(classNode, methodNode2, (FieldInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof JumpInsnNode && asmWorker.workInstNode(classNode, methodNode2, (JumpInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof VarInsnNode && asmWorker.workInstNode(classNode, methodNode2, (VarInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (abstractInsnNode instanceof MethodInsnNode && asmWorker.workInstNode(classNode, methodNode2, (MethodInsnNode)abstractInsnNode)) {
                                methodNode2.instructions.remove(abstractInsnNode);
                            }
                            if (!(abstractInsnNode instanceof InsnNode) || !asmWorker.workInstNode(classNode, methodNode2, (InsnNode)abstractInsnNode)) continue;
                            methodNode2.instructions.remove(abstractInsnNode);
                        }
                    }
                }
                cng += asmWorker.changes;
                asmWorker.workDataEnd();
            }
            if (cng > 0L) {
                File file;
                if (PatcherConfigHandler.INSTANCE.getLogDebug()) {
                    logger.debug(String.format("Trying to make %d changes in %s(%s)", cng, name, transformedName));
                }
                classNode.accept((ClassVisitor)classWriter);
                byte[] bytes = classWriter.toByteArray();
                if (has2DumpChangedClasses) {
                    file = new File("ASJCoreDumpClasses/KASMLib/" + transformedName.replaceAll("\\.", "/") + ".class");
                    file.getParentFile().mkdirs();
                    IOUtils.write((byte[])bytes, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                }
                if (has2DumpUnchangedClasses) {
                    file = new File("ASJCoreDumpClasses/KASMLib/" + transformedName.replaceAll("\\.", "/") + "UNCHANGED.class");
                    file.getParentFile().mkdirs();
                    IOUtils.write((byte[])basicClass, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                }
                return bytes;
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error transforming class %s(%s)", name, transformedName), e);
            throw new RuntimeException(e);
        }
        return basicClass;
    }
}

