/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.patcher.asm.hook;

import alexsocol.asjlib.ExtensionsKt;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.McBlockPart;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J0\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0007JX\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0005H\u0007J0\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0007J:\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u0018\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0005H\u0007J8\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J8\u0010+\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0007J\u0012\u0010-\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010/H\u0007J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u000e\u001a\u00020/H\u0007J4\u00102\u001a\u0004\u0018\u0001032\b\u0010\u000e\u001a\u0004\u0018\u00010/2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00104\u001a\u0002052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0007R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!\u00a8\u00067"}, d2={"Lalexsocol/patcher/asm/hook/BlockButtonExtender;", "", "<init>", "()V", "buttonMeta", "", "Lnet/minecraftforge/common/util/ForgeDirection;", "getButtonMeta", "(Lnet/minecraftforge/common/util/ForgeDirection;)I", "buttonSide", "getButtonSide", "(I)Lnet/minecraftforge/common/util/ForgeDirection;", "canPlaceBlockOnSide", "", "button", "Lnet/minecraft/block/BlockButton;", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "side", "canPlaceBlockAt", "onBlockPlaced", "hitX", "", "hitY", "hitZ", "metadata", "pickValidMeta", "addedDirs", "", "getAddedDirs", "()[Lnet/minecraftforge/common/util/ForgeDirection;", "[Lnet/minecraftforge/common/util/ForgeDirection;", "onNeighborBlockChange", "", "block", "Lnet/minecraft/block/Block;", "setBlockBoundsFromMeta", "meta", "isProvidingStrongPower", "Lnet/minecraft/world/IBlockAccess;", "updateNeighbor", "metaBase", "ButtonPart$clinit", "static", "Lcodechicken/multipart/minecraft/ButtonPart;", "getBounds", "Lcodechicken/lib/vec/Cuboid6;", "placement", "Lcodechicken/multipart/minecraft/McBlockPart;", "pos", "Lcodechicken/lib/vec/BlockCoord;", "type", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nBlockButtonExtender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockButtonExtender.kt\nalexsocol/patcher/asm/hook/BlockButtonExtender\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,132:1\n12574#2,2:133\n1310#2,2:135\n*S KotlinDebug\n*F\n+ 1 BlockButtonExtender.kt\nalexsocol/patcher/asm/hook/BlockButtonExtender\n*L\n27#1:133,2\n47#1:135,2\n*E\n"})
public final class BlockButtonExtender {
    @NotNull
    public static final BlockButtonExtender INSTANCE = new BlockButtonExtender();
    @NotNull
    private static final ForgeDirection[] addedDirs;

    private BlockButtonExtender() {
    }

    private final int getButtonMeta(ForgeDirection $this$buttonMeta) {
        return 6 - $this$buttonMeta.ordinal();
    }

    private final ForgeDirection getButtonSide(int $this$buttonSide) {
        return (ForgeDirection)EntriesMappings.entries$0.get(6 - $this$buttonSide);
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static final boolean canPlaceBlockOnSide(@NotNull BlockButton button, @NotNull World world, int x, int y, int z, int side) {
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(world, "world");
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite());
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static final boolean canPlaceBlockAt(@NotNull BlockButton button, @NotNull World world, int x, int y, int z) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(button, "button");
            Intrinsics.checkNotNullParameter(world, "world");
            Intrinsics.checkNotNullExpressionValue(ForgeDirection.VALID_DIRECTIONS, "VALID_DIRECTIONS");
            Object[] $this$any$iv = ForgeDirection.VALID_DIRECTIONS;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ForgeDirection it = (ForgeDirection)element$iv;
                boolean bl2 = false;
                if (!world.isSideSolid(x + it.offsetX, y + it.offsetY, z + it.offsetZ, it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static final int onBlockPlaced(@NotNull BlockButton button, @NotNull World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int n;
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(world, "world");
        int meta = world.func_72805_g(x, y, z);
        int pressedFlag = meta & 8;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        if (world.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite())) {
            ForgeDirection forgeDirection = dir.getOpposite();
            Intrinsics.checkNotNullExpressionValue(forgeDirection, "getOpposite(...)");
            n = INSTANCE.getButtonMeta(forgeDirection);
        } else {
            n = BlockButtonExtender.pickValidMeta(button, world, x, y, z);
        }
        meta = n;
        return meta + pressedFlag;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS, targetMethod="func_150045_e")
    public static final int pickValidMeta(@NotNull BlockButton button, @NotNull World world, int x, int y, int z) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter(button, "button");
            Intrinsics.checkNotNullParameter(world, "world");
            Intrinsics.checkNotNullExpressionValue(ForgeDirection.VALID_DIRECTIONS, "VALID_DIRECTIONS");
            Object[] $this$firstOrNull$iv = ForgeDirection.VALID_DIRECTIONS;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ForgeDirection it = (ForgeDirection)element$iv;
                boolean bl = false;
                ForgeDirection op = it.getOpposite();
                if (!world.isSideSolid(x + op.offsetX, y + op.offsetY, z + op.offsetZ, it)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        ForgeDirection forgeDirection = (ForgeDirection)object;
        return forgeDirection != null ? INSTANCE.getButtonMeta(forgeDirection) : 0;
    }

    @NotNull
    public final ForgeDirection[] getAddedDirs() {
        return addedDirs;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static final void onNeighborBlockChange(@NotNull BlockButton button, @NotNull World world, int x, int y, int z, @Nullable Block block) {
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(world, "world");
        int meta = world.func_72805_g(x, y, z);
        int metaBase = meta & 7;
        if (BlockButtonExtender.canPlaceBlockOnSide(button, world, x, y, z, INSTANCE.getButtonSide(metaBase).ordinal())) {
            return;
        }
        button.func_149697_b(world, x, y, z, meta, 0);
        world.func_147468_f(x, y, z);
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ON_TRUE, targetMethod="func_150043_b")
    public static final boolean setBlockBoundsFromMeta(@NotNull BlockButton button, int meta) {
        Intrinsics.checkNotNullParameter(button, "button");
        int metaBase = meta & 7;
        boolean isPressed = (meta & 8) > 0;
        float xzOffset = 0.1875f;
        float yOffset = isPressed ? 0.0625f : 0.125f;
        int n = metaBase;
        if (n == INSTANCE.getButtonMeta(ForgeDirection.DOWN)) {
            button.func_149676_a(0.5f - xzOffset, 1.0f - yOffset, 0.5f - xzOffset, 0.5f + xzOffset, 1.0f, 0.5f + xzOffset);
        } else if (n == INSTANCE.getButtonMeta(ForgeDirection.UP)) {
            button.func_149676_a(0.5f - xzOffset, 0.0f, 0.5f - xzOffset, 0.5f + xzOffset, yOffset, 0.5f + xzOffset);
        } else {
            return false;
        }
        return true;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ON_TRUE, intReturnConstant=15)
    public static final boolean isProvidingStrongPower(@NotNull BlockButton button, @NotNull IBlockAccess world, int x, int y, int z, int side) {
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(world, "world");
        int meta = world.func_72805_g(x, y, z);
        return (meta & 8) == 0 ? false : (meta & 7) == 6 && side == 0;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ALWAYS, targetMethod="func_150042_a")
    public static final void updateNeighbor(@NotNull BlockButton button, @NotNull World world, int x, int y, int z, int metaBase) {
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(world, "world");
        world.func_147459_d(x, y, z, (Block)button);
        ForgeDirection dir = INSTANCE.getButtonSide(metaBase).getOpposite();
        world.func_147459_d(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, (Block)button);
    }

    @JvmStatic
    @Hook(targetMethod="<clinit>", injectOnExit=true)
    public static final void ButtonPart$clinit(@Nullable ButtonPart buttonPart) {
        int[] nArray = new int[]{6, 5, 3, 4, 1, 2};
        ButtonPart.sideMetaMap = nArray;
        nArray = new int[]{-1, 4, 5, 2, 3, 0, 1};
        ButtonPart.metaSideMap = nArray;
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ON_NOT_NULL)
    @Nullable
    public static final Cuboid6 getBounds(@NotNull ButtonPart button) {
        Intrinsics.checkNotNullParameter(button, "button");
        int meta = ExtensionsKt.getI(button.meta);
        int metaBase = meta & 7;
        boolean isPressed = button.pressed();
        float xzOffset = 0.1875f;
        double yOffset = isPressed ? 0.0625 : 0.125;
        int n = metaBase;
        return n == INSTANCE.getButtonMeta(ForgeDirection.DOWN) ? new Cuboid6(0.5 - (double)xzOffset, 1.0 - yOffset, 0.5 - (double)xzOffset, 0.5 + (double)xzOffset, 1.0, 0.5 + (double)xzOffset) : (n == INSTANCE.getButtonMeta(ForgeDirection.UP) ? new Cuboid6(0.5 - (double)xzOffset, 0.0, 0.5 - (double)xzOffset, 0.5 + (double)xzOffset, yOffset, 0.5 + (double)xzOffset) : null);
    }

    @JvmStatic
    @Hook(returnCondition=ReturnCondition.ON_NOT_NULL)
    @Nullable
    public static final McBlockPart placement(@Nullable ButtonPart button, @NotNull World world, @NotNull BlockCoord pos, int side, int type2) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        if (side != 0 && side != 1) {
            return null;
        }
        BlockCoord newPos = pos.copy().offset(side ^ 1);
        return !world.isSideSolid(newPos.x, newPos.y, newPos.z, ForgeDirection.getOrientation((int)side)) ? null : (McBlockPart)new ButtonPart(ButtonPart.sideMetaMap[side] | type2 << 4);
    }

    static {
        ForgeDirection[] forgeDirectionArray = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        addedDirs = forgeDirectionArray;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ForgeDirection> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ForgeDirection.values()));
        }
    }
}

