/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.math;

import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Quaternion;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 _2\u00020\u0001:\u0001_B'\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0010H\u0086\u0002J\t\u0010\u001c\u001a\u00020\u0010H\u0086\u0002J\t\u0010\u001d\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010!J\u0006\u0010,\u001a\u00020\nJ\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000J\"\u0010/\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u0010/\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u00104\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0000J\u001e\u00105\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J$\u00107\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u000e\u00107\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u00107\u001a\u00020\u00002\u0006\u00102\u001a\u000203J$\u00108\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u000e\u00108\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u00108\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0000J$\u00109\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010=\u001a\u00020\u0010J\u0006\u0010>\u001a\u00020\u0010J\u0006\u0010?\u001a\u00020\u0000J\b\u0010@\u001a\u00020AH\u0016J\u0006\u0010B\u001a\u00020\u0000J\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010D\u001a\u00020\u0000J\u0006\u0010E\u001a\u00020\u0000J\u000e\u0010F\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020KH\u0007J\b\u0010L\u001a\u00020MH\u0007J&\u0010N\u001a\u00020\u00002\b\b\u0002\u0010O\u001a\u00020\u00032\b\b\u0002\u0010P\u001a\u00020\u00032\b\b\u0002\u0010Q\u001a\u00020\u0003H\u0007J\u0006\u0010R\u001a\u00020\u0000J\u000e\u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\u0000J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0000J\u0016\u0010V\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u0000J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0003J\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0003J\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0003J\u0013\u0010[\u001a\u00020)2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0096\u0002J\b\u0010^\u001a\u00020 H\u0016R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0011\u0010+\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010*\u00a8\u0006`"}, d2={"Lalexsocol/asjlib/math/Vector3;", "Ljava/io/Serializable;", "d", "", "d1", "d2", "<init>", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "vec", "(Lalexsocol/asjlib/math/Vector3;)V", "Lnet/minecraft/util/Vec3;", "(Lnet/minecraft/util/Vec3;)V", "chunk", "Lnet/minecraft/util/ChunkCoordinates;", "(Lnet/minecraft/util/ChunkCoordinates;)V", "x", "", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "z", "getZ", "setZ", "component1", "component2", "component3", "mf", "", "", "()[Ljava/lang/Integer;", "I", "getI", "F", "", "getF", "()[Ljava/lang/Float;", "isZero", "", "()Z", "isAxial", "toVec3", "copy", "discard", "set", "e", "Lnet/minecraft/entity/Entity;", "te", "Lnet/minecraft/tileentity/TileEntity;", "rand", "dotProduct", "crossProduct", "add", "sub", "mul", "f", "extend", "shrink", "length", "lengthSquared", "normalize", "toString", "", "perpendicular", "xCrossProduct", "yCrossProduct", "zCrossProduct", "angle", "isInside", "aabb", "Lnet/minecraft/util/AxisAlignedBB;", "vector3f", "Lorg/lwjgl/util/vector/Vector3f;", "vector4f", "Lorg/lwjgl/util/vector/Vector4f;", "glVertex", "xOff", "yOff", "zOff", "negate", "scalarProject", "b", "project", "rotate", "axis", "rotateOX", "rotateOY", "rotateOZ", "equals", "other", "", "hashCode", "Companion", "1.7.10-ASJCore"})
public final class Vector3
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;
    private static final long serialVersionUID = 84148136481306L;
    @NotNull
    private static final transient Vector3 fallback = new Vector3(-1, -1, -1);
    @NotNull
    private static final transient Vector3 zero = new Vector3(null, null, null, 7, null);
    @NotNull
    private static final transient Vector3 one = new Vector3(1, 1, 1);
    @NotNull
    private static final transient Vector3 center = new Vector3(0.5, 0.5, 0.5);
    @NotNull
    private static final transient Vector3 oX = new Vector3(1, 0, 0);
    @NotNull
    private static final transient Vector3 oY = new Vector3(0, 1, 0);
    @NotNull
    private static final transient Vector3 oZ = new Vector3(0, 0, 1);

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Integer[] mf() {
        Integer[] integerArray = new Integer[]{ExtensionsKt.mfloor(this.x), ExtensionsKt.mfloor(this.y), ExtensionsKt.mfloor(this.z)};
        return integerArray;
    }

    @NotNull
    public final Integer[] getI() {
        Integer[] integerArray = new Integer[]{ExtensionsKt.getI(this.x), ExtensionsKt.getI(this.y), ExtensionsKt.getI(this.z)};
        return integerArray;
    }

    @NotNull
    public final Float[] getF() {
        Float[] floatArray = new Float[]{Float.valueOf(ExtensionsKt.getF(this.x)), Float.valueOf(ExtensionsKt.getF(this.y)), Float.valueOf(ExtensionsKt.getF(this.z))};
        return floatArray;
    }

    public final boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public final boolean isAxial() {
        return this.x == 0.0 ? this.y == 0.0 || this.z == 0.0 : this.y == 0.0 && this.z == 0.0;
    }

    public Vector3(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x = ExtensionsKt.getD(d);
        this.y = ExtensionsKt.getD(d1);
        this.z = ExtensionsKt.getD(d2);
    }

    public /* synthetic */ Vector3(Number number, Number number2, Number number3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            number = 0;
        }
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        this(number, number2, number3);
    }

    public Vector3(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.set(vec);
    }

    public Vector3(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.set(vec);
    }

    public Vector3(@NotNull ChunkCoordinates chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        this.set(chunk);
    }

    @NotNull
    public final Vec3 toVec3() {
        Vec3 vec3 = Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
        Intrinsics.checkNotNull(vec3);
        return vec3;
    }

    @NotNull
    public final Vector3 copy() {
        return new Vector3(this);
    }

    @NotNull
    public final Vector3 discard() {
        return this.set(0, 0, 0);
    }

    @NotNull
    public final Vector3 set(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x = ExtensionsKt.getD(d);
        this.y = ExtensionsKt.getD(d1);
        this.z = ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 set$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.set(number, number2, number3);
    }

    @NotNull
    public final Vector3 set(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.x = e.field_70165_t;
        this.y = Vector3.Companion.getPosYp(e);
        this.z = e.field_70161_v;
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull TileEntity te) {
        Intrinsics.checkNotNullParameter(te, "te");
        this.x = ExtensionsKt.getD(te.field_145851_c);
        this.y = ExtensionsKt.getD(te.field_145848_d);
        this.z = ExtensionsKt.getD(te.field_145849_e);
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull ChunkCoordinates chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        this.x = ExtensionsKt.getD(chunk.field_71574_a);
        this.y = ExtensionsKt.getD(chunk.field_71572_b);
        this.z = ExtensionsKt.getD(chunk.field_71573_c);
        return this;
    }

    @NotNull
    public final Vector3 rand() {
        this.x = Math.random();
        this.y = Math.random();
        this.z = Math.random();
        return this;
    }

    public final double dotProduct(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d = vec.x * this.x + vec.y * this.y + vec.z * this.z;
        if (d > 1.0 && d < 1.00001) {
            d = 1.0;
        } else if (d < -1.0 && d > -1.00001) {
            d = -1.0;
        }
        return d;
    }

    public final double dotProduct(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        return ExtensionsKt.getD(d) * this.x + ExtensionsKt.getD(d1) * this.y + ExtensionsKt.getD(d2) * this.z;
    }

    @NotNull
    public final Vector3 crossProduct(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d = this.y * vec.z - this.z * vec.y;
        double d1 = this.z * vec.x - this.x * vec.z;
        double d2 = this.x * vec.y - this.y * vec.x;
        this.x = d;
        this.y = d1;
        this.z = d2;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 add(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x += ExtensionsKt.getD(d);
        this.y += ExtensionsKt.getD(d1);
        this.z += ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 add$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.add(number, number2, number3);
    }

    @NotNull
    public final Vector3 add(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    @NotNull
    public final Vector3 add(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.x += e.field_70165_t;
        this.y += Vector3.Companion.getPosYp(e);
        this.z += e.field_70161_v;
        return this;
    }

    @NotNull
    public final Vector3 add(@NotNull TileEntity te) {
        Intrinsics.checkNotNullParameter(te, "te");
        this.x += ExtensionsKt.getD(te.field_145851_c);
        this.y += ExtensionsKt.getD(te.field_145848_d);
        this.z += ExtensionsKt.getD(te.field_145849_e);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 sub(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x -= ExtensionsKt.getD(d);
        this.y -= ExtensionsKt.getD(d1);
        this.z -= ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 sub$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.sub(number, number2, number3);
    }

    @NotNull
    public final Vector3 sub(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    @NotNull
    public final Vector3 sub(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.x -= e.field_70165_t;
        this.y -= Vector3.Companion.getPosYp(e);
        this.z -= e.field_70161_v;
        return this;
    }

    @NotNull
    public final Vector3 sub(@NotNull TileEntity te) {
        Intrinsics.checkNotNullParameter(te, "te");
        this.x -= ExtensionsKt.getD(te.field_145851_c);
        this.y -= ExtensionsKt.getD(te.field_145848_d);
        this.z -= ExtensionsKt.getD(te.field_145849_e);
        return this;
    }

    @NotNull
    public final Vector3 mul(@NotNull Vector3 f) {
        Intrinsics.checkNotNullParameter(f, "f");
        this.x *= f.x;
        this.y *= f.y;
        this.z *= f.z;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 mul(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x *= ExtensionsKt.getD(d);
        this.y *= ExtensionsKt.getD(d1);
        this.z *= ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 mul$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.mul(number, number2, number3);
    }

    @NotNull
    public final Vector3 extend(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return this.set(Vector3.mul$default(this.copy().normalize(), Math.max(this.length() + ExtensionsKt.getD(d), 0.0), null, null, 6, null));
    }

    @NotNull
    public final Vector3 shrink(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return this.set(Vector3.mul$default(this.copy().normalize(), Math.min(this.length() - ExtensionsKt.getD(d), 0.0), null, null, 6, null));
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @NotNull
    public final Vector3 normalize() {
        double d = this.length();
        if (!(d == 0.0)) {
            Vector3.mul$default(this, 1.0 / d, null, null, 6, null);
        }
        return this;
    }

    @NotNull
    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector3(" + new BigDecimal(this.x, cont) + ", " + new BigDecimal(this.y, cont) + ", " + new BigDecimal(this.z, cont) + ')';
    }

    @NotNull
    public final Vector3 perpendicular() {
        return this.z == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    @NotNull
    public final Vector3 xCrossProduct() {
        double d = this.z;
        double d1 = -this.y;
        this.x = 0.0;
        this.y = d;
        this.z = d1;
        return this;
    }

    @NotNull
    public final Vector3 yCrossProduct() {
        double d = -this.z;
        double d1 = this.x;
        this.x = d;
        this.y = 0.0;
        this.z = d1;
        return this;
    }

    @NotNull
    public final Vector3 zCrossProduct() {
        double d = this.y;
        double d1 = -this.x;
        this.x = d;
        this.y = d1;
        this.z = 0.0;
        return this;
    }

    public final double angle(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return Math.acos(this.copy().normalize().dotProduct(vec.copy().normalize()));
    }

    public final boolean isInside(@NotNull AxisAlignedBB aabb) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        return this.x >= aabb.field_72340_a && this.y >= aabb.field_72337_e && this.z >= aabb.field_72339_c && this.x < aabb.field_72336_d && this.y < aabb.field_72337_e && this.z < aabb.field_72334_f;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final Vector3f vector3f() {
        return new Vector3f(ExtensionsKt.getF(this.x), ExtensionsKt.getF(this.y), ExtensionsKt.getF(this.z));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final Vector4f vector4f() {
        return new Vector4f(ExtensionsKt.getF(this.x), ExtensionsKt.getF(this.y), ExtensionsKt.getF(this.z), 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final Vector3 glVertex(@NotNull Number xOff, @NotNull Number yOff, @NotNull Number zOff) {
        Intrinsics.checkNotNullParameter(xOff, "xOff");
        Intrinsics.checkNotNullParameter(yOff, "yOff");
        Intrinsics.checkNotNullParameter(zOff, "zOff");
        GL11.glVertex3d((double)(this.x + ExtensionsKt.getD(xOff)), (double)(this.y + ExtensionsKt.getD(yOff)), (double)(this.z + ExtensionsKt.getD(zOff)));
        return this;
    }

    public static /* synthetic */ Vector3 glVertex$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 1) != 0) {
            number = 0;
        }
        if ((n & 2) != 0) {
            number2 = 0;
        }
        if ((n & 4) != 0) {
            number3 = 0;
        }
        return vector3.glVertex(number, number2, number3);
    }

    @NotNull
    public final Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final double scalarProject(@NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double l = b.length();
        return l == 0.0 ? 0.0 : this.dotProduct(b) / l;
    }

    @NotNull
    public final Vector3 project(@NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double l = b.lengthSquared();
        if (l == 0.0) {
            this.set(0, 0, 0);
            return this;
        }
        double m = this.dotProduct(b) / l;
        Vector3.mul$default(this.set(b), m, null, null, 6, null);
        return this;
    }

    @NotNull
    public final Vector3 rotate(@NotNull Number angle, @NotNull Vector3 axis) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        Intrinsics.checkNotNullParameter(axis, "axis");
        Quaternion.Companion.aroundAxis(axis.copy().normalize(), Math.toRadians(ExtensionsKt.getD(angle))).rotate(this);
        return this;
    }

    @NotNull
    public final Vector3 rotateOX(@NotNull Number angle) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        double n = Math.toRadians(-ExtensionsKt.getD(angle));
        double rz = this.z * Math.cos(n) - this.y * Math.sin(n);
        double ry = this.z * Math.sin(n) + this.y * Math.cos(n);
        this.z = rz;
        this.y = ry;
        return this;
    }

    @NotNull
    public final Vector3 rotateOY(@NotNull Number angle) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        double n = Math.toRadians(-ExtensionsKt.getD(angle));
        double rx = this.x * Math.cos(n) - this.z * Math.sin(n);
        double rz = this.x * Math.sin(n) + this.z * Math.cos(n);
        this.x = rx;
        this.z = rz;
        return this;
    }

    @NotNull
    public final Vector3 rotateOZ(@NotNull Number angle) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        double n = Math.toRadians(ExtensionsKt.getD(angle));
        double rx = this.x * Math.cos(n) - this.y * Math.sin(n);
        double ry = this.x * Math.sin(n) + this.y * Math.cos(n);
        this.x = rx;
        this.y = ry;
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Vector3)) {
            return false;
        }
        return this.x == ((Vector3)other).x && this.y == ((Vector3)other).y && this.z == ((Vector3)other).z;
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        result = 31 * result + Double.hashCode(this.z);
        return result;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 add(@NotNull Number d, @NotNull Number d1) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        return Vector3.add$default(this, d, d1, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 add(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return Vector3.add$default(this, d, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 sub(@NotNull Number d, @NotNull Number d1) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        return Vector3.sub$default(this, d, d1, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 sub(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return Vector3.sub$default(this, d, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 mul(@NotNull Number d, @NotNull Number d1) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        return Vector3.mul$default(this, d, d1, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 mul(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return Vector3.mul$default(this, d, null, null, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0004\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u001bJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u001bJ\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001bJ\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018J&\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,J6\u00100\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u00101\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00102\u001a\u00020,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0018\u00103\u001a\u00020\u001e*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00066"}, d2={"Lalexsocol/asjlib/math/Vector3$Companion;", "", "<init>", "()V", "serialVersionUID", "", "fallback", "Lalexsocol/asjlib/math/Vector3;", "getFallback", "()Lalexsocol/asjlib/math/Vector3;", "zero", "getZero", "one", "getOne", "center", "getCenter", "oX", "getOX", "oY", "getOY", "oZ", "getOZ", "fromEntity", "e", "Lnet/minecraft/entity/Entity;", "fromEntityCenter", "fromTileEntity", "Lnet/minecraft/tileentity/TileEntity;", "fromTileEntityCenter", "vecDistance", "", "v1", "v2", "vecEntityDistance", "v", "vecTileDistance", "te", "entityTileDistance", "entityDistance", "e1", "e2", "entityDistancePlane", "pointDistancePlane", "x1", "", "y1", "x2", "y2", "pointDistanceSpace", "z1", "z2", "posYp", "getPosYp", "(Lnet/minecraft/entity/Entity;)D", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3 getFallback() {
            return fallback;
        }

        @NotNull
        public final Vector3 getZero() {
            return zero;
        }

        @NotNull
        public final Vector3 getOne() {
            return one;
        }

        @NotNull
        public final Vector3 getCenter() {
            return center;
        }

        @NotNull
        public final Vector3 getOX() {
            return oX;
        }

        @NotNull
        public final Vector3 getOY() {
            return oY;
        }

        @NotNull
        public final Vector3 getOZ() {
            return oZ;
        }

        @NotNull
        public final Vector3 fromEntity(@NotNull Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3(e.field_70165_t, this.getPosYp(e), e.field_70161_v);
        }

        @NotNull
        public final Vector3 fromEntityCenter(@NotNull Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3(e.field_70165_t, this.getPosYp(e) - (double)e.field_70129_M + (double)(e.field_70131_O / (float)2), e.field_70161_v);
        }

        @NotNull
        public final Vector3 fromTileEntity(@NotNull TileEntity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3(ExtensionsKt.getD(e.field_145851_c), ExtensionsKt.getD(e.field_145848_d), ExtensionsKt.getD(e.field_145849_e));
        }

        @NotNull
        public final Vector3 fromTileEntityCenter(@NotNull TileEntity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3((double)e.field_145851_c + 0.5, (double)e.field_145848_d + 0.5, (double)e.field_145849_e + 0.5);
        }

        public final double vecDistance(@NotNull Vector3 v1, @NotNull Vector3 v2) {
            Intrinsics.checkNotNullParameter(v1, "v1");
            Intrinsics.checkNotNullParameter(v2, "v2");
            return Math.sqrt(Math.pow(v1.getX() - v2.getX(), 2) + Math.pow(v1.getY() - v2.getY(), 2) + Math.pow(v1.getZ() - v2.getZ(), 2));
        }

        public final double vecEntityDistance(@NotNull Vector3 v, @NotNull Entity e) {
            Intrinsics.checkNotNullParameter(v, "v");
            Intrinsics.checkNotNullParameter(e, "e");
            return Math.sqrt(Math.pow(v.getX() - e.field_70165_t, 2) + Math.pow(v.getY() - this.getPosYp(e), 2) + Math.pow(v.getZ() - e.field_70161_v, 2));
        }

        public final double vecTileDistance(@NotNull Vector3 v, @NotNull TileEntity te) {
            Intrinsics.checkNotNullParameter(v, "v");
            Intrinsics.checkNotNullParameter(te, "te");
            return Math.sqrt(Math.pow(v.getX() - (double)te.field_145851_c + 0.5, 2) + Math.pow(v.getY() - (double)te.field_145848_d + 0.5, 2) + Math.pow(v.getZ() - (double)te.field_145849_e + 0.5, 2));
        }

        public final double entityTileDistance(@NotNull Entity e, @NotNull TileEntity te) {
            Intrinsics.checkNotNullParameter(e, "e");
            Intrinsics.checkNotNullParameter(te, "te");
            return Math.sqrt(Math.pow(e.field_70165_t - (double)te.field_145851_c + 0.5, 2) + Math.pow(this.getPosYp(e) - (double)te.field_145848_d + 0.5, 2) + Math.pow(e.field_70161_v - (double)te.field_145849_e + 0.5, 2));
        }

        public final double entityDistance(@NotNull Entity e1, @NotNull Entity e2) {
            Intrinsics.checkNotNullParameter(e1, "e1");
            Intrinsics.checkNotNullParameter(e2, "e2");
            return Math.sqrt(Math.pow(e1.field_70165_t - e2.field_70165_t, 2) + Math.pow(this.getPosYp(e1) - this.getPosYp(e2), 2) + Math.pow(e1.field_70161_v - e2.field_70161_v, 2));
        }

        public final double entityDistancePlane(@NotNull Entity e1, @NotNull Entity e2) {
            Intrinsics.checkNotNullParameter(e1, "e1");
            Intrinsics.checkNotNullParameter(e2, "e2");
            return Math.hypot(e1.field_70165_t - e2.field_70165_t, e1.field_70161_v - e2.field_70161_v);
        }

        public final double pointDistancePlane(@NotNull Number x1, @NotNull Number y1, @NotNull Number x2, @NotNull Number y2) {
            Intrinsics.checkNotNullParameter(x1, "x1");
            Intrinsics.checkNotNullParameter(y1, "y1");
            Intrinsics.checkNotNullParameter(x2, "x2");
            Intrinsics.checkNotNullParameter(y2, "y2");
            return Math.hypot(ExtensionsKt.getD(x1) - ExtensionsKt.getD(x2), ExtensionsKt.getD(y1) - ExtensionsKt.getD(y2));
        }

        public final double pointDistanceSpace(@NotNull Number x1, @NotNull Number y1, @NotNull Number z1, @NotNull Number x2, @NotNull Number y2, @NotNull Number z2) {
            Intrinsics.checkNotNullParameter(x1, "x1");
            Intrinsics.checkNotNullParameter(y1, "y1");
            Intrinsics.checkNotNullParameter(z1, "z1");
            Intrinsics.checkNotNullParameter(x2, "x2");
            Intrinsics.checkNotNullParameter(y2, "y2");
            Intrinsics.checkNotNullParameter(z2, "z2");
            return Math.sqrt(Math.pow(ExtensionsKt.getD(x1) - ExtensionsKt.getD(x2), 2) + Math.pow(ExtensionsKt.getD(y1) - ExtensionsKt.getD(y2), 2) + Math.pow(ExtensionsKt.getD(z1) - ExtensionsKt.getD(z2), 2));
        }

        private final double getPosYp(Entity $this$posYp) {
            return $this$posYp.field_70163_u - ($this$posYp.field_70170_p.field_72995_K && ExtensionsClientKt.getMc().field_71439_g == $this$posYp ? 1.62 : 0.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

