/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.math;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Matrix4;
import alexsocol.asjlib.math.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0011\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u0000 F2\u00020\u0001:\u0002EFB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0011\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'\u00a2\u0006\u0002\u0010(J\u001e\u0010)\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010+\u001a\u00020\u0005J\u001e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bJ\u001e\u00100\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bJ\u001e\u00101\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bJ\u0016\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\rJ\u0016\u00105\u001a\u00020\u00002\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\rJ\u000e\u00106\u001a\u00020\u00002\u0006\u00103\u001a\u00020\bJ\u000e\u00107\u001a\u00020\u00002\u0006\u00103\u001a\u00020\bJ\u000e\u00108\u001a\u00020\u00002\u0006\u00103\u001a\u00020\bJ\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\rJ\u000e\u00109\u001a\u00020:2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00109\u001a\u00020:2\u0006\u0010=\u001a\u00020\u0000J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0007J\b\u0010B\u001a\u00020?H\u0007J\b\u0010C\u001a\u00020?H\u0007J\b\u0010D\u001a\u00020?H\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0011\u0010 \u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0011\u0010\"\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u0011\u0010$\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000f\u00a8\u0006G"}, d2={"Lalexsocol/asjlib/math/OrientedBB;", "", "<init>", "()V", "aabb", "Lnet/minecraft/util/AxisAlignedBB;", "(Lnet/minecraft/util/AxisAlignedBB;)V", "length", "", "height", "width", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "pos", "Lalexsocol/asjlib/math/Vector3;", "getPos", "()Lalexsocol/asjlib/math/Vector3;", "size", "getSize", "orient", "Lalexsocol/asjlib/math/Matrix4;", "getOrient", "()Lalexsocol/asjlib/math/Matrix4;", "a", "getA", "b", "getB", "c", "getC", "d", "getD", "e", "getE", "f", "getF", "g", "getG", "h", "getH", "vertices", "", "()[Lalexsocol/asjlib/math/Vector3;", "fromParams", "fromAABB", "toAABB", "setPosition", "x", "y", "z", "translate", "scale", "rotate", "angle", "axis", "rotateLocal", "rotateOX", "rotateOY", "rotateOZ", "intersectsWith", "", "vec3", "Lnet/minecraft/util/Vec3;", "obb", "draw", "", "dt", "", "drawVertices", "drawEdges", "drawFaces", "Interval", "Companion", "1.7.10-ASJCore"})
public class OrientedBB {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3 pos;
    @NotNull
    private final Vector3 size;
    @NotNull
    private final Matrix4 orient;
    @NotNull
    private final Vector3 a;
    @NotNull
    private final Vector3 b;
    @NotNull
    private final Vector3 c;
    @NotNull
    private final Vector3 d;
    @NotNull
    private final Vector3 e;
    @NotNull
    private final Vector3 f;
    @NotNull
    private final Vector3 g;
    @NotNull
    private final Vector3 h;

    public OrientedBB() {
        this.pos = new Vector3(0.5, 0.5, 0.5);
        this.size = new Vector3(0.5, 0.5, 0.5);
        this.orient = new Matrix4();
        this.a = new Vector3(0.0, 0.0, 0.0);
        this.b = new Vector3(1.0, 0.0, 0.0);
        this.c = new Vector3(1.0, 0.0, 1.0);
        this.d = new Vector3(0.0, 0.0, 1.0);
        this.e = new Vector3(0.0, 1.0, 0.0);
        this.f = new Vector3(1.0, 1.0, 0.0);
        this.g = new Vector3(1.0, 1.0, 1.0);
        this.h = new Vector3(0.0, 1.0, 1.0);
    }

    @NotNull
    public final Vector3 getPos() {
        return this.pos;
    }

    @NotNull
    public final Vector3 getSize() {
        return this.size;
    }

    @NotNull
    public final Matrix4 getOrient() {
        return this.orient;
    }

    @NotNull
    public final Vector3 getA() {
        return this.a;
    }

    @NotNull
    public final Vector3 getB() {
        return this.b;
    }

    @NotNull
    public final Vector3 getC() {
        return this.c;
    }

    @NotNull
    public final Vector3 getD() {
        return this.d;
    }

    @NotNull
    public final Vector3 getE() {
        return this.e;
    }

    @NotNull
    public final Vector3 getF() {
        return this.f;
    }

    @NotNull
    public final Vector3 getG() {
        return this.g;
    }

    @NotNull
    public final Vector3 getH() {
        return this.h;
    }

    public OrientedBB(@NotNull AxisAlignedBB aabb) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        this();
        this.fromAABB(aabb);
    }

    public OrientedBB(@NotNull Number length, @NotNull Number height, @NotNull Number width) {
        Intrinsics.checkNotNullParameter(length, "length");
        Intrinsics.checkNotNullParameter(height, "height");
        Intrinsics.checkNotNullParameter(width, "width");
        this(ExtensionsKt.getBoundingBox(ExtensionsKt.getD(length) / (double)-2, ExtensionsKt.getD(height) / (double)-2, ExtensionsKt.getD(width) / (double)-2, ExtensionsKt.getD(length) / (double)2, ExtensionsKt.getD(height) / (double)2, ExtensionsKt.getD(width) / (double)2));
    }

    @NotNull
    public final Vector3[] vertices() {
        Vector3[] vector3Array = new Vector3[]{this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h};
        return vector3Array;
    }

    @NotNull
    public final OrientedBB fromParams(@NotNull Number length, @NotNull Number height, @NotNull Number width) {
        Intrinsics.checkNotNullParameter(length, "length");
        Intrinsics.checkNotNullParameter(height, "height");
        Intrinsics.checkNotNullParameter(width, "width");
        return this.fromAABB(ExtensionsKt.getBoundingBox(ExtensionsKt.getD(length) / (double)-2, ExtensionsKt.getD(height) / (double)-2, ExtensionsKt.getD(width) / (double)-2, ExtensionsKt.getD(length) / (double)2, ExtensionsKt.getD(height) / (double)2, ExtensionsKt.getD(width) / (double)2));
    }

    @NotNull
    public final OrientedBB fromAABB(@NotNull AxisAlignedBB aabb) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        this.pos.set(Companion.getAABBPosition(aabb));
        this.size.set(Companion.getAABBSize(aabb));
        this.a.set(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.b.set(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        this.c.set(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        this.d.set(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        this.e.set(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        this.f.set(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        this.g.set(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        this.h.set(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        return this;
    }

    @NotNull
    public final AxisAlignedBB toAABB() {
        Double[] doubleArray = new Double[]{this.a.getX(), this.b.getX(), this.c.getX(), this.d.getX(), this.e.getX(), this.f.getX(), this.g.getX(), this.h.getX()};
        List<Double> xs = CollectionsKt.listOf(doubleArray);
        Double[] doubleArray2 = new Double[]{this.a.getY(), this.b.getY(), this.c.getY(), this.d.getY(), this.e.getY(), this.f.getY(), this.g.getY(), this.h.getY()};
        List<Double> ys = CollectionsKt.listOf(doubleArray2);
        Double[] doubleArray3 = new Double[]{this.a.getZ(), this.b.getZ(), this.c.getZ(), this.d.getZ(), this.e.getZ(), this.f.getZ(), this.g.getZ(), this.h.getZ()};
        List<Double> zs = CollectionsKt.listOf(doubleArray3);
        Object t = CollectionsKt.minOrNull((Iterable)xs);
        Intrinsics.checkNotNull(t);
        Number number = (Number)t;
        Object t2 = CollectionsKt.minOrNull((Iterable)ys);
        Intrinsics.checkNotNull(t2);
        Number number2 = (Number)t2;
        Object t3 = CollectionsKt.minOrNull((Iterable)zs);
        Intrinsics.checkNotNull(t3);
        Number number3 = (Number)t3;
        Object t4 = CollectionsKt.maxOrNull((Iterable)xs);
        Intrinsics.checkNotNull(t4);
        Number number4 = (Number)t4;
        Object t5 = CollectionsKt.maxOrNull((Iterable)ys);
        Intrinsics.checkNotNull(t5);
        Number number5 = (Number)t5;
        Object t6 = CollectionsKt.maxOrNull((Iterable)zs);
        Intrinsics.checkNotNull(t6);
        return ExtensionsKt.getBoundingBox(number, number2, number3, number4, number5, (Number)t6);
    }

    @NotNull
    public final OrientedBB setPosition(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        this.pos.set(x, y, z);
        this.a.set(this.pos).add(-this.size.getX(), -this.size.getY(), -this.size.getZ());
        this.b.set(this.pos).add(this.size.getX(), -this.size.getY(), -this.size.getZ());
        this.c.set(this.pos).add(this.size.getX(), -this.size.getY(), this.size.getZ());
        this.d.set(this.pos).add(-this.size.getX(), -this.size.getY(), this.size.getZ());
        this.e.set(this.pos).add(-this.size.getX(), this.size.getY(), -this.size.getZ());
        this.f.set(this.pos).add(this.size.getX(), this.size.getY(), -this.size.getZ());
        this.g.set(this.pos).add(this.size.getX(), this.size.getY(), this.size.getZ());
        this.h.set(this.pos).add(-this.size.getX(), this.size.getY(), this.size.getZ());
        return this;
    }

    @NotNull
    public final OrientedBB translate(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        this.pos.add(x, y, z);
        this.a.add(x, y, z);
        this.b.add(x, y, z);
        this.c.add(x, y, z);
        this.d.add(x, y, z);
        this.e.add(x, y, z);
        this.f.add(x, y, z);
        this.g.add(x, y, z);
        this.h.add(x, y, z);
        return this;
    }

    @NotNull
    public final OrientedBB scale(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        this.size.mul(x, y, z);
        double i2 = this.pos.getX();
        double j = this.pos.getY();
        double k = this.pos.getZ();
        this.translate(-i2, -j, -k);
        this.a.mul(x, y, z);
        this.b.mul(x, y, z);
        this.c.mul(x, y, z);
        this.d.mul(x, y, z);
        this.e.mul(x, y, z);
        this.f.mul(x, y, z);
        this.g.mul(x, y, z);
        this.h.mul(x, y, z);
        this.translate(i2, j, k);
        return this;
    }

    @NotNull
    public final OrientedBB rotate(@NotNull Number angle, @NotNull Vector3 axis) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        Intrinsics.checkNotNullParameter(axis, "axis");
        this.orient.rotate(Math.toRadians(ExtensionsKt.getD(angle)), axis);
        this.pos.rotate(angle, axis);
        this.a.rotate(-ExtensionsKt.getD(angle), axis);
        this.b.rotate(-ExtensionsKt.getD(angle), axis);
        this.c.rotate(-ExtensionsKt.getD(angle), axis);
        this.d.rotate(-ExtensionsKt.getD(angle), axis);
        this.e.rotate(-ExtensionsKt.getD(angle), axis);
        this.f.rotate(-ExtensionsKt.getD(angle), axis);
        this.g.rotate(-ExtensionsKt.getD(angle), axis);
        this.h.rotate(-ExtensionsKt.getD(angle), axis);
        return this;
    }

    @NotNull
    public final OrientedBB rotateLocal(@NotNull Number angle, @NotNull Vector3 axis) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        Intrinsics.checkNotNullParameter(axis, "axis");
        double x = this.pos.getX();
        double y = this.pos.getY();
        double z = this.pos.getZ();
        this.translate(-x, -y, -z);
        this.rotate(angle, axis);
        this.translate(x, y, z);
        return this;
    }

    @NotNull
    public final OrientedBB rotateOX(@NotNull Number angle) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        double x = this.pos.getX();
        double y = this.pos.getY();
        double z = this.pos.getZ();
        this.translate(-x, -y, -z);
        this.rotate(angle, Vector3.Companion.getOX());
        this.translate(x, y, z);
        return this;
    }

    @NotNull
    public final OrientedBB rotateOY(@NotNull Number angle) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        double x = this.pos.getX();
        double y = this.pos.getY();
        double z = this.pos.getZ();
        this.translate(-x, -y, -z);
        this.rotate(angle, Vector3.Companion.getOY());
        this.translate(x, y, z);
        return this;
    }

    @NotNull
    public final OrientedBB rotateOZ(@NotNull Number angle) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        double x = this.pos.getX();
        double y = this.pos.getY();
        double z = this.pos.getZ();
        this.translate(-x, -y, -z);
        this.rotate(angle, Vector3.Companion.getOZ());
        this.translate(x, y, z);
        return this;
    }

    public final boolean intersectsWith(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter(vec3, "vec3");
        return Companion.intersectsWith(this, new Vector3(vec3));
    }

    public final boolean intersectsWith(@NotNull Vector3 vec3) {
        Intrinsics.checkNotNullParameter(vec3, "vec3");
        return Companion.intersectsWith(this, vec3);
    }

    public final boolean intersectsWith(@NotNull AxisAlignedBB aabb) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        return Companion.intersectsWith(this, aabb);
    }

    public final boolean intersectsWith(@NotNull OrientedBB obb) {
        Intrinsics.checkNotNullParameter(obb, "obb");
        return Companion.intersectsWith(this, obb);
    }

    @SideOnly(value=Side.CLIENT)
    public final void draw(int dt) {
        GL11.glPushMatrix();
        if (dt == 0) {
            GL11.glDisable((int)2929);
        }
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glPointSize((float)6.0f);
        this.drawVertices();
        GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glLineWidth((float)3.0f);
        this.drawEdges();
        GL11.glColor4d((double)0.0, (double)0.0, (double)1.0, (double)0.5);
        this.drawFaces();
        if (dt == 0) {
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawVertices() {
        GL11.glBegin((int)0);
        for (Vector3 v : this.vertices()) {
            Vector3.glVertex$default(v, null, null, null, 7, null);
        }
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawEdges() {
        GL11.glBegin((int)1);
        Vector3.glVertex$default(this.a, null, null, null, 7, null);
        Vector3.glVertex$default(this.b, null, null, null, 7, null);
        Vector3.glVertex$default(this.b, null, null, null, 7, null);
        Vector3.glVertex$default(this.c, null, null, null, 7, null);
        Vector3.glVertex$default(this.c, null, null, null, 7, null);
        Vector3.glVertex$default(this.d, null, null, null, 7, null);
        Vector3.glVertex$default(this.d, null, null, null, 7, null);
        Vector3.glVertex$default(this.a, null, null, null, 7, null);
        Vector3.glVertex$default(this.e, null, null, null, 7, null);
        Vector3.glVertex$default(this.f, null, null, null, 7, null);
        Vector3.glVertex$default(this.f, null, null, null, 7, null);
        Vector3.glVertex$default(this.g, null, null, null, 7, null);
        Vector3.glVertex$default(this.g, null, null, null, 7, null);
        Vector3.glVertex$default(this.h, null, null, null, 7, null);
        Vector3.glVertex$default(this.h, null, null, null, 7, null);
        Vector3.glVertex$default(this.e, null, null, null, 7, null);
        Vector3.glVertex$default(this.a, null, null, null, 7, null);
        Vector3.glVertex$default(this.e, null, null, null, 7, null);
        Vector3.glVertex$default(this.b, null, null, null, 7, null);
        Vector3.glVertex$default(this.f, null, null, null, 7, null);
        Vector3.glVertex$default(this.c, null, null, null, 7, null);
        Vector3.glVertex$default(this.g, null, null, null, 7, null);
        Vector3.glVertex$default(this.d, null, null, null, 7, null);
        Vector3.glVertex$default(this.h, null, null, null, 7, null);
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawFaces() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBegin((int)7);
        Vector3.glVertex$default(this.a, null, null, null, 7, null);
        Vector3.glVertex$default(this.b, null, null, null, 7, null);
        Vector3.glVertex$default(this.c, null, null, null, 7, null);
        Vector3.glVertex$default(this.d, null, null, null, 7, null);
        Vector3.glVertex$default(this.h, null, null, null, 7, null);
        Vector3.glVertex$default(this.g, null, null, null, 7, null);
        Vector3.glVertex$default(this.f, null, null, null, 7, null);
        Vector3.glVertex$default(this.e, null, null, null, 7, null);
        Vector3.glVertex$default(this.e, null, null, null, 7, null);
        Vector3.glVertex$default(this.f, null, null, null, 7, null);
        Vector3.glVertex$default(this.b, null, null, null, 7, null);
        Vector3.glVertex$default(this.a, null, null, null, 7, null);
        Vector3.glVertex$default(this.f, null, null, null, 7, null);
        Vector3.glVertex$default(this.g, null, null, null, 7, null);
        Vector3.glVertex$default(this.c, null, null, null, 7, null);
        Vector3.glVertex$default(this.b, null, null, null, 7, null);
        Vector3.glVertex$default(this.g, null, null, null, 7, null);
        Vector3.glVertex$default(this.h, null, null, null, 7, null);
        Vector3.glVertex$default(this.d, null, null, null, 7, null);
        Vector3.glVertex$default(this.c, null, null, null, 7, null);
        Vector3.glVertex$default(this.h, null, null, null, 7, null);
        Vector3.glVertex$default(this.e, null, null, null, 7, null);
        Vector3.glVertex$default(this.a, null, null, null, 7, null);
        Vector3.glVertex$default(this.d, null, null, null, 7, null);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0004J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0004J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0016"}, d2={"Lalexsocol/asjlib/math/OrientedBB$Companion;", "", "<init>", "()V", "intersectsWith", "", "obb", "Lalexsocol/asjlib/math/OrientedBB;", "point", "Lalexsocol/asjlib/math/Vector3;", "aabb", "Lnet/minecraft/util/AxisAlignedBB;", "obb1", "obb2", "overlapOnAxis", "axis", "getInterval", "Lalexsocol/asjlib/math/OrientedBB$Interval;", "getMin", "getMax", "getAABBPosition", "getAABBSize", "1.7.10-ASJCore"})
    @SourceDebugExtension(value={"SMAP\nOrientedBB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrientedBB.kt\nalexsocol/asjlib/math/OrientedBB$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n1734#2,3:460\n1734#2,3:463\n*S KotlinDebug\n*F\n+ 1 OrientedBB.kt\nalexsocol/asjlib/math/OrientedBB$Companion\n*L\n353#1:460,3\n374#1:463,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean intersectsWith(@NotNull OrientedBB obb, @NotNull Vector3 point) {
            Intrinsics.checkNotNullParameter(obb, "obb");
            Intrinsics.checkNotNullParameter(point, "point");
            Vector3 dir = point.copy().sub(obb.getPos());
            double[] dArray = new double[]{obb.getOrient().getM00(), obb.getOrient().getM01(), obb.getOrient().getM02(), obb.getOrient().getM10(), obb.getOrient().getM11(), obb.getOrient().getM12(), obb.getOrient().getM20(), obb.getOrient().getM21(), obb.getOrient().getM22()};
            double[] o = dArray;
            double[] dArray2 = new double[]{obb.getSize().getX(), obb.getSize().getY(), obb.getSize().getZ()};
            double[] s = dArray2;
            for (int i2 = 0; i2 < 3; ++i2) {
                Vector3 axis = new Vector3(o[i2 * 3], o[i2 * 3 + 1], o[i2 * 3 + 2]);
                double distance = dir.dotProduct(axis);
                if (distance > s[i2]) {
                    return false;
                }
                if (!(distance < -s[i2])) continue;
                return false;
            }
            return true;
        }

        public final boolean intersectsWith(@NotNull OrientedBB obb, @NotNull AxisAlignedBB aabb) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(obb, "obb");
                Intrinsics.checkNotNullParameter(aabb, "aabb");
                Vector3[] test = new Vector3[15];
                test[0] = new Vector3(1.0, 0.0, 0.0);
                test[1] = new Vector3(0.0, 1.0, 0.0);
                test[2] = new Vector3(0.0, 0.0, 1.0);
                test[3] = new Vector3(obb.getOrient().getM00(), obb.getOrient().getM01(), obb.getOrient().getM02());
                test[4] = new Vector3(obb.getOrient().getM10(), obb.getOrient().getM11(), obb.getOrient().getM12());
                test[5] = new Vector3(obb.getOrient().getM20(), obb.getOrient().getM21(), obb.getOrient().getM22());
                for (int i2 = 0; i2 < 3; ++i2) {
                    Vector3 vector3 = test[i2];
                    Intrinsics.checkNotNull(vector3);
                    Vector3 vector32 = vector3.copy();
                    Vector3 vector33 = test[0];
                    Intrinsics.checkNotNull(vector33);
                    test[6 + i2 * 3] = vector32.crossProduct(vector33);
                    Vector3 vector34 = test[i2];
                    Intrinsics.checkNotNull(vector34);
                    Vector3 vector35 = vector34.copy();
                    Vector3 vector36 = test[1];
                    Intrinsics.checkNotNull(vector36);
                    test[6 + i2 * 3 + 1] = vector35.crossProduct(vector36);
                    Vector3 vector37 = test[i2];
                    Intrinsics.checkNotNull(vector37);
                    Vector3 vector38 = vector37.copy();
                    Vector3 vector39 = test[2];
                    Intrinsics.checkNotNull(vector39);
                    test[6 + i2 * 3 + 2] = vector38.crossProduct(vector39);
                }
                Iterable $this$all$iv = new IntRange(0, 14);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        Vector3 vector3 = test[it];
                        Intrinsics.checkNotNull(vector3);
                        if (Companion.overlapOnAxis(aabb, obb, vector3)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean intersectsWith(@NotNull OrientedBB obb1, @NotNull OrientedBB obb2) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(obb1, "obb1");
                Intrinsics.checkNotNullParameter(obb2, "obb2");
                Vector3[] test = new Vector3[15];
                test[0] = new Vector3(obb1.getOrient().getM00(), obb1.getOrient().getM01(), obb1.getOrient().getM02());
                test[1] = new Vector3(obb1.getOrient().getM10(), obb1.getOrient().getM11(), obb1.getOrient().getM12());
                test[2] = new Vector3(obb1.getOrient().getM20(), obb1.getOrient().getM21(), obb1.getOrient().getM22());
                test[3] = new Vector3(obb2.getOrient().getM00(), obb2.getOrient().getM01(), obb2.getOrient().getM02());
                test[4] = new Vector3(obb2.getOrient().getM10(), obb2.getOrient().getM11(), obb2.getOrient().getM12());
                test[5] = new Vector3(obb2.getOrient().getM20(), obb2.getOrient().getM21(), obb2.getOrient().getM22());
                for (int i2 = 0; i2 < 3; ++i2) {
                    Vector3 vector3 = test[i2];
                    Intrinsics.checkNotNull(vector3);
                    Vector3 vector32 = vector3.copy();
                    Vector3 vector33 = test[0];
                    Intrinsics.checkNotNull(vector33);
                    test[6 + i2 * 3] = vector32.crossProduct(vector33);
                    Vector3 vector34 = test[i2];
                    Intrinsics.checkNotNull(vector34);
                    Vector3 vector35 = vector34.copy();
                    Vector3 vector36 = test[1];
                    Intrinsics.checkNotNull(vector36);
                    test[6 + i2 * 3 + 1] = vector35.crossProduct(vector36);
                    Vector3 vector37 = test[i2];
                    Intrinsics.checkNotNull(vector37);
                    Vector3 vector38 = vector37.copy();
                    Vector3 vector39 = test[2];
                    Intrinsics.checkNotNull(vector39);
                    test[6 + i2 * 3 + 2] = vector38.crossProduct(vector39);
                }
                Iterable $this$all$iv = new IntRange(0, 14);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        Vector3 vector3 = test[it];
                        Intrinsics.checkNotNull(vector3);
                        if (Companion.overlapOnAxis(obb1, obb2, vector3)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        protected final boolean overlapOnAxis(@NotNull AxisAlignedBB aabb, @NotNull OrientedBB obb, @NotNull Vector3 axis) {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            Intrinsics.checkNotNullParameter(obb, "obb");
            Intrinsics.checkNotNullParameter(axis, "axis");
            Interval a = this.getInterval(aabb, axis);
            Interval b = this.getInterval(obb, axis);
            return b.getMin() <= a.getMax() && a.getMin() <= b.getMax();
        }

        protected final boolean overlapOnAxis(@NotNull OrientedBB obb1, @NotNull OrientedBB obb2, @NotNull Vector3 axis) {
            Intrinsics.checkNotNullParameter(obb1, "obb1");
            Intrinsics.checkNotNullParameter(obb2, "obb2");
            Intrinsics.checkNotNullParameter(axis, "axis");
            Interval a = this.getInterval(obb1, axis);
            Interval b = this.getInterval(obb2, axis);
            return b.getMin() <= a.getMax() && a.getMin() <= b.getMax();
        }

        @NotNull
        protected final Interval getInterval(@NotNull OrientedBB obb, @NotNull Vector3 axis) {
            Intrinsics.checkNotNullParameter(obb, "obb");
            Intrinsics.checkNotNullParameter(axis, "axis");
            Vector3[] vertex = new Vector3[8];
            Vector3 c = new Vector3(obb.getPos().getX(), obb.getPos().getY(), obb.getPos().getZ());
            Vector3 e = new Vector3(obb.getSize().getX(), obb.getSize().getY(), obb.getSize().getZ());
            double[] dArray = new double[]{obb.getOrient().getM00(), obb.getOrient().getM01(), obb.getOrient().getM02(), obb.getOrient().getM10(), obb.getOrient().getM11(), obb.getOrient().getM12(), obb.getOrient().getM20(), obb.getOrient().getM21(), obb.getOrient().getM22()};
            double[] o = dArray;
            Vector3[] vector3Array = new Vector3[]{new Vector3(o[0], o[1], o[2]), new Vector3(o[3], o[4], o[5]), new Vector3(o[6], o[7], o[8])};
            Vector3[] a = vector3Array;
            vertex[0] = c.copy().add(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).add(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).add(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[1] = c.copy().sub(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).add(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).add(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[2] = c.copy().add(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).sub(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).add(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[3] = c.copy().add(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).add(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).sub(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[4] = c.copy().sub(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).sub(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).sub(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[5] = c.copy().add(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).sub(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).sub(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[6] = c.copy().sub(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).add(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).sub(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            vertex[7] = c.copy().sub(Vector3.mul$default(a[0].copy(), e.getX(), null, null, 6, null)).sub(Vector3.mul$default(a[1].copy(), e.getY(), null, null, 6, null)).add(Vector3.mul$default(a[2].copy(), e.getZ(), null, null, 6, null));
            Interval result = new Interval();
            Vector3 vector3 = axis.copy();
            Vector3 vector32 = vertex[0];
            Intrinsics.checkNotNull(vector32);
            result.setMax(vector3.dotProduct(vector32));
            result.setMin(result.getMax());
            for (int i2 = 1; i2 < 8; ++i2) {
                Vector3 vector33 = axis.copy();
                Vector3 vector34 = vertex[i2];
                Intrinsics.checkNotNull(vector34);
                double projection = vector33.dotProduct(vector34);
                result.setMin(projection < result.getMin() ? projection : result.getMin());
                result.setMax(projection > result.getMax() ? projection : result.getMax());
            }
            return result;
        }

        @NotNull
        protected final Interval getInterval(@NotNull AxisAlignedBB aabb, @NotNull Vector3 axis) {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            Intrinsics.checkNotNullParameter(axis, "axis");
            Vector3 min = this.getMin(aabb);
            Vector3 max = this.getMax(aabb);
            Vector3[] vector3Array = new Vector3[]{new Vector3(min.getX(), max.getY(), max.getZ()), new Vector3(min.getX(), max.getY(), min.getZ()), new Vector3(min.getX(), min.getY(), max.getZ()), new Vector3(min.getX(), min.getY(), min.getZ()), new Vector3(max.getX(), max.getY(), max.getZ()), new Vector3(max.getX(), max.getY(), min.getZ()), new Vector3(max.getX(), min.getY(), max.getZ()), new Vector3(max.getX(), min.getY(), min.getZ())};
            Vector3[] vertex = vector3Array;
            Interval result = new Interval();
            result.setMax(axis.copy().dotProduct(vertex[0]));
            result.setMin(result.getMax());
            for (int i2 = 1; i2 < 8; ++i2) {
                double projection = axis.copy().dotProduct(vertex[i2]);
                result.setMin(projection < result.getMin() ? projection : result.getMin());
                result.setMax(projection > result.getMax() ? projection : result.getMax());
            }
            return result;
        }

        @NotNull
        protected final Vector3 getMin(@NotNull AxisAlignedBB aabb) {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            Vector3 p1 = this.getAABBPosition(aabb).add(this.getAABBSize(aabb));
            Vector3 p2 = this.getAABBPosition(aabb).sub(this.getAABBSize(aabb));
            return new Vector3(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
        }

        @NotNull
        protected final Vector3 getMax(@NotNull AxisAlignedBB aabb) {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            Vector3 p1 = this.getAABBPosition(aabb).add(this.getAABBSize(aabb));
            Vector3 p2 = this.getAABBPosition(aabb).sub(this.getAABBSize(aabb));
            return new Vector3(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
        }

        @NotNull
        public final Vector3 getAABBPosition(@NotNull AxisAlignedBB aabb) {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            return new Vector3((aabb.field_72340_a + aabb.field_72336_d) / 2.0, (aabb.field_72338_b + aabb.field_72337_e) / 2.0, (aabb.field_72339_c + aabb.field_72334_f) / 2.0);
        }

        @NotNull
        public final Vector3 getAABBSize(@NotNull AxisAlignedBB aabb) {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            return new Vector3(Math.sqrt(Math.pow(aabb.field_72340_a - aabb.field_72336_d, 2.0)) / 2.0, Math.sqrt(Math.pow(aabb.field_72338_b - aabb.field_72337_e, 2.0)) / 2.0, Math.sqrt(Math.pow(aabb.field_72339_c - aabb.field_72334_f, 2.0)) / 2.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lalexsocol/asjlib/math/OrientedBB$Interval;", "", "<init>", "()V", "min", "", "getMin", "()D", "setMin", "(D)V", "max", "getMax", "setMax", "1.7.10-ASJCore"})
    public static final class Interval {
        private double min;
        private double max;

        public final double getMin() {
            return this.min;
        }

        public final void setMin(double d) {
            this.min = d;
        }

        public final double getMax() {
            return this.max;
        }

        public final void setMax(double d) {
            this.max = d;
        }
    }
}

