/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.asm;

import alexsocol.patcher.asm.transformer.ASJAbstractClassTransformer;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001b"}, d2={"Lalexsocol/asjlib/asm/ASJPacketCompleter;", "Lalexsocol/patcher/asm/transformer/ASJAbstractClassTransformer;", "<init>", "()V", "transform", "", "transformedName", "", "basicClass", "isASJPacket", "", "classNames", "", "classBytes", "getClassData", "className", "makeConstructor", "", "cl", "Lorg/objectweb/asm/tree/ClassNode;", "makeFromBytes", "callCustom", "makeToBytes", "getFileds", "", "Lorg/objectweb/asm/tree/FieldNode;", "Companion", "1.7.10-ASJCore"})
public final class ASJPacketCompleter
extends ASJAbstractClassTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> descriptors;

    @Override
    @NotNull
    public byte[] transform(@NotNull String transformedName, @NotNull byte[] basicClass) {
        Intrinsics.checkNotNullParameter(transformedName, "transformedName");
        Intrinsics.checkNotNullParameter(basicClass, "basicClass");
        try {
            ClassReader cr = new ClassReader(basicClass);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            String[] stringArray = new String[]{transformedName};
            if (this.isASJPacket(CollectionsKt.mutableListOf(stringArray), basicClass)) {
                this.getLogger().debug("Expanding ASJPacket " + transformedName);
                boolean[] fs = new boolean[5];
                for (MethodNode mt : cn.methods) {
                    if (Intrinsics.areEqual(mt.name, "<init>") && Intrinsics.areEqual(mt.desc, "()V")) {
                        fs[0] = true;
                        continue;
                    }
                    if (Intrinsics.areEqual(mt.name, "fromBytes") && Intrinsics.areEqual(mt.desc, "(Lio/netty/buffer/ByteBuf;)V")) {
                        fs[1] = true;
                        continue;
                    }
                    if (Intrinsics.areEqual(mt.name, "toBytes") && Intrinsics.areEqual(mt.desc, "(Lio/netty/buffer/ByteBuf;)V")) {
                        fs[2] = true;
                        continue;
                    }
                    if (Intrinsics.areEqual(mt.name, "fromCustomBytes") && Intrinsics.areEqual(mt.desc, "(Lio/netty/buffer/ByteBuf;)V")) {
                        fs[3] = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual(mt.name, "toCustomBytes") || !Intrinsics.areEqual(mt.desc, "(Lio/netty/buffer/ByteBuf;)V")) continue;
                    fs[4] = true;
                }
                if (!fs[0]) {
                    this.makeConstructor(cn);
                }
                if (!fs[1]) {
                    this.makeFromBytes(cn, fs[3]);
                }
                if (!fs[2]) {
                    this.makeToBytes(cn, fs[4]);
                }
                ClassWriter cw = new ClassWriter(3);
                cn.accept((ClassVisitor)cw);
                byte[] byArray = cw.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
                return byArray;
            }
        }
        catch (Throwable e) {
            this.getLogger().error("Something went wrong while transforming class " + transformedName + ". Ignore if everything is OK (this is NOT ASJCore error):", e);
            return basicClass;
        }
        return basicClass;
    }

    private final boolean isASJPacket(List<String> classNames, byte[] classBytes) {
        try {
            ClassReader classReader = new ClassReader(classBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (Intrinsics.areEqual(classNode.superName, "alexsocol/asjlib/network/ASJPacket")) {
                return true;
            }
            String superClassName = classNode.superName;
            if (superClassName != null) {
                classNames.add(superClassName);
                return this.isASJPacket(classNames, this.getClassData(superClassName));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private final byte[] getClassData(String className) {
        String classResourceName = '/' + StringsKt.replace$default(className, '.', '/', false, 4, null) + ".class";
        InputStream inputStream = ASJPacketCompleter.class.getResourceAsStream(classResourceName);
        if (inputStream == null) {
            throw new NullPointerException("Cannot read class `" + className + "` (Path: `" + classResourceName + "`)");
        }
        InputStream stream = inputStream;
        byte[] byArray = IOUtils.toByteArray((InputStream)stream);
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    private final void makeConstructor(ClassNode cl) {
        MethodVisitor mv = cl.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, cl.superName, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitEnd();
    }

    private final void makeFromBytes(ClassNode cl, boolean callCustom) {
        MethodVisitor mv = cl.visitMethod(1, "fromBytes", "(Lio/netty/buffer/ByteBuf;)V", null, null);
        mv.visitCode();
        if (callCustom) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, cl.name, "fromCustomBytes", "(Lio/netty/buffer/ByteBuf;)V", false);
        }
        for (FieldNode fn : this.getFileds(cl)) {
            if (!descriptors.contains(fn.desc)) continue;
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            StringBuilder stringBuilder = new StringBuilder().append("read");
            String string = fn.desc;
            Intrinsics.checkNotNullExpressionValue(string, "desc");
            CharSequence charSequence = string;
            Regex regex = new Regex("/");
            String string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex(";");
            string2 = "";
            mv.visitMethodInsn(184, "alexsocol/asjlib/network/ASJPacket", stringBuilder.append(regex.replace(charSequence, string2)).toString(), "(Lio/netty/buffer/ByteBuf;)" + fn.desc, false);
            mv.visitFieldInsn(181, cl.name, fn.name, fn.desc);
        }
        mv.visitInsn(177);
        mv.visitEnd();
    }

    private final void makeToBytes(ClassNode cl, boolean callCustom) {
        MethodVisitor mv = cl.visitMethod(1, "toBytes", "(Lio/netty/buffer/ByteBuf;)V", null, null);
        mv.visitCode();
        if (callCustom) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, cl.name, "toCustomBytes", "(Lio/netty/buffer/ByteBuf;)V", false);
        }
        for (FieldNode fn : this.getFileds(cl)) {
            if (!descriptors.contains(fn.desc)) continue;
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, cl.name, fn.name, fn.desc);
            mv.visitMethodInsn(184, "alexsocol/asjlib/network/ASJPacket", "write", "(Lio/netty/buffer/ByteBuf;" + fn.desc + ")V", false);
        }
        mv.visitInsn(177);
        mv.visitEnd();
    }

    private final List<FieldNode> getFileds(ClassNode cl) {
        ArrayList<FieldNode> fns = new ArrayList<FieldNode>();
        for (FieldNode fn : cl.fields) {
            if ((fn.access & 8) > 0 || (fn.access & 0x10) > 0) continue;
            fns.add(fn);
        }
        return fns;
    }

    static {
        Object[] objectArray = new String[]{"Z", "B", "C", "D", "F", "I", "J", "S", "Ljava/lang/String;", "Lnet/minecraft/item/ItemStack;", "Lnet/minecraft/nbt/NBTTagCompound;"};
        ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayList(...)");
        descriptors = arrayList;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lalexsocol/asjlib/asm/ASJPacketCompleter$Companion;", "", "<init>", "()V", "descriptors", "", "", "getDescriptors", "()Ljava/util/List;", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDescriptors() {
            return descriptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

