/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.launcher;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.GenericProperty;
import com.mojang.authlib.launcher.LauncherUtils;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.HashMap;
import java.util.Map;

public class Authlib1Utils {
    public static GameProfile createGameProfile(GenericGameProfile gameProfile) {
        GameProfile profile = new GameProfile(gameProfile.uuid(), gameProfile.username());
        for (Map.Entry<String, GenericProperty> e : gameProfile.properties().entrySet()) {
            profile.getProperties().put(e.getKey(), Authlib1Utils.createProperty(e.getValue()));
        }
        return profile;
    }

    public static GameProfile createGameProfile(GenericGameProfile gameProfile, GameProfile oldGameProfile) {
        GameProfile profile = new GameProfile(gameProfile.uuid(), gameProfile.username());
        for (Map.Entry<String, GenericProperty> e : gameProfile.properties().entrySet()) {
            profile.getProperties().put(e.getKey(), Authlib1Utils.createProperty(e.getValue()));
            oldGameProfile.getProperties().put(e.getKey(), Authlib1Utils.createProperty(e.getValue()));
        }
        return profile;
    }

    public static Property createProperty(GenericProperty property) {
        return new Property(property.name(), property.value(), property.signature());
    }

    public static MinecraftProfileTexture createTexture(LauncherUtils.GenericTexture texture) {
        return new MinecraftProfileTexture(texture.getUrl(), texture.getHash(), texture.getMetadata());
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> parseTextureProperty(Property texturesProperty) {
        if (texturesProperty == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> authlibTextures = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        Map<String, LauncherUtils.GenericTexture> textures = LauncherUtils.parseTexturesProperty(texturesProperty.getValue());
        for (MinecraftProfileTexture.Type e : MinecraftProfileTexture.Type.values()) {
            String k = e.toString();
            LauncherUtils.GenericTexture v = textures.get(k);
            if (v == null) continue;
            authlibTextures.put(e, Authlib1Utils.createTexture(v));
        }
        return authlibTextures;
    }
}

