/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stb_vorbis_alloc")
public class STBVorbisAlloc
extends Struct<STBVorbisAlloc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC_BUFFER;
    public static final int ALLOC_BUFFER_LENGTH_IN_BYTES;

    protected STBVorbisAlloc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected STBVorbisAlloc create(long address, @Nullable ByteBuffer container) {
        return new STBVorbisAlloc(address, container);
    }

    public STBVorbisAlloc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), STBVorbisAlloc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer alloc_buffer() {
        return STBVorbisAlloc.nalloc_buffer(this.address());
    }

    public int alloc_buffer_length_in_bytes() {
        return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
    }

    public STBVorbisAlloc alloc_buffer(@NativeType(value="char *") ByteBuffer value) {
        STBVorbisAlloc.nalloc_buffer(this.address(), value);
        return this;
    }

    public STBVorbisAlloc set(STBVorbisAlloc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static STBVorbisAlloc malloc() {
        return new STBVorbisAlloc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static STBVorbisAlloc calloc() {
        return new STBVorbisAlloc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static STBVorbisAlloc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new STBVorbisAlloc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static STBVorbisAlloc create(long address) {
        return new STBVorbisAlloc(address, null);
    }

    public static @Nullable STBVorbisAlloc createSafe(long address) {
        return address == 0L ? null : new STBVorbisAlloc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)STBVorbisAlloc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = STBVorbisAlloc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static STBVorbisAlloc mallocStack() {
        return STBVorbisAlloc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static STBVorbisAlloc callocStack() {
        return STBVorbisAlloc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static STBVorbisAlloc mallocStack(MemoryStack stack) {
        return STBVorbisAlloc.malloc(stack);
    }

    @Deprecated
    public static STBVorbisAlloc callocStack(MemoryStack stack) {
        return STBVorbisAlloc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return STBVorbisAlloc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return STBVorbisAlloc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBVorbisAlloc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBVorbisAlloc.calloc(capacity, stack);
    }

    public static STBVorbisAlloc malloc(MemoryStack stack) {
        return new STBVorbisAlloc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBVorbisAlloc calloc(MemoryStack stack) {
        return new STBVorbisAlloc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nalloc_buffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_BUFFER)), (int)STBVorbisAlloc.nalloc_buffer_length_in_bytes(struct));
    }

    public static int nalloc_buffer_length_in_bytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOC_BUFFER_LENGTH_IN_BYTES));
    }

    public static void nalloc_buffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ALLOC_BUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        STBVorbisAlloc.nalloc_buffer_length_in_bytes(struct, value.remaining());
    }

    public static void nalloc_buffer_length_in_bytes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOC_BUFFER_LENGTH_IN_BYTES), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_BUFFER)));
    }

    static {
        Struct.Layout layout = STBVorbisAlloc.__struct((Struct.Member[])new Struct.Member[]{STBVorbisAlloc.__member((int)POINTER_SIZE), STBVorbisAlloc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOC_BUFFER = layout.offsetof(0);
        ALLOC_BUFFER_LENGTH_IN_BYTES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<STBVorbisAlloc, Buffer>
    implements NativeResource {
        private static final STBVorbisAlloc ELEMENT_FACTORY = STBVorbisAlloc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected STBVorbisAlloc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public ByteBuffer alloc_buffer() {
            return STBVorbisAlloc.nalloc_buffer(this.address());
        }

        public int alloc_buffer_length_in_bytes() {
            return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
        }

        public Buffer alloc_buffer(@NativeType(value="char *") ByteBuffer value) {
            STBVorbisAlloc.nalloc_buffer(this.address(), value);
            return this;
        }
    }
}

