/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;

public class SoundManager {
    public static final int SAMPLE_RATE = 48000;
    public static final int FRAME_SIZE = 960;
    public static final int MAX_PAYLOAD_SIZE = 1024;
    @Nullable
    private final String deviceName;
    private ALCdevice device;
    private ALCcontext context;
    private static final Pattern DEVICE_NAME = Pattern.compile("^(?:OpenAL.+?on )?(.*)$");

    @Deprecated
    public SoundManager(@Nullable String deviceName) throws SpeakerException {
        this.deviceName = deviceName;
        this.device = this.openSpeaker(deviceName);
        this.context = ALC10.alcCreateContext((ALCdevice)this.device, (IntBuffer)null);
        PluginManager.instance().onCreateALContext(SoundManager.getContextAddress(this.context), SoundManager.getDeviceAddress(this.device));
    }

    public void close() {
        PluginManager.instance().onDestroyALContext(SoundManager.getContextAddress(this.context), SoundManager.getDeviceAddress(this.device));
        if (this.context != null) {
            ALC10.alcDestroyContext((ALCcontext)this.context);
            SoundManager.checkAlcError(this.device);
        }
        if (this.device != null) {
            ALC10.alcCloseDevice((ALCdevice)this.device);
            SoundManager.checkAlcError(this.device);
        }
        this.context = null;
        this.device = null;
    }

    public boolean isClosed() {
        return this.context == null || this.device == null;
    }

    private ALCdevice openSpeaker(@Nullable String name) throws SpeakerException {
        try {
            return this.tryOpenSpeaker(name);
        }
        catch (SpeakerException e) {
            if (name != null) {
                Voicechat.LOGGER.warn("Failed to open audio channel '{}', falling back to default", (Object)name);
            }
            try {
                return this.tryOpenSpeaker(SoundManager.getDefaultSpeaker());
            }
            catch (SpeakerException ex) {
                return this.tryOpenSpeaker(null);
            }
        }
    }

    private ALCdevice tryOpenSpeaker(@Nullable String string) throws SpeakerException {
        ALCdevice l = ALC10.alcOpenDevice((String)string);
        if (l == null) {
            throw new SpeakerException("Failed to open audio device: Audio device not found");
        }
        SoundManager.checkAlcError(this.device);
        return l;
    }

    @Nullable
    public static String getDefaultSpeaker() {
        if (!SoundManager.canEnumerate()) {
            return null;
        }
        String defaultSpeaker = ALC10.alcGetString(null, (int)4115);
        SoundManager.checkAlcError(null);
        return defaultSpeaker;
    }

    public static List<String> getAllSpeakers() {
        if (!SoundManager.canEnumerate()) {
            return Collections.emptyList();
        }
        ArrayList devices = new ArrayList();
        SoundManager.checkAlcError(null);
        return devices == null ? Collections.emptyList() : devices;
    }

    public void runInContext(Executor executor, Runnable runnable) {
        long time = System.currentTimeMillis();
        executor.execute(() -> {
            long diff = System.currentTimeMillis() - time;
            if (diff > 20L || diff >= 5L && Voicechat.debugMode()) {
                Voicechat.LOGGER.warn("Sound executor delay: {} ms!", (Object)diff);
            }
            if (this.openContext()) {
                runnable.run();
                this.closeContext();
            }
        });
    }

    public boolean openContext() {
        if (this.context == null) {
            return false;
        }
        boolean success = true;
        return success;
    }

    public void closeContext() {
        SoundManager.checkAlcError(this.device);
    }

    public static boolean checkAlError() {
        int error = AL10.alGetError();
        if (error == 0) {
            return false;
        }
        StackTraceElement stack = Thread.currentThread().getStackTrace()[2];
        Voicechat.LOGGER.error("Voicechat sound manager AL error: {}.{}[{}] {}", (Object)stack.getClassName(), (Object)stack.getMethodName(), (Object)stack.getLineNumber(), (Object)SoundManager.getAlError(error));
        return true;
    }

    public static boolean checkAlcError(@Nullable ALCdevice device) {
        int error = ALC10.alcGetError((ALCdevice)device);
        if (error == 0) {
            return false;
        }
        StackTraceElement stack = Thread.currentThread().getStackTrace()[2];
        Voicechat.LOGGER.error("Voicechat sound manager ALC error: {}.{}[{}] {}", (Object)stack.getClassName(), (Object)stack.getMethodName(), (Object)stack.getLineNumber(), (Object)SoundManager.getAlcError(error));
        return true;
    }

    private static String getAlError(int i) {
        switch (i) {
            case 40961: {
                return "Invalid name";
            }
            case 40962: {
                return "Invalid enum ";
            }
            case 40963: {
                return "Invalid value";
            }
            case 40964: {
                return "Invalid operation";
            }
            case 40965: {
                return "Out of memory";
            }
        }
        return "Unknown error";
    }

    public static String getAlcError(int i) {
        switch (i) {
            case 40961: {
                return "Invalid device";
            }
            case 40962: {
                return "Invalid context";
            }
            case 40963: {
                return "Invalid enum";
            }
            case 40964: {
                return "Invalid value";
            }
            case 40965: {
                return "Out of memory";
            }
        }
        return "Unknown error";
    }

    public static String cleanDeviceName(String name) {
        Matcher matcher = DEVICE_NAME.matcher(name);
        if (!matcher.matches()) {
            return name;
        }
        return matcher.group(1);
    }

    public static boolean canEnumerate() {
        return false;
    }

    public static long getContextAddress(ALCcontext context) {
        try {
            Field c = context.getClass().getDeclaredField("context");
            c.setAccessible(true);
            return (Long)c.get(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getDeviceAddress(ALCdevice device) {
        try {
            Field c = device.getClass().getDeclaredField("device");
            c.setAccessible(true);
            return (Long)c.get(device);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

