/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class KeyEvents {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    public static KeyBinding KEY_PTT;
    public static KeyBinding KEY_WHISPER;
    public static KeyBinding KEY_MUTE;
    public static KeyBinding KEY_DISABLE;
    public static KeyBinding KEY_HIDE_ICONS;
    public static KeyBinding KEY_VOICE_CHAT;
    public static KeyBinding KEY_VOICE_CHAT_SETTINGS;
    public static KeyBinding KEY_GROUP;
    public static KeyBinding KEY_TOGGLE_RECORDING;
    public static KeyBinding KEY_ADJUST_VOLUMES;

    public KeyEvents() {
        ClientCompatibilityManager.INSTANCE.onHandleKeyBinds(this::handleKeybinds);
        KEY_PTT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.push_to_talk", 58, "key.categories.voicechat"));
        KEY_WHISPER = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.whisper", 0, "key.categories.voicechat"));
        KEY_MUTE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.mute_microphone", 50, "key.categories.voicechat"));
        KEY_DISABLE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.disable_voice_chat", 49, "key.categories.voicechat"));
        KEY_HIDE_ICONS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.hide_icons", 35, "key.categories.voicechat"));
        KEY_VOICE_CHAT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat", 47, "key.categories.voicechat"));
        KEY_VOICE_CHAT_SETTINGS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_settings", 0, "key.categories.voicechat"));
        KEY_GROUP = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_group", 34, "key.categories.voicechat"));
        KEY_TOGGLE_RECORDING = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_toggle_recording", 0, "key.categories.voicechat"));
        KEY_ADJUST_VOLUMES = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_adjust_volumes", 0, "key.categories.voicechat"));
    }

    private void handleKeybinds() {
        ClientVoicechat client = ClientManager.getClient();
        ClientPlayerStateManager playerStateManager = ClientManager.getPlayerStateManager();
        if (KEY_VOICE_CHAT.func_151468_f()) {
            this.minecraft.func_147108_a((GuiScreen)new VoiceChatScreen());
        }
        if (KEY_GROUP.func_151468_f()) {
            if (client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled()) {
                ClientGroup group = playerStateManager.getGroup();
                if (group != null) {
                    this.minecraft.func_147108_a((GuiScreen)new GroupScreen(group));
                } else {
                    this.minecraft.func_147108_a((GuiScreen)new JoinGroupScreen());
                }
            } else {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("message.voicechat.groups_disabled", new Object[0]), true);
            }
        }
        if (KEY_VOICE_CHAT_SETTINGS.func_151468_f()) {
            this.minecraft.func_147108_a((GuiScreen)new VoiceChatSettingsScreen());
        }
        if (KEY_ADJUST_VOLUMES.func_151468_f()) {
            this.minecraft.func_147108_a((GuiScreen)new AdjustVolumesScreen());
        }
        if (KEY_PTT.func_151468_f()) {
            this.checkConnected();
        }
        if (KEY_WHISPER.func_151468_f()) {
            this.checkConnected();
        }
        if (KEY_MUTE.func_151468_f()) {
            playerStateManager.setMuted(!playerStateManager.isMuted());
        }
        if (KEY_DISABLE.func_151468_f()) {
            playerStateManager.setDisabled(!playerStateManager.isDisabled());
        }
        if (KEY_TOGGLE_RECORDING.func_151468_f() && client != null) {
            ClientManager.getClient().toggleRecording();
        }
        if (KEY_HIDE_ICONS.func_151468_f()) {
            boolean hidden = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
            VoicechatClient.CLIENT_CONFIG.hideIcons.set(hidden).save();
            if (hidden) {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("message.voicechat.icons_hidden", new Object[0]), true);
            } else {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("message.voicechat.icons_visible", new Object[0]), true);
            }
        }
    }

    private boolean checkConnected() {
        if (ClientManager.getClient() == null || ClientManager.getClient().getConnection() == null || !ClientManager.getClient().getConnection().isInitialized()) {
            this.sendUnavailableMessage();
            return false;
        }
        return true;
    }

    private void sendUnavailableMessage() {
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("message.voicechat.voice_chat_not_connected", new Object[0]), true);
    }
}

