/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeNetworkEvents {
    private static final Map<String, ServerCustomPayloadEvent> serverPackets = new ConcurrentHashMap<String, ServerCustomPayloadEvent>();
    private static final Map<String, ClientCustomPayloadEvent> clientPackets = new ConcurrentHashMap<String, ClientCustomPayloadEvent>();

    public static void registerServerPacket(ResourceLocation channel, ServerCustomPayloadEvent event) {
        serverPackets.put(channel.toString(), event);
    }

    public static void registerClientPacket(ResourceLocation channel, ClientCustomPayloadEvent event) {
        clientPackets.put(channel.toString(), event);
    }

    public static boolean onCustomPayloadServer(CPacketCustomPayload packet, EntityPlayerMP player) {
        ServerCustomPayloadEvent event = serverPackets.get(packet.func_149559_c());
        if (event != null) {
            event.onCustomPayload(packet, player);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean onCustomPayloadClient(SPacketCustomPayload packet) {
        ClientCustomPayloadEvent event = clientPackets.get(packet.func_149169_c());
        if (event != null) {
            event.onCustomPayload(packet);
            return true;
        }
        return false;
    }

    public static interface ClientCustomPayloadEvent {
        public void onCustomPayload(SPacketCustomPayload var1);
    }

    public static interface ServerCustomPayloadEvent {
        public void onCustomPayload(CPacketCustomPayload var1, EntityPlayerMP var2);
    }
}

