/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.NativeDependencyException;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerManager;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class MicTestButton
extends ButtonBase {
    private static final ITextComponent TEST_UNAVAILABLE = new TextComponentTranslation("message.voicechat.mic_test_unavailable", new Object[0]);
    private static final ITextComponent TEST_ON = new TextComponentTranslation("message.voicechat.mic_test_on", new Object[0]);
    private static final ITextComponent TEST_OFF = new TextComponentTranslation("message.voicechat.mic_test_off", new Object[0]);
    private boolean micActive;
    @Nullable
    private VoiceThread voiceThread;
    private final MicListener micListener;
    @Nullable
    private final ClientVoicechat client;

    public MicTestButton(int id, int xIn, int yIn, int widthIn, int heightIn, MicListener micListener) {
        super(id, xIn, yIn, widthIn, heightIn, (ITextComponent)new TextComponentString(""));
        this.micListener = micListener;
        this.client = ClientManager.getClient();
        this.updateText();
    }

    private void updateText() {
        if (!this.field_146124_l) {
            this.field_146126_j = TEST_UNAVAILABLE.func_150261_e();
            return;
        }
        this.field_146126_j = this.micActive ? TEST_ON.func_150261_e() : TEST_OFF.func_150261_e();
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        if (this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
        this.updateText();
    }

    @Override
    public void onPress() {
        this.setMicActive(!this.micActive);
        if (this.micActive) {
            this.close();
            try {
                this.voiceThread = new VoiceThread();
                this.voiceThread.start();
            }
            catch (Exception e) {
                this.setMicActive(false);
                this.field_146124_l = false;
                e.printStackTrace();
            }
        } else {
            this.close();
        }
        this.updateText();
    }

    private void close() {
        if (this.voiceThread != null) {
            this.voiceThread.close();
            this.voiceThread = null;
        }
    }

    public void stop() {
        this.close();
        this.setMicActive(false);
    }

    public static interface MicListener {
        public void onMicValue(double var1);
    }

    private class VoiceThread
    extends Thread {
        private final Speaker speaker;
        private boolean running = true;
        private long lastRender;
        private MicThread micThread;
        private boolean usesOwnMicThread;

        public VoiceThread() throws SpeakerException, MicrophoneException, NativeDependencyException {
            this.setDaemon(true);
            this.setName("VoiceTestingThread");
            MicThread micThread = this.micThread = MicTestButton.this.client != null ? MicTestButton.this.client.getMicThread() : null;
            if (this.micThread == null) {
                this.micThread = new MicThread(MicTestButton.this.client, null);
                this.usesOwnMicThread = true;
            }
            this.speaker = SpeakerManager.createSpeaker(null, null);
            this.updateLastRender();
            this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running && System.currentTimeMillis() - this.lastRender <= 500L) {
                short[] buff = this.micThread.pollMic();
                if (buff == null) continue;
                MicTestButton.this.micListener.onMicValue(Utils.dbToPerc(Utils.getHighestAudioLevel(buff)));
                this.speaker.play(buff, VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get().floatValue(), null);
            }
            this.speaker.close();
            this.setMicLocked(false);
            MicTestButton.this.micListener.onMicValue(0.0);
            if (this.usesOwnMicThread) {
                this.micThread.close();
            }
            Voicechat.LOGGER.info("Mic test audio channel closed");
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        private void setMicLocked(boolean locked) {
            this.micThread.setMicrophoneLocked(locked);
        }

        public void close() {
            if (!this.running) {
                return;
            }
            Voicechat.LOGGER.info("Stopping mic test audio channel");
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

