/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectDeviceScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class AudioDeviceEntry
extends ListScreenEntryBase {
    protected static final ResourceLocation SELECTED = new ResourceLocation("voicechat", "textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = VoiceChatScreenBase.color(255, 74, 74, 74);
    protected static final int BG_FILL_HOVERED = VoiceChatScreenBase.color(255, 90, 90, 90);
    protected static final int BG_FILL_SELECTED = VoiceChatScreenBase.color(255, 40, 40, 40);
    protected static final int DEVICE_NAME_COLOR = VoiceChatScreenBase.color(255, 255, 255, 255);
    protected final Minecraft minecraft;
    protected final String device;
    protected final String visibleDeviceName;
    protected final SelectDeviceScreen parent;

    public AudioDeviceEntry(SelectDeviceScreen parent, String device) {
        this.parent = parent;
        this.device = device;
        this.visibleDeviceName = parent.getVisibleName(device);
        this.minecraft = Minecraft.func_71410_x();
    }

    @Override
    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        boolean selected = this.parent.getSelectedDevice().equals(this.device);
        if (selected) {
            GuiScreen.func_73734_a((int)x, (int)y, (int)(x + listWidth), (int)(y + slotHeight), (int)BG_FILL_SELECTED);
        } else if (isSelected) {
            GuiScreen.func_73734_a((int)x, (int)y, (int)(x + listWidth), (int)(y + slotHeight), (int)BG_FILL_HOVERED);
        } else {
            GuiScreen.func_73734_a((int)x, (int)y, (int)(x + listWidth), (int)(y + slotHeight), (int)BG_FILL);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.parent.getIcon(this.device));
        GuiScreen.func_146110_a((int)(x + 4), (int)(y + slotHeight / 2 - 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        if (selected) {
            this.minecraft.func_110434_K().func_110577_a(SELECTED);
            GuiScreen.func_146110_a((int)(x + 4), (int)(y + slotHeight / 2 - 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        float deviceWidth = this.minecraft.field_71466_p.func_78256_a(this.visibleDeviceName);
        float space = listWidth - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 4 + 16 + 4), (double)((float)(y + slotHeight / 2) - (float)this.minecraft.field_71466_p.field_78288_b * scale / 2.0f), (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.minecraft.field_71466_p.func_78276_b(this.visibleDeviceName, 0, 0, DEVICE_NAME_COLOR);
        GlStateManager.func_179121_F();
    }

    public String getDevice() {
        return this.device;
    }
}

