/*
 * Decompiled with CFR 0.152.
 */
package com.sb205.missing_pieces.Config;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MpConfiguration {
    private static final boolean SLAB_DEFAULT_VALUE = true;
    private static final boolean MISC_DEFAULT_VALUE = true;
    private static final boolean WEDGE_DEFAULT_VALUE = true;
    private static final boolean CHAIR_DEFAULT_VALUE = true;
    private static final boolean SHELF_DEFAULT_VALUE = true;
    private static final boolean CANDELABRA_DEFAULT_VALUE = true;
    private static final boolean TABLE_DEFAULT_VALUE = true;
    private static final boolean LAMP_DEFAULT_VALUE = true;
    private static final boolean LOG_DEFAULT_VALUE = true;
    private static final boolean PILLAR_DEFAULT_VALUE = true;
    public static final String CATEGORY_NAME_CHAIRS = "category_chairs";
    public static final String CATEGORY_NAME_TABLES = "category_tables";
    public static final String CATEGORY_NAME_LAMPS = "category_lamps";
    public static final String CATEGORY_NAME_SHELVES = "category_shelves";
    public static final String CATEGORY_NAME_CANDELABRAS = "category_candelabras";
    public static final String CATEGORY_NAME_PILLARS = "category_pillars";
    public static final String CATEGORY_NAME_WEDGES = "category_wedges";
    public static final String CATEGORY_NAME_SLABS = "category_slabs";
    public static final String CATEGORY_NAME_MISC = "category_misc";
    public static final String CATEGORY_NAME_NATURA_CHAIRS = "category_natura_chairs";
    public static final String CATEGORY_NAME_NATURA_TABLES = "category_natura_tables";
    public static final String CATEGORY_NAME_NATURA_LAMPS = "category_natura_lamps";
    public static final String CATEGORY_NAME_NATURA_SHELVES = "category_natura_shelves";
    public static final String CATEGORY_NAME_NATURA_CANDELABRAS = "category_natura_candelabras";
    public static final String CATEGORY_NAME_NATURA_PILLARS = "category_natura_pillars";
    public static final String CATEGORY_NAME_NATURA_WEDGES = "category_natura_wedges";
    public static final String CATEGORY_NAME_BASEM_LAMPS = "category_base_metal_lamps";
    public static final String CATEGORY_NAME_BASEM_CANDELABRAS = "category_base_metal_candelabras";
    public static final String CATEGORY_NAME_MINERAL_PILLARS = "category_mineralogy_pillars";
    public static final String CATEGORY_NAME_MINERAL_WEDGES = "category_mineralogy_wedges";
    private static int configQty = ConfigInfo.values().length;
    public static Boolean[] BlockEnable = new Boolean[configQty];
    public static Property[] ConfigProperty = new Property[configQty];
    public static int[] ConfigValue = new int[configQty];
    private static Configuration config = null;

    public static void init() {
        File configFile = new File(Loader.instance().getConfigDir(), "MisingPieces-4.2.cfg");
        config = new Configuration(configFile);
        MpConfiguration.syncFromFile();
    }

    public static void clientInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventHandler());
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void syncFromFile() {
        MpConfiguration.syncConfig(true, true);
    }

    public static void syncFromGUI() {
        MpConfiguration.syncConfig(false, true);
    }

    public static void syncFromFields() {
        MpConfiguration.syncConfig(false, false);
    }

    private static void syncConfig(boolean loadConfigFromFile, boolean readFieldsFromConfig) {
        if (loadConfigFromFile) {
            config.load();
        }
        Boolean baseMetalsLoaded = false;
        Boolean mineralogyLoaded = false;
        Boolean biopLoaded = false;
        Boolean naturaLoaded = false;
        if (Loader.isModLoaded((String)"basemetals")) {
            baseMetalsLoaded = true;
        }
        if (Loader.isModLoaded((String)"mineralogy")) {
            mineralogyLoaded = true;
        }
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            biopLoaded = true;
        }
        if (Loader.isModLoaded((String)"natura")) {
            naturaLoaded = true;
        }
        for (ConfigInfo item : ConfigInfo.values()) {
            if (item.getMod() == ModType.MOD_MISSING_PIECES || item.getMod() == ModType.MOD_BASE_METALS && baseMetalsLoaded == true || item.getMod() == ModType.MOD_BIOMES_O_PLENTY && biopLoaded == true || item.getMod() == ModType.MOD_NATURA && naturaLoaded == true || item.getMod() == ModType.MOD_MINERALOGY && mineralogyLoaded.booleanValue()) {
                MpConfiguration.ConfigProperty[item.ordinal()] = config.get(item.getCategory(), item.getName(), item.getEnable().booleanValue());
                ConfigProperty[item.ordinal()].setLanguageKey("tile." + item.getName() + ".name").setRequiresMcRestart(true);
                continue;
            }
            if (item.getMod() != ModType.MOD_CONFIG_VALUE) continue;
            MpConfiguration.ConfigProperty[item.ordinal()] = config.get(item.getCategory(), item.getName(), item.getDefInt(), item.getComment(), item.getMin(), item.getMax());
            ConfigProperty[item.ordinal()].setLanguageKey("tile." + item.getName() + ".name").setRequiresMcRestart(true);
        }
        if (readFieldsFromConfig) {
            for (ConfigInfo item : ConfigInfo.values()) {
                if (item.getMod() == ModType.MOD_MISSING_PIECES || item.getMod() == ModType.MOD_BASE_METALS && baseMetalsLoaded == true || item.getMod() == ModType.MOD_BIOMES_O_PLENTY && biopLoaded == true || item.getMod() == ModType.MOD_NATURA && naturaLoaded == true || item.getMod() == ModType.MOD_MINERALOGY && mineralogyLoaded.booleanValue()) {
                    MpConfiguration.BlockEnable[item.ordinal()] = ConfigProperty[item.ordinal()].getBoolean();
                    continue;
                }
                if (item.getMod() != ModType.MOD_CONFIG_VALUE) continue;
                MpConfiguration.ConfigValue[item.ordinal()] = ConfigProperty[item.ordinal()].getInt();
            }
        }
        for (ConfigInfo item : ConfigInfo.values()) {
            if (item.getMod() == ModType.MOD_MISSING_PIECES || item.getMod() == ModType.MOD_BASE_METALS && baseMetalsLoaded == true || item.getMod() == ModType.MOD_BIOMES_O_PLENTY && biopLoaded == true || item.getMod() == ModType.MOD_NATURA && naturaLoaded == true || item.getMod() == ModType.MOD_MINERALOGY && mineralogyLoaded.booleanValue()) {
                ConfigProperty[item.ordinal()].set(BlockEnable[item.ordinal()].booleanValue());
                continue;
            }
            if (item.getMod() != ModType.MOD_CONFIG_VALUE) continue;
            ConfigProperty[item.ordinal()].set(ConfigValue[item.ordinal()]);
        }
        if (config.hasChanged()) {
            System.out.println("Saving Config");
            config.save();
        }
    }

    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.NORMAL)
        public void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if ("missing_pieces".equals(event.getModID()) && !event.isWorldRunning() && (event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_WEDGES) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_PILLARS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_CHAIRS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_TABLES) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_LAMPS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_SLABS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_CANDELABRAS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_NATURA_WEDGES) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_NATURA_PILLARS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_NATURA_CHAIRS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_NATURA_TABLES) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_NATURA_LAMPS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_NATURA_CANDELABRAS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_BASEM_LAMPS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_BASEM_CANDELABRAS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_MINERAL_WEDGES) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_MINERAL_PILLARS) || event.getConfigID().equals(MpConfiguration.CATEGORY_NAME_MISC))) {
                MpConfiguration.syncFromGUI();
            }
        }
    }

    public static enum ConfigInfo {
        WEDGE_QTY("Wedge_Quantity", "category_wedges", ModType.MOD_CONFIG_VALUE, "Number of Wedges per recipe [3] - 6", 3, 3, 6),
        MISC_SPINDLE("Spindle", "category_misc", ModType.MOD_MISSING_PIECES, true),
        MISC_FLAT_SPINDLE("FlatSpindle", "category_misc", ModType.MOD_MISSING_PIECES, true),
        MISC_TALL_SPINDLE("TallSpindle", "category_misc", ModType.MOD_MISSING_PIECES, true),
        MISC_BENT_SPINDLE("BentSpindle", "category_misc", ModType.MOD_MISSING_PIECES, true),
        LOG_ACACIA("acacia_log", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        LOG_BIRCH("birch_log", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        LOG_DARK_OAK("dark_oak_log", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        LOG_JUNGLE("jungle_log", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        LOG_OAK("oak_log", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        LOG_SPRUCE("spruce_log", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        LOG_AMARANTH("amaranth_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_DARKWOOD("darkwood_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_EUCALYPTUS("eucalyptus_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_FUSEWOOD("fusewood_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_GHOSTWOOD("ghostwood_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_HOPSEED("hopseed_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_MAPLE("maple_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_REDWOOD("redwood_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_SAKURA("sakura_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_SILVERBELL("silverbell_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_TIGER("tiger_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        LOG_WILLOW("willow_log", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_STONE("stone_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_STONEBRICK("stonebrick_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_PURPUR("purpur_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_COBBLESTONE("cobblestone_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_GRANITE("granite_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_ANDESITE("andesite_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_DIORITE("diorite_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_P_GRANITE("p_granite_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_P_ANDESITE("p_andesite_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_P_DIORITE("p_diorite_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_OBSIDIAN("obsidian_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_QUARTZ("quartz_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_ACACIA("acacia_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_BIRCH("birch_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_DARK_OAK("dark_oak_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_JUNGLE("jungle_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_OAK("oak_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_SPRUCE("spruce_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_SANDSTONE("sandstone_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_RED_SANDSTONE("red_sandstone_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_NETHER_BRICK("nether_brick_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_END_STONE("end_stone_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_BLACK_CLAY("black_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_BLUE_CLAY("blue_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_BROWN_CLAY("brown_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_CYAN_CLAY("cyan_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_GRAY_CLAY("gray_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_GREEN_CLAY("green_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_LIGHT_BLUE_CLAY("light_blue_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_LIGHT_GRAY_CLAY("light_gray_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_LIME_CLAY("lime_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_MAGENTA_CLAY("magenta_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_ORANGE_CLAY("orange_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_PINK_CLAY("pink_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_PURPLE_CLAY("purple_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_RED_CLAY("red_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_WHITE_CLAY("white_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_YELLOW_CLAY("yellow_clay_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_GLASS("glass_pillar", "category_pillars", ModType.MOD_MISSING_PIECES, true),
        PILLAR_AMARANTH("amaranth_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_DARKWOOD("darkwood_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_EUCALYPTUS("eucalyptus_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_FUSEWOOD("fusewood_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_GHOSTWOOD("ghostwood_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_HOPSEED("hopseed_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_MAPLE("maple_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_REDWOOD("redwood_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_SAKURA("sakura_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_SILVERBELL("silverbell_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_TIGER("tiger_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        PILLAR_WILLOW("willow_pillar", "category_natura_pillars", ModType.MOD_NATURA, true),
        CANDELABRA_ACACIA("acacia_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_BIRCH("birch_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_DARK_OAK("dark_oak_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_JUNGLE("jungle_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_OAK("oak_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_SPRUCE("spruce_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_GOLD("gold_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        CANDELABRA_IRON("iron_candelabra", "category_candelabras", ModType.MOD_MISSING_PIECES, true),
        SHELF_ACACIA("acacia_shelf", "category_shelves", ModType.MOD_MISSING_PIECES, true),
        SHELF_BIRCH("birch_shelf", "category_shelves", ModType.MOD_MISSING_PIECES, true),
        SHELF_DARK_OAK("dark_oak_shelf", "category_shelves", ModType.MOD_MISSING_PIECES, true),
        SHELF_JUNGLE("jungle_shelf", "category_shelves", ModType.MOD_MISSING_PIECES, true),
        SHELF_OAK("oak_shelf", "category_shelves", ModType.MOD_MISSING_PIECES, true),
        SHELF_SPRUCE("spruce_shelf", "category_shelves", ModType.MOD_MISSING_PIECES, true),
        SHELF_AMARANTH("amaranth_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_DARKWOOD("darkwood_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_EUCALYPTUS("eucalyptus_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_FUSEWOOD("fusewood_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_GHOSTWOOD("ghostwood_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_HOPSEED("hopseed_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_MAPLE("maple_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_REDWOOD("redwood_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_SAKURA("sakura_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_SILVERBELL("silverbell_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_TIGER("tiger_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        SHELF_WILLOW("willow_shelf", "category_natura_shelves", ModType.MOD_NATURA, true),
        LAMP_ACACIA("acacia_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_BIRCH("birch_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_DARK_OAK("dark_oak_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_JUNGLE("jungle_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_OAK("oak_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_SPRUCE("spruce_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_GOLD("gold_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        LAMP_IRON("iron_lamp", "category_lamps", ModType.MOD_MISSING_PIECES, true),
        TABLE_ACACIA("acacia_table", "category_tables", ModType.MOD_MISSING_PIECES, true),
        TABLE_BIRCH("birch_table", "category_tables", ModType.MOD_MISSING_PIECES, true),
        TABLE_DARK_OAK("dark_oak_table", "category_tables", ModType.MOD_MISSING_PIECES, true),
        TABLE_JUNGLE("jungle_table", "category_tables", ModType.MOD_MISSING_PIECES, true),
        TABLE_OAK("oak_table", "category_tables", ModType.MOD_MISSING_PIECES, true),
        TABLE_SPRUCE("spruce_table", "category_tables", ModType.MOD_MISSING_PIECES, true),
        TABLE_AMARANTH("amaranth_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_DARKWOOD("darkwood_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_EUCALYPTUS("eucalyptus_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_FUSEWOOD("fusewood_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_GHOSTWOOD("ghostwood_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_HOPSEED("hopseed_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_MAPLE("maple_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_REDWOOD("redwood_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_SAKURA("sakura_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_SILVERBELL("silverbell_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_TIGER("tiger_table", "category_natura_tables", ModType.MOD_NATURA, true),
        TABLE_WILLOW("willow_table", "category_natura_tables", ModType.MOD_NATURA, true),
        CHAIR_ACACIA("acacia_chair", "category_chairs", ModType.MOD_MISSING_PIECES, true),
        CHAIR_BIRCH("birch_chair", "category_chairs", ModType.MOD_MISSING_PIECES, true),
        CHAIR_DARK_OAK("dark_oak_chair", "category_chairs", ModType.MOD_MISSING_PIECES, true),
        CHAIR_JUNGLE("jungle_chair", "category_chairs", ModType.MOD_MISSING_PIECES, true),
        CHAIR_OAK("oak_chair", "category_chairs", ModType.MOD_MISSING_PIECES, true),
        CHAIR_SPRUCE("spruce_chair", "category_chairs", ModType.MOD_MISSING_PIECES, true),
        CHAIR_AMARANTH("amaranth_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_DARKWOOD("darkwood_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_EUCALYPTUS("eucalyptus_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_FUSEWOOD("fusewood_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_GHOSTWOOD("ghostwood_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_HOPSEED("hopseed_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_MAPLE("maple_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_REDWOOD("redwood_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_SAKURA("sakura_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_SILVERBELL("silverbell_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_TIGER("tiger_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        CHAIR_WILLOW("willow_chair", "category_natura_chairs", ModType.MOD_NATURA, true),
        SLABPATT1("stone_patt1_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT2("stone_patt2_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT3("stone_patt3_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT4("stone_patt4_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT5("stone_patt5_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT6("stone_patt6_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT7("stone_patt7_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT8("stone_patt8_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT9("stone_patt9_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT10("stone_patt10_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT11("stone_patt11_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        SLABPATT12("stone_patt12_slab", "category_slabs", ModType.MOD_MISSING_PIECES, true),
        WEDGE_STONE("stone_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_STONEBRICK("stonebrick_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_PURPUR("purpur_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_COBBLESTONE("cobblestone_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_GRANITE("granite_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_OBSIDIAN("obsidian_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_ANDESITE("andesite_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_DIORITE("diorite_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_P_GRANITE("p_granite_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_P_ANDESITE("p_andesite_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_P_DIORITE("p_diorite_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_QUARTZ("quartz_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_ACACIA("acacia_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_BIRCH("birch_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_DARK_OAK("dark_oak_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_JUNGLE("jungle_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_OAK("oak_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_SPRUCE("spruce_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_SANDSTONE("sandstone_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_RED_SANDSTONE("red_sandstone_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_NETHER_BRICK("nether_brick_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_END_STONE("end_stone_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_BLACK_CLAY("black_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_BLUE_CLAY("blue_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_BROWN_CLAY("brown_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_CYAN_CLAY("cyan_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_GRAY_CLAY("gray_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_GREEN_CLAY("green_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_LIGHT_BLUE_CLAY("light_blue_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_LIGHT_GRAY_CLAY("light_gray_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_LIME_CLAY("lime_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_MAGENTA_CLAY("magenta_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_ORANGE_CLAY("orange_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_PINK_CLAY("pink_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_PURPLE_CLAY("purple_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_RED_CLAY("red_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_WHITE_CLAY("white_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_YELLOW_CLAY("yellow_clay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_GLASS("glass_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_HAY("hay_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_DIRT("dirt_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_GRASS("grass_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_GRASS_PATH("grass_path_wedge", "category_wedges", ModType.MOD_MISSING_PIECES, true),
        WEDGE_AMPHIBOLITE("amphibolite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_AMPHIBOLITE_SMOOTH("amphibolite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_M_ANDESITE("m_andesite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_M_ANDESITE_SMOOTH("m_andesite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_BASALT("basalt_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_BASALT_SMOOTH("basalt_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_CHERT("chert_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_CONGLOMERATE("conglomerate_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_CONGLOMERATE_SMOOTH("conglomerate_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_M_DIORITE("m_diorite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_M_DIORITE_SMOOTH("m_diorite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_DOLOMITE("dolomite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_DOLOMITE_SMOOTH("dolomite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_GNEISS("gneiss_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_GNEISS_SMOOTH("gneiss_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_M_GRANITE("m_granite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_M_GRANITE_SMOOTH("m_granite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_LIMESTONE("limestone_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_LIMESTONE_SMOOTH("limestone_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_MARBLE("marble_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_MARBLE_SMOOTH("marble_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_PUMICE("pumice_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_PEGMATITE("pegmatite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_PEGMATITE_SMOOTH("pegmatite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_PHYLLITE("rhyolite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_PHYLLITE_SMOOTH("rhyolite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_RHYOLITE("rhyolite_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_RHYOLITE_SMOOTH("rhyolite_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_SCHIST("schist_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_SCHIST_SMOOTH("schist_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_SHALE("shale_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_SHALE_SMOOTH("shale_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_SLATE("slate_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_SLATE_SMOOTH("slate_smooth_wedge", "category_mineralogy_wedges", ModType.MOD_MINERALOGY, true),
        WEDGE_AMARANTH("amaranth_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_DARKWOOD("darkwood_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_EUCALYPTUS("eucalyptus_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_FUSEWOOD("fusewood_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_GHOSTWOOD("ghostwood_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_HOPSEED("hopseed_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_MAPLE("maple_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_REDWOOD("redwood_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_SAKURA("sakura_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_SILVERBELL("silverbell_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_TIGER("tiger_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        WEDGE_WILLOW("willow_wedge", "category_natura_wedges", ModType.MOD_NATURA, true),
        PILLAR_AMPHIBOLITE("amphibolite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_AMPHIBOLITE_SMOOTH("amphibolite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_M_ANDESITE("m_andesite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_M_ANDESITE_SMOOTH("m_andesite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_BASALT("basalt_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_BASALT_SMOOTH("basalt_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_CHERT("chert_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_CONGLOMERATE("conglomerate_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_CONGLOMERATE_SMOOTH("conglomerate_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_M_DIORITE("m_diorite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_M_DIORITE_SMOOTH("m_diorite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_DOLOMITE("dolomite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_DOLOMITE_SMOOTH("dolomite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_GNEISS("gneiss_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_GNEISS_SMOOTH("gneiss_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_M_GRANITE("m_granite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_M_GRANITE_SMOOTH("m_granite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_LIMESTONE("limestone_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_LIMESTONE_SMOOTH("limestone_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_MARBLE("marble_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_MARBLE_SMOOTH("marble_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_PUMICE("pumice_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_PHYLLITE("phyllite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_PHYLLITE_SMOOTH("phyllite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_PEGMATITE("pegmatite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_PEGMATITE_SMOOTH("pegmatite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_RHYOLITE("rhyolite_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_RHYOLITE_SMOOTH("rhyolite_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_SCHIST("schist_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_SCHIST_SMOOTH("schist_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_SHALE("shale_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_SHALE_SMOOTH("shale_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_SLATE("slate_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        PILLAR_SLATE_SMOOTH("slate_smooth_pillar", "category_mineralogy_pillars", ModType.MOD_MINERALOGY, true),
        LAMP_ADAMANTINE("adamantine_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_AQUARIUM("aquarium_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_BRASS("brass_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_BRONZE("bronze_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_COLD_IRON("cold_iron_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_COPPER("copper_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_ELECTRUM("electrum_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_INVAR("invar_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_LEAD("lead_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_MITHRIL("mithril_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_NICKEL("nickel_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_SILVER("silver_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_STAR_STEEL("star_steel_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_STEEL("steel_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_TIN("tin_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_ZINC("zinc_lamp", "category_base_metal_lamps", ModType.MOD_BASE_METALS, true),
        LAMP_AMARANTH("amaranth_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_DARKWOOD("darkwood_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_EUCALYPTUS("eucalyptus_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_FUSEWOOD("fusewood_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_GHOSTWOOD("ghostwood_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_HOPSEED("hopseed_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_MAPLE("maple_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_REDWOOD("redwood_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_SAKURA("sakura_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_SILVERBELL("silverbell_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_TIGER("tiger_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        LAMP_WILLOW("willow_lamp", "category_natura_lamps", ModType.MOD_NATURA, true),
        CANDELABRA_ADAMANTINE("adamantine_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_AQUARIUM("aquarium_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_BRASS("brass_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_BRONZE("bronze_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_COLD_IRON("cold_iron_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_COPPER("copper_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_ELECTRUM("electrum_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_INVAR("invar_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_LEAD("lead_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_MITHRIL("mithril_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_NICKEL("nickel_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_SILVER("silver_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_STAR_STEEL("star_steel_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_STEEL("steel_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_TIN("tin_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_ZINC("zinc_candelabra", "category_base_metal_candelabras", ModType.MOD_BASE_METALS, true),
        CANDELABRA_AMARANTH("amaranth_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_DARKWOOD("darkwood_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_EUCALYPTUS("eucalyptus_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_FUSEWOOD("fusewood_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_GHOSTWOOD("ghostwood_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_HOPSEED("hopseed_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_MAPLE("maple_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_REDWOOD("redwood_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_SAKURA("sakura_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_SILVERBELL("silverbell_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_TIGER("tiger_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true),
        CANDELABRA_WILLOW("willow_candelabra", "category_natura_candelabras", ModType.MOD_NATURA, true);

        private String configName;
        private String configCat;
        private String configComment;
        private Boolean enabled;
        private ModType mod;
        private int defInt;
        private int minInt;
        private int maxInt;

        private ConfigInfo(String name, String category, ModType modType, Boolean enable) {
            this.configName = name;
            this.configCat = category;
            this.enabled = enable;
            this.mod = modType;
        }

        private ConfigInfo(String name, String category, ModType modType, String comment, int defValue, int minValue, int maxValue) {
            this.configName = name;
            this.configCat = category;
            this.mod = modType;
            this.configComment = comment;
            this.defInt = defValue;
            this.minInt = minValue;
            this.maxInt = maxValue;
        }

        public String getName() {
            return this.configName;
        }

        public String getCategory() {
            return this.configCat;
        }

        public String getComment() {
            return this.configComment;
        }

        public Boolean getEnable() {
            return this.enabled;
        }

        public ModType getMod() {
            return this.mod;
        }

        public int getDefInt() {
            return this.defInt;
        }

        public int getMin() {
            return this.minInt;
        }

        public int getMax() {
            return this.maxInt;
        }
    }

    private static enum ModType {
        MOD_MISSING_PIECES,
        MOD_MINERALOGY,
        MOD_BASE_METALS,
        MOD_BIOMES_O_PLENTY,
        MOD_NATURA,
        MOD_CONFIG_VALUE;

    }
}

