/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.render;

import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class CachedExtrusion {
    private static final int BYTES_PER_VERTEX = 32;
    private static final int BYTES_PER_QUAD = 192;
    private ResourceLocation texture;
    private int vertices;
    private int vbo;
    private ByteBuffer buffer;

    public CachedExtrusion(ResourceLocation texture, int w, int h) {
        this.texture = texture;
        this.buffer = BufferUtils.createByteBuffer((int)(w * h * 192));
        this.vbo = GL15.glGenBuffers();
    }

    public void addVertex(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.buffer.putFloat(nx);
        this.buffer.putFloat(ny);
        this.buffer.putFloat(nz);
        this.buffer.putFloat(u);
        this.buffer.putFloat(v);
        ++this.vertices;
    }

    public void flush() {
        this.buffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (ByteBuffer)this.buffer, (int)35048);
    }

    public void render() {
        GlStateManager.func_179129_p();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL11.glVertexPointer((int)3, (int)5126, (int)32, (long)0L);
        GL11.glNormalPointer((int)5126, (int)32, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)24L);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32885);
        GL11.glEnableClientState((int)32888);
        GL11.glDrawArrays((int)4, (int)0, (int)this.vertices);
        GL15.glBindBuffer((int)34963, (int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32885);
        GL11.glDisableClientState((int)32888);
        GlStateManager.func_179089_o();
    }
}

