/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.morphs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.utils.GuiInventoryElement;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.vanilla_pack.morphs.ItemStackMorph;
import mchorse.vanilla_pack.render.CachedExtrusion;
import mchorse.vanilla_pack.render.ItemExtruder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMorph
extends ItemStackMorph {
    @SideOnly(value=Side.CLIENT)
    private static BiMap<String, ItemCameraTransforms.TransformType> transformTypes;
    public ItemStack stack = new ItemStack(Items.field_151012_L, 1);
    public String transform = "";
    public ResourceLocation texture;
    public boolean animation;
    public boolean itemFromEquipment;
    public EntityEquipmentSlot equipmentSlot = EntityEquipmentSlot.MAINHAND;

    @SideOnly(value=Side.CLIENT)
    public static BiMap<String, ItemCameraTransforms.TransformType> getTransformTypes() {
        if (transformTypes == null) {
            transformTypes = HashBiMap.create();
            transformTypes.put((Object)"none", (Object)ItemCameraTransforms.TransformType.NONE);
            transformTypes.put((Object)"third_person_left_hand", (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
            transformTypes.put((Object)"third_person_right_hand", (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
            transformTypes.put((Object)"first_person_left_hand", (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
            transformTypes.put((Object)"first_person_right_hand", (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
            transformTypes.put((Object)"head", (Object)ItemCameraTransforms.TransformType.HEAD);
            transformTypes.put((Object)"gui", (Object)ItemCameraTransforms.TransformType.GUI);
            transformTypes.put((Object)"ground", (Object)ItemCameraTransforms.TransformType.GROUND);
            transformTypes.put((Object)"fixed", (Object)ItemCameraTransforms.TransformType.FIXED);
        }
        return transformTypes;
    }

    public ItemMorph() {
        this.name = "item";
    }

    @SideOnly(value=Side.CLIENT)
    private ItemStack getStackForRender(EntityLivingBase entity) {
        if (this.itemFromEquipment) {
            if (GuiModelRenderer.isRendering()) {
                entity = Minecraft.func_71410_x().field_71439_g;
            }
            return entity.func_184582_a(this.equipmentSlot);
        }
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemCameraTransforms.TransformType getTransformType() {
        if (this.transform == null || this.transform.isEmpty()) {
            return ItemCameraTransforms.TransformType.NONE;
        }
        ItemCameraTransforms.TransformType transformType = (ItemCameraTransforms.TransformType)ItemMorph.getTransformTypes().get((Object)this.transform);
        return transformType == null ? ItemCameraTransforms.TransformType.NONE : transformType;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179126_j();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        scale /= 16.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)(y - 12), (float)0.0f);
        if (this.texture != null) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)(scale * 16.0f), (float)(-scale * 16.0f), (float)(scale * 16.0f));
            CachedExtrusion extrusion = ItemExtruder.extrude(this.texture);
            if (extrusion != null) {
                extrusion.render();
            }
        } else {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            RenderHelper.func_74520_c();
            GuiInventoryElement.drawItemStack((ItemStack)this.stack, (int)-8, (int)-8, (int)0, null);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179097_i();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        if (!this.lighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        ItemStack stack = this.getStackForRender(entity);
        IBakedModel model = render.func_184393_a(stack, entity.field_70170_p, entity);
        ItemCameraTransforms.TransformType transform = this.getTransformType();
        if (transform != ItemCameraTransforms.TransformType.NONE) {
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transform, (boolean)false);
        }
        if (this.animation) {
            long ticks = entity.field_70170_p.func_82737_E();
            float bobbing = MathHelper.func_76126_a((float)(((float)ticks + partialTicks) / 10.0f)) * 0.1f + 0.1f;
            GlStateManager.func_179109_b((float)0.0f, (float)bobbing, (float)0.0f);
            GlStateManager.func_179114_b((float)(((float)entity.field_70173_aa + partialTicks) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.texture != null) {
            CachedExtrusion extrusion = ItemExtruder.extrude(this.texture);
            if (extrusion != null) {
                extrusion.render();
            }
        } else {
            render.func_180454_a(stack, model);
        }
        GlStateManager.func_179121_F();
        if (!this.lighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof ItemMorph) {
            ItemMorph item = (ItemMorph)obj;
            result = result && ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.stack, (ItemStack)item.stack);
            result = result && Objects.equals(this.transform, item.transform);
            result = result && Objects.equals(this.texture, item.texture);
            result = result && this.animation == item.animation;
            result = result && this.itemFromEquipment == item.itemFromEquipment;
            result = result && this.equipmentSlot == item.equipmentSlot;
        }
        return result;
    }

    @Override
    public AbstractMorph create() {
        return new ItemMorph();
    }

    @Override
    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof ItemMorph) {
            ItemMorph item = (ItemMorph)from;
            this.stack = item.stack.func_77946_l();
            this.transform = item.transform;
            this.texture = item.texture;
            this.animation = item.animation;
            this.itemFromEquipment = item.itemFromEquipment;
            this.equipmentSlot = item.equipmentSlot;
        }
    }

    @Override
    public float getWidth(EntityLivingBase target) {
        return target.field_70130_N;
    }

    @Override
    public float getHeight(EntityLivingBase target) {
        return target.field_70131_O;
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (!this.stack.func_190926_b()) {
            tag.func_74782_a("Stack", (NBTBase)this.stack.serializeNBT());
        }
        tag.func_74778_a("Transform", this.transform);
        if (this.texture != null) {
            tag.func_74778_a("Texture", this.texture.toString());
        }
        if (this.animation) {
            tag.func_74757_a("Animation", this.animation);
        }
        if (this.itemFromEquipment) {
            tag.func_74757_a("ItemFromEquipment", this.itemFromEquipment);
        }
        if (this.equipmentSlot != EntityEquipmentSlot.MAINHAND) {
            tag.func_74778_a("EquipmentSlot", this.equipmentSlot.func_188450_d());
        }
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Stack")) {
            this.stack = new ItemStack(tag.func_74775_l("Stack"));
        }
        this.transform = tag.func_74779_i("Transform");
        if (tag.func_74764_b("Texture")) {
            this.texture = RLUtils.create((String)tag.func_74779_i("Texture"));
        }
        if (tag.func_74764_b("Animation")) {
            this.animation = tag.func_74767_n("Animation");
        }
        if (tag.func_74764_b("ItemFromEquipment")) {
            this.itemFromEquipment = tag.func_74767_n("ItemFromEquipment");
        }
        if (tag.func_74764_b("EquipmentSlot")) {
            this.equipmentSlot = EntityEquipmentSlot.func_188451_a((String)tag.func_74779_i("EquipmentSlot"));
        }
    }
}

