/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.editors.panels;

import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import mchorse.vanilla_pack.morphs.ItemMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiItemPanel
extends GuiMorphPanel<ItemMorph, GuiAbstractMorph<? extends ItemMorph>> {
    public GuiSlotElement slot;
    public GuiToggleElement lighting;
    public GuiCirculateElement transform;
    public GuiButtonElement texture;
    public GuiToggleElement animation;
    public GuiToggleElement itemFromEquipment;
    public GuiCirculateElement equipmentSlot;
    public GuiTexturePicker picker;

    public GuiItemPanel(Minecraft mc, GuiAbstractMorph<? extends ItemMorph> editor) {
        super(mc, editor);
        this.slot = new GuiSlotElement(mc, 0, stack -> ((ItemMorph)this.morph).setStack((ItemStack)stack));
        this.lighting = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.label.lighting"), b -> {
            ((ItemMorph)this.morph).lighting = b.isToggled();
        });
        this.transform = new GuiCirculateElement(mc, b -> {
            ItemCameraTransforms.TransformType type = ItemCameraTransforms.TransformType.values()[b.getValue()];
            ((ItemMorph)this.morph).transform = (String)ItemMorph.getTransformTypes().inverse().get((Object)type);
        });
        this.animation = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.item.animation"), b -> {
            ((ItemMorph)this.morph).animation = b.isToggled();
        });
        this.itemFromEquipment = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.item.item_from_equipment"), b -> {
            ((ItemMorph)this.morph).itemFromEquipment = b.isToggled();
        });
        this.equipmentSlot = new GuiCirculateElement(mc, b -> {
            ((ItemMorph)this.morph).equipmentSlot = EntityEquipmentSlot.values()[b.getValue()];
        });
        this.slot.flex().relative((GuiElement)this).x(0.5f, 0).y(1.0f, -10).wh(32, 32).anchor(0.5f, 1.0f);
        for (ItemCameraTransforms.TransformType transformType : ItemCameraTransforms.TransformType.values()) {
            String key = (String)ItemMorph.getTransformTypes().inverse().get((Object)transformType);
            this.transform.addLabel(IKey.lang((String)("metamorph.gui.item.transform." + key)));
        }
        for (ItemCameraTransforms.TransformType transformType : EntityEquipmentSlot.values()) {
            this.equipmentSlot.addLabel(IKey.lang((String)("metamorph.gui.item.equipment_slot." + transformType.func_188450_d())));
        }
        this.texture = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.editor.texture"), b -> {
            this.picker.refresh();
            this.picker.fill(((ItemMorph)this.morph).texture);
            this.add((IGuiElement)this.picker);
            this.picker.resize();
        });
        this.picker = new GuiTexturePicker(mc, rl -> {
            ((ItemMorph)this.morph).texture = RLUtils.clone((ResourceLocation)rl);
        });
        this.picker.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        GuiElement column = Elements.column((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.lighting, this.transform, this.texture, this.animation, this.itemFromEquipment.marginTop(12), this.equipmentSlot});
        column.flex().relative((GuiElement)this).xy(10, 10).w(110);
        this.add(new IGuiElement[]{this.slot, column});
    }

    @Override
    public void fillData(ItemMorph morph) {
        super.fillData(morph);
        ItemCameraTransforms.TransformType type = morph.getTransformType();
        this.slot.setStack(morph.getStack());
        this.lighting.toggled(morph.lighting);
        this.transform.setValue(type.ordinal());
        this.animation.toggled(morph.animation);
        this.itemFromEquipment.toggled(morph.itemFromEquipment);
        this.equipmentSlot.setValue(morph.equipmentSlot.ordinal());
    }
}

